package com.xebialabs.xlrelease.runner.impl

import com.xebialabs.xlrelease.domain.runner.{JobRunner, JobRunnerOps, RemoteJobRunner}
import RunnerProxyActor.NewCommand
import com.xebialabs.xlrelease.runner.domain._
import com.xebialabs.xlrelease.support.akka.spring.ScalaSpringAwareBean
import grizzled.slf4j.Logging

trait RemoteJobRunnerOps extends JobRunnerOps

object RemoteJobRunnerOps extends RemoteJobRunnerOps with ScalaSpringAwareBean with Logging {

  private lazy val remoteRunnerProxyActorFactory = springBean[RunnerProxyFactory]

  override def start(runner: JobRunner): Unit = {
    logger.debug(s"Start invoked on $runner")
    val command = EnableRunner(runnerCapacity = runner.capacity)
    remoteRunnerProxyActorFactory.create(()) ! NewCommand(runner.getId, command)
  }

  override def stop(runner: JobRunner): Unit = {
    logger.debug(s"Stop invoked on $runner")
    val command = DisableRunner()
    remoteRunnerProxyActorFactory.create(()) ! NewCommand(runner.getId, command)
  }

  override def abortJob(runner: JobRunner, jobId: Long): Unit = {
    logger.debug(s"Abort job invoked on $runner")
    val command = Abort(jobId)
    remoteRunnerProxyActorFactory.create(()) ! NewCommand(runner.getId, command)
  }

  override def accepts(runner: JobRunner): Boolean = {
    runner.isInstanceOf[RemoteJobRunner]
  }
}
