/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.actors.ReleaseExecutionActorMessages;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.PhaseDeletedEvent;
import com.xebialabs.xlrelease.domain.events.PhaseDuplicatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseCreatedEvent;
import com.xebialabs.xlrelease.domain.events.TaskCompletedEvent;
import com.xebialabs.xlrelease.domain.events.TaskCopiedEvent;
import com.xebialabs.xlrelease.domain.events.TaskCreatedEvent;
import com.xebialabs.xlrelease.domain.events.TaskDeletedEvent;
import com.xebialabs.xlrelease.domain.events.TaskSkippedEvent;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.progress.actors.extension.ProgressExecutionActorExtensionHandlerFactory;
import com.xebialabs.xlrelease.risk.domain.progress.ReleaseProgress;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@EventListener
public class ProgressService {
    private static final Logger logger = LoggerFactory.getLogger(ProgressService.class);
    private ReleaseActorService releaseActorService;

    @Autowired
    public ProgressService(ReleaseActorService releaseActorService) {
        this.releaseActorService = releaseActorService;
    }

    @Subscribe
    public void releaseCreated(ReleaseCreatedEvent releaseCreatedEvent) {
        this.updateReleaseProgress(releaseCreatedEvent.release());
    }

    @Subscribe
    public void phaseDuplicated(PhaseDuplicatedEvent phaseDuplicatedEvent) {
        this.updateReleaseProgress(phaseDuplicatedEvent.phaseDuplicate().getRelease());
    }

    @Subscribe
    public void phaseDeleted(PhaseDeletedEvent phaseDeletedEvent) {
        this.updateReleaseProgress(phaseDeletedEvent.phase().getRelease());
    }

    @Subscribe
    public void taskSkipped(TaskSkippedEvent taskSkippedEvent) {
        this.updateReleaseProgress(taskSkippedEvent.task());
    }

    @Subscribe
    public void taskCompleted(TaskCompletedEvent taskCompletedEvent) {
        this.updateReleaseProgress(taskCompletedEvent.task());
    }

    @Subscribe
    public void taskCreated(TaskCreatedEvent taskCreatedEvent) {
        this.updateReleaseProgress(taskCreatedEvent.task());
    }

    @Subscribe
    public void taskDuplicated(TaskCopiedEvent taskCopiedEvent) {
        this.updateReleaseProgress(taskCopiedEvent.taskCopied());
    }

    @Subscribe
    public void taskDeleted(TaskDeletedEvent event) {
        this.updateReleaseProgress(event.task());
    }

    private void updateReleaseProgress(Task task) {
        this.updateReleaseProgress(task.getRelease());
    }

    @Timed
    public void updateReleaseProgress(Release release) {
        if (!release.isTemplate()) {
            logger.debug("Updating progress of release {}", (Object)release.getId());
            List allTasks = release.getAllTasks();
            int totalTasks = allTasks.size();
            int tasksCompleted = (int)allTasks.stream().filter(ProgressService::isTaskCompleted).count();
            ReleaseProgress releaseProgress = new ReleaseProgress();
            releaseProgress.setId(release.getId() + "/progress");
            releaseProgress.setTotalRemainingTasks(totalTasks - tasksCompleted);
            releaseProgress.setTotalTasks(totalTasks);
            HashMap<String, String> phasesProgress = new HashMap<String, String>();
            release.getPhases().forEach(phase -> {
                int totalPhaseTasks = phase.getAllTasks().size();
                int tasksCompletedInPhase = (int)phase.getAllTasks().stream().filter(ProgressService::isTaskCompleted).count();
                phasesProgress.put(phase.getId(), String.format("%d;%d", totalPhaseTasks, tasksCompletedInPhase));
            });
            releaseProgress.setPhasesProgress(phasesProgress);
            this.releaseActorService.executeCommandAsync(release.getId(), (ReleaseExecutionActorMessages.ExtensionCommand)new ProgressExecutionActorExtensionHandlerFactory.UpdateReleaseProgress(releaseProgress));
        }
    }

    private static boolean isTaskCompleted(Task task) {
        return task.isDone() || task.isDoneInAdvance();
    }
}

