/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.repository;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseExtension;
import com.xebialabs.xlrelease.domain.utils.Diff;
import com.xebialabs.xlrelease.domain.utils.Diff$;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseExtensionsRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.risk.builder.RiskBuilder;
import com.xebialabs.xlrelease.risk.domain.Risk;
import com.xebialabs.xlrelease.risk.domain.RiskAssessment;
import com.xebialabs.xlrelease.risk.repository.sql.persistence.RiskPersistence;
import com.xebialabs.xlrelease.service.ReleaseService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Repository
@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\u0005%h\u0001B\n\u0015\u0001}A\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006IA\u0011\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\u0017\"A\u0011\u000b\u0001B\u0001B\u0003%!\u000bC\u0003Y\u0001\u0011\u0005\u0011\fC\u0004o\u0001\t\u0007I\u0011I8\t\ri\u0004\u0001\u0015!\u0003q\u0011\u0015Y\b\u0001\"\u0011}\u0011\u001d\t9\u0001\u0001C!\u0003\u0013Aq!a\u0005\u0001\t\u0003\n)\u0002C\u0004\u0002\u001a\u0001!\t%a\u0007\t\u000f\u0005}\u0001\u0001\"\u0011\u0002\"!9\u0011Q\u0005\u0001\u0005\u0002\u0005\u001d\u0002bBA\u0016\u0001\u0011\u0005\u0011Q\u0006\u0005\b\u0003s\u0001A\u0011AA\u001e\u0011\u001d\ty\u0004\u0001C\t\u0003\u0003Bq!!\u001d\u0001\t#\t\u0019\bC\u0004\u0002\b\u0002!\t\"!#\t\u000f\u0005U\u0006\u0001\"\u0005\u00028\nq!+[:l%\u0016\u0004xn]5u_JL(BA\u000b\u0017\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0003/a\tAA]5tW*\u0011\u0011DG\u0001\nq2\u0014X\r\\3bg\u0016T!a\u0007\u000f\u0002\u0013a,'-[1mC\n\u001c(\"A\u000f\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001\u0001\u0013\bE\u0002\"aMr!AI\u0017\u000f\u0005\rbcB\u0001\u0013,\u001d\t)#F\u0004\u0002'S5\tqE\u0003\u0002)=\u00051AH]8pizJ\u0011!H\u0005\u00037qI!!\u0007\u000e\n\u0005UA\u0012B\u0001\u00180\u0003m\u0011V\r\\3bg\u0016,\u0005\u0010^3og&|gn\u001d*fa>\u001c\u0018\u000e^8ss*\u0011Q\u0003G\u0005\u0003cI\u0012QEU3mK\u0006\u001cX-\u0012=uK:\u001c\u0018n\u001c8Ta\u0016\u001c\u0017.\u00197ju\u0016$'+\u001a9pg&$xN]=\u000b\u00059z\u0003C\u0001\u001b8\u001b\u0005)$B\u0001\u001c\u0017\u0003\u0019!w.\\1j]&\u0011\u0001(\u000e\u0002\u0005%&\u001c8\u000e\u0005\u0002;\u007f5\t1H\u0003\u0002={\u0005)1\u000f\u001c45U*\ta(\u0001\u0005he&T(\u0010\\3e\u0013\t\u00015HA\u0004M_\u001e<\u0017N\\4\u0002\u001fIL7o\u001b)feNL7\u000f^3oG\u0016\u0004\"a\u0011%\u000e\u0003\u0011S!!\u0012$\u0002\u0017A,'o]5ti\u0016t7-\u001a\u0006\u0003\u000fR\t1a]9m\u0013\tIEIA\bSSN\\\u0007+\u001a:tSN$XM\\2f\u0003I\u0011X\r\\3bg\u0016\u0004VM]:jgR,gnY3\u0011\u00051{U\"A'\u000b\u0005\u0015s%BA$0\u0013\t\u0001VJ\u0001\nSK2,\u0017m]3QKJ\u001c\u0018n\u001d;f]\u000e,\u0017A\u0004:fY\u0016\f7/Z*feZL7-\u001a\t\u0003'Zk\u0011\u0001\u0016\u0006\u0003+b\tqa]3sm&\u001cW-\u0003\u0002X)\nq!+\u001a7fCN,7+\u001a:wS\u000e,\u0017A\u0002\u001fj]&$h\b\u0006\u0003[9vs\u0006CA.\u0001\u001b\u0005!\u0002\"B!\u0005\u0001\u0004\u0011\u0005\"\u0002&\u0005\u0001\u0004Y\u0005\"B)\u0005\u0001\u0004\u0011\u0006F\u0001\u0003a!\t\tG.D\u0001c\u0015\t\u0019G-\u0001\u0006b]:|G/\u0019;j_:T!!\u001a4\u0002\u000f\u0019\f7\r^8ss*\u0011q\r[\u0001\u0006E\u0016\fgn\u001d\u0006\u0003S*\fqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002W\u0006\u0019qN]4\n\u00055\u0014'!C!vi><\u0018N]3e\u0003\u0011q\u0017-\\3\u0016\u0003A\u0004\"!]<\u000f\u0005I,\bC\u0001\u0014t\u0015\u0005!\u0018!B:dC2\f\u0017B\u0001<t\u0003\u0019\u0001&/\u001a3fM&\u0011\u00010\u001f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Y\u001c\u0018!\u00028b[\u0016\u0004\u0013AB3ySN$8\u000fF\u0002~\u0003\u0007\u0001\"A`@\u000e\u0003ML1!!\u0001t\u0005\u001d\u0011un\u001c7fC:Da!!\u0002\b\u0001\u0004\u0001\u0018A\u0002:jg.LE-\u0001\u0003sK\u0006$G\u0003BA\u0006\u0003#\u0001BA`A\u0007g%\u0019\u0011qB:\u0003\r=\u0003H/[8o\u0011\u0019\t)\u0001\u0003a\u0001a\u000611M]3bi\u0016$2aMA\f\u0011\u00159\u0012\u00021\u00014\u0003\u0019)\b\u000fZ1uKR\u0019Q0!\b\t\u000b]Q\u0001\u0019A\u001a\u0002\r\u0011,G.\u001a;f)\ri\u00181\u0005\u0005\u0007\u0003\u000bY\u0001\u0019\u00019\u0002#\u0019Lg\u000e\u001a\"z\u0013\u0012|%\u000fR3gCVdG\u000fF\u00024\u0003SAa!!\u0002\r\u0001\u0004\u0001\u0018A\u00064j]\u0012\u0014\u0016n]6BgN,7o]7f]R\u0014\u00150\u00133\u0015\t\u0005=\u0012Q\u0007\t\u0004i\u0005E\u0012bAA\u001ak\tq!+[:l\u0003N\u001cXm]:nK:$\bBBA\u001c\u001b\u0001\u0007\u0001/\u0001\tsSN\\\u0017i]:fgNlWM\u001c;JI\u0006YA-\u001a4bk2$(+[:l)\r\u0019\u0014Q\b\u0005\u0007\u0003\u000bq\u0001\u0019\u00019\u0002+U\u0004H-\u0019;f%&\u001c8.Q:tKN\u001cX.\u001a8ugR)Q0a\u0011\u0002^!9\u0011QI\bA\u0002\u0005\u001d\u0013A\u0003:fY\u0016\f7/Z+jIB!\u0011\u0011JA,\u001d\u0011\tY%a\u0015\u000f\t\u00055\u0013\u0011\u000b\b\u0004E\u0005=\u0013BA$0\u0013\t)e*C\u0002\u0002V5\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002Z\u0005m#!B\"j+&$'bAA+\u001b\"9\u0011qL\bA\u0002\u0005\u0005\u0014a\u0004:jg.\f5o]3tg6,g\u000e^:\u0011\r\u0005\r\u00141NA\u0018\u001d\u0011\t)'!\u001b\u000f\u0007\u0019\n9'C\u0001u\u0013\r\t)f]\u0005\u0005\u0003[\nyGA\u0002TKFT1!!\u0016t\u0003}9W\r^#yi\u0016t7/[8o\rJ|W.\u0011:dQ&4X\r\u001a*fY\u0016\f7/\u001a\u000b\u0005\u0003\u0017\t)\bC\u0004\u0002xA\u0001\r!!\u001f\u0002\u0013I,G.Z1tK&#\u0007\u0003BA>\u0003\u0003sA!a\u0013\u0002~%\u0019\u0011qP'\u0002\t\rK\u0017\nZ\u0005\u0005\u0003\u0007\u000b)I\u0001\u0003DS&#'bAA@\u001b\u0006aq/\u001b;i%\u0016dW-Y:faU!\u00111RAK)\u0011\ti)!-\u0015\t\u0005=\u0015q\u0015\t\u0006}\u00065\u0011\u0011\u0013\t\u0005\u0003'\u000b)\n\u0004\u0001\u0005\u000f\u0005]\u0015C1\u0001\u0002\u001a\n\t\u0011)\u0005\u0003\u0002\u001c\u0006\u0005\u0006c\u0001@\u0002\u001e&\u0019\u0011qT:\u0003\u000f9{G\u000f[5oOB\u0019a0a)\n\u0007\u0005\u00156OA\u0002B]fDq!!+\u0012\u0001\u0004\tY+A\u0001g!\u001dq\u0018QVA$\u0003#K1!a,t\u0005%1UO\\2uS>t\u0017\u0007C\u0004\u00024F\u0001\r!!\u001f\u0002\t\rL\u0017\nZ\u0001\fo&$\bNU3mK\u0006\u001cX-\u0006\u0003\u0002:\u0006}F\u0003BA^\u0003\u000b$B!!0\u0002BB!\u00111SA`\t\u001d\t9J\u0005b\u0001\u00033Cq!!+\u0013\u0001\u0004\t\u0019\rE\u0004\u007f\u0003[\u000b9%!0\t\u000f\u0005M&\u00031\u0001\u0002z!\u001a\u0001!!3\u0011\t\u0005-\u0017q[\u0007\u0003\u0003\u001bTA!a4\u0002R\u0006YAO]1og\u0006\u001cG/[8o\u0015\r9\u00151\u001b\u0006\u0004\u0003+D\u0012A\u00013c\u0013\u0011\tI.!4\u0003\u001f%\u001bHK]1og\u0006\u001cG/[8oC2D3\u0001AAo!\u0011\ty.!:\u000e\u0005\u0005\u0005(bAArQ\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005\u001d\u0018\u0011\u001d\u0002\u000b%\u0016\u0004xn]5u_JL\b")
public class RiskRepository
extends ReleaseExtensionsRepository.ReleaseExtensionSpecializedRepository<Risk>
implements Logging {
    private final RiskPersistence riskPersistence;
    private final ReleasePersistence releasePersistence;
    private final ReleaseService releaseService;
    private final String name;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RiskRepository riskRepository = this;
        synchronized (riskRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public String name() {
        return this.name;
    }

    public boolean exists(String riskId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(8).append("exists(").append(riskId).append(")").toString());
        return this.releasePersistence.findUidByReleaseId(Ids.releaseIdFrom((String)riskId)).exists((Function1 & Serializable & scala.Serializable)releaseUid -> BoxesRunTime.boxToBoolean((boolean)this.riskPersistence.exists(releaseUid)));
    }

    public Option<Risk> read(String riskId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(6).append("read(").append(riskId).append(")").toString());
        return this.withRelease0(Ids.releaseIdFrom((String)riskId), (Function1 & Serializable & scala.Serializable)releaseUid -> $this.riskPersistence.read((Integer)releaseUid).map((Function1 & Serializable & scala.Serializable)risk -> {
            risk.setId(riskId);
            Seq<RiskAssessment> riskAssessments = $this.riskPersistence.readAllAssessments((Integer)releaseUid);
            riskAssessments.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                x$1.setRisk(risk);
                return BoxedUnit.UNIT;
            });
            risk.setRiskAssessments((List)JavaConverters$.MODULE$.seqAsJavaListConverter(riskAssessments).asJava());
            return risk;
        })).flatten(Predef$.MODULE$.$conforms());
    }

    public Risk create(Risk risk) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(8).append("create(").append(risk.getId()).append(")").toString());
        return (Risk)((Object)this.withRelease(Ids.releaseIdFrom((String)risk.getId()), (Function1 & Serializable & scala.Serializable)releaseUid -> {
            $this.riskPersistence.create((Integer)releaseUid, Predef$.MODULE$.Integer2int(risk.getScore()), Predef$.MODULE$.Integer2int(risk.getTotalScore()));
            $this.riskPersistence.createAssessments((Integer)releaseUid, (Seq<RiskAssessment>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(risk.getRiskAssessments()).asScala()));
            return risk;
        }));
    }

    public boolean update(Risk risk) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(8).append("update(").append(risk.getId()).append(")").toString());
        return BoxesRunTime.unboxToBoolean(this.withRelease(Ids.releaseIdFrom((String)risk.getId()), (Function1 & Serializable & scala.Serializable)releaseUid -> BoxesRunTime.boxToBoolean((boolean)RiskRepository.$anonfun$update$2(this, risk, releaseUid))));
    }

    public boolean delete(String riskId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(8).append("delete(").append(riskId).append(")").toString());
        return BoxesRunTime.unboxToBoolean(this.withRelease(Ids.releaseIdFrom((String)riskId), (Function1 & Serializable & scala.Serializable)releaseUid -> BoxesRunTime.boxToBoolean((boolean)RiskRepository.$anonfun$delete$2(this, releaseUid))));
    }

    public Risk findByIdOrDefault(String riskId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("findByIdOrDefault(").append(riskId).append(")").toString());
        return (Risk)((Object)this.read(riskId).orElse((Function0 & Serializable & scala.Serializable)() -> {
            String releaseId = Ids.releaseIdFrom((String)riskId);
            return $this.releaseService.isArchived(releaseId) ? this.getExtensionFromArchivedRelease(releaseId) : None$.MODULE$;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.defaultRisk(riskId)));
    }

    public RiskAssessment findRiskAssessmentById(String riskAssessmentId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("findRiskAssessmentById(").append(riskAssessmentId).append(")").toString());
        Risk risk = this.findByIdOrDefault(Ids.getParentId((String)riskAssessmentId));
        return (RiskAssessment)((Object)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(risk.getRiskAssessments()).asScala()).find((Function1 & Serializable & scala.Serializable)ra -> BoxesRunTime.boxToBoolean((boolean)RiskRepository.$anonfun$findRiskAssessmentById$2(riskAssessmentId, ra))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(26).append("RiskAssessment ").append(riskAssessmentId).append(" not found.").toString(), new Object[0]);
        }));
    }

    public Risk defaultRisk(String riskId) {
        return RiskBuilder.newRisk().withId(riskId).withScore(0).withTotalScore(0).withAssessments(new RiskAssessment[0]).build();
    }

    public boolean updateRiskAssessments(Integer releaseUid, Seq<RiskAssessment> riskAssessments) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("updateRiskAssessments(").append(releaseUid).append(", ").append(riskAssessments.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getId(), Seq$.MODULE$.canBuildFrom())).append(")").toString());
        Seq<RiskAssessment> original = this.riskPersistence.readAllAssessments(releaseUid);
        Diff diff = Diff$.MODULE$.apply(((TraversableOnce)original.map((Function1 & Serializable & scala.Serializable)ra -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ra.getRiskAssessorId()), (Object)ra), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()), ((TraversableOnce)riskAssessments.map((Function1 & Serializable & scala.Serializable)ra -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ra.getRiskAssessorId()), (Object)ra), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        int numDeleted = this.riskPersistence.deleteAssessments(releaseUid, (Seq<String>)diff.deletedKeys().toSeq());
        int numUpdated = this.riskPersistence.updateAssessments(releaseUid, (Seq<RiskAssessment>)diff.updatedValues().toSeq());
        int numCreated = this.riskPersistence.createAssessments(releaseUid, (Seq<RiskAssessment>)diff.newValues().toSeq());
        int num = numCreated + numUpdated - numDeleted;
        return riskAssessments.size() == num;
    }

    public Option<Risk> getExtensionFromArchivedRelease(String releaseId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("getExtensionFromArchivedRelease(").append(releaseId).append(")").toString());
        Release release = this.releaseService.findByIdInArchive(releaseId);
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter((List)release.getProperty("extensions")).asScala()).collectFirst((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RiskRepository $outer;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final <A1 extends ReleaseExtension, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                void var3_8;
                A1 A1 = x1;
                if (A1 instanceof Risk) {
                    Risk risk = (Risk)A1;
                    String string = Ids.getName((String)risk.getId());
                    String string2 = this.$outer.name();
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        Risk risk2 = risk;
                        return var3_8;
                    }
                }
                Object object = function1.apply(x1);
                return var3_8;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(ReleaseExtension x1) {
                ReleaseExtension releaseExtension = x1;
                if (!(releaseExtension instanceof Risk)) return false;
                Risk risk = (Risk)releaseExtension;
                String string = Ids.getName((String)risk.getId());
                String string2 = this.$outer.name();
                if (string != null) {
                    if (!string.equals(string2)) return false;
                    return true;
                }
                if (string2 == null) return true;
                return false;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public <A> Option<A> withRelease0(String ciId, Function1<Integer, A> f) {
        return this.releasePersistence.findUidByReleaseId(ciId).map(f);
    }

    public <A> A withRelease(String ciId, Function1<Integer, A> f) {
        return (A)this.withRelease0(ciId, f).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(20).append("Release [").append(ciId).append("] not found").toString(), new Object[0]);
        });
    }

    public static final /* synthetic */ boolean $anonfun$update$2(RiskRepository $this, Risk risk$3, Integer releaseUid) {
        $this.updateRiskAssessments(releaseUid, (Seq<RiskAssessment>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(risk$3.getRiskAssessments()).asScala()));
        return $this.riskPersistence.update(releaseUid, Predef$.MODULE$.Integer2int(risk$3.getScore()), Predef$.MODULE$.Integer2int(risk$3.getTotalScore())) == 1;
    }

    public static final /* synthetic */ boolean $anonfun$delete$2(RiskRepository $this, Integer releaseUid) {
        int numDeleted = $this.riskPersistence.deleteAllAssessments(releaseUid);
        int deleted = $this.riskPersistence.delete(releaseUid);
        return numDeleted > 0 && deleted == 1;
    }

    public static final /* synthetic */ boolean $anonfun$findRiskAssessmentById$2(String riskAssessmentId$1, RiskAssessment ra) {
        String string = ra.getId();
        String string2 = riskAssessmentId$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @Autowired
    public RiskRepository(RiskPersistence riskPersistence, ReleasePersistence releasePersistence, ReleaseService releaseService) {
        this.riskPersistence = riskPersistence;
        this.releasePersistence = releasePersistence;
        this.releaseService = releaseService;
        Logging.$init$((Logging)this);
        this.name = "Risk";
    }
}

