/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.api.v1;

import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.risk.domain.RiskAssessment;
import com.xebialabs.xlrelease.risk.repository.RiskRepository;
import com.xebialabs.xlrelease.security.PermissionChecker;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/api/v1/risks/assessments")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Controller
public class RiskAssessmentApi {
    private PermissionChecker permissionChecker;
    private RiskRepository riskRepository;

    @Autowired
    public RiskAssessmentApi(PermissionChecker permissionChecker, RiskRepository riskRepository) {
        this.permissionChecker = permissionChecker;
        this.riskRepository = riskRepository;
    }

    @GET
    @Path(value="/{riskAssessmentId:.*RiskAssessment[^/-]*}")
    public RiskAssessment getAssessment(@PathParam(value="riskAssessmentId") String riskAssessmentId) {
        this.permissionChecker.checkView(Ids.releaseIdFrom((String)riskAssessmentId));
        return this.riskRepository.findRiskAssessmentById(riskAssessmentId);
    }
}

