/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseExtension;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseExtensionsRepository;
import com.xebialabs.xlrelease.service.ReleaseService;
import java.io.Serializable;
import java.util.List;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000194Q!\u0001\u0002\u0002\u0002-\u0011\u0011EU3mK\u0006\u001cX-\u0012=uK:\u001c\u0018n\u001c8t\u0011\u0016d\u0007/\u001a:SKB|7/\u001b;pefT!a\u0001\u0003\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0002\u0006\r\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003\u000f!\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003%\t1aY8n\u0007\u0001)\"\u0001D\u0014\u0014\u0005\u0001i\u0001C\u0001\b\u0012\u001b\u0005y!\"\u0001\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iy!AB!osJ+g\r\u0003\u0005\u0015\u0001\t\u0005\t\u0015!\u0003\u0016\u00039\u0011X\r\\3bg\u0016\u001cVM\u001d<jG\u0016\u0004\"AF\r\u000e\u0003]Q!\u0001\u0007\u0003\u0002\u000fM,'O^5dK&\u0011!d\u0006\u0002\u000f%\u0016dW-Y:f'\u0016\u0014h/[2f\u0011!a\u0002A!A!\u0002\u0013i\u0012a\u0007:fY\u0016\f7/Z#yi\u0016t7/[8ogJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002\u001f?5\t!!\u0003\u0002!\u0005\tY\"+\u001a7fCN,W\t\u001f;f]NLwN\\:SKB|7/\u001b;pefDQA\t\u0001\u0005\u0002\r\na\u0001P5oSRtDc\u0001\u00134iA\u0019a\u0004A\u0013\u0011\u0005\u0019:C\u0002\u0001\u0003\u0006Q\u0001\u0011\r!\u000b\u0002\u0002)F\u0011!&\f\t\u0003\u001d-J!\u0001L\b\u0003\u000f9{G\u000f[5oOB\u0011a&M\u0007\u0002_)\u0011\u0001\u0007B\u0001\u0007I>l\u0017-\u001b8\n\u0005Iz#\u0001\u0005*fY\u0016\f7/Z#yi\u0016t7/[8o\u0011\u0015!\u0012\u00051\u0001\u0016\u0011\u0015a\u0012\u00051\u0001\u001e\u0011\u00151\u0004\u0001\"\u00018\u0003E1\u0017N\u001c3Cs&#wJ\u001d#fM\u0006,H\u000e\u001e\u000b\u0004Kaj\u0004\"B\u001d6\u0001\u0004Q\u0014a\u0002:fY\u0016\f7/\u001a\t\u0003]mJ!\u0001P\u0018\u0003\u000fI+G.Z1tK\")a(\u000ea\u0001\u007f\u0005\u0011\"/\u001a7fCN,W\t\u001f;f]NLwN\\%e!\t\u0001uI\u0004\u0002B\u000bB\u0011!iD\u0007\u0002\u0007*\u0011AIC\u0001\u0007yI|w\u000e\u001e \n\u0005\u0019{\u0011A\u0002)sK\u0012,g-\u0003\u0002I\u0013\n11\u000b\u001e:j]\u001eT!AR\b)\u0005UZ\u0005C\u0001'T\u001b\u0005i%B\u0001(P\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003!F\u000bq!\\3ue&\u001c7O\u0003\u0002S\u0011\u0005A1m\u001c3bQ\u0006dW-\u0003\u0002U\u001b\n)A+[7fI\")a\u0007\u0001C\u0001-R\u0011Qe\u0016\u0005\u0006}U\u0003\ra\u0010\u0015\u0003+.CQA\u0017\u0001\u0005\u0002m\u000b\u0001BZ5oI\nK\u0018\n\u001a\u000b\u0003KqCQAP-A\u0002}B#!W&\t\u000b}\u0003A\u0011\u00011\u0002'\u001d,GOU3mK\u0006\u001cX-\u0012=uK:\u001c\u0018n\u001c8\u0015\u0005\u0005$\u0007c\u0001\bcK%\u00111m\u0004\u0002\u0007\u001fB$\u0018n\u001c8\t\u000byr\u0006\u0019A )\u0005y[\u0005\"B4\u0001\t\u0013A\u0017aH4fi\u0016CH/\u001a8tS>tgI]8n\u0003J\u001c\u0007.\u001b<fIJ+G.Z1tKR\u0011\u0011-\u001b\u0005\u0006}\u0019\u0004\ra\u0010\u0005\u0006W\u00021\t\u0001\\\u0001\u001eGJ,\u0017\r^3EK\u001a\fW\u000f\u001c;SK2,\u0017m]3FqR,gn]5p]R\u0011Q%\u001c\u0005\u0006})\u0004\ra\u0010")
public abstract class ReleaseExtensionsHelperRepository<T extends ReleaseExtension> {
    private final ReleaseService releaseService;
    private final ReleaseExtensionsRepository releaseExtensionsRepository;

    @Timed
    public T findByIdOrDefault(Release release, String releaseExtensionId) {
        return (T)((ReleaseExtension)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getExtensions()).asScala()).find((Function1 & Serializable & scala.Serializable)extension -> BoxesRunTime.boxToBoolean((boolean)ReleaseExtensionsHelperRepository.$anonfun$findByIdOrDefault$1(releaseExtensionId, extension))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.createDefaultReleaseExtension(releaseExtensionId)));
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public T findByIdOrDefault(String releaseExtensionId) {
        void var3_3;
        Option<T> extensionOption = this.getReleaseExtension(releaseExtensionId);
        ReleaseExtension result = (ReleaseExtension)extensionOption.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.createDefaultReleaseExtension(releaseExtensionId));
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public T findById(String releaseExtensionId) {
        void var3_3;
        Option<T> extensionOption = this.getReleaseExtension(releaseExtensionId);
        ReleaseExtension result = (ReleaseExtension)extensionOption.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ReleaseExtension [%s] does not exist in the repository or archive"})).s((Seq)Nil$.MODULE$), new Object[]{releaseExtensionId});
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Option<T> getReleaseExtension(String releaseExtensionId) {
        void var3_3;
        String releaseId = Ids.releaseIdFrom((String)releaseExtensionId);
        Option<T> extensionOption = this.releaseService.exists(releaseId) ? this.releaseExtensionsRepository.read(releaseExtensionId) : (this.releaseService.isArchived(releaseId) ? this.getExtensionFromArchivedRelease(releaseExtensionId) : None$.MODULE$);
        return var3_3;
    }

    private Option<T> getExtensionFromArchivedRelease(String releaseExtensionId) {
        Release release = this.releaseService.findByIdInArchive(Ids.releaseIdFrom((String)releaseExtensionId));
        return ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)release.getProperty("extensions")).asScala()).find((Function1 & Serializable & scala.Serializable)extension -> BoxesRunTime.boxToBoolean((boolean)ReleaseExtensionsHelperRepository.$anonfun$getExtensionFromArchivedRelease$1(releaseExtensionId, extension)));
    }

    public abstract T createDefaultReleaseExtension(String var1);

    public static final /* synthetic */ boolean $anonfun$findByIdOrDefault$1(String releaseExtensionId$1, ReleaseExtension extension) {
        String string = Ids.getName((String)extension.getId());
        String string2 = Ids.getName((String)releaseExtensionId$1);
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getExtensionFromArchivedRelease$1(String releaseExtensionId$4, ReleaseExtension extension) {
        String string = Ids.getName((String)extension.getId());
        String string2 = Ids.getName((String)releaseExtensionId$4);
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public ReleaseExtensionsHelperRepository(ReleaseService releaseService, ReleaseExtensionsRepository releaseExtensionsRepository) {
        this.releaseService = releaseService;
        this.releaseExtensionsRepository = releaseExtensionsRepository;
    }
}

