/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.events.ConfigurationCopiedEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationDeletedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.RetryTitleGenerator;
import com.xebialabs.xlrelease.repository.query.ReleaseBasicData;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.risk.domain.events.RiskProfileUpdated;
import com.xebialabs.xlrelease.risk.domain.riskassessors.RiskAssessor;
import com.xebialabs.xlrelease.risk.repository.RiskIds$;
import com.xebialabs.xlrelease.service.CiIdService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005me\u0001B\u000b\u0017\u0001\u0005B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\tm\u0001\u0011\t\u0011)A\u0005o!AQ\b\u0001B\u0001B\u0003%a\b\u0003\u0005B\u0001\t\u0015\r\u0011\"\u0001C\u0011!I\u0005A!A!\u0002\u0013\u0019\u0005\"\u0002&\u0001\t\u0003Y\u0005\"B1\u0001\t\u0003\u0011\u0007\"B;\u0001\t\u00031\bbBA\t\u0001\u0011\u0005\u00111\u0003\u0005\b\u00033\u0001A\u0011AA\u000e\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003KAq!a\u000b\u0001\t\u0003\ti\u0003C\u0004\u0002B\u0001!\t!a\u0011\t\u000f\u0005-\u0003\u0001\"\u0001\u0002N!9\u00111\u000b\u0001\u0005\u0002\u0005U\u0003bBA1\u0001\u0011\u0005\u00111\r\u0005\b\u0003S\u0002A\u0011AA6\u0011\u001d\ty\b\u0001C\u0001\u0003\u0003C\u0001\"a!\u0001A\u0013%\u0011Q\u0011\u0005\t\u0003\u0013\u0003\u0001\u0015\"\u0003\u0002\f\n\u0011\"+[:l!J|g-\u001b7f'\u0016\u0014h/[2f\u0015\t9\u0002$A\u0004tKJ4\u0018nY3\u000b\u0005eQ\u0012\u0001\u0002:jg.T!a\u0007\u000f\u0002\u0013ad'/\u001a7fCN,'BA\u000f\u001f\u0003%AXMY5bY\u0006\u00147OC\u0001 \u0003\r\u0019w.\\\u0002\u0001'\r\u0001!\u0005\u000b\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005%rS\"\u0001\u0016\u000b\u0005-b\u0013!B:mMRR'\"A\u0017\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!a\f\u0016\u0003\u000f1{wmZ5oO\u0006Y1-[%e'\u0016\u0014h/[2f!\t\u0011D'D\u00014\u0015\t9\"$\u0003\u00026g\tY1)[%e'\u0016\u0014h/[2f\u0003]\u0019wN\u001c4jOV\u0014\u0018\r^5p]J+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u00029w5\t\u0011H\u0003\u0002;5\u0005Q!/\u001a9pg&$xN]=\n\u0005qJ$aF\"p]\u001aLw-\u001e:bi&|gNU3q_NLGo\u001c:z\u0003E\u0011X\r\\3bg\u0016\u0014V\r]8tSR|'/\u001f\t\u0003q}J!\u0001Q\u001d\u0003#I+G.Z1tKJ+\u0007o\\:ji>\u0014\u00180\u0001\u0005fm\u0016tGOQ;t+\u0005\u0019\u0005C\u0001#H\u001b\u0005)%B\u0001$\u001b\u0003\u0019)g/\u001a8ug&\u0011\u0001*\u0012\u0002\u001212\u0013V\r\\3bg\u0016,e/\u001a8u\u0005V\u001c\u0018!C3wK:$()^:!\u0003\u0019a\u0014N\\5u}Q)AJT(Q#B\u0011Q\nA\u0007\u0002-!)\u0001G\u0002a\u0001c!)aG\u0002a\u0001o!)QH\u0002a\u0001}!)\u0011I\u0002a\u0001\u0007\"\u0012aa\u0015\t\u0003)~k\u0011!\u0016\u0006\u0003-^\u000b!\"\u00198o_R\fG/[8o\u0015\tA\u0016,A\u0004gC\u000e$xN]=\u000b\u0005i[\u0016!\u00022fC:\u001c(B\u0001/^\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u00010\u0002\u0007=\u0014x-\u0003\u0002a+\nI\u0011)\u001e;po&\u0014X\rZ\u0001\u0007GJ,\u0017\r^3\u0015\u0005\rL\u0007C\u00013h\u001b\u0005)'B\u00014\u0019\u0003\u0019!w.\\1j]&\u0011\u0001.\u001a\u0002\f%&\u001c8\u000e\u0015:pM&dW\rC\u0003k\u000f\u0001\u00071-A\u0006sSN\\\u0007K]8gS2,\u0007FA\u0004m!\ti7/D\u0001o\u0015\t1vN\u0003\u0002qc\u00069Q.\u001a;sS\u000e\u001c(B\u0001:\u001f\u0003!\u0019w\u000eZ1iC2,\u0017B\u0001;o\u0005\u0015!\u0016.\\3e\u0003\u0019)\u00070[:ugR\u0011qO\u001f\t\u0003GaL!!\u001f\u0013\u0003\u000f\t{w\u000e\\3b]\")1\u0010\u0003a\u0001y\u0006i!/[:l!J|g-\u001b7f\u0013\u0012\u00042!`A\u0005\u001d\rq\u0018Q\u0001\t\u0003\u007f\u0012j!!!\u0001\u000b\u0007\u0005\r\u0001%\u0001\u0004=e>|GOP\u0005\u0004\u0003\u000f!\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002\f\u00055!AB*ue&twMC\u0002\u0002\b\u0011B#\u0001\u00037\u0002\u0011\u0019Lg\u000e\u001a\"z\u0013\u0012$2aYA\u000b\u0011\u0015Y\u0018\u00021\u0001}Q\tIA.A\u0007fq&\u001cHo\u001d\"z)&$H.\u001a\u000b\u0004o\u0006u\u0001BBA\u0010\u0015\u0001\u0007A0A\u0003uSRdW\r\u000b\u0002\u000bY\u0006\tb-\u001b8e\u0005fLEm\u0014:EK\u001a\fW\u000f\u001c;\u0015\u0007\r\f9\u0003C\u0003|\u0017\u0001\u0007A\u0010\u000b\u0002\fY\u00069a-\u001b8e\u00032dGCAA\u0018!\u0015\t\t$a\u000fd\u001b\t\t\u0019D\u0003\u0003\u00026\u0005]\u0012\u0001B;uS2T!!!\u000f\u0002\t)\fg/Y\u0005\u0005\u0003{\t\u0019D\u0001\u0003MSN$\bF\u0001\u0007m\u0003-1\u0017N\u001c3CsRKG\u000f\\3\u0015\u0007\r\f)\u0005\u0003\u0004\u0002H5\u0001\r\u0001`\u0001\u0011e&\u001c8\u000e\u0015:pM&dW\rV5uY\u0016D#!\u00047\u0002\rU\u0004H-\u0019;f)\r\u0019\u0017q\n\u0005\u0006U:\u0001\ra\u0019\u0015\u0003\u001d1\fa\u0001Z3mKR,G\u0003BA,\u0003;\u00022aIA-\u0013\r\tY\u0006\n\u0002\u0005+:LG\u000fC\u0003|\u001f\u0001\u0007A\u0010\u000b\u0002\u0010Y\u0006!1m\u001c9z)\r\u0019\u0017Q\r\u0005\u0006wB\u0001\r\u0001 \u0015\u0003!1\fQbZ3u%\u00164WM]3oG\u0016\u001cH\u0003BA7\u0003w\u0002b!!\r\u0002<\u0005=\u0004\u0003BA9\u0003oj!!a\u001d\u000b\u0007\u0005U\u0014(A\u0003rk\u0016\u0014\u00180\u0003\u0003\u0002z\u0005M$\u0001\u0005*fY\u0016\f7/\u001a\"bg&\u001cG)\u0019;b\u0011\u0015Y\u0018\u00031\u0001}Q\t\tB.\u0001\u000ehK:,'/\u0019;f\t\u00164\u0017-\u001e7u%&\u001c8\u000e\u0015:pM&dW-F\u0001d\u00039\u0019\u0007.Z2l\tV\u0004H.[2bi\u0016$B!a\u0016\u0002\b\"1\u0011qD\nA\u0002q\fQcZ3oKJ\fG/\u001a*jg.\u0004&o\u001c4jY\u0016LE-F\u0001}Q\r\u0001\u0011q\u0012\t\u0005\u0003#\u000b9*\u0004\u0002\u0002\u0014*\u0019\u0011QS.\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0002\u001a\u0006M%aB*feZL7-\u001a")
public class RiskProfileService
implements Logging {
    private final CiIdService ciIdService;
    private final ConfigurationRepository configurationRepository;
    private final XLReleaseEventBus eventBus;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RiskProfileService riskProfileService = this;
        synchronized (riskProfileService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    @Timed
    public RiskProfile create(RiskProfile riskProfile) {
        this.checkDuplicate(riskProfile.getTitle());
        riskProfile.setId(this.generateRiskProfileId());
        this.configurationRepository.create((BaseConfiguration)riskProfile);
        this.eventBus().publish((XLReleaseEvent)new ConfigurationCreatedEvent((BaseConfiguration)riskProfile));
        return riskProfile;
    }

    @Timed
    public boolean exists(String riskProfileId) {
        return this.configurationRepository.exists(riskProfileId);
    }

    @Timed
    public RiskProfile findById(String riskProfileId) {
        return (RiskProfile)this.configurationRepository.read(riskProfileId);
    }

    @Timed
    public boolean existsByTitle(String title) {
        return this.configurationRepository.existsByTypeAndTitle(Type.valueOf(RiskProfile.class), title);
    }

    @Timed
    public RiskProfile findByIdOrDefault(String riskProfileId) {
        RiskProfile riskProfile;
        try {
            riskProfile = (RiskProfile)this.configurationRepository.read(riskProfileId);
        }
        catch (NotFoundException notFoundException) {
            riskProfile = this.generateDefaultRiskProfile();
        }
        return riskProfile;
    }

    @Timed
    public List<RiskProfile> findAll() {
        return this.configurationRepository.findAllByType(Type.valueOf(RiskProfile.class));
    }

    @Timed
    public RiskProfile findByTitle(String riskProfileTitle) {
        List profiles = this.configurationRepository.findAllByTypeAndTitle(Type.valueOf(RiskProfile.class), riskProfileTitle);
        int n = profiles.size();
        switch (n) {
            case 0: {
                throw new NotFoundException(new StringBuilder(40).append("Could not find risk profile for title [").append(riskProfileTitle).append("]").toString(), new Object[0]);
            }
        }
        return (RiskProfile)((Object)profiles.get(0));
    }

    @Timed
    public RiskProfile update(RiskProfile riskProfile) {
        RiskProfile currentRiskProfile = this.findById(riskProfile.getId());
        String string = currentRiskProfile.getTitle();
        String string2 = riskProfile.getTitle();
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.checkDuplicate(riskProfile.getTitle());
        }
        this.configurationRepository.update((BaseConfiguration)riskProfile);
        this.eventBus().publish((XLReleaseEvent)new RiskProfileUpdated(riskProfile));
        return riskProfile;
    }

    @Timed
    public void delete(String riskProfileId) {
        RiskProfile riskProfile = this.findById(riskProfileId);
        this.configurationRepository.delete(riskProfileId);
        this.eventBus().publish((XLReleaseEvent)new ConfigurationDeletedEvent((BaseConfiguration)riskProfile));
    }

    @Timed
    public RiskProfile copy(String riskProfileId) {
        RiskProfile riskProfile = this.findById(riskProfileId);
        String copyRiskProfileTitle = riskProfile.getTitle();
        while (this.existsByTitle(copyRiskProfileTitle)) {
            copyRiskProfileTitle = RetryTitleGenerator.getNextTitle((String)copyRiskProfileTitle);
        }
        RiskProfile copyRiskProfile = (RiskProfile)Type.valueOf(RiskProfile.class).getDescriptor().newInstance(this.generateRiskProfileId());
        copyRiskProfile.setTitle(copyRiskProfileTitle);
        copyRiskProfile.setRiskProfileAssessors(riskProfile.getRiskProfileAssessors());
        this.configurationRepository.create((BaseConfiguration)copyRiskProfile);
        this.eventBus().publish((XLReleaseEvent)new ConfigurationCopiedEvent((BaseConfiguration)riskProfile, copyRiskProfile.getId()));
        return copyRiskProfile;
    }

    @Timed
    public List<ReleaseBasicData> getReferences(String riskProfileId) {
        return this.configurationRepository.getReferences(riskProfileId);
    }

    /*
     * WARNING - void declaration
     */
    public RiskProfile generateDefaultRiskProfile() {
        void var1_1;
        RiskProfile defaultRiskProfile = (RiskProfile)Type.valueOf(RiskProfile.class).getDescriptor().newInstance(null);
        ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(DescriptorRegistry.getSubtypes((Type)Type.valueOf(RiskAssessor.class))).asScala()).filter((Function1 & Serializable & scala.Serializable)type -> BoxesRunTime.boxToBoolean((boolean)RiskProfileService.$anonfun$generateDefaultRiskProfile$1(type)))).foreach((Function1 & Serializable & scala.Serializable)t -> {
            defaultRiskProfile.setValueFor(t, BoxesRunTime.unboxToInt((Object)t.getDescriptor().getPropertyDescriptor("score").getDefaultValue()));
            return BoxedUnit.UNIT;
        });
        return var1_1;
    }

    private void checkDuplicate(String title) {
        if (this.existsByTitle(title)) {
            throw new ItemAlreadyExistsException("Risk profile '%s' already exist.", new Object[]{title});
        }
    }

    private String generateRiskProfileId() {
        return this.ciIdService.getUniqueId(Type.valueOf(RiskProfile.class), RiskIds$.MODULE$.RISK_PROFILE_CONFIGURATION_ROOT());
    }

    public static final /* synthetic */ boolean $anonfun$generateDefaultRiskProfile$1(Type type) {
        return !type.getDescriptor().isVirtual();
    }

    @Autowired
    public RiskProfileService(CiIdService ciIdService, ConfigurationRepository configurationRepository, ReleaseRepository releaseRepository, XLReleaseEventBus eventBus) {
        this.ciIdService = ciIdService;
        this.configurationRepository = configurationRepository;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

