/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.domain.riskassessors;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.status.FlagStatus;
import com.xebialabs.xlrelease.risk.domain.RiskAssessment;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.risk.domain.riskassessors.RiskAssessor;
import java.util.ArrayList;
import java.util.Optional;

@PublicApiRef
@Metadata(label="ReleaseFlaggedAttentionNeededRiskAssessor", versioned=false)
public class ReleaseFlaggedAttentionNeededRiskAssessor
extends RiskAssessor {
    private static final String RELEASE_NEEDS_ATTENTION_HEADLINE = "Release is flagged as amber";
    private static final String RELEASE_FLAGGED_MESSAGE = "%s: %s";

    @Override
    public RiskAssessment execute(Release release, RiskProfile riskProfile) {
        RiskAssessment assessment = new RiskAssessment();
        assessment.setRiskAssessorId(this.getId());
        ArrayList<String> messages = new ArrayList<String>();
        if (release.getFlagStatus() == FlagStatus.ATTENTION_NEEDED) {
            assessment.setScore(riskProfile.getValueFor(this.getType()));
            assessment.setHeadline(RELEASE_NEEDS_ATTENTION_HEADLINE);
            messages.add(this.getMessage(release.getTitle(), release.getFlagComment()));
        } else {
            assessment.setScore(0);
            assessment.setHeadline("Release is on track");
        }
        assessment.setMessages(messages);
        return assessment;
    }

    private String getMessage(String releaseTitle, String flagComment) {
        return String.format(RELEASE_FLAGGED_MESSAGE, releaseTitle, Optional.ofNullable(flagComment).orElse(""));
    }
}

