/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.repository;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseExtension;
import com.xebialabs.xlrelease.domain.utils.Diff;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseExtensionsRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.risk.builder.RiskBuilder;
import com.xebialabs.xlrelease.risk.domain.Risk;
import com.xebialabs.xlrelease.risk.domain.RiskAssessment;
import com.xebialabs.xlrelease.risk.repository.sql.persistence.RiskPersistence;
import com.xebialabs.xlrelease.service.ReleaseService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Repository
@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\u0005%h\u0001B\u0001\u0003\u00015\u0011aBU5tWJ+\u0007o\\:ji>\u0014\u0018P\u0003\u0002\u0004\t\u0005Q!/\u001a9pg&$xN]=\u000b\u0005\u00151\u0011\u0001\u0002:jg.T!a\u0002\u0005\u0002\u0013ad'/\u001a7fCN,'BA\u0005\u000b\u0003%AXMY5bY\u0006\u00147OC\u0001\f\u0003\r\u0019w.\\\u0002\u0001'\r\u0001ab\n\t\u0004\u001fy\tcB\u0001\t\u001c\u001d\t\t\"D\u0004\u0002\u001339\u00111\u0003\u0007\b\u0003)]i\u0011!\u0006\u0006\u0003-1\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0005%Q\u0011BA\u0004\t\u0013\t\u0019a!\u0003\u0002\u001d;\u0005Y\"+\u001a7fCN,W\t\u001f;f]NLwN\\:SKB|7/\u001b;pefT!a\u0001\u0004\n\u0005}\u0001#!\n*fY\u0016\f7/Z#yi\u0016t7/[8o'B,7-[1mSj,GMU3q_NLGo\u001c:z\u0015\taR\u0004\u0005\u0002#K5\t1E\u0003\u0002%\t\u00051Am\\7bS:L!AJ\u0012\u0003\tIK7o\u001b\t\u0003Q5j\u0011!\u000b\u0006\u0003U-\nQa\u001d7gi)T\u0011\u0001L\u0001\tOJL'P\u001f7fI&\u0011a&\u000b\u0002\b\u0019><w-\u001b8h\u0011!\u0001\u0004A!A!\u0002\u0013\t\u0014a\u0004:jg.\u0004VM]:jgR,gnY3\u0011\u0005I:T\"A\u001a\u000b\u0005Q*\u0014a\u00039feNL7\u000f^3oG\u0016T!A\u000e\u0002\u0002\u0007M\fH.\u0003\u00029g\ty!+[:l!\u0016\u00148/[:uK:\u001cW\r\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003<\u0003I\u0011X\r\\3bg\u0016\u0004VM]:jgR,gnY3\u0011\u0005qzT\"A\u001f\u000b\u0005Qr$B\u0001\u001c\u001e\u0013\t\u0001UH\u0001\nSK2,\u0017m]3QKJ\u001c\u0018n\u001d;f]\u000e,\u0007\u0002\u0003\"\u0001\u0005\u0003\u0005\u000b\u0011B\"\u0002\u001dI,G.Z1tKN+'O^5dKB\u0011AiR\u0007\u0002\u000b*\u0011aIB\u0001\bg\u0016\u0014h/[2f\u0013\tAUI\u0001\bSK2,\u0017m]3TKJ4\u0018nY3\t\u000b)\u0003A\u0011A&\u0002\rqJg.\u001b;?)\u0011aej\u0014)\u0011\u00055\u0003Q\"\u0001\u0002\t\u000bAJ\u0005\u0019A\u0019\t\u000biJ\u0005\u0019A\u001e\t\u000b\tK\u0005\u0019A\")\u0005%\u0013\u0006CA*_\u001b\u0005!&BA+W\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003/b\u000bqAZ1di>\u0014\u0018P\u0003\u0002Z5\u0006)!-Z1og*\u00111\fX\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\tQ,A\u0002pe\u001eL!a\u0018+\u0003\u0013\u0005+Ho\\<je\u0016$\u0007bB1\u0001\u0005\u0004%\tEY\u0001\u0005]\u0006lW-F\u0001d!\t!'N\u0004\u0002fQB\u0011AC\u001a\u0006\u0002O\u0006)1oY1mC&\u0011\u0011NZ\u0001\u0007!J,G-\u001a4\n\u0005-d'AB*ue&twM\u0003\u0002jM\"1a\u000e\u0001Q\u0001\n\r\fQA\\1nK\u0002BQ\u0001\u001d\u0001\u0005BE\fa!\u001a=jgR\u001cHC\u0001:w!\t\u0019H/D\u0001g\u0013\t)hMA\u0004C_>dW-\u00198\t\u000b]|\u0007\u0019A2\u0002\rIL7o[%e\u0011\u0015I\b\u0001\"\u0011{\u0003\u0011\u0011X-\u00193\u0015\u0005mt\bcA:}C%\u0011QP\u001a\u0002\u0007\u001fB$\u0018n\u001c8\t\u000b]D\b\u0019A2\t\u000f\u0005\u0005\u0001\u0001\"\u0011\u0002\u0004\u000511M]3bi\u0016$2!IA\u0003\u0011\u0015)q\u00101\u0001\"\u0011\u001d\tI\u0001\u0001C!\u0003\u0017\ta!\u001e9eCR,Gc\u0001:\u0002\u000e!1Q!a\u0002A\u0002\u0005Bq!!\u0005\u0001\t\u0003\n\u0019\"\u0001\u0004eK2,G/\u001a\u000b\u0004e\u0006U\u0001BB<\u0002\u0010\u0001\u00071\rC\u0004\u0002\u001a\u0001!\t!a\u0007\u0002#\u0019Lg\u000e\u001a\"z\u0013\u0012|%\u000fR3gCVdG\u000fF\u0002\"\u0003;Aaa^A\f\u0001\u0004\u0019\u0007bBA\u0011\u0001\u0011\u0005\u00111E\u0001\u0017M&tGMU5tW\u0006\u001b8/Z:t[\u0016tGOQ=JIR!\u0011QEA\u0016!\r\u0011\u0013qE\u0005\u0004\u0003S\u0019#A\u0004*jg.\f5o]3tg6,g\u000e\u001e\u0005\b\u0003[\ty\u00021\u0001d\u0003A\u0011\u0018n]6BgN,7o]7f]RLE\rC\u0004\u00022\u0001!\t!a\r\u0002\u0017\u0011,g-Y;miJK7o\u001b\u000b\u0004C\u0005U\u0002BB<\u00020\u0001\u00071\rC\u0004\u0002:\u0001!\t\"a\u000f\u0002+U\u0004H-\u0019;f%&\u001c8.Q:tKN\u001cX.\u001a8ugR)!/!\u0010\u0002X!A\u0011qHA\u001c\u0001\u0004\t\t%\u0001\u0006sK2,\u0017m]3VS\u0012\u0004B!a\u0011\u0002R9!\u0011QIA'\u001d\u0011\t9%a\u0013\u000f\u0007A\tI%\u0003\u00027;%\u0011AGP\u0005\u0004\u0003\u001fj\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003'\n)FA\u0003DSVKGMC\u0002\u0002PuB\u0001\"!\u0017\u00028\u0001\u0007\u00111L\u0001\u0010e&\u001c8.Q:tKN\u001cX.\u001a8ugB1\u0011QLA3\u0003KqA!a\u0018\u0002d9\u0019A#!\u0019\n\u0003\u001dL1!a\u0014g\u0013\u0011\t9'!\u001b\u0003\u0007M+\u0017OC\u0002\u0002P\u0019Dq!!\u001c\u0001\t#\ty'A\u0010hKR,\u0005\u0010^3og&|gN\u0012:p[\u0006\u00138\r[5wK\u0012\u0014V\r\\3bg\u0016$2a_A9\u0011!\t\u0019(a\u001bA\u0002\u0005U\u0014!\u0003:fY\u0016\f7/Z%e!\u0011\t9(! \u000f\t\u0005\u0015\u0013\u0011P\u0005\u0004\u0003wj\u0014\u0001B\"j\u0013\u0012LA!a \u0002\u0002\n!1)[%e\u0015\r\tY(\u0010\u0005\b\u0003\u000b\u0003A\u0011CAD\u000319\u0018\u000e\u001e5SK2,\u0017m]31+\u0011\tI)a%\u0015\t\u0005-\u0015q\u0016\u000b\u0005\u0003\u001b\u000b)\u000b\u0005\u0003ty\u0006=\u0005\u0003BAI\u0003'c\u0001\u0001\u0002\u0005\u0002\u0016\u0006\r%\u0019AAL\u0005\u0005\t\u0015\u0003BAM\u0003?\u00032a]AN\u0013\r\tiJ\u001a\u0002\b\u001d>$\b.\u001b8h!\r\u0019\u0018\u0011U\u0005\u0004\u0003G3'aA!os\"A\u0011qUAB\u0001\u0004\tI+A\u0001g!\u001d\u0019\u00181VA!\u0003\u001fK1!!,g\u0005%1UO\\2uS>t\u0017\u0007\u0003\u0005\u00022\u0006\r\u0005\u0019AA;\u0003\u0011\u0019\u0017.\u00133\t\u000f\u0005U\u0006\u0001\"\u0005\u00028\u0006Yq/\u001b;i%\u0016dW-Y:f+\u0011\tI,a0\u0015\t\u0005m\u0016Q\u0019\u000b\u0005\u0003{\u000b\t\r\u0005\u0003\u0002\u0012\u0006}F\u0001CAK\u0003g\u0013\r!a&\t\u0011\u0005\u001d\u00161\u0017a\u0001\u0003\u0007\u0004ra]AV\u0003\u0003\ni\f\u0003\u0005\u00022\u0006M\u0006\u0019AA;Q\r\u0001\u0011\u0011\u001a\t\u0005\u0003\u0017\f9.\u0004\u0002\u0002N*!\u0011qZAi\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\u0007Y\n\u0019NC\u0002\u0002V\u001a\t!\u0001\u001a2\n\t\u0005e\u0017Q\u001a\u0002\u0010\u0013N$&/\u00198tC\u000e$\u0018n\u001c8bY\"\u001a\u0001!!8\u0011\t\u0005}\u0017Q]\u0007\u0003\u0003CT1!a9[\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003O\f\tO\u0001\u0006SKB|7/\u001b;pef\u0004")
public class RiskRepository
extends ReleaseExtensionsRepository.ReleaseExtensionSpecializedRepository<Risk>
implements Logging {
    private final RiskPersistence riskPersistence;
    private final ReleasePersistence releasePersistence;
    private final ReleaseService releaseService;
    private final String name;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RiskRepository riskRepository = this;
        synchronized (riskRepository) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public String name() {
        return this.name;
    }

    public boolean exists(String riskId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"exists(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{riskId})));
        return this.releasePersistence.findUidByReleaseId(Ids.releaseIdFrom((String)riskId)).exists((Function1 & Serializable & scala.Serializable)releaseUid -> BoxesRunTime.boxToBoolean((boolean)this.riskPersistence.exists(releaseUid)));
    }

    public Option<Risk> read(String riskId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"read(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{riskId})));
        return this.withRelease0(Ids.releaseIdFrom((String)riskId), (Function1 & Serializable & scala.Serializable)releaseUid -> $this.riskPersistence.read((Integer)releaseUid).map((Function1 & Serializable & scala.Serializable)risk -> {
            risk.setId(riskId);
            Seq<RiskAssessment> riskAssessments = $this.riskPersistence.readAllAssessments((Integer)releaseUid);
            riskAssessments.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                x$1.setRisk(risk);
                return BoxedUnit.UNIT;
            });
            risk.setRiskAssessments((List)JavaConverters$.MODULE$.seqAsJavaListConverter(riskAssessments).asJava());
            return risk;
        })).flatten(Predef$.MODULE$.$conforms());
    }

    public Risk create(Risk risk) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"create(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{risk.getId()})));
        return (Risk)((Object)this.withRelease(Ids.releaseIdFrom((String)risk.getId()), (Function1 & Serializable & scala.Serializable)releaseUid -> {
            $this.riskPersistence.create((Integer)releaseUid, Predef$.MODULE$.Integer2int(risk.getScore()), Predef$.MODULE$.Integer2int(risk.getTotalScore()));
            $this.riskPersistence.createAssessments((Integer)releaseUid, (Seq<RiskAssessment>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(risk.getRiskAssessments()).asScala()));
            return risk;
        }));
    }

    public boolean update(Risk risk) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"update(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{risk.getId()})));
        return BoxesRunTime.unboxToBoolean(this.withRelease(Ids.releaseIdFrom((String)risk.getId()), (Function1 & Serializable & scala.Serializable)releaseUid -> BoxesRunTime.boxToBoolean((boolean)RiskRepository.$anonfun$update$2(this, risk, releaseUid))));
    }

    public boolean delete(String riskId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"delete(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{riskId})));
        return BoxesRunTime.unboxToBoolean(this.withRelease(Ids.releaseIdFrom((String)riskId), (Function1 & Serializable & scala.Serializable)releaseUid -> BoxesRunTime.boxToBoolean((boolean)RiskRepository.$anonfun$delete$2(this, releaseUid))));
    }

    public Risk findByIdOrDefault(String riskId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"findByIdOrDefault(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{riskId})));
        return (Risk)((Object)this.read(riskId).orElse((Function0 & Serializable & scala.Serializable)() -> {
            String releaseId = Ids.releaseIdFrom((String)riskId);
            return $this.releaseService.isArchived(releaseId) ? this.getExtensionFromArchivedRelease(releaseId) : None$.MODULE$;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.defaultRisk(riskId)));
    }

    public RiskAssessment findRiskAssessmentById(String riskAssessmentId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"findRiskAssessmentById(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{riskAssessmentId})));
        Risk risk = this.findByIdOrDefault(Ids.getParentId((String)riskAssessmentId));
        return (RiskAssessment)((Object)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(risk.getRiskAssessments()).asScala()).find((Function1 & Serializable & scala.Serializable)ra -> BoxesRunTime.boxToBoolean((boolean)RiskRepository.$anonfun$findRiskAssessmentById$2(riskAssessmentId, ra))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RiskAssessment ", " not found."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{riskAssessmentId})), new Object[0]);
        }));
    }

    public Risk defaultRisk(String riskId) {
        return RiskBuilder.newRisk().withId(riskId).withScore(0).withTotalScore(0).withAssessments(new RiskAssessment[0]).build();
    }

    public boolean updateRiskAssessments(Integer releaseUid, Seq<RiskAssessment> riskAssessments) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"updateRiskAssessments(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseUid, riskAssessments.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getId(), Seq$.MODULE$.canBuildFrom())})));
        Seq<RiskAssessment> original = this.riskPersistence.readAllAssessments(releaseUid);
        Diff diff = new Diff(((TraversableOnce)original.map((Function1 & Serializable & scala.Serializable)ra -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ra.getRiskAssessorId()), (Object)ra), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()), ((TraversableOnce)riskAssessments.map((Function1 & Serializable & scala.Serializable)ra -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ra.getRiskAssessorId()), (Object)ra), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        int numDeleted = this.riskPersistence.deleteAssessments(releaseUid, (Seq<String>)diff.deletedKeys().toSeq());
        int numUpdated = this.riskPersistence.updateAssessments(releaseUid, (Seq<RiskAssessment>)diff.updatedValues().toSeq());
        int numCreated = this.riskPersistence.createAssessments(releaseUid, (Seq<RiskAssessment>)diff.newValues().toSeq());
        int num = numCreated + numUpdated - numDeleted;
        return riskAssessments.size() == num;
    }

    public Option<Risk> getExtensionFromArchivedRelease(String releaseId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"getExtensionFromArchivedRelease(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseId})));
        Release release = this.releaseService.findByIdInArchive(releaseId);
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter((List)release.getProperty("extensions")).asScala()).collectFirst((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RiskRepository $outer;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final <A1 extends ReleaseExtension, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                void var3_8;
                A1 A1 = x1;
                if (A1 instanceof Risk) {
                    Risk risk = (Risk)A1;
                    String string = Ids.getName((String)risk.getId());
                    String string2 = this.$outer.name();
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        Risk risk2 = risk;
                        return var3_8;
                    }
                }
                Object object = function1.apply(x1);
                return var3_8;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(ReleaseExtension x1) {
                ReleaseExtension releaseExtension = x1;
                if (!(releaseExtension instanceof Risk)) return false;
                Risk risk = (Risk)releaseExtension;
                String string = Ids.getName((String)risk.getId());
                String string2 = this.$outer.name();
                if (string != null) {
                    if (!string.equals(string2)) return false;
                    return true;
                }
                if (string2 == null) return true;
                return false;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public <A> Option<A> withRelease0(String ciId, Function1<Integer, A> f) {
        return this.releasePersistence.findUidByReleaseId(ciId).map(f);
    }

    public <A> A withRelease(String ciId, Function1<Integer, A> f) {
        return (A)this.withRelease0(ciId, f).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Release [", "] not found"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ciId})), new Object[0]);
        });
    }

    public static final /* synthetic */ boolean $anonfun$update$2(RiskRepository $this, Risk risk$2, Integer releaseUid) {
        $this.updateRiskAssessments(releaseUid, (Seq<RiskAssessment>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(risk$2.getRiskAssessments()).asScala()));
        return $this.riskPersistence.update(releaseUid, Predef$.MODULE$.Integer2int(risk$2.getScore()), Predef$.MODULE$.Integer2int(risk$2.getTotalScore())) == 1;
    }

    public static final /* synthetic */ boolean $anonfun$delete$2(RiskRepository $this, Integer releaseUid) {
        int numDeleted = $this.riskPersistence.deleteAllAssessments(releaseUid);
        int deleted = $this.riskPersistence.delete(releaseUid);
        return numDeleted > 0 && deleted == 1;
    }

    public static final /* synthetic */ boolean $anonfun$findRiskAssessmentById$2(String riskAssessmentId$1, RiskAssessment ra) {
        String string = ra.getId();
        String string2 = riskAssessmentId$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @Autowired
    public RiskRepository(RiskPersistence riskPersistence, ReleasePersistence releasePersistence, ReleaseService releaseService) {
        this.riskPersistence = riskPersistence;
        this.releasePersistence = releasePersistence;
        this.releaseService = releaseService;
        Logging.$init$((Logging)this);
        this.name = "Risk";
    }
}

