/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.RetryTitleGenerator;
import com.xebialabs.xlrelease.repository.query.ReleaseBasicData;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.risk.domain.events.RiskProfileUpdated;
import com.xebialabs.xlrelease.risk.domain.riskassessors.RiskAssessor;
import com.xebialabs.xlrelease.risk.repository.RiskIds$;
import com.xebialabs.xlrelease.service.CiIdService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005me\u0001B\u0001\u0003\u00015\u0011!CU5tWB\u0013xNZ5mKN+'O^5dK*\u00111\u0001B\u0001\bg\u0016\u0014h/[2f\u0015\t)a!\u0001\u0003sSN\\'BA\u0004\t\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\n\u0015\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002\u0017\u0005\u00191m\\7\u0004\u0001M\u0019\u0001A\u0004\u000b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)\"$D\u0001\u0017\u0015\t9\u0002$A\u0003tY\u001a$$NC\u0001\u001a\u0003!9'/\u001b>{Y\u0016$\u0017BA\u000e\u0017\u0005\u001daunZ4j]\u001eD\u0001\"\b\u0001\u0003\u0002\u0003\u0006IAH\u0001\fG&LEmU3sm&\u001cW\r\u0005\u0002 C5\t\u0001E\u0003\u0002\u0004\r%\u0011!\u0005\t\u0002\f\u0007&LEmU3sm&\u001cW\r\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003&\u0003]\u0019wN\u001c4jOV\u0014\u0018\r^5p]J+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002'S5\tqE\u0003\u0002)\r\u0005Q!/\u001a9pg&$xN]=\n\u0005):#aF\"p]\u001aLw-\u001e:bi&|gNU3q_NLGo\u001c:z\u0011!a\u0003A!A!\u0002\u0013i\u0013!\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ssB\u0011aEL\u0005\u0003_\u001d\u0012\u0011CU3mK\u0006\u001cXMU3q_NLGo\u001c:z\u0011!\t\u0004A!b\u0001\n\u0003\u0011\u0014\u0001C3wK:$()^:\u0016\u0003M\u0002\"\u0001N\u001c\u000e\u0003UR!A\u000e\u0004\u0002\r\u00154XM\u001c;t\u0013\tATGA\tY\u0019J+G.Z1tK\u00163XM\u001c;CkND\u0001B\u000f\u0001\u0003\u0002\u0003\u0006IaM\u0001\nKZ,g\u000e\u001e\"vg\u0002BQ\u0001\u0010\u0001\u0005\u0002u\na\u0001P5oSRtD#\u0002 A\u0003\n\u001b\u0005CA \u0001\u001b\u0005\u0011\u0001\"B\u000f<\u0001\u0004q\u0002\"\u0002\u0013<\u0001\u0004)\u0003\"\u0002\u0017<\u0001\u0004i\u0003\"B\u0019<\u0001\u0004\u0019\u0004FA\u001eF!\t1\u0015+D\u0001H\u0015\tA\u0015*\u0001\u0006b]:|G/\u0019;j_:T!AS&\u0002\u000f\u0019\f7\r^8ss*\u0011A*T\u0001\u0006E\u0016\fgn\u001d\u0006\u0003\u001d>\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002!\u0006\u0019qN]4\n\u0005I;%!C!vi><\u0018N]3e\u0011\u0015!\u0006\u0001\"\u0001V\u0003\u0019\u0019'/Z1uKR\u0011a\u000b\u0018\t\u0003/jk\u0011\u0001\u0017\u0006\u00033\u0012\ta\u0001Z8nC&t\u0017BA.Y\u0005-\u0011\u0016n]6Qe>4\u0017\u000e\\3\t\u000bu\u001b\u0006\u0019\u0001,\u0002\u0017IL7o\u001b)s_\u001aLG.\u001a\u0015\u0003'~\u0003\"\u0001\u00194\u000e\u0003\u0005T!\u0001\u00132\u000b\u0005\r$\u0017aB7fiJL7m\u001d\u0006\u0003K*\t\u0001bY8eC\"\fG.Z\u0005\u0003O\u0006\u0014Q\u0001V5nK\u0012DQ!\u001b\u0001\u0005\u0002)\fa!\u001a=jgR\u001cHCA6o!\tyA.\u0003\u0002n!\t9!i\\8mK\u0006t\u0007\"B8i\u0001\u0004\u0001\u0018!\u0004:jg.\u0004&o\u001c4jY\u0016LE\r\u0005\u0002rq:\u0011!O\u001e\t\u0003gBi\u0011\u0001\u001e\u0006\u0003k2\ta\u0001\u0010:p_Rt\u0014BA<\u0011\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011P\u001f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005]\u0004\u0002F\u00015`\u0011\u0015i\b\u0001\"\u0001\u007f\u0003!1\u0017N\u001c3Cs&#GC\u0001,\u0000\u0011\u0015yG\u00101\u0001qQ\tax\fC\u0004\u0002\u0006\u0001!\t!a\u0002\u0002\u001b\u0015D\u0018n\u001d;t\u0005f$\u0016\u000e\u001e7f)\rY\u0017\u0011\u0002\u0005\b\u0003\u0017\t\u0019\u00011\u0001q\u0003\u0015!\u0018\u000e\u001e7fQ\r\t\u0019a\u0018\u0005\b\u0003#\u0001A\u0011AA\n\u0003E1\u0017N\u001c3Cs&#wJ\u001d#fM\u0006,H\u000e\u001e\u000b\u0004-\u0006U\u0001BB8\u0002\u0010\u0001\u0007\u0001\u000fK\u0002\u0002\u0010}Cq!a\u0007\u0001\t\u0003\ti\"A\u0004gS:$\u0017\t\u001c7\u0015\u0005\u0005}\u0001#BA\u0011\u0003W1VBAA\u0012\u0015\u0011\t)#a\n\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003S\tAA[1wC&!\u0011QFA\u0012\u0005\u0011a\u0015n\u001d;)\u0007\u0005eq\fC\u0004\u00024\u0001!\t!!\u000e\u0002\u0017\u0019Lg\u000e\u001a\"z)&$H.\u001a\u000b\u0004-\u0006]\u0002bBA\u001d\u0003c\u0001\r\u0001]\u0001\u0011e&\u001c8\u000e\u0015:pM&dW\rV5uY\u0016D3!!\r`\u0011\u001d\ty\u0004\u0001C\u0001\u0003\u0003\na!\u001e9eCR,Gc\u0001,\u0002D!1Q,!\u0010A\u0002YC3!!\u0010`\u0011\u001d\tI\u0005\u0001C\u0001\u0003\u0017\na\u0001Z3mKR,GcA6\u0002N!1q.a\u0012A\u0002AD3!a\u0012`\u0011\u001d\t\u0019\u0006\u0001C\u0001\u0003+\nAaY8qsR\u0019a+a\u0016\t\r=\f\t\u00061\u0001qQ\r\t\tf\u0018\u0005\b\u0003;\u0002A\u0011AA0\u000359W\r\u001e*fM\u0016\u0014XM\\2fgR!\u0011\u0011MA8!\u0019\t\t#a\u000b\u0002dA!\u0011QMA6\u001b\t\t9GC\u0002\u0002j\u001d\nQ!];fefLA!!\u001c\u0002h\t\u0001\"+\u001a7fCN,')Y:jG\u0012\u000bG/\u0019\u0005\u0007_\u0006m\u0003\u0019\u00019)\u0007\u0005ms\fC\u0004\u0002v\u0001!\t!a\u001e\u00025\u001d,g.\u001a:bi\u0016$UMZ1vYR\u0014\u0016n]6Qe>4\u0017\u000e\\3\u0016\u0003YC\u0001\"a\u001f\u0001A\u0013%\u0011QP\u0001\u000fG\",7m\u001b#va2L7-\u0019;f)\u0011\ty(!\"\u0011\u0007=\t\t)C\u0002\u0002\u0004B\u0011A!\u00168ji\"9\u00111BA=\u0001\u0004\u0001\b\u0002CAE\u0001\u0001&I!a#\u0002+\u001d,g.\u001a:bi\u0016\u0014\u0016n]6Qe>4\u0017\u000e\\3JIV\t\u0001\u000fK\u0002\u0001\u0003\u001f\u0003B!!%\u0002\u00186\u0011\u00111\u0013\u0006\u0004\u0003+k\u0015AC:uKJ,w\u000e^=qK&!\u0011\u0011TAJ\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class RiskProfileService
implements Logging {
    private final CiIdService ciIdService;
    private final ConfigurationRepository configurationRepository;
    private final XLReleaseEventBus eventBus;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RiskProfileService riskProfileService = this;
        synchronized (riskProfileService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    @Timed
    public RiskProfile create(RiskProfile riskProfile) {
        this.checkDuplicate(riskProfile.getTitle());
        riskProfile.setId(this.generateRiskProfileId());
        this.configurationRepository.create((BaseConfiguration)riskProfile);
        return riskProfile;
    }

    @Timed
    public boolean exists(String riskProfileId) {
        return this.configurationRepository.exists(riskProfileId);
    }

    @Timed
    public RiskProfile findById(String riskProfileId) {
        return (RiskProfile)this.configurationRepository.read(riskProfileId);
    }

    @Timed
    public boolean existsByTitle(String title) {
        return this.configurationRepository.existsByTypeAndTitle(Type.valueOf(RiskProfile.class), title);
    }

    @Timed
    public RiskProfile findByIdOrDefault(String riskProfileId) {
        RiskProfile riskProfile;
        try {
            riskProfile = (RiskProfile)this.configurationRepository.read(riskProfileId);
        }
        catch (NotFoundException notFoundException) {
            riskProfile = this.generateDefaultRiskProfile();
        }
        return riskProfile;
    }

    @Timed
    public List<RiskProfile> findAll() {
        return this.configurationRepository.findAllByType(Type.valueOf(RiskProfile.class));
    }

    @Timed
    public RiskProfile findByTitle(String riskProfileTitle) {
        List profiles = this.configurationRepository.findAllByTypeAndTitle(Type.valueOf(RiskProfile.class), riskProfileTitle);
        int n = profiles.size();
        switch (n) {
            case 0: {
                throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find risk profile for title [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{riskProfileTitle})), new Object[0]);
            }
        }
        return (RiskProfile)((Object)profiles.get(0));
    }

    @Timed
    public RiskProfile update(RiskProfile riskProfile) {
        RiskProfile currentRiskProfile = this.findById(riskProfile.getId());
        String string = currentRiskProfile.getTitle();
        String string2 = riskProfile.getTitle();
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.checkDuplicate(riskProfile.getTitle());
        }
        this.configurationRepository.update((BaseConfiguration)riskProfile);
        this.eventBus().publish((XLReleaseEvent)new RiskProfileUpdated(riskProfile));
        return riskProfile;
    }

    @Timed
    public boolean delete(String riskProfileId) {
        return this.configurationRepository.delete(riskProfileId);
    }

    @Timed
    public RiskProfile copy(String riskProfileId) {
        RiskProfile riskProfile = this.findById(riskProfileId);
        String copyRiskProfileTitle = riskProfile.getTitle();
        while (this.existsByTitle(copyRiskProfileTitle)) {
            copyRiskProfileTitle = RetryTitleGenerator.getNextTitle((String)copyRiskProfileTitle);
        }
        RiskProfile copyRiskProfile = (RiskProfile)Type.valueOf(RiskProfile.class).getDescriptor().newInstance(this.generateRiskProfileId());
        copyRiskProfile.setTitle(copyRiskProfileTitle);
        copyRiskProfile.setRiskProfileAssessors(riskProfile.getRiskProfileAssessors());
        this.configurationRepository.create((BaseConfiguration)copyRiskProfile);
        return copyRiskProfile;
    }

    @Timed
    public List<ReleaseBasicData> getReferences(String riskProfileId) {
        return this.configurationRepository.getReferences(riskProfileId);
    }

    /*
     * WARNING - void declaration
     */
    public RiskProfile generateDefaultRiskProfile() {
        void var1_1;
        RiskProfile defaultRiskProfile = (RiskProfile)Type.valueOf(RiskProfile.class).getDescriptor().newInstance(null);
        ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(DescriptorRegistry.getSubtypes((Type)Type.valueOf(RiskAssessor.class))).asScala()).filter((Function1 & Serializable & scala.Serializable)type -> BoxesRunTime.boxToBoolean((boolean)RiskProfileService.$anonfun$generateDefaultRiskProfile$1(type)))).foreach((Function1 & Serializable & scala.Serializable)t -> {
            defaultRiskProfile.setValueFor(t, BoxesRunTime.unboxToInt((Object)t.getDescriptor().getPropertyDescriptor("score").getDefaultValue()));
            return BoxedUnit.UNIT;
        });
        return var1_1;
    }

    private void checkDuplicate(String title) {
        if (this.existsByTitle(title)) {
            throw new ItemAlreadyExistsException("Risk profile '%s' already exist.", new Object[]{title});
        }
    }

    private String generateRiskProfileId() {
        return this.ciIdService.getUniqueId(Type.valueOf(RiskProfile.class), RiskIds$.MODULE$.RISK_PROFILE_CONFIGURATION_ROOT());
    }

    public static final /* synthetic */ boolean $anonfun$generateDefaultRiskProfile$1(Type type) {
        return !type.getDescriptor().isVirtual();
    }

    @Autowired
    public RiskProfileService(CiIdService ciIdService, ConfigurationRepository configurationRepository, ReleaseRepository releaseRepository, XLReleaseEventBus eventBus) {
        this.ciIdService = ciIdService;
        this.configurationRepository = configurationRepository;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

