/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.service;

import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.events.ReleaseCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseOverdueEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.TaskAbortedEvent;
import com.xebialabs.xlrelease.domain.events.TaskCompletedEvent;
import com.xebialabs.xlrelease.domain.events.TaskDeletedEvent;
import com.xebialabs.xlrelease.domain.events.TaskFailedEvent;
import com.xebialabs.xlrelease.domain.events.TaskOverdueEvent;
import com.xebialabs.xlrelease.domain.events.TaskSkippedEvent;
import com.xebialabs.xlrelease.domain.events.TaskUpdatedEvent;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.events.SynchronizedSubscribe;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.risk.domain.events.RiskProfileUpdated;
import com.xebialabs.xlrelease.risk.service.RiskService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.concurrent.Executor;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@Service
@EventListener
@ScalaSignature(bytes="\u0006\u0001\u0005ug\u0001B\u0001\u0003\u00015\u0011\u0001CU5tW\u00163XM\u001c;IC:$G.\u001a:\u000b\u0005\r!\u0011aB:feZL7-\u001a\u0006\u0003\u000b\u0019\tAA]5tW*\u0011q\u0001C\u0001\nq2\u0014X\r\\3bg\u0016T!!\u0003\u0006\u0002\u0013a,'-[1mC\n\u001c(\"A\u0006\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001qA\u0003\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003+ii\u0011A\u0006\u0006\u0003/a\tQa\u001d7gi)T\u0011!G\u0001\tOJL'P\u001f7fI&\u00111D\u0006\u0002\b\u0019><w-\u001b8h\u0011!i\u0002A!A!\u0002\u0013q\u0012!\u0003=me\u000e{gNZ5h!\ty\"%D\u0001!\u0015\t\tc!\u0001\u0004d_:4\u0017nZ\u0005\u0003G\u0001\u0012\u0011\u0002\u00177s\u0007>tg-[4\t\u0011\u0015\u0002!\u0011!Q\u0001\n\u0019\nqcY8oM&<WO]1uS>t'+\u001a9pg&$xN]=\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0005%2\u0011A\u0003:fa>\u001c\u0018\u000e^8ss&\u00111\u0006\u000b\u0002\u0018\u0007>tg-[4ve\u0006$\u0018n\u001c8SKB|7/\u001b;pefD\u0001\"\f\u0001\u0003\u0002\u0003\u0006IAL\u0001\u0012e\u0016dW-Y:f%\u0016\u0004xn]5u_JL\bCA\u00140\u0013\t\u0001\u0004FA\tSK2,\u0017m]3SKB|7/\u001b;pefD\u0001B\r\u0001\u0003\u0002\u0003\u0006IaM\u0001\fe&\u001c8nU3sm&\u001cW\r\u0005\u00025k5\t!!\u0003\u00027\u0005\tY!+[:l'\u0016\u0014h/[2f\u0011!A\u0004A!A!\u0002\u0013I\u0014\u0001\b:jg.\u001c\u0015\r\\2vY\u0006$\u0018n\u001c8CCR\u001c\u0007.\u0012=fGV$xN\u001d\t\u0003u\u0005k\u0011a\u000f\u0006\u0003yu\n!bY8oGV\u0014(/\u001a8u\u0015\tqt(\u0001\u0003vi&d'\"\u0001!\u0002\t)\fg/Y\u0005\u0003\u0005n\u0012\u0001\"\u0012=fGV$xN\u001d\u0005\u0006\t\u0002!\t!R\u0001\u0007y%t\u0017\u000e\u001e \u0015\r\u0019;\u0005*\u0013&L!\t!\u0004\u0001C\u0003\u001e\u0007\u0002\u0007a\u0004C\u0003&\u0007\u0002\u0007a\u0005C\u0003.\u0007\u0002\u0007a\u0006C\u00033\u0007\u0002\u00071\u0007C\u00039\u0007\u0002\u0007\u0011\b\u000b\u0002D\u001bB\u0011a*W\u0007\u0002\u001f*\u0011\u0001+U\u0001\u000bC:tw\u000e^1uS>t'B\u0001*T\u0003\u001d1\u0017m\u0019;pefT!\u0001V+\u0002\u000b\t,\u0017M\\:\u000b\u0005Y;\u0016aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003a\u000b1a\u001c:h\u0013\tQvJA\u0005BkR|w/\u001b:fI\")A\f\u0001C\u0001;\u0006q!/\u001a7fCN,7I]3bi\u0016$GC\u00010b!\tyq,\u0003\u0002a!\t!QK\\5u\u0011\u0015\u00117\f1\u0001d\u0003M\u0011X\r\\3bg\u0016\u001c%/Z1uK\u0012,e/\u001a8u!\t!\u0017.D\u0001f\u0015\t1w-\u0001\u0004fm\u0016tGo\u001d\u0006\u0003Q\u001a\ta\u0001Z8nC&t\u0017B\u00016f\u0005M\u0011V\r\\3bg\u0016\u001c%/Z1uK\u0012,e/\u001a8uQ\tYF\u000e\u0005\u0002n_6\taN\u0003\u0002g\r%\u0011\u0001O\u001c\u0002\n'V\u00147o\u0019:jE\u0016DQA\u001d\u0001\u0005\u0002M\faB]3mK\u0006\u001cX-\u00169eCR,G\r\u0006\u0002_i\")Q/\u001da\u0001m\u0006\u0019\"/\u001a7fCN,W\u000b\u001d3bi\u0016$WI^3oiB\u0011Am^\u0005\u0003q\u0016\u00141CU3mK\u0006\u001cX-\u00169eCR,G-\u0012<f]RD#!\u001d7\t\u000bm\u0004A\u0011\u0001?\u0002\u001dI,G.Z1tK>3XM\u001d3vKR\u0011a, \u0005\u0006}j\u0004\ra`\u0001\u0014e\u0016dW-Y:f\u001fZ,'\u000fZ;f\u000bZ,g\u000e\u001e\t\u0004I\u0006\u0005\u0011bAA\u0002K\n\u0019\"+\u001a7fCN,wJ^3sIV,WI^3oi\"\u0012!\u0010\u001c\u0005\b\u0003\u0013\u0001A\u0011AA\u0006\u0003)!\u0018m]6GC&dW\r\u001a\u000b\u0004=\u00065\u0001\u0002CA\b\u0003\u000f\u0001\r!!\u0005\u0002\u001fQ\f7o\u001b$bS2,G-\u0012<f]R\u00042\u0001ZA\n\u0013\r\t)\"\u001a\u0002\u0010)\u0006\u001c8NR1jY\u0016$WI^3oi\"\u001a\u0011q\u00017\t\u000f\u0005m\u0001\u0001\"\u0001\u0002\u001e\u0005iA/Y:l\u0007>l\u0007\u000f\\3uK\u0012$2AXA\u0010\u0011!\t\t#!\u0007A\u0002\u0005\r\u0012A\u0005;bg.\u001cu.\u001c9mKR,G-\u0012<f]R\u00042\u0001ZA\u0013\u0013\r\t9#\u001a\u0002\u0013)\u0006\u001c8nQ8na2,G/\u001a3Fm\u0016tG\u000fK\u0002\u0002\u001a1Dq!!\f\u0001\t\u0003\ty#A\u0006uCN\\7k[5qa\u0016$Gc\u00010\u00022!A\u00111GA\u0016\u0001\u0004\t)$\u0001\tuCN\\7k[5qa\u0016$WI^3oiB\u0019A-a\u000e\n\u0007\u0005eRM\u0001\tUCN\\7k[5qa\u0016$WI^3oi\"\u001a\u00111\u00067\t\u000f\u0005}\u0002\u0001\"\u0001\u0002B\u0005YA/Y:l\u0003\n|'\u000f^3e)\rq\u00161\t\u0005\t\u0003\u000b\ni\u00041\u0001\u0002H\u0005\u0001B/Y:l\u0003\n|'\u000f^3e\u000bZ,g\u000e\u001e\t\u0004I\u0006%\u0013bAA&K\n\u0001B+Y:l\u0003\n|'\u000f^3e\u000bZ,g\u000e\u001e\u0015\u0004\u0003{a\u0007bBA)\u0001\u0011\u0005\u00111K\u0001\fi\u0006\u001c8.\u00169eCR,G\rF\u0002_\u0003+B\u0001\"a\u0016\u0002P\u0001\u0007\u0011\u0011L\u0001\u0011i\u0006\u001c8.\u00169eCR,G-\u0012<f]R\u00042\u0001ZA.\u0013\r\ti&\u001a\u0002\u0011)\u0006\u001c8.\u00169eCR,G-\u0012<f]RD3!a\u0014m\u0011\u001d\t\u0019\u0007\u0001C\u0001\u0003K\n1\u0002^1tW>3XM\u001d3vKR\u0019a,a\u001a\t\u0011\u0005%\u0014\u0011\ra\u0001\u0003W\n\u0001\u0003^1tW>3XM\u001d3vK\u00163XM\u001c;\u0011\u0007\u0011\fi'C\u0002\u0002p\u0015\u0014\u0001\u0003V1tW>3XM\u001d3vK\u00163XM\u001c;)\u0007\u0005\u0005D\u000eC\u0004\u0002v\u0001!\t!a\u001e\u0002\u0017Q\f7o\u001b#fY\u0016$X\r\u001a\u000b\u0004=\u0006e\u0004\u0002CA>\u0003g\u0002\r!! \u0002!Q\f7o\u001b#fY\u0016$X\rZ#wK:$\bc\u00013\u0002\u0000%\u0019\u0011\u0011Q3\u0003!Q\u000b7o\u001b#fY\u0016$X\rZ#wK:$\bfAA:Y\"9\u0011q\u0011\u0001\u0005\n\u0005%\u0015!D2bY\u000e,H.\u0019;f%&\u001c8\u000eF\u0002_\u0003\u0017C\u0001\"!$\u0002\u0006\u0002\u0007\u0011qR\u0001\be\u0016dW-Y:f!\u0011\t\t*a%\u000e\u0003\u001dL1!!&h\u0005\u001d\u0011V\r\\3bg\u0016Dq!!'\u0001\t\u0003\tY*A\fiC:$G.\u001a*jg.\u0004&o\u001c4jY\u0016,\u0006\u000fZ1uKR\u0019a,!(\t\u0011\u0005}\u0015q\u0013a\u0001\u0003C\u000bQ!\u001a<f]R\u0004B!a)\u0002*6\u0011\u0011Q\u0015\u0006\u0004M\u0006\u001d&B\u00015\u0005\u0013\u0011\tY+!*\u0003%IK7o\u001b)s_\u001aLG.Z+qI\u0006$X\r\u001a\u0015\u0005\u0003/\u000by\u000bE\u0002n\u0003cK1!a-o\u0005U\u0019\u0016P\\2ie>t\u0017N_3e'V\u00147o\u0019:jE\u0016Dq!a.\u0001\t\u0013\tI,A\u000fsk:\u001c\u0015\r\\2vY\u0006$\u0018n\u001c8t\r>\u0014(+[:l!J|g-\u001b7f)\rq\u00161\u0018\u0005\t\u0003{\u000b)\f1\u0001\u0002@\u0006Y!/[:l!J|g-\u001b7f!\u0011\t\t-a1\u000e\u0005\u0005\u001d\u0016\u0002BAc\u0003O\u00131BU5tWB\u0013xNZ5mK\"\u001a\u0001!!3\u0011\u00075\fY-C\u0002\u0002N:\u0014Q\"\u0012<f]Rd\u0015n\u001d;f]\u0016\u0014\bf\u0001\u0001\u0002RB!\u00111[Am\u001b\t\t)NC\u0002\u0002XV\u000b!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\tY.!6\u0003\u000fM+'O^5dK\u0002")
public class RiskEventHandler
implements Logging {
    private final XlrConfig xlrConfig;
    private final ConfigurationRepository configurationRepository;
    private final RiskService riskService;
    private final Executor riskCalculationBatchExecutor;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RiskEventHandler riskEventHandler = this;
        synchronized (riskEventHandler) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Subscribe
    public void releaseCreated(ReleaseCreatedEvent releaseCreatedEvent) {
        this.calculateRisk(releaseCreatedEvent.release());
    }

    @Subscribe
    public void releaseUpdated(ReleaseUpdatedEvent releaseUpdatedEvent) {
        this.calculateRisk(releaseUpdatedEvent.updated());
    }

    @Subscribe
    public void releaseOverdue(ReleaseOverdueEvent releaseOverdueEvent) {
        this.calculateRisk(releaseOverdueEvent.release());
    }

    @Subscribe
    public void taskFailed(TaskFailedEvent taskFailedEvent) {
        this.calculateRisk(taskFailedEvent.task().getRelease());
    }

    @Subscribe
    public void taskCompleted(TaskCompletedEvent taskCompletedEvent) {
        this.calculateRisk(taskCompletedEvent.task().getRelease());
    }

    @Subscribe
    public void taskSkipped(TaskSkippedEvent taskSkippedEvent) {
        this.calculateRisk(taskSkippedEvent.task().getRelease());
    }

    @Subscribe
    public void taskAborted(TaskAbortedEvent taskAbortedEvent) {
        this.calculateRisk(taskAbortedEvent.task().getRelease());
    }

    @Subscribe
    public void taskUpdated(TaskUpdatedEvent taskUpdatedEvent) {
        this.calculateRisk(taskUpdatedEvent.updated().getRelease());
    }

    @Subscribe
    public void taskOverdue(TaskOverdueEvent taskOverdueEvent) {
        this.calculateRisk(taskOverdueEvent.task().getRelease());
    }

    @Subscribe
    public void taskDeleted(TaskDeletedEvent taskDeletedEvent) {
        this.calculateRisk(taskDeletedEvent.task().getRelease());
    }

    private void calculateRisk(Release release) {
        block0: {
            if (!this.xlrConfig.isRiskCalculationEnabled()) break block0;
            this.riskService.calculateRiskAndUpdateRelease(release);
        }
    }

    @SynchronizedSubscribe
    public void handleRiskProfileUpdate(RiskProfileUpdated event) {
        block0: {
            if (!this.xlrConfig.isRiskCalculationEnabled()) break block0;
            RiskProfile riskProfile = event.riskProfile();
            this.riskCalculationBatchExecutor.execute(() -> this.runCalculationsForRiskProfile(riskProfile));
        }
    }

    private void runCalculationsForRiskProfile(RiskProfile riskProfile) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Running risk calculations after Risk profile ", " update"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{riskProfile.getId()})));
        this.configurationRepository.getReferences(riskProfile.getId()).forEach(data -> $this.riskService.calculateRiskAndUpdateRelease(data.id()));
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finished running risk calculations after Risk profile ", " update"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{riskProfile.getId()})));
    }

    @Autowired
    public RiskEventHandler(XlrConfig xlrConfig, ConfigurationRepository configurationRepository, ReleaseRepository releaseRepository, RiskService riskService, Executor riskCalculationBatchExecutor) {
        this.xlrConfig = xlrConfig;
        this.configurationRepository = configurationRepository;
        this.riskService = riskService;
        this.riskCalculationBatchExecutor = riskCalculationBatchExecutor;
        Logging.$init$((Logging)this);
    }
}

