/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.EventListening;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.RetryTitleGenerator;
import com.xebialabs.xlrelease.repository.query.ReleaseBasicData;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.risk.domain.events.RiskProfileUpdated;
import com.xebialabs.xlrelease.risk.domain.riskassessors.RiskAssessor;
import com.xebialabs.xlrelease.risk.repository.RiskIds$;
import com.xebialabs.xlrelease.service.CiIdService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005f\u0001B\u0001\u0003\u00015\u0011!CU5tWB\u0013xNZ5mKN+'O^5dK*\u00111\u0001B\u0001\bg\u0016\u0014h/[2f\u0015\t)a!\u0001\u0003sSN\\'BA\u0004\t\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\n\u0015\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002\u0017\u0005\u00191m\\7\u0004\u0001M!\u0001A\u0004\u000b\u001b!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011Q\u0003G\u0007\u0002-)\u0011qCB\u0001\u0007KZ,g\u000e^:\n\u0005e1\"AD#wK:$H*[:uK:Lgn\u001a\t\u00037\u0001j\u0011\u0001\b\u0006\u0003;y\tQa\u001d7gi)T\u0011aH\u0001\tOJL'P\u001f7fI&\u0011\u0011\u0005\b\u0002\b\u0019><w-\u001b8h\u0011!\u0019\u0003A!A!\u0002\u0013!\u0013aC2j\u0013\u0012\u001cVM\u001d<jG\u0016\u0004\"!J\u0014\u000e\u0003\u0019R!a\u0001\u0004\n\u0005!2#aC\"j\u0013\u0012\u001cVM\u001d<jG\u0016D\u0001B\u000b\u0001\u0003\u0002\u0003\u0006IaK\u0001\u0018G>tg-[4ve\u0006$\u0018n\u001c8SKB|7/\u001b;pef\u0004\"\u0001L\u0018\u000e\u00035R!A\f\u0004\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u00021[\t92i\u001c8gS\u001e,(/\u0019;j_:\u0014V\r]8tSR|'/\u001f\u0005\te\u0001\u0011\t\u0011)A\u0005g\u0005\t\"/\u001a7fCN,'+\u001a9pg&$xN]=\u0011\u00051\"\u0014BA\u001b.\u0005E\u0011V\r\\3bg\u0016\u0014V\r]8tSR|'/\u001f\u0005\to\u0001\u0011)\u0019!C\u0001q\u0005AQM^3oi\n+8/F\u0001:!\t)\"(\u0003\u0002<-\t\t\u0002\f\u0014*fY\u0016\f7/Z#wK:$()^:\t\u0011u\u0002!\u0011!Q\u0001\ne\n\u0011\"\u001a<f]R\u0014Uo\u001d\u0011\t\u000b}\u0002A\u0011\u0001!\u0002\rqJg.\u001b;?)\u0015\t5\tR#G!\t\u0011\u0005!D\u0001\u0003\u0011\u0015\u0019c\b1\u0001%\u0011\u0015Qc\b1\u0001,\u0011\u0015\u0011d\b1\u00014\u0011\u00159d\b1\u0001:Q\tq\u0004\n\u0005\u0002J)6\t!J\u0003\u0002L\u0019\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u00055s\u0015a\u00024bGR|'/\u001f\u0006\u0003\u001fB\u000bQAY3b]NT!!\u0015*\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011aU\u0001\u0004_J<\u0017BA+K\u0005%\tU\u000f^8xSJ,G\rC\u0003X\u0001\u0011\u0005\u0001,\u0001\u0004de\u0016\fG/\u001a\u000b\u00033~\u0003\"AW/\u000e\u0003mS!\u0001\u0018\u0003\u0002\r\u0011|W.Y5o\u0013\tq6LA\u0006SSN\\\u0007K]8gS2,\u0007\"\u00021W\u0001\u0004I\u0016a\u0003:jg.\u0004&o\u001c4jY\u0016D#A\u00162\u0011\u0005\rLW\"\u00013\u000b\u0005-+'B\u00014h\u0003\u001diW\r\u001e:jGNT!\u0001\u001b\u0006\u0002\u0011\r|G-\u00195bY\u0016L!A\u001b3\u0003\u000bQKW.\u001a3\t\u000b1\u0004A\u0011A7\u0002\r\u0015D\u0018n\u001d;t)\tq\u0017\u000f\u0005\u0002\u0010_&\u0011\u0001\u000f\u0005\u0002\b\u0005>|G.Z1o\u0011\u0015\u00118\u000e1\u0001t\u00035\u0011\u0018n]6Qe>4\u0017\u000e\\3JIB\u0011Ao\u001f\b\u0003kf\u0004\"A\u001e\t\u000e\u0003]T!\u0001\u001f\u0007\u0002\rq\u0012xn\u001c;?\u0013\tQ\b#\u0001\u0004Qe\u0016$WMZ\u0005\u0003yv\u0014aa\u0015;sS:<'B\u0001>\u0011Q\tY'\rC\u0004\u0002\u0002\u0001!\t!a\u0001\u0002\u0011\u0019Lg\u000e\u001a\"z\u0013\u0012$2!WA\u0003\u0011\u0015\u0011x\u00101\u0001tQ\ty(\rC\u0004\u0002\f\u0001!\t!!\u0004\u0002\u001b\u0015D\u0018n\u001d;t\u0005f$\u0016\u000e\u001e7f)\rq\u0017q\u0002\u0005\b\u0003#\tI\u00011\u0001t\u0003\u0015!\u0018\u000e\u001e7fQ\r\tIA\u0019\u0005\b\u0003/\u0001A\u0011AA\r\u0003E1\u0017N\u001c3Cs&#wJ\u001d#fM\u0006,H\u000e\u001e\u000b\u00043\u0006m\u0001B\u0002:\u0002\u0016\u0001\u00071\u000fK\u0002\u0002\u0016\tDq!!\t\u0001\t\u0003\t\u0019#A\u0004gS:$\u0017\t\u001c7\u0015\u0005\u0005\u0015\u0002#BA\u0014\u0003cIVBAA\u0015\u0015\u0011\tY#!\f\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003_\tAA[1wC&!\u00111GA\u0015\u0005\u0011a\u0015n\u001d;)\u0007\u0005}!\rC\u0004\u0002:\u0001!\t!a\u000f\u0002\u0017\u0019Lg\u000e\u001a\"z)&$H.\u001a\u000b\u00043\u0006u\u0002bBA \u0003o\u0001\ra]\u0001\u0011e&\u001c8\u000e\u0015:pM&dW\rV5uY\u0016D3!a\u000ec\u0011\u001d\t)\u0005\u0001C\u0001\u0003\u000f\na!\u001e9eCR,GcA-\u0002J!1\u0001-a\u0011A\u0002eC3!a\u0011c\u0011\u001d\ty\u0005\u0001C\u0001\u0003#\na\u0001Z3mKR,Gc\u00018\u0002T!1!/!\u0014A\u0002MD3!!\u0014c\u0011\u001d\tI\u0006\u0001C\u0001\u00037\nAaY8qsR\u0019\u0011,!\u0018\t\rI\f9\u00061\u0001tQ\r\t9F\u0019\u0005\b\u0003G\u0002A\u0011AA3\u000359W\r\u001e*fM\u0016\u0014XM\\2fgR!\u0011qMA;!\u0019\t9#!\r\u0002jA!\u00111NA9\u001b\t\tiGC\u0002\u0002p5\nQ!];fefLA!a\u001d\u0002n\t\u0001\"+\u001a7fCN,')Y:jG\u0012\u000bG/\u0019\u0005\u0007e\u0006\u0005\u0004\u0019A:)\u0007\u0005\u0005$\rC\u0004\u0002|\u0001!\t!! \u00025\u001d,g.\u001a:bi\u0016$UMZ1vYR\u0014\u0016n]6Qe>4\u0017\u000e\\3\u0016\u0003eC\u0001\"!!\u0001A\u0013%\u00111Q\u0001\u000fG\",7m\u001b#va2L7-\u0019;f)\u0011\t))a#\u0011\u0007=\t9)C\u0002\u0002\nB\u0011A!\u00168ji\"9\u0011\u0011CA@\u0001\u0004\u0019\b\u0002CAH\u0001\u0001&I!!%\u0002+\u001d,g.\u001a:bi\u0016\u0014\u0016n]6Qe>4\u0017\u000e\\3JIV\t1\u000fK\u0002\u0001\u0003+\u0003B!a&\u0002\u001e6\u0011\u0011\u0011\u0014\u0006\u0004\u00037\u0003\u0016AC:uKJ,w\u000e^=qK&!\u0011qTAM\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class RiskProfileService
implements EventListening,
Logging {
    private final CiIdService ciIdService;
    private final ConfigurationRepository configurationRepository;
    private final XLReleaseEventBus eventBus;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @PostConstruct
    public void postConstruct() {
        EventListening.postConstruct$((EventListening)this);
    }

    @PreDestroy
    public void preDestroy() {
        EventListening.preDestroy$((EventListening)this);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RiskProfileService riskProfileService = this;
        synchronized (riskProfileService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    @Timed
    public RiskProfile create(RiskProfile riskProfile) {
        this.checkDuplicate(riskProfile.getTitle());
        riskProfile.setId(this.generateRiskProfileId());
        this.configurationRepository.create((BaseConfiguration)riskProfile);
        return riskProfile;
    }

    @Timed
    public boolean exists(String riskProfileId) {
        return this.configurationRepository.exists(riskProfileId);
    }

    @Timed
    public RiskProfile findById(String riskProfileId) {
        return (RiskProfile)this.configurationRepository.read(riskProfileId);
    }

    @Timed
    public boolean existsByTitle(String title) {
        return this.configurationRepository.existsByTypeAndTitle(Type.valueOf(RiskProfile.class), title);
    }

    @Timed
    public RiskProfile findByIdOrDefault(String riskProfileId) {
        RiskProfile riskProfile;
        try {
            riskProfile = (RiskProfile)this.configurationRepository.read(riskProfileId);
        }
        catch (NotFoundException notFoundException) {
            riskProfile = this.generateDefaultRiskProfile();
        }
        return riskProfile;
    }

    @Timed
    public List<RiskProfile> findAll() {
        return this.configurationRepository.findAllByType(Type.valueOf(RiskProfile.class));
    }

    @Timed
    public RiskProfile findByTitle(String riskProfileTitle) {
        List profiles = this.configurationRepository.findAllByTypeAndTitle(Type.valueOf(RiskProfile.class), riskProfileTitle);
        int n = profiles.size();
        switch (n) {
            case 0: {
                throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find risk profile for title [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{riskProfileTitle})), new Object[0]);
            }
        }
        return (RiskProfile)((Object)profiles.get(0));
    }

    @Timed
    public RiskProfile update(RiskProfile riskProfile) {
        RiskProfile currentRiskProfile = this.findById(riskProfile.getId());
        String string = currentRiskProfile.getTitle();
        String string2 = riskProfile.getTitle();
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.checkDuplicate(riskProfile.getTitle());
        }
        this.configurationRepository.update((BaseConfiguration)riskProfile);
        this.eventBus().publish((XLReleaseEvent)new RiskProfileUpdated(riskProfile));
        return riskProfile;
    }

    @Timed
    public boolean delete(String riskProfileId) {
        return this.configurationRepository.delete(riskProfileId);
    }

    @Timed
    public RiskProfile copy(String riskProfileId) {
        RiskProfile riskProfile = this.findById(riskProfileId);
        String copyRiskProfileTitle = riskProfile.getTitle();
        while (this.existsByTitle(copyRiskProfileTitle)) {
            copyRiskProfileTitle = RetryTitleGenerator.getNextTitle((String)copyRiskProfileTitle);
        }
        RiskProfile copyRiskProfile = (RiskProfile)Type.valueOf(RiskProfile.class).getDescriptor().newInstance(this.generateRiskProfileId());
        copyRiskProfile.setTitle(copyRiskProfileTitle);
        copyRiskProfile.setRiskProfileAssessors(riskProfile.getRiskProfileAssessors());
        this.configurationRepository.create((BaseConfiguration)copyRiskProfile);
        return copyRiskProfile;
    }

    @Timed
    public List<ReleaseBasicData> getReferences(String riskProfileId) {
        return this.configurationRepository.getReferences(riskProfileId);
    }

    /*
     * WARNING - void declaration
     */
    public RiskProfile generateDefaultRiskProfile() {
        void var1_1;
        RiskProfile defaultRiskProfile = (RiskProfile)Type.valueOf(RiskProfile.class).getDescriptor().newInstance(null);
        ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(DescriptorRegistry.getSubtypes((Type)Type.valueOf(RiskAssessor.class))).asScala()).filter((Function1 & Serializable & scala.Serializable)type -> BoxesRunTime.boxToBoolean((boolean)RiskProfileService.$anonfun$generateDefaultRiskProfile$1(type)))).foreach((Function1 & Serializable & scala.Serializable)t -> {
            defaultRiskProfile.setValueFor(t, BoxesRunTime.unboxToInt((Object)t.getDescriptor().getPropertyDescriptor("score").getDefaultValue()));
            return BoxedUnit.UNIT;
        });
        return var1_1;
    }

    private void checkDuplicate(String title) {
        if (this.existsByTitle(title)) {
            throw new ItemAlreadyExistsException("Risk profile '%s' already exist.", new Object[]{title});
        }
    }

    private String generateRiskProfileId() {
        return this.ciIdService.getUniqueId(Type.valueOf(RiskProfile.class), RiskIds$.MODULE$.RISK_PROFILE_CONFIGURATION_ROOT());
    }

    public static final /* synthetic */ boolean $anonfun$generateDefaultRiskProfile$1(Type type) {
        return !type.getDescriptor().isVirtual();
    }

    @Autowired
    public RiskProfileService(CiIdService ciIdService, ConfigurationRepository configurationRepository, ReleaseRepository releaseRepository, XLReleaseEventBus eventBus) {
        this.ciIdService = ciIdService;
        this.configurationRepository = configurationRepository;
        this.eventBus = eventBus;
        EventListening.$init$((EventListening)this);
        Logging.$init$((Logging)this);
    }
}

