/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.domain;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.status.FlagStatus;
import com.xebialabs.xlrelease.risk.domain.RiskAssessment;
import com.xebialabs.xlrelease.risk.domain.RiskAssessor;
import java.util.ArrayList;
import java.util.Optional;

@PublicApiRef
@Metadata(label="ReleaseFlagAssessor", versioned=false)
public class ReleaseFlagRiskAssessor
extends RiskAssessor {
    private static final int RELEASE_AT_RISK_SCORE = 80;
    private static final String RELEASE_AT_RISK_HEADLINE = "Release is flagged as red";
    private static final int RELEASE_NEED_ATTENTION_SCORE = 30;
    private static final String RELEASE_NEEDS_ATTENTION_HEADLINE = "Release is flagged as amber";
    private static final String RELEASE_FLAGGED_MESSAGE = "%s: %s";

    @Override
    public RiskAssessment execute(Release release) {
        RiskAssessment assessment = new RiskAssessment();
        assessment.setRiskAssessorId(this.getId());
        ArrayList<String> messages = new ArrayList<String>();
        if (release.getFlagStatus() == FlagStatus.AT_RISK) {
            assessment.setScore(80);
            assessment.setHeadline(RELEASE_AT_RISK_HEADLINE);
            messages.add(this.getMessage(release.getTitle(), release.getFlagComment()));
        } else if (release.getFlagStatus() == FlagStatus.ATTENTION_NEEDED) {
            assessment.setScore(30);
            assessment.setHeadline(RELEASE_NEEDS_ATTENTION_HEADLINE);
            messages.add(this.getMessage(release.getTitle(), release.getFlagComment()));
        } else {
            assessment.setScore(0);
            assessment.setHeadline("Release is on track");
        }
        assessment.setMessages(messages);
        return assessment;
    }

    private String getMessage(String releaseTitle, String flagComment) {
        return String.format(RELEASE_FLAGGED_MESSAGE, releaseTitle, Optional.ofNullable(flagComment).orElse(""));
    }
}

