/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.domain;

import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.risk.domain.RiskAssessor;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public abstract class PlanItemDueDateRiskAssessor
extends RiskAssessor {
    protected static final String PLAN_ITEM_OVERDUE_MESSAGE = "%s is overdue since %s";

    protected String formatMessage(PlanItem planItem) {
        LocalDateTime dueDate = planItem.getOrCalculateDueDate().map(LocalDateTime::fromDateFields).orElseThrow(() -> new IllegalStateException("Due date should be set or calculated."));
        DateTimeFormatter formatter = ISODateTimeFormat.dateTime();
        return String.format(PLAN_ITEM_OVERDUE_MESSAGE, planItem.getTitle(), formatter.print((ReadablePartial)dueDate)).trim();
    }
}

