package com.xebialabs.xlrelease.risk.service

import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.risk.domain.riskassessors.RiskAssessor
import com.xebialabs.xlrelease.risk.domain.{Risk, RiskAssessment, RiskProfile}
import grizzled.slf4j.Logging

import scala.jdk.CollectionConverters._

trait RiskCalculator extends Logging {
  def calculateRisk(profile: RiskProfile, riskAssessors: List[RiskAssessor], riskId: String, release: Release): Risk = {
    val risk = new Risk()
    risk.setId(riskId)
    logger.debug(s"Running risk calculations for release ${release.getId}")

    // Evaluate risk assessors
    val riskAssessments: List[RiskAssessment] = riskAssessors.map { riskAssessor =>
      riskAssessor.execute(release, profile)
    }

    risk.setRiskAssessments(riskAssessments.asJava)

    val score: Int = riskAssessments.map(_.getScore.toInt).maxOption.getOrElse(0)
    val totalScore: Int = riskAssessments.map(_.getScore.toInt).sum

    risk.setScore(score)
    risk.setTotalScore(totalScore)

    logger.debug(s"Finished running risk calculations for release ${release.getId} with score ${risk.getScore} and total score ${risk.getTotalScore}")

    risk
  }
}