package com.xebialabs.xlrelease.risk

import com.xebialabs.xlrelease.actors.ActorSystemHolder
import com.xebialabs.xlrelease.risk.ReleaseRiskSupervisorActor.ReleaseRiskSupervisorManagedActor
import org.springframework.context.annotation.{Bean, Configuration}

@Configuration
class ReleaseRiskActorSupervisorInitializer(actorSystemHolder: ActorSystemHolder) {
  @Bean
  def releaseRiskActorSupervisorManagedActor(): ReleaseRiskSupervisorManagedActor = {
    actorSystemHolder.actorOf(classOf[ReleaseRiskSupervisorActor], "releaseRiskSupervisor")
  }

  @Bean
  def releaseRiskEventHandler(): ReleaseRiskEventHandler = {
    ReleaseRiskEventHandler(releaseRiskActorSupervisorManagedActor())
  }
}
