package com.xebialabs.xlrelease.risk

import com.xebialabs.xlrelease.actors.utils.ReleaseActorTerminator.ReleaseActorStopped
import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.domain.events._
import com.xebialabs.xlrelease.events.{EventListener, Subscribe}
import com.xebialabs.xlrelease.risk.ReleaseRiskSupervisorActor.{CalculateReleaseRisk, ReleaseRiskSupervisorManagedActor, UnWatch, Watch}

@EventListener
case class ReleaseRiskEventHandler(managedActor: ReleaseRiskSupervisorManagedActor) {
  @Subscribe
  def onReleaseActorStarted(event: ReleaseActorStarted): Unit = {
    managedActor ! Watch(event.releaseId)
  }

  @Subscribe
  def onReleaseActorStopped(event: ReleaseActorStopped): Unit = {
    managedActor ! UnWatch(event.releaseId)
  }

  @Subscribe
  def releaseCreated(event: ReleaseCreatedEvent): Unit = {
    val release = event.release
    managedActor ! Watch(release.getId)
    calculateRisk(event.getClass, release)
  }

  @Subscribe
  def releaseUpdated(event: ReleaseUpdatedEvent): Unit = {
    calculateRisk(event.getClass, event.updated)
  }

  @Subscribe
  def releaseOverdue(event: ReleaseOverdueEvent): Unit = {
    calculateRisk(event.getClass, event.release)
  }

  @Subscribe
  def taskFailed(event: TaskFailedEvent): Unit = {
    calculateRisk(event.getClass, event.task.getRelease)
  }

  @Subscribe
  def taskRetried(event: TaskRetriedEvent): Unit = {
    calculateRisk(event.getClass, event.task.getRelease)
  }

  @Subscribe
  def releaseResumedEvent(event: ReleaseResumedEvent): Unit = {
    calculateRisk(event.getClass, event.release)
  }

  @Subscribe
  def taskCompleted(event: TaskCompletedEvent): Unit = {
    calculateRisk(event.getClass, event.task.getRelease)
  }

  @Subscribe
  def taskSkipped(event: TaskSkippedEvent): Unit = {
    calculateRisk(event.getClass, event.task.getRelease)
  }

  @Subscribe
  def taskAborted(event: TaskAbortedEvent): Unit = {
    calculateRisk(event.getClass, event.task.getRelease)
  }

  @Subscribe
  def taskUpdated(event: TaskUpdatedEvent): Unit = {
    calculateRisk(event.getClass, event.updated.getRelease)
  }

  @Subscribe
  def taskOverdue(event: TaskOverdueEvent): Unit = {
    calculateRisk(event.getClass, event.task.getRelease)
  }

  @Subscribe
  def taskDeleted(event: TaskDeletedEvent): Unit = {
    calculateRisk(event.getClass, event.task.getRelease)
  }

  private def calculateRisk(eventType: Class[_], release: Release): Unit = {
    managedActor ! CalculateReleaseRisk(eventType, release)
  }

}