package com.xebialabs.xlrelease.risk.repository

import com.xebialabs.deployit.checks.Checks.checkNotNull
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional
import com.xebialabs.xlrelease.repository._
import com.xebialabs.xlrelease.risk.builder.ReleaseProgressBuilder.newReleaseProgress
import com.xebialabs.xlrelease.risk.domain.progress.ReleaseProgress
import com.xebialabs.xlrelease.service.ReleaseService
import grizzled.slf4j.Logging
import io.micrometer.core.annotation.Timed
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Repository

@Repository
@IsTransactional
class ProgressRepository @Autowired()(releaseService: ReleaseService, releaseExtensionsRepository: ReleaseExtensionsRepository)
  extends ReleaseExtensionsHelperRepository[ReleaseProgress](releaseService, releaseExtensionsRepository) with Logging {

  releaseExtensionsRepository.registerGeneric(ReleaseProgress.PROGRESS_PREFIX)

  @Timed
  override def createDefaultReleaseExtension(releaseExtensionId: String): ReleaseProgress =
    newReleaseProgress()
      .withId(releaseExtensionId)
      .withTotalRemainingTasks(0)
      .withTotalTasks(0)
      .build()

  @Timed
  def createOrUpdate(releaseProgress: ReleaseProgress): ReleaseProgress = {
    checkNotNull(releaseProgress.getId, "Missing ReleaseProgress Id")

    if (releaseExtensionsRepository.exists(releaseProgress.getId)) {
      releaseExtensionsRepository.update(releaseProgress)
    } else {
      releaseExtensionsRepository.create(releaseProgress)
    }
    releaseProgress
  }

}
