/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.service;

import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.risk.domain.Risk;
import com.xebialabs.xlrelease.risk.domain.RiskAssessment;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.risk.domain.events.RiskScoreUpdated;
import com.xebialabs.xlrelease.risk.domain.riskassessors.RiskAssessor;
import com.xebialabs.xlrelease.risk.repository.RiskRepository;
import com.xebialabs.xlrelease.risk.service.AsyncRiskExecutor;
import com.xebialabs.xlrelease.risk.service.RiskCalculator;
import com.xebialabs.xlrelease.risk.service.RiskProfileService;
import com.xebialabs.xlrelease.service.FeatureService;
import com.xebialabs.xlrelease.utils.Diff;
import com.xebialabs.xlrelease.utils.Diff$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005Eg\u0001B\u000e\u001d\u0001\u001dB\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\"AA\t\u0001B\u0001B\u0003%Q\t\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003M\u0011!\t\u0006A!A!\u0002\u0013\u0011\u0006\u0002\u0003-\u0001\u0005\u0003\u0005\u000b\u0011B-\t\u000bq\u0003A\u0011A/\t\u000f\u0015\u0004\u0001\u0019!C\u0005M\"9Q\u000e\u0001a\u0001\n\u0013q\u0007B\u0002;\u0001A\u0003&q\rC\u0004z\u0001\t\u0007I\u0011\u0002>\t\u000f\u0005\u001d\u0002\u0001)A\u0005w\"9\u0011\u0011\u0006\u0001\u0005\u0002\u0005-\u0002bBA\u0015\u0001\u0011\u0005\u0011\u0011\t\u0005\b\u0003'\u0002A\u0011AA+\u0011\u001d\t9\u0007\u0001C\u0001\u0003SBq!!\u001c\u0001\t\u0013\ty\u0007C\u0004\u0002z\u0001!\t!a\u001f\t\u000f\u0005\u001d\u0005\u0001\"\u0003\u0002\n\"9\u00111\u0013\u0001\u0005\n\u0005U\u0005bBAN\u0001\u0011%\u0011Q\u0014\u0005\b\u0003K\u0003A\u0011BAT\u0011\u001d\ti\u000b\u0001C!\u0003_Cq!!-\u0001\t\u0003\n\u0019\fC\u0004\u00026\u0002!\t%a-\t\u000f\u0005]\u0006\u0001\"\u0011\u0002:\nY!+[:l'\u0016\u0014h/[2f\u0015\tib$A\u0004tKJ4\u0018nY3\u000b\u0005}\u0001\u0013\u0001\u0002:jg.T!!\t\u0012\u0002\u0013ad'/\u001a7fCN,'BA\u0012%\u0003%AXMY5bY\u0006\u00147OC\u0001&\u0003\r\u0019w.\\\u0002\u0001'\u0011\u0001\u0001\u0006M\u001b\u0011\u0005%rS\"\u0001\u0016\u000b\u0005-b\u0013\u0001\u00027b]\u001eT\u0011!L\u0001\u0005U\u00064\u0018-\u0003\u00020U\t1qJ\u00196fGR\u0004\"!M\u001a\u000e\u0003IR!!\b\u0011\n\u0005Q\u0012$A\u0004$fCR,(/Z*feZL7-\u001a\t\u0003m]j\u0011\u0001H\u0005\u0003qq\u0011aBU5tW\u000e\u000bGnY;mCR|'/\u0001\bsSN\\'+\u001a9pg&$xN]=\u0011\u0005mrT\"\u0001\u001f\u000b\u0005ur\u0012A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011q\b\u0010\u0002\u000f%&\u001c8NU3q_NLGo\u001c:z\u0003I\u0011\u0018n]6Qe>4\u0017\u000e\\3TKJ4\u0018nY3\u0011\u0005Y\u0012\u0015BA\"\u001d\u0005I\u0011\u0016n]6Qe>4\u0017\u000e\\3TKJ4\u0018nY3\u0002'I,G.Z1tK\u0006\u001bGo\u001c:TKJ4\u0018nY3\u0011\u0005\u0019KU\"A$\u000b\u0005!\u0003\u0013AB1di>\u00148/\u0003\u0002K\u000f\n\u0019\"+\u001a7fCN,\u0017i\u0019;peN+'O^5dK\u0006\t\"/\u001a7fCN,'+\u001a9pg&$xN]=\u0011\u00055{U\"\u0001(\u000b\u0005u\u0002\u0013B\u0001)O\u0005E\u0011V\r\\3bg\u0016\u0014V\r]8tSR|'/_\u0001\tKZ,g\u000e\u001e\"vgB\u00111KV\u0007\u0002)*\u0011Q\u000bI\u0001\u0007KZ,g\u000e^:\n\u0005]#&!\u0005-M%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vg\u0006\t\u0012m]=oGJK7o[#yK\u000e,Ho\u001c:\u0011\u0005YR\u0016BA.\u001d\u0005E\t5/\u001f8d%&\u001c8.\u0012=fGV$xN]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000fy{\u0006-\u00192dIB\u0011a\u0007\u0001\u0005\u0006s\u001d\u0001\rA\u000f\u0005\u0006\u0001\u001e\u0001\r!\u0011\u0005\u0006\t\u001e\u0001\r!\u0012\u0005\u0006\u0017\u001e\u0001\r\u0001\u0014\u0005\u0006#\u001e\u0001\rA\u0015\u0005\u00061\u001e\u0001\r!W\u0001\bK:\f'\r\\3e+\u00059\u0007C\u00015l\u001b\u0005I'\"\u00016\u0002\u000bM\u001c\u0017\r\\1\n\u00051L'a\u0002\"p_2,\u0017M\\\u0001\fK:\f'\r\\3e?\u0012*\u0017\u000f\u0006\u0002peB\u0011\u0001\u000e]\u0005\u0003c&\u0014A!\u00168ji\"91/CA\u0001\u0002\u00049\u0017a\u0001=%c\u0005AQM\\1cY\u0016$\u0007\u0005\u000b\u0002\u000bmB\u0011\u0001n^\u0005\u0003q&\u0014\u0001B^8mCRLG.Z\u0001\u0012e&\u001c8.Q:tKN\u001cxN\u001d+za\u0016\u001cX#A>\u0011\u000bq\fI!a\u0004\u000f\u0007u\f)AD\u0002\u007f\u0003\u0007i\u0011a \u0006\u0004\u0003\u00031\u0013A\u0002\u001fs_>$h(C\u0001k\u0013\r\t9![\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY!!\u0004\u0003\t1K7\u000f\u001e\u0006\u0004\u0003\u000fI\u0007\u0003BA\t\u0003Gi!!a\u0005\u000b\t\u0005U\u0011qC\u0001\be\u00164G.Z2u\u0015\u0011\tI\"a\u0007\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002\u001e\u0005}\u0011A\u00029mk\u001eLgNC\u0002\u0002\"\t\n\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0005\u0003K\t\u0019B\u0001\u0003UsB,\u0017A\u0005:jg.\f5o]3tg>\u0014H+\u001f9fg\u0002\nQdY1mGVd\u0017\r^3SSN\\\u0017I\u001c3Va\u0012\fG/\u001a*fY\u0016\f7/\u001a\u000b\u0004_\u00065\u0002bBA\u0018\u001b\u0001\u0007\u0011\u0011G\u0001\ne\u0016dW-Y:f\u0013\u0012\u0004B!a\r\u0002<9!\u0011QGA\u001c!\tq\u0018.C\u0002\u0002:%\fa\u0001\u0015:fI\u00164\u0017\u0002BA\u001f\u0003\u007f\u0011aa\u0015;sS:<'bAA\u001dSR\u0019q.a\u0011\t\u000f\u0005\u0015c\u00021\u0001\u0002H\u00059!/\u001a7fCN,\u0007\u0003BA%\u0003\u001fj!!a\u0013\u000b\u0007\u00055\u0003%\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0003#\nYEA\u0004SK2,\u0017m]3\u0002\u001b\r\fGnY;mCR,'+[:l)\u0019\t9&!\u0019\u0002fA!\u0011\u0011LA/\u001b\t\tYFC\u0002\u0002NyIA!a\u0018\u0002\\\t!!+[:l\u0011\u001d\t\u0019g\u0004a\u0001\u0003/\nAb\u001c:jO&t\u0017\r\u001c*jg.Dq!!\u0012\u0010\u0001\u0004\t9%A\u0004hKR\u0014\u0016n]6\u0015\t\u0005]\u00131\u000e\u0005\b\u0003_\u0001\u0002\u0019AA\u0019\u000399W\r\u001e*jg.\u0004&o\u001c4jY\u0016$B!!\u001d\u0002xA!\u0011\u0011LA:\u0013\u0011\t)(a\u0017\u0003\u0017IK7o\u001b)s_\u001aLG.\u001a\u0005\b\u0003\u000b\n\u0002\u0019AA$\u0003))\b\u000fZ1uKJK7o\u001b\u000b\t\u0003/\ni(a \u0002\u0004\"9\u0011q\u0006\nA\u0002\u0005E\u0002bBAA%\u0001\u0007\u0011qK\u0001\t_JLw-\u001b8bY\"9\u0011Q\u0011\nA\u0002\u0005]\u0013aB;qI\u0006$X\rZ\u0001\u0016e&\u001c8.Q:tKN\u001cX.\u001a8u\u0007\"\fgnZ3e)\u00159\u00171RAH\u0011\u001d\tii\u0005a\u0001\u0003/\n\u0011!\u0019\u0005\b\u0003#\u001b\u0002\u0019AA,\u0003\u0005\u0011\u0017\u0001D:d_J,7\t[1oO\u0016$G#B4\u0002\u0018\u0006e\u0005bBAG)\u0001\u0007\u0011q\u000b\u0005\b\u0003##\u0002\u0019AA,\u000399WM\\3sCR,'+[:l\u0013\u0012$B!a(\u0002$B\u0019\u0011&!)\n\u0007\u0005u\"\u0006C\u0004\u00020U\u0001\r!!\r\u0002%\u001d,g.\u001a:bi\u0016\f5o]3tg>\u0014\u0018\n\u001a\u000b\u0005\u0003c\tI\u000bC\u0004\u0002,Z\u0001\r!!\r\u0002\u0019\u0005\u001c8/Z:t_Jt\u0015-\\3\u0002\u0017M,'O^5dK:\u000bW.\u001a\u000b\u0003\u0003c\tQa\u001d;beR$\u0012a\\\u0001\u0005gR|\u0007/A\u0005jgJ+hN\\5oOR\tq\rK\u0002\u0001\u0003{\u0003B!a0\u0002N6\u0011\u0011\u0011\u0019\u0006\u0005\u0003\u0007\f)-\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016TA!a2\u0002J\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148N\u0003\u0002\u0002L\u0006\u0019qN]4\n\t\u0005=\u0017\u0011\u0019\u0002\b'\u0016\u0014h/[2f\u0001")
public class RiskService
implements FeatureService,
RiskCalculator {
    private final RiskRepository riskRepository;
    private final RiskProfileService riskProfileService;
    private final ReleaseActorService releaseActorService;
    private final ReleaseRepository releaseRepository;
    private final XLReleaseEventBus eventBus;
    private final AsyncRiskExecutor asyncRiskExecutor;
    private volatile boolean enabled;
    private final List<Type> riskAssessorTypes;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Risk calculateRisk(RiskProfile profile, List<RiskAssessor> riskAssessors, String riskId, Release release) {
        return RiskCalculator.calculateRisk$(this, profile, riskAssessors, riskId, release);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RiskService riskService = this;
        synchronized (riskService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private boolean enabled() {
        return this.enabled;
    }

    private void enabled_$eq(boolean x$1) {
        this.enabled = x$1;
    }

    private List<Type> riskAssessorTypes() {
        return this.riskAssessorTypes;
    }

    public void calculateRiskAndUpdateRelease(String releaseId) {
        if (this.enabled()) {
            this.asyncRiskExecutor.executeAsync((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                Release release = $this.releaseRepository.findById(releaseId);
                this.calculateRiskAndUpdateRelease(release);
            });
            return;
        }
    }

    public void calculateRiskAndUpdateRelease(Release release) {
        if (this.enabled()) {
            this.asyncRiskExecutor.executeAsync((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                if (release.isPlannedOrActive() && !release.isWorkflow()) {
                    Risk originalRisk = $this.riskRepository.findByIdOrDefault(this.generateRiskId(release.getId()));
                    Risk updatedRisk = this.calculateRisk(originalRisk, release);
                    this.updateRisk(release.getId(), originalRisk, updatedRisk);
                    return;
                }
            });
            return;
        }
    }

    public Risk calculateRisk(Risk originalRisk, Release release) {
        if (this.enabled() && release.isPlannedOrActive() && !release.isWorkflow()) {
            RiskProfile riskProfileByRelease = this.getRiskProfile(release);
            List riskAssessors = this.riskAssessorTypes().filter((Function1 & Serializable)type -> BoxesRunTime.boxToBoolean((boolean)riskProfileByRelease.hasRiskAssessorEnabled(type))).map((Function1 & Serializable)riskAssessorType -> (RiskAssessor)riskAssessorType.getDescriptor().newInstance(this.generateAssessorId(riskAssessorType.getName())));
            String riskId = this.generateRiskId(release.getId());
            return this.calculateRisk(riskProfileByRelease, (List<RiskAssessor>)riskAssessors, riskId, release);
        }
        return originalRisk;
    }

    public Risk getRisk(String releaseId) {
        String riskId = this.generateRiskId(releaseId);
        return this.riskRepository.findByIdOrDefault(riskId);
    }

    private RiskProfile getRiskProfile(Release release) {
        return (RiskProfile)Option$.MODULE$.apply(release.getProperty("riskProfile")).getOrElse((Function0 & Serializable)() -> $this.riskProfileService.findByIdOrDefault(RiskProfile.DEFAULT_RISK_PROFILE_ID));
    }

    public Risk updateRisk(String releaseId, Risk original, Risk updated) {
        block0: {
            if (!this.scoreChanged(original, updated) && !this.riskAssessmentChanged(original, updated)) break block0;
            Object object = original.getRiskAssessments().isEmpty() ? this.riskRepository.create(updated) : BoxesRunTime.boxToBoolean((boolean)this.riskRepository.update(updated));
            this.logger().info((Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Updated risk score for release " + releaseId + " from " + original.getScore() + " to " + updated.getScore() + " and total risk score from " + original.getTotalScore() + " to " + updated.getTotalScore())));
            this.releaseRepository.setRiskScores(releaseId, Predef$.MODULE$.Integer2int(updated.getScore()), Predef$.MODULE$.Integer2int(updated.getTotalScore()));
            this.releaseActorService.updateReleaseRiskScores(releaseId, updated.getScore(), updated.getTotalScore());
            this.eventBus.publish((XLReleaseEvent)new RiskScoreUpdated(releaseId, Option$.MODULE$.apply((Object)original), updated));
        }
        return updated;
    }

    private boolean riskAssessmentChanged(Risk a, Risk b) {
        Function1 & Serializable keyMapping = (Function1 & Serializable)ra -> ra.getRiskAssessorId();
        Function2 & Serializable areEqual = (Function2 & Serializable)(ra1, ra2) -> BoxesRunTime.boxToBoolean((boolean)RiskService.$anonfun$riskAssessmentChanged$2(ra1, ra2));
        Diff diff = Diff$.MODULE$.applyWithKeyMappingAndComparator((Iterable)CollectionConverters$.MODULE$.ListHasAsScala(a.getRiskAssessments()).asScala(), (Iterable)CollectionConverters$.MODULE$.ListHasAsScala(b.getRiskAssessments()).asScala(), (Function1)keyMapping, (Function2)areEqual);
        return diff.updatedEntries().nonEmpty() || diff.newEntries().nonEmpty() || diff.deletedEntries().nonEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean scoreChanged(Risk a, Risk b) {
        Integer n = a.getScore();
        Integer n2 = b.getScore();
        if (n == null) {
            if (n2 != null) {
                return true;
            }
        } else if (!((Object)n).equals(n2)) return true;
        Integer n3 = a.getTotalScore();
        Integer n4 = b.getTotalScore();
        if (n3 == null) {
            if (n4 == null) return false;
            return true;
        } else if (((Object)n3).equals(n4)) return false;
        return true;
    }

    private String generateRiskId(String releaseId) {
        return releaseId + "/Risk";
    }

    private String generateAssessorId(String assessorName) {
        return Ids.ROOT_FOLDER_ID + "/" + assessorName;
    }

    public String serviceName() {
        return "RiskService";
    }

    public void start() {
        this.enabled_$eq(true);
    }

    public void stop() {
        this.enabled_$eq(false);
    }

    public boolean isRunning() {
        return this.enabled();
    }

    public static final /* synthetic */ boolean $anonfun$riskAssessorTypes$1(Type x$1) {
        return !x$1.getDescriptor().isVirtual();
    }

    private static final boolean safeEquals$1(Object x, Object y) {
        Option option = Option$.MODULE$.apply(x);
        Option option2 = Option$.MODULE$.apply(y);
        return !(option != null ? !option.equals(option2) : option2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$riskAssessmentChanged$2(RiskAssessment ra1, RiskAssessment ra2) {
        return RiskService.safeEquals$1(ra1.getScore(), ra2.getScore()) && RiskService.safeEquals$1(ra1.getHeadline(), ra2.getHeadline()) && RiskService.safeEquals$1(ra1.getMessages(), ra2.getMessages());
    }

    public RiskService(RiskRepository riskRepository, RiskProfileService riskProfileService, ReleaseActorService releaseActorService, ReleaseRepository releaseRepository, XLReleaseEventBus eventBus, AsyncRiskExecutor asyncRiskExecutor) {
        this.riskRepository = riskRepository;
        this.riskProfileService = riskProfileService;
        this.releaseActorService = releaseActorService;
        this.releaseRepository = releaseRepository;
        this.eventBus = eventBus;
        this.asyncRiskExecutor = asyncRiskExecutor;
        Logging.$init$((Logging)this);
        RiskCalculator.$init$(this);
        this.enabled = true;
        this.riskAssessorTypes = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(DescriptorRegistry.getSubtypes((Type)Type.valueOf(RiskAssessor.class))).asScala().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RiskService.$anonfun$riskAssessorTypes$1(x$1)))).toList();
    }
}

