package com.xebialabs.xlrelease.risk

import com.xebialabs.xlrelease.risk.ReleaseRiskSupervisorActor.CalculateReleaseRisk
import com.xebialabs.xlrelease.risk.domain.Risk
import com.xebialabs.xlrelease.risk.service.RiskService
import org.apache.pekko.actor.{Actor, Props}
import org.apache.pekko.event.slf4j.SLF4JLogging

class ReleaseRiskActor(releaseId: String, riskService: RiskService) extends Actor with SLF4JLogging{

  private var previousRisk: Risk = _

  override def preStart(): Unit = {
    super.preStart()
    previousRisk = riskService.getRisk(releaseId)
  }

  override def receive: Receive = {
    case CalculateReleaseRisk(eventType, releaseWithRisk) =>
      log.debug("Calculating release risk for event '{}' from release: '{}', previous score: {}, previous total score: {}",
        eventType.getSimpleName,
        releaseId,
        previousRisk.getScore,
        previousRisk.getTotalScore
      )
      val newRisk = riskService.calculateRisk(previousRisk, releaseWithRisk)
      riskService.updateRisk(releaseId, previousRisk, newRisk)
      previousRisk = newRisk
  }
}

object ReleaseRiskActor {
  def props(releaseId: String, riskService: RiskService) = Props(classOf[ReleaseRiskActor], releaseId, riskService)
}