package com.xebialabs.xlrelease.risk

import com.xebialabs.xlrelease.domain.Release

import scala.util.Try

package object domain {

  implicit class ReleaseWithRisk(release: Release) {

    val RISK_SCORE_PROPERTY = "riskScore"
    val RISK_TOTAL_SCORE_PROPERTY = "totalRiskScore"

    def getRiskScore: Int = {
      parseScore(release.getProperty(RISK_SCORE_PROPERTY))
    }

    def setRiskScore(riskScore: Int): Unit = {
      release.setProperty(RISK_SCORE_PROPERTY, s"$riskScore")
    }

    def getRiskTotalScore: Int = {
      parseScore(release.getProperty(RISK_TOTAL_SCORE_PROPERTY))
    }

    def setRiskTotalScore(riskTotalScore: Int): Unit = {
      release.setProperty(RISK_TOTAL_SCORE_PROPERTY, s"$riskTotalScore")
    }

    private def parseScore(s: String): Int = Try(s.toInt).getOrElse(0)

  }

}
