/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.repository;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseExtension;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseExtensionsRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.risk.builder.RiskBuilder;
import com.xebialabs.xlrelease.risk.domain.Risk;
import com.xebialabs.xlrelease.risk.domain.RiskAssessment;
import com.xebialabs.xlrelease.risk.repository.sql.persistence.RiskPersistence;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.utils.Diff;
import com.xebialabs.xlrelease.utils.Diff$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Repository
@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\u0005]h\u0001B\n\u0015\u0001}A\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006IA\u0011\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\u0017\"A\u0011\u000b\u0001B\u0001B\u0003%!\u000bC\u0003Y\u0001\u0011\u0005\u0011\fC\u0004o\u0001\t\u0007I\u0011I8\t\ri\u0004\u0001\u0015!\u0003q\u0011\u0015Y\b\u0001\"\u0011}\u0011\u001d\t9\u0001\u0001C!\u0003\u0013Aq!a\u0005\u0001\t\u0003\n)\u0002C\u0004\u0002\u001a\u0001!\t%a\u0007\t\u000f\u0005}\u0001\u0001\"\u0011\u0002\"!9\u0011Q\u0005\u0001\u0005\u0002\u0005\u001d\u0002bBA\u0016\u0001\u0011\u0005\u0011Q\u0006\u0005\b\u0003s\u0001A\u0011AA\u001e\u0011\u001d\ty\u0004\u0001C\t\u0003\u0003Bq!a\u001e\u0001\t#\tI\bC\u0004\u0002\u0016\u0002!\t\"a&\t\u000f\u0005\r\u0007\u0001\"\u0005\u0002F\nq!+[:l%\u0016\u0004xn]5u_JL(BA\u000b\u0017\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0003/a\tAA]5tW*\u0011\u0011DG\u0001\nq2\u0014X\r\\3bg\u0016T!a\u0007\u000f\u0002\u0013a,'-[1mC\n\u001c(\"A\u000f\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001\u0001\u0013\bE\u0002\"aMr!AI\u0017\u000f\u0005\rbcB\u0001\u0013,\u001d\t)#F\u0004\u0002'S5\tqE\u0003\u0002)=\u00051AH]8pizJ\u0011!H\u0005\u00037qI!!\u0007\u000e\n\u0005UA\u0012B\u0001\u00180\u0003m\u0011V\r\\3bg\u0016,\u0005\u0010^3og&|gn\u001d*fa>\u001c\u0018\u000e^8ss*\u0011Q\u0003G\u0005\u0003cI\u0012QEU3mK\u0006\u001cX-\u0012=uK:\u001c\u0018n\u001c8Ta\u0016\u001c\u0017.\u00197ju\u0016$'+\u001a9pg&$xN]=\u000b\u00059z\u0003C\u0001\u001b8\u001b\u0005)$B\u0001\u001c\u0017\u0003\u0019!w.\\1j]&\u0011\u0001(\u000e\u0002\u0005%&\u001c8\u000e\u0005\u0002;\u007f5\t1H\u0003\u0002={\u0005)1\u000f\u001c45U*\ta(\u0001\u0005he&T(\u0010\\3e\u0013\t\u00015HA\u0004M_\u001e<\u0017N\\4\u0002\u001fIL7o\u001b)feNL7\u000f^3oG\u0016\u0004\"a\u0011%\u000e\u0003\u0011S!!\u0012$\u0002\u0017A,'o]5ti\u0016t7-\u001a\u0006\u0003\u000fR\t1a]9m\u0013\tIEIA\bSSN\\\u0007+\u001a:tSN$XM\\2f\u0003I\u0011X\r\\3bg\u0016\u0004VM]:jgR,gnY3\u0011\u00051{U\"A'\u000b\u0005\u0015s%BA$0\u0013\t\u0001VJ\u0001\nSK2,\u0017m]3QKJ\u001c\u0018n\u001d;f]\u000e,\u0017A\u0004:fY\u0016\f7/Z*feZL7-\u001a\t\u0003'Zk\u0011\u0001\u0016\u0006\u0003+b\tqa]3sm&\u001cW-\u0003\u0002X)\nq!+\u001a7fCN,7+\u001a:wS\u000e,\u0017A\u0002\u001fj]&$h\b\u0006\u0003[9vs\u0006CA.\u0001\u001b\u0005!\u0002\"B!\u0005\u0001\u0004\u0011\u0005\"\u0002&\u0005\u0001\u0004Y\u0005\"B)\u0005\u0001\u0004\u0011\u0006F\u0001\u0003a!\t\tG.D\u0001c\u0015\t\u0019G-\u0001\u0006b]:|G/\u0019;j_:T!!\u001a4\u0002\u000f\u0019\f7\r^8ss*\u0011q\r[\u0001\u0006E\u0016\fgn\u001d\u0006\u0003S*\fqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002W\u0006\u0019qN]4\n\u00055\u0014'!C!vi><\u0018N]3e\u0003\u0011q\u0017-\\3\u0016\u0003A\u0004\"!]<\u000f\u0005I,\bC\u0001\u0014t\u0015\u0005!\u0018!B:dC2\f\u0017B\u0001<t\u0003\u0019\u0001&/\u001a3fM&\u0011\u00010\u001f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Y\u001c\u0018!\u00028b[\u0016\u0004\u0013AB3ySN$8\u000fF\u0002~\u0003\u0007\u0001\"A`@\u000e\u0003ML1!!\u0001t\u0005\u001d\u0011un\u001c7fC:Da!!\u0002\b\u0001\u0004\u0001\u0018A\u0002:jg.LE-\u0001\u0003sK\u0006$G\u0003BA\u0006\u0003#\u0001BA`A\u0007g%\u0019\u0011qB:\u0003\r=\u0003H/[8o\u0011\u0019\t)\u0001\u0003a\u0001a\u000611M]3bi\u0016$2aMA\f\u0011\u00159\u0012\u00021\u00014\u0003\u0019)\b\u000fZ1uKR\u0019Q0!\b\t\u000b]Q\u0001\u0019A\u001a\u0002\r\u0011,G.\u001a;f)\ri\u00181\u0005\u0005\u0007\u0003\u000bY\u0001\u0019\u00019\u0002#\u0019Lg\u000e\u001a\"z\u0013\u0012|%\u000fR3gCVdG\u000fF\u00024\u0003SAa!!\u0002\r\u0001\u0004\u0001\u0018A\u00064j]\u0012\u0014\u0016n]6BgN,7o]7f]R\u0014\u00150\u00133\u0015\t\u0005=\u0012Q\u0007\t\u0004i\u0005E\u0012bAA\u001ak\tq!+[:l\u0003N\u001cXm]:nK:$\bBBA\u001c\u001b\u0001\u0007\u0001/\u0001\tsSN\\\u0017i]:fgNlWM\u001c;JI\u0006YA-\u001a4bk2$(+[:l)\r\u0019\u0014Q\b\u0005\u0007\u0003\u000bq\u0001\u0019\u00019\u0002+U\u0004H-\u0019;f%&\u001c8.Q:tKN\u001cX.\u001a8ugR)Q0a\u0011\u0002d!9\u0011QI\bA\u0002\u0005\u001d\u0013A\u0003:fY\u0016\f7/Z+jIB!\u0011\u0011JA/\u001d\u0011\tY%a\u0016\u000f\t\u00055\u0013\u0011\u000b\b\u0004G\u0005=\u0013B\u0001\u001c\u0019\u0013\u0011\t\u0019&!\u0016\u0002\u0005%$'B\u0001\u001c\u0019\u0013\u0011\tI&a\u0017\u0002\u000fA\f7m[1hK*!\u00111KA+\u0013\u0011\ty&!\u0019\u0003\u000b\rKW+\u001b3\u000b\t\u0005e\u00131\f\u0005\b\u0003Kz\u0001\u0019AA4\u0003=\u0011\u0018n]6BgN,7o]7f]R\u001c\bCBA5\u0003c\nyC\u0004\u0003\u0002l\u0005=db\u0001\u0014\u0002n%\tA/C\u0002\u0002ZMLA!a\u001d\u0002v\t\u00191+Z9\u000b\u0007\u0005e3/A\u0010hKR,\u0005\u0010^3og&|gN\u0012:p[\u0006\u00138\r[5wK\u0012\u0014V\r\\3bg\u0016$B!a\u0003\u0002|!9\u0011Q\u0010\tA\u0002\u0005}\u0014!\u0003:fY\u0016\f7/Z%e!\u0011\t\t)a$\u000f\t\u0005\r\u00151\u0012\b\u0005\u0003\u000b\u000bIID\u0002#\u0003\u000fK!aR\u0018\n\u0005\u0015s\u0015bAAG\u001b\u0006!1)[%e\u0013\u0011\t\t*a%\u0003\t\rK\u0017\n\u001a\u0006\u0004\u0003\u001bk\u0015\u0001D<ji\"\u0014V\r\\3bg\u0016\u0004T\u0003BAM\u0003G#B!a'\u0002@R!\u0011QTA[!\u0015q\u0018QBAP!\u0011\t\t+a)\r\u0001\u00119\u0011QU\tC\u0002\u0005\u001d&!A!\u0012\t\u0005%\u0016q\u0016\t\u0004}\u0006-\u0016bAAWg\n9aj\u001c;iS:<\u0007c\u0001@\u00022&\u0019\u00111W:\u0003\u0007\u0005s\u0017\u0010C\u0004\u00028F\u0001\r!!/\u0002\u0003\u0019\u0004rA`A^\u0003\u000f\ny*C\u0002\u0002>N\u0014\u0011BR;oGRLwN\\\u0019\t\u000f\u0005\u0005\u0017\u00031\u0001\u0002\u0000\u0005!1-[%e\u0003-9\u0018\u000e\u001e5SK2,\u0017m]3\u0016\t\u0005\u001d\u0017Q\u001a\u000b\u0005\u0003\u0013\f\u0019\u000e\u0006\u0003\u0002L\u0006=\u0007\u0003BAQ\u0003\u001b$q!!*\u0013\u0005\u0004\t9\u000bC\u0004\u00028J\u0001\r!!5\u0011\u000fy\fY,a\u0012\u0002L\"9\u0011\u0011\u0019\nA\u0002\u0005}\u0004f\u0001\u0001\u0002XB!\u0011\u0011\\Ap\u001b\t\tYNC\u0002\u0002^\"\f!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\t\t/a7\u0003\u0015I+\u0007o\\:ji>\u0014\u0018\u0010K\u0002\u0001\u0003K\u0004B!a:\u0002t6\u0011\u0011\u0011\u001e\u0006\u0005\u0003W\fi/A\u0006ue\u0006t7/Y2uS>t'bA$\u0002p*\u0019\u0011\u0011\u001f\r\u0002\u0005\u0011\u0014\u0017\u0002BA{\u0003S\u0014q\"S:Ue\u0006t7/Y2uS>t\u0017\r\u001c")
public class RiskRepository
extends ReleaseExtensionsRepository.ReleaseExtensionSpecializedRepository<Risk>
implements Logging {
    private final RiskPersistence riskPersistence;
    private final ReleasePersistence releasePersistence;
    private final ReleaseService releaseService;
    private final String name;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RiskRepository riskRepository = this;
        synchronized (riskRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public String name() {
        return this.name;
    }

    public boolean exists(String riskId) {
        this.logger().debug((Function0 & Serializable)() -> "exists(" + riskId + ")");
        return this.releasePersistence.findUidByReleaseId(Ids.releaseIdFrom((String)riskId)).exists((Function1 & Serializable)releaseUid -> BoxesRunTime.boxToBoolean((boolean)this.riskPersistence.exists(releaseUid)));
    }

    public Option<Risk> read(String riskId) {
        this.logger().debug((Function0 & Serializable)() -> "read(" + riskId + ")");
        return this.withRelease0(Ids.releaseIdFrom((String)riskId), (Function1 & Serializable)releaseUid -> $this.riskPersistence.read((Long)releaseUid).map((Function1 & Serializable)risk -> {
            risk.setId(riskId);
            Seq<RiskAssessment> riskAssessments = $this.riskPersistence.readAllAssessments((Long)releaseUid);
            riskAssessments.foreach((Function1 & Serializable)x$1 -> {
                x$1.setRisk(risk);
                return BoxedUnit.UNIT;
            });
            risk.setRiskAssessments(CollectionConverters$.MODULE$.SeqHasAsJava(riskAssessments).asJava());
            return risk;
        })).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Risk create(Risk risk) {
        this.logger().debug((Function0 & Serializable)() -> "create(" + risk.getId() + ")");
        return (Risk)this.withRelease(Ids.releaseIdFrom((String)risk.getId()), (Function1 & Serializable)releaseUid -> {
            $this.riskPersistence.create((Long)releaseUid, Predef$.MODULE$.Integer2int(risk.getScore()), Predef$.MODULE$.Integer2int(risk.getTotalScore()));
            $this.riskPersistence.createOrUpdateAssessments((Long)releaseUid, (Seq<RiskAssessment>)CollectionConverters$.MODULE$.ListHasAsScala(risk.getRiskAssessments()).asScala().toSeq());
            return risk;
        });
    }

    public boolean update(Risk risk) {
        this.logger().debug((Function0 & Serializable)() -> "update(" + risk.getId() + ")");
        return BoxesRunTime.unboxToBoolean(this.withRelease(Ids.releaseIdFrom((String)risk.getId()), (Function1 & Serializable)releaseUid -> BoxesRunTime.boxToBoolean((boolean)RiskRepository.$anonfun$update$2(this, risk, releaseUid))));
    }

    public boolean delete(String riskId) {
        this.logger().debug((Function0 & Serializable)() -> "delete(" + riskId + ")");
        return BoxesRunTime.unboxToBoolean(this.withRelease(Ids.releaseIdFrom((String)riskId), (Function1 & Serializable)releaseUid -> BoxesRunTime.boxToBoolean((boolean)RiskRepository.$anonfun$delete$2(this, releaseUid))));
    }

    public Risk findByIdOrDefault(String riskId) {
        this.logger().debug((Function0 & Serializable)() -> "findByIdOrDefault(" + riskId + ")");
        return (Risk)this.read(riskId).orElse((Function0 & Serializable)() -> {
            String releaseId = Ids.releaseIdFrom((String)riskId);
            if ($this.releaseService.isArchived(releaseId)) {
                return this.getExtensionFromArchivedRelease(releaseId);
            }
            return None$.MODULE$;
        }).getOrElse((Function0 & Serializable)() -> this.defaultRisk(riskId));
    }

    public RiskAssessment findRiskAssessmentById(String riskAssessmentId) {
        this.logger().debug((Function0 & Serializable)() -> "findRiskAssessmentById(" + riskAssessmentId + ")");
        Risk risk = this.findByIdOrDefault(Ids.getParentId((String)riskAssessmentId));
        return (RiskAssessment)CollectionConverters$.MODULE$.ListHasAsScala(risk.getRiskAssessments()).asScala().find((Function1 & Serializable)ra -> BoxesRunTime.boxToBoolean((boolean)RiskRepository.$anonfun$findRiskAssessmentById$2(riskAssessmentId, ra))).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("RiskAssessment " + riskAssessmentId + " not found.", new Object[0]);
        });
    }

    public Risk defaultRisk(String riskId) {
        return RiskBuilder.newRisk().withId(riskId).withScore(0).withTotalScore(0).withAssessments(new RiskAssessment[0]).build();
    }

    public boolean updateRiskAssessments(Long releaseUid, Seq<RiskAssessment> riskAssessments) {
        this.logger().debug((Function0 & Serializable)() -> "updateRiskAssessments(" + releaseUid + ", " + riskAssessments.map((Function1 & Serializable)x$2 -> x$2.getId()) + ")");
        Seq<RiskAssessment> original = this.riskPersistence.readAllAssessments(releaseUid);
        Diff diff = Diff$.MODULE$.apply(((IterableOnceOps)original.map((Function1 & Serializable)ra -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ra.getRiskAssessorId()), ra))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), ((IterableOnceOps)riskAssessments.map((Function1 & Serializable)ra -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ra.getRiskAssessorId()), ra))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        int numDeleted = this.riskPersistence.deleteAssessments(releaseUid, (Seq<String>)diff.deletedKeys().toSeq());
        int numUpdated = this.riskPersistence.updateAssessments(releaseUid, (Seq<RiskAssessment>)diff.updatedValues().toSeq());
        int numCreated = this.riskPersistence.createOrUpdateAssessments(releaseUid, (Seq<RiskAssessment>)diff.newValues().toSeq());
        int num = numCreated + numUpdated - numDeleted;
        return riskAssessments.size() == num;
    }

    public Option<Risk> getExtensionFromArchivedRelease(String releaseId) {
        this.logger().debug((Function0 & Serializable)() -> "getExtensionFromArchivedRelease(" + releaseId + ")");
        Release release = this.releaseService.findByIdInArchive(releaseId);
        return CollectionConverters$.MODULE$.ListHasAsScala((List)release.getProperty("extensions")).asScala().collectFirst((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ RiskRepository $outer;

            public final <A1 extends ReleaseExtension, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Risk) {
                    Risk risk = (Risk)A1;
                    String string = Ids.getName((String)risk.getId());
                    String string2 = this.$outer.name();
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        return (B1)risk;
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(ReleaseExtension x1) {
                ReleaseExtension releaseExtension = x1;
                if (releaseExtension instanceof Risk) {
                    Risk risk = (Risk)releaseExtension;
                    String string = Ids.getName((String)risk.getId());
                    String string2 = this.$outer.name();
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        return true;
                    }
                }
                return false;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public <A> Option<A> withRelease0(String ciId, Function1<Long, A> f) {
        return this.releasePersistence.findUidByReleaseId(ciId).map(f);
    }

    public <A> A withRelease(String ciId, Function1<Long, A> f) {
        return (A)this.withRelease0(ciId, f).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Release [" + ciId + "] not found", new Object[0]);
        });
    }

    public static final /* synthetic */ boolean $anonfun$update$2(RiskRepository $this, Risk risk$3, Long releaseUid) {
        $this.updateRiskAssessments(releaseUid, (Seq<RiskAssessment>)CollectionConverters$.MODULE$.ListHasAsScala(risk$3.getRiskAssessments()).asScala().toSeq());
        return $this.riskPersistence.update(releaseUid, Predef$.MODULE$.Integer2int(risk$3.getScore()), Predef$.MODULE$.Integer2int(risk$3.getTotalScore())) == 1;
    }

    public static final /* synthetic */ boolean $anonfun$delete$2(RiskRepository $this, Long releaseUid) {
        int numDeleted = $this.riskPersistence.deleteAllAssessments(releaseUid);
        int deleted = $this.riskPersistence.delete(releaseUid);
        return numDeleted > 0 && deleted == 1;
    }

    public static final /* synthetic */ boolean $anonfun$findRiskAssessmentById$2(String riskAssessmentId$1, RiskAssessment ra) {
        String string = ra.getId();
        String string2 = riskAssessmentId$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @Autowired
    public RiskRepository(RiskPersistence riskPersistence, ReleasePersistence releasePersistence, ReleaseService releaseService) {
        this.riskPersistence = riskPersistence;
        this.releasePersistence = releasePersistence;
        this.releaseService = releaseService;
        Logging.$init$((Logging)this);
        this.name = "Risk";
    }
}

