/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.service;

import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.risk.domain.Risk;
import com.xebialabs.xlrelease.risk.domain.RiskAssessment;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.risk.domain.events.RiskScoreUpdated;
import com.xebialabs.xlrelease.risk.domain.riskassessors.RiskAssessor;
import com.xebialabs.xlrelease.risk.repository.RiskRepository;
import com.xebialabs.xlrelease.risk.service.AsyncRiskExecutor;
import com.xebialabs.xlrelease.risk.service.RiskCalculator;
import com.xebialabs.xlrelease.risk.service.RiskProfileService;
import com.xebialabs.xlrelease.service.FeatureService;
import com.xebialabs.xlrelease.utils.Diff;
import com.xebialabs.xlrelease.utils.Diff$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005-f\u0001\u0002\r\u001a\u0001\u0011B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t{\u0001\u0011\t\u0011)A\u0005}!A\u0011\t\u0001B\u0001B\u0003%!\t\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003J\u0011!q\u0005A!A!\u0002\u0013y\u0005\u0002C+\u0001\u0005\u0003\u0005\u000b\u0011\u0002,\t\u000be\u0003A\u0011\u0001.\t\u000f\t\u0004\u0001\u0019!C\u0005G\"9!\u000e\u0001a\u0001\n\u0013Y\u0007BB9\u0001A\u0003&A\rC\u0004w\u0001\t\u0007I\u0011B<\t\u000f\u0005\u0005\u0002\u0001)A\u0005q\"9\u00111\u0005\u0001\u0005\u0002\u0005\u0015\u0002bBA\u0012\u0001\u0011\u0005\u00111\b\u0005\b\u0003\u001b\u0002A\u0011BA(\u0011\u001d\t\t\u0007\u0001C\u0005\u0003GBq!!\u001c\u0001\t\u0013\ty\u0007C\u0004\u0002v\u0001!I!a\u001e\t\u000f\u0005}\u0004\u0001\"\u0003\u0002\u0002\"9\u0011q\u0011\u0001\u0005B\u0005%\u0005bBAF\u0001\u0011\u0005\u0013Q\u0012\u0005\b\u0003\u001f\u0003A\u0011IAG\u0011\u001d\t\t\n\u0001C!\u0003'\u00131BU5tWN+'O^5dK*\u0011!dG\u0001\bg\u0016\u0014h/[2f\u0015\taR$\u0001\u0003sSN\\'B\u0001\u0010 \u0003%AHN]3mK\u0006\u001cXM\u0003\u0002!C\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002E\u0005\u00191m\\7\u0004\u0001M!\u0001!J\u00173!\t13&D\u0001(\u0015\tA\u0013&\u0001\u0003mC:<'\"\u0001\u0016\u0002\t)\fg/Y\u0005\u0003Y\u001d\u0012aa\u00142kK\u000e$\bC\u0001\u00181\u001b\u0005y#B\u0001\u000e\u001e\u0013\t\ttF\u0001\bGK\u0006$XO]3TKJ4\u0018nY3\u0011\u0005M\"T\"A\r\n\u0005UJ\"A\u0004*jg.\u001c\u0015\r\\2vY\u0006$xN]\u0001\u000fe&\u001c8NU3q_NLGo\u001c:z!\tA4(D\u0001:\u0015\tQ4$\u0001\u0006sKB|7/\u001b;pefL!\u0001P\u001d\u0003\u001dIK7o\u001b*fa>\u001c\u0018\u000e^8ss\u0006\u0011\"/[:l!J|g-\u001b7f'\u0016\u0014h/[2f!\t\u0019t(\u0003\u0002A3\t\u0011\"+[:l!J|g-\u001b7f'\u0016\u0014h/[2f\u0003M\u0011X\r\\3bg\u0016\f5\r^8s'\u0016\u0014h/[2f!\t\u0019e)D\u0001E\u0015\t)U$\u0001\u0004bGR|'o]\u0005\u0003\u000f\u0012\u00131CU3mK\u0006\u001cX-Q2u_J\u001cVM\u001d<jG\u0016\f\u0011C]3mK\u0006\u001cXMU3q_NLGo\u001c:z!\tQE*D\u0001L\u0015\tQT$\u0003\u0002N\u0017\n\t\"+\u001a7fCN,'+\u001a9pg&$xN]=\u0002\u0011\u00154XM\u001c;CkN\u0004\"\u0001U*\u000e\u0003ES!AU\u000f\u0002\r\u00154XM\u001c;t\u0013\t!\u0016KA\tY\u0019J+G.Z1tK\u00163XM\u001c;CkN\f\u0011#Y:z]\u000e\u0014\u0016n]6Fq\u0016\u001cW\u000f^8s!\t\u0019t+\u0003\u0002Y3\t\t\u0012i]=oGJK7o[#yK\u000e,Ho\u001c:\u0002\rqJg.\u001b;?)\u001dYF,\u00180`A\u0006\u0004\"a\r\u0001\t\u000bY:\u0001\u0019A\u001c\t\u000bu:\u0001\u0019\u0001 \t\u000b\u0005;\u0001\u0019\u0001\"\t\u000b!;\u0001\u0019A%\t\u000b9;\u0001\u0019A(\t\u000bU;\u0001\u0019\u0001,\u0002\u000f\u0015t\u0017M\u00197fIV\tA\r\u0005\u0002fQ6\taMC\u0001h\u0003\u0015\u00198-\u00197b\u0013\tIgMA\u0004C_>dW-\u00198\u0002\u0017\u0015t\u0017M\u00197fI~#S-\u001d\u000b\u0003Y>\u0004\"!Z7\n\u000594'\u0001B+oSRDq\u0001]\u0005\u0002\u0002\u0003\u0007A-A\u0002yIE\n\u0001\"\u001a8bE2,G\r\t\u0015\u0003\u0015M\u0004\"!\u001a;\n\u0005U4'\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002#IL7o[!tg\u0016\u001c8o\u001c:UsB,7/F\u0001y!\u0015I\u00181AA\u0005\u001d\tQxP\u0004\u0002|}6\tAP\u0003\u0002~G\u00051AH]8pizJ\u0011aZ\u0005\u0004\u0003\u00031\u0017a\u00029bG.\fw-Z\u0005\u0005\u0003\u000b\t9A\u0001\u0003MSN$(bAA\u0001MB!\u00111BA\u000f\u001b\t\tiA\u0003\u0003\u0002\u0010\u0005E\u0011a\u0002:fM2,7\r\u001e\u0006\u0005\u0003'\t)\"A\u0002ba&TA!a\u0006\u0002\u001a\u00051\u0001\u000f\\;hS:T1!a\u0007 \u0003!!W\r\u001d7ps&$\u0018\u0002BA\u0010\u0003\u001b\u0011A\u0001V=qK\u0006\u0011\"/[:l\u0003N\u001cXm]:peRK\b/Z:!\u0003u\u0019\u0017\r\\2vY\u0006$XMU5tW\u0006sG-\u00169eCR,'+\u001a7fCN,Gc\u00017\u0002(!9\u0011\u0011F\u0007A\u0002\u0005-\u0012!\u0003:fY\u0016\f7/Z%e!\u0011\ti#!\u000e\u000f\t\u0005=\u0012\u0011\u0007\t\u0003w\u001aL1!a\rg\u0003\u0019\u0001&/\u001a3fM&!\u0011qGA\u001d\u0005\u0019\u0019FO]5oO*\u0019\u00111\u00074\u0015\u00071\fi\u0004C\u0004\u0002@9\u0001\r!!\u0011\u0002\u000fI,G.Z1tKB!\u00111IA%\u001b\t\t)EC\u0002\u0002Hu\ta\u0001Z8nC&t\u0017\u0002BA&\u0003\u000b\u0012qAU3mK\u0006\u001cX-\u0001\u0006va\u0012\fG/\u001a*jg.$R\u0001\\A)\u0003'Bq!!\u000b\u0010\u0001\u0004\tY\u0003C\u0004\u0002V=\u0001\r!a\u0016\u0002\u000fU\u0004H-\u0019;fIB!\u0011\u0011LA/\u001b\t\tYFC\u0002\u0002HmIA!a\u0018\u0002\\\t!!+[:l\u0003U\u0011\u0018n]6BgN,7o]7f]R\u001c\u0005.\u00198hK\u0012$R\u0001ZA3\u0003SBq!a\u001a\u0011\u0001\u0004\t9&A\u0001b\u0011\u001d\tY\u0007\u0005a\u0001\u0003/\n\u0011AY\u0001\rg\u000e|'/Z\"iC:<W\r\u001a\u000b\u0006I\u0006E\u00141\u000f\u0005\b\u0003O\n\u0002\u0019AA,\u0011\u001d\tY'\u0005a\u0001\u0003/\nabZ3oKJ\fG/\u001a*jg.LE\r\u0006\u0003\u0002z\u0005u\u0004c\u0001\u0014\u0002|%\u0019\u0011qG\u0014\t\u000f\u0005%\"\u00031\u0001\u0002,\u0005\u0011r-\u001a8fe\u0006$X-Q:tKN\u001cxN]%e)\u0011\tY#a!\t\u000f\u0005\u00155\u00031\u0001\u0002,\u0005a\u0011m]:fgN|'OT1nK\u0006Y1/\u001a:wS\u000e,g*Y7f)\t\tY#A\u0003ti\u0006\u0014H\u000fF\u0001m\u0003\u0011\u0019Ho\u001c9\u0002\u0013%\u001c(+\u001e8oS:<G#\u00013)\u0007\u0001\t9\n\u0005\u0003\u0002\u001a\u0006\u001dVBAAN\u0015\u0011\ti*a(\u0002\u0015M$XM]3pif\u0004XM\u0003\u0003\u0002\"\u0006\r\u0016aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0005\u0005\u0015\u0016aA8sO&!\u0011\u0011VAN\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class RiskService
implements FeatureService,
RiskCalculator {
    private final RiskRepository riskRepository;
    private final RiskProfileService riskProfileService;
    private final ReleaseActorService releaseActorService;
    private final ReleaseRepository releaseRepository;
    private final XLReleaseEventBus eventBus;
    private final AsyncRiskExecutor asyncRiskExecutor;
    private volatile boolean enabled;
    private final List<Type> riskAssessorTypes;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Risk calculateRisk(RiskProfile profile, List<RiskAssessor> riskAssessors, Risk risk, Release release) {
        return RiskCalculator.calculateRisk$(this, profile, riskAssessors, risk, release);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RiskService riskService = this;
        synchronized (riskService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private boolean enabled() {
        return this.enabled;
    }

    private void enabled_$eq(boolean x$1) {
        this.enabled = x$1;
    }

    private List<Type> riskAssessorTypes() {
        return this.riskAssessorTypes;
    }

    public void calculateRiskAndUpdateRelease(String releaseId) {
        if (this.enabled()) {
            this.asyncRiskExecutor.executeAsync((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                Release release = $this.releaseRepository.findById(releaseId);
                this.calculateRiskAndUpdateRelease(release);
            });
            return;
        }
    }

    public void calculateRiskAndUpdateRelease(Release release) {
        if (this.enabled()) {
            this.asyncRiskExecutor.executeAsync((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                if (release.isPlannedOrActive() && !release.isWorkflow()) {
                    Risk originalRisk = $this.riskRepository.findByIdOrDefault(this.generateRiskId(release.getId()));
                    RiskProfile riskProfileByRelease = (RiskProfile)Option$.MODULE$.apply(release.getProperty("riskProfile")).getOrElse((Function0 & Serializable)() -> $this.riskProfileService.findByIdOrDefault(RiskProfile.DEFAULT_RISK_PROFILE_ID));
                    List riskAssessors = this.riskAssessorTypes().filter((Function1 & Serializable)type -> BoxesRunTime.boxToBoolean((boolean)riskProfileByRelease.hasRiskAssessorEnabled(type))).map((Function1 & Serializable)riskAssessorType -> (RiskAssessor)riskAssessorType.getDescriptor().newInstance(this.generateAssessorId(riskAssessorType.getName())));
                    Risk updatedRisk = this.calculateRisk(riskProfileByRelease, (List<RiskAssessor>)riskAssessors, originalRisk, release);
                    this.updateRisk(release.getId(), updatedRisk);
                    return;
                }
            });
            return;
        }
    }

    private void updateRisk(String releaseId, Risk updated) {
        Some some;
        Risk original;
        boolean bl;
        Option<Risk> maybeOriginal;
        this.logger().debug((Function0 & Serializable)() -> "UpdateRisk(" + releaseId + ")");
        String riskId = releaseId + "/Risk";
        Option<Risk> option = maybeOriginal = this.riskRepository.read(riskId);
        if (None$.MODULE$.equals(option)) {
            this.riskRepository.create(updated);
            this.logger().info((Function0 & Serializable)() -> "Created risk score for release " + releaseId + ": " + updated.getScore() + " and total risk score " + updated.getTotalScore());
            bl = true;
        } else if (option instanceof Some && (original = (Risk)(some = (Some)option).value()) != null) {
            Risk risk = original;
            if (this.scoreChanged(risk, updated) || this.riskAssessmentChanged(risk, updated)) {
                this.riskRepository.update(updated);
                this.logger().info((Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Updated risk score for release " + releaseId + " from " + risk.getScore() + " to " + updated.getScore() + "\n               | and total risk score from " + risk.getTotalScore() + " to " + updated.getTotalScore())));
                bl = true;
            } else {
                bl = false;
            }
        } else {
            throw new MatchError(option);
        }
        boolean doUpdate = bl;
        if (doUpdate) {
            this.releaseRepository.setRiskScores(releaseId, Predef$.MODULE$.Integer2int(updated.getScore()), Predef$.MODULE$.Integer2int(updated.getTotalScore()));
            this.releaseActorService.updateReleaseRiskScores(releaseId, updated.getScore(), updated.getTotalScore());
            this.eventBus.publish((XLReleaseEvent)new RiskScoreUpdated(releaseId, maybeOriginal, updated));
            return;
        }
    }

    private boolean riskAssessmentChanged(Risk a, Risk b) {
        Function1 & Serializable keyMapping = (Function1 & Serializable)ra -> ra.getRiskAssessorId();
        Function2 & Serializable areEqual = (Function2 & Serializable)(ra1, ra2) -> BoxesRunTime.boxToBoolean((boolean)RiskService.$anonfun$riskAssessmentChanged$2(ra1, ra2));
        Diff diff = Diff$.MODULE$.applyWithKeyMappingAndComparator((Iterable)CollectionConverters$.MODULE$.ListHasAsScala(a.getRiskAssessments()).asScala(), (Iterable)CollectionConverters$.MODULE$.ListHasAsScala(b.getRiskAssessments()).asScala(), (Function1)keyMapping, (Function2)areEqual);
        return diff.updatedEntries().nonEmpty() || diff.newEntries().nonEmpty() || diff.deletedEntries().nonEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean scoreChanged(Risk a, Risk b) {
        Integer n = a.getScore();
        Integer n2 = b.getScore();
        if (n == null) {
            if (n2 != null) {
                return true;
            }
        } else if (!((Object)n).equals(n2)) return true;
        Integer n3 = a.getTotalScore();
        Integer n4 = b.getTotalScore();
        if (n3 == null) {
            if (n4 == null) return false;
            return true;
        } else if (((Object)n3).equals(n4)) return false;
        return true;
    }

    private String generateRiskId(String releaseId) {
        return releaseId + "/Risk";
    }

    private String generateAssessorId(String assessorName) {
        return Ids.ROOT_FOLDER_ID + "/" + assessorName;
    }

    public String serviceName() {
        return "RiskService";
    }

    public void start() {
        this.enabled_$eq(true);
    }

    public void stop() {
        this.enabled_$eq(false);
    }

    public boolean isRunning() {
        return this.enabled();
    }

    public static final /* synthetic */ boolean $anonfun$riskAssessorTypes$1(Type x$1) {
        return !x$1.getDescriptor().isVirtual();
    }

    private static final boolean safeEquals$1(Object x, Object y) {
        Option option = Option$.MODULE$.apply(x);
        Option option2 = Option$.MODULE$.apply(y);
        return !(option != null ? !option.equals(option2) : option2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$riskAssessmentChanged$2(RiskAssessment ra1, RiskAssessment ra2) {
        return RiskService.safeEquals$1(ra1.getScore(), ra2.getScore()) && RiskService.safeEquals$1(ra1.getHeadline(), ra2.getHeadline()) && RiskService.safeEquals$1(ra1.getMessages(), ra2.getMessages());
    }

    public RiskService(RiskRepository riskRepository, RiskProfileService riskProfileService, ReleaseActorService releaseActorService, ReleaseRepository releaseRepository, XLReleaseEventBus eventBus, AsyncRiskExecutor asyncRiskExecutor) {
        this.riskRepository = riskRepository;
        this.riskProfileService = riskProfileService;
        this.releaseActorService = releaseActorService;
        this.releaseRepository = releaseRepository;
        this.eventBus = eventBus;
        this.asyncRiskExecutor = asyncRiskExecutor;
        Logging.$init$((Logging)this);
        RiskCalculator.$init$(this);
        this.enabled = true;
        this.riskAssessorTypes = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(DescriptorRegistry.getSubtypes((Type)Type.valueOf(RiskAssessor.class))).asScala().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RiskService.$anonfun$riskAssessorTypes$1(x$1)))).toList();
    }
}

