/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.service;

import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.events.ReleaseCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseOverdueEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.TaskAbortedEvent;
import com.xebialabs.xlrelease.domain.events.TaskCompletedEvent;
import com.xebialabs.xlrelease.domain.events.TaskDeletedEvent;
import com.xebialabs.xlrelease.domain.events.TaskFailedEvent;
import com.xebialabs.xlrelease.domain.events.TaskOverdueEvent;
import com.xebialabs.xlrelease.domain.events.TaskRetriedEvent;
import com.xebialabs.xlrelease.domain.events.TaskSkippedEvent;
import com.xebialabs.xlrelease.domain.events.TaskUpdatedEvent;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.events.SynchronizedSubscribe;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.risk.domain.events.RiskProfileUpdated;
import com.xebialabs.xlrelease.risk.service.RiskService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.concurrent.Executor;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.reflect.ScalaSignature;

@Service
@EventListener
@ScalaSignature(bytes="\u0006\u0005\u0005\rh\u0001\u0002\u000b\u0016\u0001\u0001B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tm\u0001\u0011\t\u0011)A\u0005o!AQ\b\u0001B\u0001B\u0003%a\b\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003D\u0011\u0015i\u0005\u0001\"\u0001O\u0011\u0015\u0019\u0007\u0001\"\u0001e\u0011\u0015A\b\u0001\"\u0001z\u0011\u001d\t\t\u0001\u0001C\u0001\u0003\u0007Aq!!\u0005\u0001\t\u0003\t\u0019\u0002C\u0004\u0002\"\u0001!\t!a\t\t\u000f\u0005E\u0002\u0001\"\u0001\u00024!9\u0011\u0011\t\u0001\u0005\u0002\u0005\r\u0003bBA)\u0001\u0011\u0005\u00111\u000b\u0005\b\u0003C\u0002A\u0011AA2\u0011\u001d\t\t\b\u0001C\u0001\u0003gBq!!!\u0001\t\u0003\t\u0019\tC\u0004\u0002\u0012\u0002!I!a%\t\u000f\u0005\u0005\u0006\u0001\"\u0001\u0002$\"9\u0011Q\u0018\u0001\u0005\n\u0005}&\u0001\u0005*jg.,e/\u001a8u\u0011\u0006tG\r\\3s\u0015\t1r#A\u0004tKJ4\u0018nY3\u000b\u0005aI\u0012\u0001\u0002:jg.T!AG\u000e\u0002\u0013ad'/\u001a7fCN,'B\u0001\u000f\u001e\u0003%AXMY5bY\u0006\u00147OC\u0001\u001f\u0003\r\u0019w.\\\u0002\u0001'\r\u0001\u0011e\n\t\u0003E\u0015j\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011ae\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005!jS\"A\u0015\u000b\u0005)Z\u0013!B:mMRR'\"\u0001\u0017\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!AL\u0015\u0003\u000f1{wmZ5oO\u0006I\u0001\u0010\u001c:D_:4\u0017n\u001a\t\u0003cQj\u0011A\r\u0006\u0003ge\taaY8oM&<\u0017BA\u001b3\u0005%AFN]\"p]\u001aLw-A\fd_:4\u0017nZ;sCRLwN\u001c*fa>\u001c\u0018\u000e^8ssB\u0011\u0001hO\u0007\u0002s)\u0011!(G\u0001\u000be\u0016\u0004xn]5u_JL\u0018B\u0001\u001f:\u0005]\u0019uN\u001c4jOV\u0014\u0018\r^5p]J+\u0007o\\:ji>\u0014\u00180A\u0006sSN\\7+\u001a:wS\u000e,\u0007CA A\u001b\u0005)\u0012BA!\u0016\u0005-\u0011\u0016n]6TKJ4\u0018nY3\u00029IL7o[\"bY\u000e,H.\u0019;j_:\u0014\u0015\r^2i\u000bb,7-\u001e;peB\u0011AiS\u0007\u0002\u000b*\u0011aiR\u0001\u000bG>t7-\u001e:sK:$(B\u0001%J\u0003\u0011)H/\u001b7\u000b\u0003)\u000bAA[1wC&\u0011A*\u0012\u0002\t\u000bb,7-\u001e;pe\u00061A(\u001b8jiz\"Ra\u0014)R%N\u0003\"a\u0010\u0001\t\u000b=*\u0001\u0019\u0001\u0019\t\u000bY*\u0001\u0019A\u001c\t\u000bu*\u0001\u0019\u0001 \t\u000b\t+\u0001\u0019A\")\u0005\u0015)\u0006C\u0001,b\u001b\u00059&B\u0001-Z\u0003)\tgN\\8uCRLwN\u001c\u0006\u00035n\u000bqAZ1di>\u0014\u0018P\u0003\u0002];\u0006)!-Z1og*\u0011alX\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t\u0001-A\u0002pe\u001eL!AY,\u0003\u0013\u0005+Ho\\<je\u0016$\u0017A\u0004:fY\u0016\f7/Z\"sK\u0006$X\r\u001a\u000b\u0003K\"\u0004\"A\t4\n\u0005\u001d\u001c#\u0001B+oSRDQ!\u001b\u0004A\u0002)\f1C]3mK\u0006\u001cXm\u0011:fCR,G-\u0012<f]R\u0004\"a\u001b9\u000e\u00031T!!\u001c8\u0002\r\u00154XM\u001c;t\u0015\ty\u0017$\u0001\u0004e_6\f\u0017N\\\u0005\u0003c2\u00141CU3mK\u0006\u001cXm\u0011:fCR,G-\u0012<f]RD#AB:\u0011\u0005Q4X\"A;\u000b\u00055L\u0012BA<v\u0005%\u0019VOY:de&\u0014W-\u0001\bsK2,\u0017m]3Va\u0012\fG/\u001a3\u0015\u0005\u0015T\b\"B>\b\u0001\u0004a\u0018a\u0005:fY\u0016\f7/Z+qI\u0006$X\rZ#wK:$\bCA6~\u0013\tqHNA\nSK2,\u0017m]3Va\u0012\fG/\u001a3Fm\u0016tG\u000f\u000b\u0002\bg\u0006q!/\u001a7fCN,wJ^3sIV,GcA3\u0002\u0006!9\u0011q\u0001\u0005A\u0002\u0005%\u0011a\u0005:fY\u0016\f7/Z(wKJ$W/Z#wK:$\bcA6\u0002\f%\u0019\u0011Q\u00027\u0003'I+G.Z1tK>3XM\u001d3vK\u00163XM\u001c;)\u0005!\u0019\u0018A\u0003;bg.4\u0015-\u001b7fIR\u0019Q-!\u0006\t\u000f\u0005]\u0011\u00021\u0001\u0002\u001a\u0005yA/Y:l\r\u0006LG.\u001a3Fm\u0016tG\u000fE\u0002l\u00037I1!!\bm\u0005=!\u0016m]6GC&dW\rZ#wK:$\bFA\u0005t\u0003-!\u0018m]6SKR\u0014\u0018.\u001a3\u0015\u0007\u0015\f)\u0003C\u0004\u0002()\u0001\r!!\u000b\u0002!Q\f7o\u001b*fiJLW\rZ#wK:$\bcA6\u0002,%\u0019\u0011Q\u00067\u0003!Q\u000b7o\u001b*fiJLW\rZ#wK:$\bF\u0001\u0006t\u00035!\u0018m]6D_6\u0004H.\u001a;fIR\u0019Q-!\u000e\t\u000f\u0005]2\u00021\u0001\u0002:\u0005\u0011B/Y:l\u0007>l\u0007\u000f\\3uK\u0012,e/\u001a8u!\rY\u00171H\u0005\u0004\u0003{a'A\u0005+bg.\u001cu.\u001c9mKR,G-\u0012<f]RD#aC:\u0002\u0017Q\f7o[*lSB\u0004X\r\u001a\u000b\u0004K\u0006\u0015\u0003bBA$\u0019\u0001\u0007\u0011\u0011J\u0001\u0011i\u0006\u001c8nU6jaB,G-\u0012<f]R\u00042a[A&\u0013\r\ti\u0005\u001c\u0002\u0011)\u0006\u001c8nU6jaB,G-\u0012<f]RD#\u0001D:\u0002\u0017Q\f7o[!c_J$X\r\u001a\u000b\u0004K\u0006U\u0003bBA,\u001b\u0001\u0007\u0011\u0011L\u0001\u0011i\u0006\u001c8.\u00112peR,G-\u0012<f]R\u00042a[A.\u0013\r\ti\u0006\u001c\u0002\u0011)\u0006\u001c8.\u00112peR,G-\u0012<f]RD#!D:\u0002\u0017Q\f7o[+qI\u0006$X\r\u001a\u000b\u0004K\u0006\u0015\u0004bBA4\u001d\u0001\u0007\u0011\u0011N\u0001\u0011i\u0006\u001c8.\u00169eCR,G-\u0012<f]R\u00042a[A6\u0013\r\ti\u0007\u001c\u0002\u0011)\u0006\u001c8.\u00169eCR,G-\u0012<f]RD#AD:\u0002\u0017Q\f7o[(wKJ$W/\u001a\u000b\u0004K\u0006U\u0004bBA<\u001f\u0001\u0007\u0011\u0011P\u0001\u0011i\u0006\u001c8n\u0014<fe\u0012,X-\u0012<f]R\u00042a[A>\u0013\r\ti\b\u001c\u0002\u0011)\u0006\u001c8n\u0014<fe\u0012,X-\u0012<f]RD#aD:\u0002\u0017Q\f7o\u001b#fY\u0016$X\r\u001a\u000b\u0004K\u0006\u0015\u0005bBAD!\u0001\u0007\u0011\u0011R\u0001\u0011i\u0006\u001c8\u000eR3mKR,G-\u0012<f]R\u00042a[AF\u0013\r\ti\t\u001c\u0002\u0011)\u0006\u001c8\u000eR3mKR,G-\u0012<f]RD#\u0001E:\u0002\u001b\r\fGnY;mCR,'+[:l)\r)\u0017Q\u0013\u0005\b\u0003/\u000b\u0002\u0019AAM\u0003\u001d\u0011X\r\\3bg\u0016\u0004B!a'\u0002\u001e6\ta.C\u0002\u0002 :\u0014qAU3mK\u0006\u001cX-A\fiC:$G.\u001a*jg.\u0004&o\u001c4jY\u0016,\u0006\u000fZ1uKR\u0019Q-!*\t\u000f\u0005\u001d&\u00031\u0001\u0002*\u0006)QM^3oiB!\u00111VAY\u001b\t\tiKC\u0002n\u0003_S!a\\\f\n\t\u0005M\u0016Q\u0016\u0002\u0013%&\u001c8\u000e\u0015:pM&dW-\u00169eCR,G\rK\u0002\u0013\u0003o\u00032\u0001^A]\u0013\r\tY,\u001e\u0002\u0016'ft7\r\u001b:p]&TX\rZ*vEN\u001c'/\u001b2f\u0003u\u0011XO\\\"bY\u000e,H.\u0019;j_:\u001chi\u001c:SSN\\\u0007K]8gS2,GcA3\u0002B\"9\u00111Y\nA\u0002\u0005\u0015\u0017a\u0003:jg.\u0004&o\u001c4jY\u0016\u0004B!a2\u0002J6\u0011\u0011qV\u0005\u0005\u0003\u0017\fyKA\u0006SSN\\\u0007K]8gS2,\u0007f\u0001\u0001\u0002PB!\u0011\u0011[Al\u001b\t\t\u0019NC\u0002\u0002Vv\u000b!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\tI.a5\u0003\u000fM+'O^5dK\"\u001a\u0001!!8\u0011\u0007Q\fy.C\u0002\u0002bV\u0014Q\"\u0012<f]Rd\u0015n\u001d;f]\u0016\u0014\b")
public class RiskEventHandler
implements Logging {
    private final XlrConfig xlrConfig;
    private final ConfigurationRepository configurationRepository;
    private final RiskService riskService;
    private final Executor riskCalculationBatchExecutor;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RiskEventHandler riskEventHandler = this;
        synchronized (riskEventHandler) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Subscribe
    public void releaseCreated(ReleaseCreatedEvent releaseCreatedEvent) {
        this.calculateRisk(releaseCreatedEvent.release());
    }

    @Subscribe
    public void releaseUpdated(ReleaseUpdatedEvent releaseUpdatedEvent) {
        this.calculateRisk(releaseUpdatedEvent.updated());
    }

    @Subscribe
    public void releaseOverdue(ReleaseOverdueEvent releaseOverdueEvent) {
        this.calculateRisk(releaseOverdueEvent.release());
    }

    @Subscribe
    public void taskFailed(TaskFailedEvent taskFailedEvent) {
        this.calculateRisk(taskFailedEvent.task().getRelease());
    }

    @Subscribe
    public void taskRetried(TaskRetriedEvent taskRetriedEvent) {
        this.calculateRisk(taskRetriedEvent.task().getRelease());
    }

    @Subscribe
    public void taskCompleted(TaskCompletedEvent taskCompletedEvent) {
        this.calculateRisk(taskCompletedEvent.task().getRelease());
    }

    @Subscribe
    public void taskSkipped(TaskSkippedEvent taskSkippedEvent) {
        this.calculateRisk(taskSkippedEvent.task().getRelease());
    }

    @Subscribe
    public void taskAborted(TaskAbortedEvent taskAbortedEvent) {
        this.calculateRisk(taskAbortedEvent.task().getRelease());
    }

    @Subscribe
    public void taskUpdated(TaskUpdatedEvent taskUpdatedEvent) {
        this.calculateRisk(taskUpdatedEvent.updated().getRelease());
    }

    @Subscribe
    public void taskOverdue(TaskOverdueEvent taskOverdueEvent) {
        this.calculateRisk(taskOverdueEvent.task().getRelease());
    }

    @Subscribe
    public void taskDeleted(TaskDeletedEvent taskDeletedEvent) {
        this.calculateRisk(taskDeletedEvent.task().getRelease());
    }

    private void calculateRisk(Release release) {
        if (this.xlrConfig.isRiskCalculationEnabled() && this.riskService.isRunning()) {
            this.riskService.calculateRiskAndUpdateRelease(release);
            return;
        }
    }

    @SynchronizedSubscribe
    public void handleRiskProfileUpdate(RiskProfileUpdated event) {
        if (this.xlrConfig.isRiskCalculationEnabled()) {
            RiskProfile riskProfile = event.riskProfile();
            this.riskCalculationBatchExecutor.execute(() -> this.runCalculationsForRiskProfile(riskProfile));
            return;
        }
    }

    private void runCalculationsForRiskProfile(RiskProfile riskProfile) {
        this.logger().debug((Function0 & Serializable)() -> "Running risk calculations after Risk profile " + riskProfile.getId() + " update");
        this.configurationRepository.getReferenceReleases(riskProfile.getId()).forEach(data -> $this.riskService.calculateRiskAndUpdateRelease(data.id()));
        this.logger().debug((Function0 & Serializable)() -> "Finished running risk calculations after Risk profile " + riskProfile.getId() + " update");
    }

    @Autowired
    public RiskEventHandler(XlrConfig xlrConfig, ConfigurationRepository configurationRepository, RiskService riskService, Executor riskCalculationBatchExecutor) {
        this.xlrConfig = xlrConfig;
        this.configurationRepository = configurationRepository;
        this.riskService = riskService;
        this.riskCalculationBatchExecutor = riskCalculationBatchExecutor;
        Logging.$init$((Logging)this);
    }
}

