/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.service;

import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.risk.domain.Risk;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.risk.domain.events.RiskScoreUpdated;
import com.xebialabs.xlrelease.risk.domain.riskassessors.RiskAssessor;
import com.xebialabs.xlrelease.risk.repository.RiskRepository;
import com.xebialabs.xlrelease.risk.service.AsyncRiskExecutor;
import com.xebialabs.xlrelease.risk.service.RiskProfileService;
import com.xebialabs.xlrelease.service.FeatureService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005Mf\u0001\u0002\r\u001a\u0001\u0011B\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\"Aa\t\u0001B\u0001B\u0003%q\t\u0003\u0005N\u0001\t\u0005\t\u0015!\u0003O\u0011!\u0019\u0006A!A!\u0002\u0013!\u0006\u0002\u0003.\u0001\u0005\u0003\u0005\u000b\u0011B.\t\u000by\u0003A\u0011A0\t\u000f\u001d\u0004\u0001\u0019!C\u0005Q\"9q\u000e\u0001a\u0001\n\u0013\u0001\bB\u0002<\u0001A\u0003&\u0011\u000eC\u0004|\u0001\t\u0007I\u0011\u0002?\t\u000f\u0005-\u0002\u0001)A\u0005{\"9\u0011Q\u0006\u0001\u0005\u0002\u0005=\u0002bBA&\u0001\u0011\u0005\u0011Q\n\u0005\b\u0003\u0017\u0002A\u0011AA2\u0011\u001d\t9\u0007\u0001C\u0005\u0003SBq!!\u001d\u0001\t\u0013\t\u0019\bC\u0004\u0002~\u0001!I!a \t\u000f\u0005\u001d\u0005\u0001\"\u0003\u0002\n\"9\u0011q\u0012\u0001\u0005B\u0005E\u0005bBAJ\u0001\u0011\u0005\u0013Q\u0013\u0005\b\u0003/\u0003A\u0011IAK\u0011\u001d\tI\n\u0001C!\u00037\u00131BU5tWN+'O^5dK*\u0011!dG\u0001\bg\u0016\u0014h/[2f\u0015\taR$\u0001\u0003sSN\\'B\u0001\u0010 \u0003%AHN]3mK\u0006\u001cXM\u0003\u0002!C\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002E\u0005\u00191m\\7\u0004\u0001M!\u0001!J\u00173!\t13&D\u0001(\u0015\tA\u0013&\u0001\u0003mC:<'\"\u0001\u0016\u0002\t)\fg/Y\u0005\u0003Y\u001d\u0012aa\u00142kK\u000e$\bC\u0001\u00181\u001b\u0005y#B\u0001\u000e\u001e\u0013\t\ttF\u0001\bGK\u0006$XO]3TKJ4\u0018nY3\u0011\u0005MBT\"\u0001\u001b\u000b\u0005U2\u0014!B:mMRR'\"A\u001c\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!!\u000f\u001b\u0003\u000f1{wmZ5oO\u0006q!/[:l%\u0016\u0004xn]5u_JL\bC\u0001\u001f@\u001b\u0005i$B\u0001 \u001c\u0003)\u0011X\r]8tSR|'/_\u0005\u0003\u0001v\u0012aBU5tWJ+\u0007o\\:ji>\u0014\u00180\u0001\nsSN\\\u0007K]8gS2,7+\u001a:wS\u000e,\u0007CA\"E\u001b\u0005I\u0012BA#\u001a\u0005I\u0011\u0016n]6Qe>4\u0017\u000e\\3TKJ4\u0018nY3\u0002'I,G.Z1tK\u0006\u001bGo\u001c:TKJ4\u0018nY3\u0011\u0005![U\"A%\u000b\u0005)k\u0012AB1di>\u00148/\u0003\u0002M\u0013\n\u0019\"+\u001a7fCN,\u0017i\u0019;peN+'O^5dK\u0006\t\"/\u001a7fCN,'+\u001a9pg&$xN]=\u0011\u0005=\u000bV\"\u0001)\u000b\u0005yj\u0012B\u0001*Q\u0005E\u0011V\r\\3bg\u0016\u0014V\r]8tSR|'/_\u0001\tKZ,g\u000e\u001e\"vgB\u0011Q\u000bW\u0007\u0002-*\u0011q+H\u0001\u0007KZ,g\u000e^:\n\u0005e3&!\u0005-M%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vg\u0006\t\u0012m]=oGJK7o[#yK\u000e,Ho\u001c:\u0011\u0005\rc\u0016BA/\u001a\u0005E\t5/\u001f8d%&\u001c8.\u0012=fGV$xN]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f\u0001\f'm\u00193fMB\u00111\t\u0001\u0005\u0006u\u001d\u0001\ra\u000f\u0005\u0006\u0003\u001e\u0001\rA\u0011\u0005\u0006\r\u001e\u0001\ra\u0012\u0005\u0006\u001b\u001e\u0001\rA\u0014\u0005\u0006'\u001e\u0001\r\u0001\u0016\u0005\u00065\u001e\u0001\raW\u0001\bK:\f'\r\\3e+\u0005I\u0007C\u00016n\u001b\u0005Y'\"\u00017\u0002\u000bM\u001c\u0017\r\\1\n\u00059\\'a\u0002\"p_2,\u0017M\\\u0001\fK:\f'\r\\3e?\u0012*\u0017\u000f\u0006\u0002riB\u0011!N]\u0005\u0003g.\u0014A!\u00168ji\"9Q/CA\u0001\u0002\u0004I\u0017a\u0001=%c\u0005AQM\\1cY\u0016$\u0007\u0005\u000b\u0002\u000bqB\u0011!._\u0005\u0003u.\u0014\u0001B^8mCRLG.Z\u0001\u0012e&\u001c8.Q:tKN\u001cxN\u001d+za\u0016\u001cX#A?\u0011\u000by\fi!a\u0005\u000f\u0007}\fIA\u0004\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\r\t)aI\u0001\u0007yI|w\u000e\u001e \n\u00031L1!a\u0003l\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0004\u0002\u0012\t!A*[:u\u0015\r\tYa\u001b\t\u0005\u0003+\t9#\u0004\u0002\u0002\u0018)!\u0011\u0011DA\u000e\u0003\u001d\u0011XM\u001a7fGRTA!!\b\u0002 \u0005\u0019\u0011\r]5\u000b\t\u0005\u0005\u00121E\u0001\u0007a2,x-\u001b8\u000b\u0007\u0005\u0015r$\u0001\u0005eKBdw._5u\u0013\u0011\tI#a\u0006\u0003\tQK\b/Z\u0001\u0013e&\u001c8.Q:tKN\u001cxN\u001d+za\u0016\u001c\b%A\u0007dC2\u001cW\u000f\\1uKJK7o\u001b\u000b\u0005\u0003c\ti\u0004\u0005\u0003\u00024\u0005eRBAA\u001b\u0015\r\t9dG\u0001\u0007I>l\u0017-\u001b8\n\t\u0005m\u0012Q\u0007\u0002\u0005%&\u001c8\u000eC\u0004\u0002@5\u0001\r!!\u0011\u0002\u000fI,G.Z1tKB!\u00111IA$\u001b\t\t)EC\u0002\u00028uIA!!\u0013\u0002F\t9!+\u001a7fCN,\u0017!H2bY\u000e,H.\u0019;f%&\u001c8.\u00118e+B$\u0017\r^3SK2,\u0017m]3\u0015\u0007E\fy\u0005C\u0004\u0002R9\u0001\r!a\u0015\u0002\u0013I,G.Z1tK&#\u0007\u0003BA+\u0003;rA!a\u0016\u0002ZA\u0019\u0011\u0011A6\n\u0007\u0005m3.\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003?\n\tG\u0001\u0004TiJLgn\u001a\u0006\u0004\u00037ZGcA9\u0002f!9\u0011qH\bA\u0002\u0005\u0005\u0013AC;qI\u0006$XMU5tWR)\u0011/a\u001b\u0002n!9\u0011\u0011\u000b\tA\u0002\u0005M\u0003bBA8!\u0001\u0007\u0011\u0011G\u0001\bkB$\u0017\r^3e\u00031\u00198m\u001c:f\u0007\"\fgnZ3e)\u0015I\u0017QOA=\u0011\u001d\t9(\u0005a\u0001\u0003c\t\u0011!\u0019\u0005\b\u0003w\n\u0002\u0019AA\u0019\u0003\u0005\u0011\u0017AD4f]\u0016\u0014\u0018\r^3SSN\\\u0017\n\u001a\u000b\u0005\u0003\u0003\u000b)\tE\u0002'\u0003\u0007K1!a\u0018(\u0011\u001d\t\tF\u0005a\u0001\u0003'\n!cZ3oKJ\fG/Z!tg\u0016\u001c8o\u001c:JIR!\u00111KAF\u0011\u001d\tii\u0005a\u0001\u0003'\nA\"Y:tKN\u001cxN\u001d(b[\u0016\f1b]3sm&\u001cWMT1nKR\u0011\u00111K\u0001\u0006gR\f'\u000f\u001e\u000b\u0002c\u0006!1\u000f^8q\u0003%I7OU;o]&tw\rF\u0001jQ\r\u0001\u0011q\u0014\t\u0005\u0003C\u000by+\u0004\u0002\u0002$*!\u0011QUAT\u0003)\u0019H/\u001a:f_RL\b/\u001a\u0006\u0005\u0003S\u000bY+A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\t\ti+A\u0002pe\u001eLA!!-\u0002$\n91+\u001a:wS\u000e,\u0007")
public class RiskService
implements FeatureService,
Logging {
    private final RiskRepository riskRepository;
    private final RiskProfileService riskProfileService;
    private final ReleaseActorService releaseActorService;
    private final ReleaseRepository releaseRepository;
    private final XLReleaseEventBus eventBus;
    private final AsyncRiskExecutor asyncRiskExecutor;
    private volatile boolean enabled;
    private final List<Type> riskAssessorTypes;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RiskService riskService = this;
        synchronized (riskService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private boolean enabled() {
        return this.enabled;
    }

    private void enabled_$eq(boolean x$1) {
        this.enabled = x$1;
    }

    private List<Type> riskAssessorTypes() {
        return this.riskAssessorTypes;
    }

    public Risk calculateRisk(Release release) {
        this.logger().debug((Function0 & Serializable)() -> "Running risk calculations for release " + release.getId());
        Risk risk = this.riskRepository.findByIdOrDefault(this.generateRiskId(release.getId()));
        RiskProfile riskProfileByRelease = (RiskProfile)Option$.MODULE$.apply(release.getProperty("riskProfile")).getOrElse((Function0 & Serializable)() -> $this.riskProfileService.findByIdOrDefault(RiskProfile.DEFAULT_RISK_PROFILE_ID));
        List riskAssessors = this.riskAssessorTypes().filter((Function1 & Serializable)type -> BoxesRunTime.boxToBoolean((boolean)riskProfileByRelease.hasRiskAssessorEnabled(type))).map((Function1 & Serializable)riskAssessorType -> (RiskAssessor)riskAssessorType.getDescriptor().newInstance(this.generateAssessorId(riskAssessorType.getName())));
        List riskAssessments = riskAssessors.map((Function1 & Serializable)riskAssessor -> riskAssessor.execute(release, riskProfileByRelease));
        risk.setRiskAssessments(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)riskAssessments).asJava());
        int score = BoxesRunTime.unboxToInt((Object)riskAssessments.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$2.getScore()))).maxOption((Ordering)Ordering.Int$.MODULE$).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
        int totalScore = BoxesRunTime.unboxToInt((Object)riskAssessments.map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$3.getScore()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        risk.setScore(Predef$.MODULE$.int2Integer(score));
        risk.setTotalScore(Predef$.MODULE$.int2Integer(totalScore));
        this.logger().debug((Function0 & Serializable)() -> "Finished running risk calculations for release " + release.getId() + " with score " + risk.getScore() + " and total score " + risk.getTotalScore());
        return risk;
    }

    public void calculateRiskAndUpdateRelease(String releaseId) {
        if (this.enabled()) {
            this.asyncRiskExecutor.executeAsync((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                Release release = $this.releaseRepository.findById(releaseId);
                this.calculateRiskAndUpdateRelease(release);
            });
            return;
        }
    }

    public void calculateRiskAndUpdateRelease(Release release) {
        if (this.enabled()) {
            this.asyncRiskExecutor.executeAsync((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                if (release.isPlannedOrActive() && !release.isWorkflow()) {
                    Risk risk = this.calculateRisk(release);
                    this.updateRisk(release.getId(), risk);
                    return;
                }
            });
            return;
        }
    }

    private void updateRisk(String releaseId, Risk updated) {
        Some some;
        Risk risk;
        boolean bl;
        Option<Risk> maybeOriginal;
        this.logger().debug((Function0 & Serializable)() -> "UpdateRisk(" + releaseId + ")");
        String riskId = releaseId + "/Risk";
        Option<Risk> option = maybeOriginal = this.riskRepository.read(riskId);
        if (None$.MODULE$.equals(option)) {
            this.riskRepository.create(updated);
            this.logger().info((Function0 & Serializable)() -> "Created risk score for release " + releaseId + ": " + updated.getScore() + " and total risk score " + updated.getTotalScore());
            bl = true;
        } else if (option instanceof Some && (risk = (Risk)(some = (Some)option).value()) != null) {
            Risk risk2;
            Risk original = risk2 = risk;
            this.riskRepository.update(updated);
            if (this.scoreChanged(original, updated)) {
                this.logger().info((Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Updated risk score for release " + releaseId + " from " + original.getScore() + " to " + updated.getScore() + "\n               | and total risk score from " + original.getTotalScore() + " to " + updated.getTotalScore())));
                bl = true;
            } else {
                bl = false;
            }
        } else {
            throw new MatchError(option);
        }
        boolean doUpdate = bl;
        if (doUpdate) {
            this.releaseRepository.setRiskScores(releaseId, Predef$.MODULE$.Integer2int(updated.getScore()), Predef$.MODULE$.Integer2int(updated.getTotalScore()));
            this.releaseActorService.updateReleaseRiskScores(releaseId, updated.getScore(), updated.getTotalScore());
            this.eventBus.publish((XLReleaseEvent)new RiskScoreUpdated(releaseId, maybeOriginal, updated));
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean scoreChanged(Risk a, Risk b) {
        Integer n = a.getScore();
        Integer n2 = b.getScore();
        if (n == null) {
            if (n2 != null) {
                return true;
            }
        } else if (!((Object)n).equals(n2)) return true;
        Integer n3 = a.getTotalScore();
        Integer n4 = b.getTotalScore();
        if (n3 == null) {
            if (n4 == null) return false;
            return true;
        } else if (((Object)n3).equals(n4)) return false;
        return true;
    }

    private String generateRiskId(String releaseId) {
        return releaseId + "/Risk";
    }

    private String generateAssessorId(String assessorName) {
        return Ids.ROOT_FOLDER_ID + "/" + assessorName;
    }

    public String serviceName() {
        return "RiskService";
    }

    public void start() {
        this.enabled_$eq(true);
    }

    public void stop() {
        this.enabled_$eq(false);
    }

    public boolean isRunning() {
        return this.enabled();
    }

    public static final /* synthetic */ boolean $anonfun$riskAssessorTypes$1(Type x$1) {
        return !x$1.getDescriptor().isVirtual();
    }

    public RiskService(RiskRepository riskRepository, RiskProfileService riskProfileService, ReleaseActorService releaseActorService, ReleaseRepository releaseRepository, XLReleaseEventBus eventBus, AsyncRiskExecutor asyncRiskExecutor) {
        this.riskRepository = riskRepository;
        this.riskProfileService = riskProfileService;
        this.releaseActorService = releaseActorService;
        this.releaseRepository = releaseRepository;
        this.eventBus = eventBus;
        this.asyncRiskExecutor = asyncRiskExecutor;
        Logging.$init$((Logging)this);
        this.enabled = true;
        this.riskAssessorTypes = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(DescriptorRegistry.getSubtypes((Type)Type.valueOf(RiskAssessor.class))).asScala().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RiskService.$anonfun$riskAssessorTypes$1(x$1)))).toList();
    }
}

