/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.spring.config;

import com.xebialabs.xlrelease.scheduler.RestartableExecutorService;
import com.xebialabs.xlrelease.scheduler.XlrExecutors;
import com.xebialabs.xlrelease.service.FeatureService;
import io.micrometer.core.instrument.MeterRegistry;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;

@Configuration
@EnableAsync
public class RiskConfiguration
implements FeatureService {
    private static final String RISK_CALCULATION = "risk-calculation";
    private static final String RISK_CALCULATION_BATCH = "risk-calculation-batch";
    public static final String RISK_CALCULATION_EXECUTOR = "riskCalculationExecutor";
    private volatile boolean enabled = true;
    private final MeterRegistry meterRegistry;

    public RiskConfiguration(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    @Bean(name={"riskCalculationExecutor"})
    public RestartableExecutorService riskCalculationExecutor() {
        return XlrExecutors.newFixedThreadPool((String)RISK_CALCULATION, (int)4, (MeterRegistry)this.meterRegistry, (long)60L);
    }

    @Bean
    public RestartableExecutorService riskCalculationBatchExecutor() {
        return XlrExecutors.newFixedThreadPool((String)RISK_CALCULATION_BATCH, (int)2, (MeterRegistry)this.meterRegistry, (long)60L);
    }

    public String serviceName() {
        return "risk execution service";
    }

    public void start() {
        if (!this.enabled) {
            this.riskCalculationExecutor().start();
            this.riskCalculationBatchExecutor().start();
        }
        this.enabled = true;
    }

    public void stop() {
        if (this.enabled) {
            this.riskCalculationExecutor().stop();
            this.riskCalculationBatchExecutor().stop();
        }
        this.enabled = false;
    }

    public boolean isRunning() {
        return this.enabled;
    }
}

