/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.service;

import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.risk.domain.Risk;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.risk.domain.events.RiskScoreUpdated;
import com.xebialabs.xlrelease.risk.domain.riskassessors.RiskAssessor;
import com.xebialabs.xlrelease.risk.repository.RiskRepository;
import com.xebialabs.xlrelease.risk.service.RiskProfileService;
import com.xebialabs.xlrelease.service.FeatureService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@Service
@Scope(proxyMode=ScopedProxyMode.TARGET_CLASS)
@ScalaSignature(bytes="\u0006\u0005\u0005}g\u0001\u0002\f\u0018\u0001\tB\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\"AA\t\u0001B\u0001B\u0003%Q\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003L\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u001d9\u0007\u00011A\u0005\n!Dqa\u001c\u0001A\u0002\u0013%\u0001\u000f\u0003\u0004w\u0001\u0001\u0006K!\u001b\u0005\bw\u0002\u0011\r\u0011\"\u0003}\u0011\u001d\tY\u0003\u0001Q\u0001\nuDq!!\f\u0001\t\u0003\ty\u0003C\u0004\u0002L\u0001!\t!!\u0014\t\u000f\u0005-\u0003\u0001\"\u0001\u0002z!9\u0011q\u0010\u0001\u0005\n\u0005\u0005\u0005bBAE\u0001\u0011%\u00111\u0012\u0005\b\u0003+\u0003A\u0011BAL\u0011\u001d\ty\n\u0001C\u0005\u0003CCq!a*\u0001\t\u0003\nI\u000bC\u0004\u0002,\u0002!\t%!,\t\u000f\u0005=\u0006\u0001\"\u0011\u0002.\"9\u0011\u0011\u0017\u0001\u0005B\u0005M&a\u0003*jg.\u001cVM\u001d<jG\u0016T!\u0001G\r\u0002\u000fM,'O^5dK*\u0011!dG\u0001\u0005e&\u001c8N\u0003\u0002\u001d;\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003=}\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003\u0001\n1aY8n\u0007\u0001\u0019B\u0001A\u0012,aA\u0011A%K\u0007\u0002K)\u0011aeJ\u0001\u0005Y\u0006twMC\u0001)\u0003\u0011Q\u0017M^1\n\u0005)*#AB(cU\u0016\u001cG\u000f\u0005\u0002-]5\tQF\u0003\u0002\u00197%\u0011q&\f\u0002\u000f\r\u0016\fG/\u001e:f'\u0016\u0014h/[2f!\t\td'D\u00013\u0015\t\u0019D'A\u0003tY\u001a$$NC\u00016\u0003!9'/\u001b>{Y\u0016$\u0017BA\u001c3\u0005\u001daunZ4j]\u001e\faB]5tWJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002;{5\t1H\u0003\u0002=3\u0005Q!/\u001a9pg&$xN]=\n\u0005yZ$A\u0004*jg.\u0014V\r]8tSR|'/_\u0001\u0013e&\u001c8\u000e\u0015:pM&dWmU3sm&\u001cW\r\u0005\u0002B\u00056\tq#\u0003\u0002D/\t\u0011\"+[:l!J|g-\u001b7f'\u0016\u0014h/[2f\u0003E\u0011X\r\\3bg\u0016\u0014V\r]8tSR|'/\u001f\t\u0003\r\"k\u0011a\u0012\u0006\u0003ymI!!S$\u0003#I+G.Z1tKJ+\u0007o\\:ji>\u0014\u00180\u0001\u0005fm\u0016tGOQ;t!\tau*D\u0001N\u0015\tq5$\u0001\u0004fm\u0016tGo]\u0005\u0003!6\u0013\u0011\u0003\u0017'SK2,\u0017m]3Fm\u0016tGOQ;t\u0003\u0019a\u0014N\\5u}Q)1\u000bV+W/B\u0011\u0011\t\u0001\u0005\u0006q\u0015\u0001\r!\u000f\u0005\u0006\u007f\u0015\u0001\r\u0001\u0011\u0005\u0006\t\u0016\u0001\r!\u0012\u0005\u0006\u0015\u0016\u0001\ra\u0013\u0015\u0003\u000be\u0003\"AW3\u000e\u0003mS!\u0001X/\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002_?\u00069a-Y2u_JL(B\u00011b\u0003\u0015\u0011W-\u00198t\u0015\t\u00117-A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005!\u0017aA8sO&\u0011am\u0017\u0002\n\u0003V$xn^5sK\u0012\fq!\u001a8bE2,G-F\u0001j!\tQW.D\u0001l\u0015\u0005a\u0017!B:dC2\f\u0017B\u00018l\u0005\u001d\u0011un\u001c7fC:\f1\"\u001a8bE2,Gm\u0018\u0013fcR\u0011\u0011\u000f\u001e\t\u0003UJL!a]6\u0003\tUs\u0017\u000e\u001e\u0005\bk\u001e\t\t\u00111\u0001j\u0003\rAH%M\u0001\tK:\f'\r\\3eA!\u0012\u0001\u0002\u001f\t\u0003UfL!A_6\u0003\u0011Y|G.\u0019;jY\u0016\f\u0011C]5tW\u0006\u001b8/Z:t_J$\u0016\u0010]3t+\u0005i\b#\u0002@\u0002\u000e\u0005MabA@\u0002\n9!\u0011\u0011AA\u0004\u001b\t\t\u0019AC\u0002\u0002\u0006\u0005\na\u0001\u0010:p_Rt\u0014\"\u00017\n\u0007\u0005-1.A\u0004qC\u000e\\\u0017mZ3\n\t\u0005=\u0011\u0011\u0003\u0002\u0005\u0019&\u001cHOC\u0002\u0002\f-\u0004B!!\u0006\u0002(5\u0011\u0011q\u0003\u0006\u0005\u00033\tY\"A\u0004sK\u001adWm\u0019;\u000b\t\u0005u\u0011qD\u0001\u0004CBL'\u0002BA\u0011\u0003G\ta\u0001\u001d7vO&t'bAA\u0013;\u0005AA-\u001a9m_fLG/\u0003\u0003\u0002*\u0005]!\u0001\u0002+za\u0016\f!C]5tW\u0006\u001b8/Z:t_J$\u0016\u0010]3tA\u0005i1-\u00197dk2\fG/\u001a*jg.$B!!\r\u0002>A!\u00111GA\u001d\u001b\t\t)DC\u0002\u00028e\ta\u0001Z8nC&t\u0017\u0002BA\u001e\u0003k\u0011AAU5tW\"9\u0011qH\u0006A\u0002\u0005\u0005\u0013a\u0002:fY\u0016\f7/\u001a\t\u0005\u0003\u0007\n9%\u0004\u0002\u0002F)\u0019\u0011qG\u000e\n\t\u0005%\u0013Q\t\u0002\b%\u0016dW-Y:f\u0003u\u0019\u0017\r\\2vY\u0006$XMU5tW\u0006sG-\u00169eCR,'+\u001a7fCN,GcA9\u0002P!9\u0011\u0011\u000b\u0007A\u0002\u0005M\u0013!\u0003:fY\u0016\f7/Z%e!\u0011\t)&!\u0018\u000f\t\u0005]\u0013\u0011\f\t\u0004\u0003\u0003Y\u0017bAA.W\u00061\u0001K]3eK\u001aLA!a\u0018\u0002b\t11\u000b\u001e:j]\u001eT1!a\u0017lQ\u001da\u0011QMA:\u0003k\u0002B!a\u001a\u0002p5\u0011\u0011\u0011\u000e\u0006\u00049\u0006-$bAA7C\u0006Q1o\u00195fIVd\u0017N\\4\n\t\u0005E\u0014\u0011\u000e\u0002\u0006\u0003NLhnY\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003o\nqC]5tW\u000e\u000bGnY;mCRLwN\\#yK\u000e,Ho\u001c:\u0015\u0007E\fY\bC\u0004\u0002@5\u0001\r!!\u0011)\u000f5\t)'a\u001d\u0002v\u0005QQ\u000f\u001d3bi\u0016\u0014\u0016n]6\u0015\u000bE\f\u0019)!\"\t\u000f\u0005Ec\u00021\u0001\u0002T!9\u0011q\u0011\bA\u0002\u0005E\u0012aB;qI\u0006$X\rZ\u0001\rg\u000e|'/Z\"iC:<W\r\u001a\u000b\u0006S\u00065\u0015\u0011\u0013\u0005\b\u0003\u001f{\u0001\u0019AA\u0019\u0003\u0005\t\u0007bBAJ\u001f\u0001\u0007\u0011\u0011G\u0001\u0002E\u0006qq-\u001a8fe\u0006$XMU5tW&#G\u0003BAM\u0003;\u00032\u0001JAN\u0013\r\ty&\n\u0005\b\u0003#\u0002\u0002\u0019AA*\u0003I9WM\\3sCR,\u0017i]:fgN|'/\u00133\u0015\t\u0005M\u00131\u0015\u0005\b\u0003K\u000b\u0002\u0019AA*\u00031\t7o]3tg>\u0014h*Y7f\u0003\u0011q\u0017-\\3\u0015\u0005\u0005M\u0013AB3oC\ndW\rF\u0001r\u0003\u001d!\u0017n]1cY\u0016\f\u0011\"[:F]\u0006\u0014G.\u001a3\u0015\u0003%D3\u0001AA\\!\u0011\tI,a0\u000e\u0005\u0005m&bAA_C\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005\u0005\u00171\u0018\u0002\b'\u0016\u0014h/[2fQ\u001d\u0001\u0011QYAj\u0003+\u0004B!a2\u0002P6\u0011\u0011\u0011\u001a\u0006\u00049\u0006-'bAAgC\u000691m\u001c8uKb$\u0018\u0002BAi\u0003\u0013\u0014QaU2pa\u0016\f\u0011\u0002\u001d:pqflu\u000eZ3%\u0005\u0005]\u0017\u0002BAm\u00037\fA\u0002V!S\u000f\u0016#vl\u0011'B'NSA!!8\u0002J\u0006y1kY8qK\u0012\u0004&o\u001c=z\u001b>$W\r")
public class RiskService
implements FeatureService,
Logging {
    private final RiskRepository riskRepository;
    private final RiskProfileService riskProfileService;
    private final ReleaseRepository releaseRepository;
    private final XLReleaseEventBus eventBus;
    private volatile boolean enabled;
    private final List<Type> riskAssessorTypes;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @ManagedOperation(description="Stop service")
    public void stop() {
        super.stop();
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RiskService riskService = this;
        synchronized (riskService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private boolean enabled() {
        return this.enabled;
    }

    private void enabled_$eq(boolean x$1) {
        this.enabled = x$1;
    }

    private List<Type> riskAssessorTypes() {
        return this.riskAssessorTypes;
    }

    public Risk calculateRisk(Release release) {
        this.logger().debug((Function0 & Serializable)() -> "Running risk calculations for release " + release.getId());
        Risk risk = this.riskRepository.findByIdOrDefault(this.generateRiskId(release.getId()));
        RiskProfile riskProfileByRelease = (RiskProfile)Option$.MODULE$.apply(release.getProperty("riskProfile")).getOrElse((Function0 & Serializable)() -> $this.riskProfileService.findByIdOrDefault(RiskProfile.DEFAULT_RISK_PROFILE_ID));
        List riskAssessors = this.riskAssessorTypes().filter((Function1 & Serializable)type -> BoxesRunTime.boxToBoolean((boolean)riskProfileByRelease.hasRiskAssessorEnabled(type))).map((Function1 & Serializable)riskAssessorType -> (RiskAssessor)riskAssessorType.getDescriptor().newInstance(this.generateAssessorId(riskAssessorType.getName())));
        List riskAssessments = riskAssessors.map((Function1 & Serializable)riskAssessor -> riskAssessor.execute(release, riskProfileByRelease));
        risk.setRiskAssessments(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)riskAssessments).asJava());
        int score = BoxesRunTime.unboxToInt((Object)riskAssessments.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$2.getScore()))).maxOption((Ordering)Ordering.Int$.MODULE$).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
        int totalScore = BoxesRunTime.unboxToInt((Object)riskAssessments.map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$3.getScore()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        risk.setScore(Predef$.MODULE$.int2Integer(score));
        risk.setTotalScore(Predef$.MODULE$.int2Integer(totalScore));
        this.logger().debug((Function0 & Serializable)() -> "Finished running risk calculations for release " + release.getId() + " with score " + risk.getScore() + " and total score " + risk.getTotalScore());
        return risk;
    }

    @Async(value="riskCalculationExecutor")
    public void calculateRiskAndUpdateRelease(String releaseId) {
        Release release = this.releaseRepository.findById(releaseId);
        this.calculateRiskAndUpdateRelease(release);
    }

    @Async(value="riskCalculationExecutor")
    public void calculateRiskAndUpdateRelease(Release release) {
        if (release.isPlannedOrActive() && !release.isWorkflow()) {
            Risk risk = this.calculateRisk(release);
            if (this.enabled()) {
                this.updateRisk(release.getId(), risk);
                return;
            }
            return;
        }
    }

    private void updateRisk(String releaseId, Risk updated) {
        Some some;
        Risk risk;
        boolean bl;
        Option<Risk> maybeOriginal;
        this.logger().debug((Function0 & Serializable)() -> "UpdateRisk(" + releaseId + ")");
        String riskId = releaseId + "/Risk";
        Option<Risk> option = maybeOriginal = this.riskRepository.read(riskId);
        if (None$.MODULE$.equals(option)) {
            this.riskRepository.create(updated);
            this.logger().info((Function0 & Serializable)() -> "Created risk score for release " + releaseId + ": " + updated.getScore() + " and total risk score " + updated.getTotalScore());
            bl = true;
        } else if (option instanceof Some && (risk = (Risk)(some = (Some)option).value()) != null) {
            Risk risk2;
            Risk original = risk2 = risk;
            this.riskRepository.update(updated);
            if (this.scoreChanged(original, updated)) {
                this.logger().info((Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Updated risk score for release " + releaseId + " from " + original.getScore() + " to " + updated.getScore() + "\n               | and total risk score from " + original.getTotalScore() + " to " + updated.getTotalScore())));
                bl = true;
            } else {
                bl = false;
            }
        } else {
            throw new MatchError(option);
        }
        boolean doUpdate = bl;
        if (doUpdate) {
            this.releaseRepository.setRiskScores(releaseId, Predef$.MODULE$.Integer2int(updated.getScore()), Predef$.MODULE$.Integer2int(updated.getTotalScore()));
            this.eventBus.publish((XLReleaseEvent)new RiskScoreUpdated(releaseId, maybeOriginal, updated));
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean scoreChanged(Risk a, Risk b) {
        Integer n = a.getScore();
        Integer n2 = b.getScore();
        if (n == null) {
            if (n2 != null) {
                return true;
            }
        } else if (!((Object)n).equals(n2)) return true;
        Integer n3 = a.getTotalScore();
        Integer n4 = b.getTotalScore();
        if (n3 == null) {
            if (n4 == null) return false;
            return true;
        } else if (((Object)n3).equals(n4)) return false;
        return true;
    }

    private String generateRiskId(String releaseId) {
        return releaseId + "/Risk";
    }

    private String generateAssessorId(String assessorName) {
        return Ids.ROOT_FOLDER_ID + "/" + assessorName;
    }

    public String name() {
        return "RiskService";
    }

    public void enable() {
        this.enabled_$eq(true);
    }

    public void disable() {
        this.enabled_$eq(false);
    }

    public boolean isEnabled() {
        return this.enabled();
    }

    public static final /* synthetic */ boolean $anonfun$riskAssessorTypes$1(Type x$1) {
        return !x$1.getDescriptor().isVirtual();
    }

    @Autowired
    public RiskService(RiskRepository riskRepository, RiskProfileService riskProfileService, ReleaseRepository releaseRepository, XLReleaseEventBus eventBus) {
        this.riskRepository = riskRepository;
        this.riskProfileService = riskProfileService;
        this.releaseRepository = releaseRepository;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
        this.enabled = true;
        this.riskAssessorTypes = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(DescriptorRegistry.getSubtypes((Type)Type.valueOf(RiskAssessor.class))).asScala().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RiskService.$anonfun$riskAssessorTypes$1(x$1)))).toList();
    }
}

