package com.xebialabs.xlrelease.risk.spring.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;

import com.xebialabs.xlrelease.scheduler.RestartableExecutorService;
import com.xebialabs.xlrelease.scheduler.XlrExecutors;
import com.xebialabs.xlrelease.service.FeatureService;

import io.micrometer.core.instrument.MeterRegistry;

@Configuration
@EnableAsync
public class RiskConfiguration implements FeatureService {
    private static final String RISK_CALCULATION = "risk-calculation";
    private static final String RISK_CALCULATION_BATCH = "risk-calculation-batch";
    public static final String RISK_CALCULATION_EXECUTOR = "riskCalculationExecutor";

    private volatile boolean enabled = true;
    private final MeterRegistry meterRegistry;

    public RiskConfiguration(final MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    @Bean(name = RISK_CALCULATION_EXECUTOR)
    public RestartableExecutorService riskCalculationExecutor() {
        return XlrExecutors.newFixedThreadPool(RISK_CALCULATION, 4, meterRegistry, 60);
    }

    @Bean
    public RestartableExecutorService riskCalculationBatchExecutor() {
        return XlrExecutors.newFixedThreadPool(RISK_CALCULATION_BATCH, 2, meterRegistry, 60);
    }

    @Override
    public String serviceName() {
        return "risk execution service";
    }

    @Override
    public void start() {
        if (!enabled) {
            riskCalculationExecutor().start();
            riskCalculationBatchExecutor().start();
        }
        enabled = true;
    }

    @Override
    public void stop() {
        if (enabled) {
            riskCalculationExecutor().stop();
            riskCalculationBatchExecutor().stop();
        }
        enabled = false;
    }

    @Override
    public boolean isRunning() {
        return enabled;
    }
}
