/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.api.v1.impl;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.api.v1.RiskApi;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.risk.configuration.RiskGlobalThresholds;
import com.xebialabs.xlrelease.risk.domain.Risk;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.risk.domain.riskassessors.RiskAssessor;
import com.xebialabs.xlrelease.risk.repository.RiskRepository;
import com.xebialabs.xlrelease.risk.service.RiskProfileService;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import java.text.MessageFormat;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class RiskApiImpl
implements RiskApi {
    private PermissionChecker permissions;
    private RiskProfileService riskProfileService;
    private ConfigurationRepository configurationRepository;
    private RiskRepository riskRepository;

    @Autowired
    public RiskApiImpl(PermissionChecker permissions, RiskRepository riskRepository, ConfigurationRepository configurationRepository, RiskProfileService riskProfileService) {
        this.permissions = permissions;
        this.configurationRepository = configurationRepository;
        this.riskRepository = riskRepository;
        this.riskProfileService = riskProfileService;
    }

    public Risk getRisk(String riskId) {
        this.permissions.checkView(Ids.releaseIdFrom((String)riskId));
        return this.riskRepository.findByIdOrDefault(riskId);
    }

    public Risk getRisk(Release release) {
        return this.getRisk(release.getId() + "/Risk");
    }

    public RiskGlobalThresholds getRiskGlobalThresholds() {
        return (RiskGlobalThresholds)this.configurationRepository.read("Configuration/risks/RiskGlobalThresholds");
    }

    public RiskGlobalThresholds updateRiskGlobalThresholds(RiskGlobalThresholds thresholds) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.configurationRepository.update((BaseConfiguration)thresholds);
        return (RiskGlobalThresholds)this.configurationRepository.read(thresholds.getId());
    }

    public List<RiskProfile> getRiskProfiles() {
        return this.riskProfileService.findAll();
    }

    public RiskProfile getRiskProfile(String riskProfileId) {
        return this.riskProfileService.findByIdOrDefault(riskProfileId);
    }

    public RiskProfile getRiskProfileByTitle(String title) {
        return this.riskProfileService.findByTitle(title);
    }

    public RiskProfile updateRiskProfile(String riskProfileId, RiskProfile riskProfile) {
        this.permissions.check(XLReleasePermissions.EDIT_RISK_PROFILE);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)riskProfile.getTitle()), (String)"Risk profile title cannot be null or empty", (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)riskProfile.getId()), (String)"Risk profile id cannot be null or empty", (Object[])new Object[0]);
        this.validateValues(riskProfile);
        return this.riskProfileService.update(riskProfile);
    }

    public RiskProfile updateRiskProfile(RiskProfile riskProfile) {
        return this.updateRiskProfile(riskProfile.getId(), riskProfile);
    }

    public RiskProfile createRiskProfile(RiskProfile riskProfile) {
        this.permissions.check(XLReleasePermissions.EDIT_RISK_PROFILE);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)riskProfile.getTitle()), (String)"Risk profile title cannot be null or empty", (Object[])new Object[0]);
        this.validateValues(riskProfile);
        return this.riskProfileService.create(riskProfile);
    }

    public void deleteRiskProfile(String riskProfileId) {
        this.permissions.check(XLReleasePermissions.EDIT_RISK_PROFILE);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)riskProfileId), (String)"Risk profile id cannot be null or empty", (Object[])new Object[0]);
        this.riskProfileService.delete(riskProfileId);
    }

    public void deleteRiskProfile(RiskProfile riskProfile) {
        this.deleteRiskProfile(riskProfile.getId());
    }

    public RiskProfile copyRiskProfile(String riskProfileId) {
        this.permissions.check(XLReleasePermissions.EDIT_RISK_PROFILE);
        return this.riskProfileService.copy(riskProfileId);
    }

    public RiskProfile copyRiskProfile(RiskProfile riskProfile) {
        return this.copyRiskProfile(riskProfile.getId());
    }

    public List<RiskAssessor> getAllRiskAssessors() {
        return DescriptorRegistry.getSubtypes((Type)Type.valueOf(RiskAssessor.class)).stream().filter(type -> !type.getDescriptor().isVirtual()).map(type -> (RiskAssessor)type.getDescriptor().newInstance(this.generateAssessorId(type.getName()))).collect(Collectors.toList());
    }

    private String generateAssessorId(String name) {
        return MessageFormat.format("{0}/{1}", Ids.ROOT_FOLDER_ID, name);
    }

    private void validateValues(RiskProfile riskProfile) {
        riskProfile.getRiskProfileAssessors().forEach((profile, score) -> Checks.checkArgument((score.chars().allMatch(Character::isDigit) && Integer.parseInt(score) >= 0 && Integer.parseInt(score) <= 100 ? 1 : 0) != 0, (String)String.format("Incorrect value %s for risk assessor %s. Value must be an integer between 0 and 100", score, profile), (Object[])new Object[0]));
    }
}

