/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseExtension;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseExtensionsRepository;
import com.xebialabs.xlrelease.service.ReleaseService;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import java.util.List;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005A4QAC\u0006\u0002\u0002QA\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!\b\u0005\tG\u0001\u0011\t\u0011)A\u0005I!)\u0001\u0006\u0001C\u0001S!)1\b\u0001C\u0001y!)1\b\u0001C\u00019\")q\f\u0001C\u0001A\")1\r\u0001C\u0001I\")!\u000e\u0001C\u0005W\")Q\u000e\u0001D\u0001]\n\t#+\u001a7fCN,W\t\u001f;f]NLwN\\:IK2\u0004XM\u001d*fa>\u001c\u0018\u000e^8ss*\u0011A\"D\u0001\u000be\u0016\u0004xn]5u_JL(B\u0001\b\u0010\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u0011#\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002%\u0005\u00191m\\7\u0004\u0001U\u0011Q#L\n\u0003\u0001Y\u0001\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011a!\u00118z%\u00164\u0017A\u0004:fY\u0016\f7/Z*feZL7-\u001a\t\u0003=\u0005j\u0011a\b\u0006\u0003A5\tqa]3sm&\u001cW-\u0003\u0002#?\tq!+\u001a7fCN,7+\u001a:wS\u000e,\u0017a\u0007:fY\u0016\f7/Z#yi\u0016t7/[8ogJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002&M5\t1\"\u0003\u0002(\u0017\tY\"+\u001a7fCN,W\t\u001f;f]NLwN\\:SKB|7/\u001b;pef\fa\u0001P5oSRtDc\u0001\u0016:uA\u0019Q\u0005A\u0016\u0011\u00051jC\u0002\u0001\u0003\u0006]\u0001\u0011\ra\f\u0002\u0002)F\u0011\u0001g\r\t\u0003/EJ!A\r\r\u0003\u000f9{G\u000f[5oOB\u0011AgN\u0007\u0002k)\u0011a'D\u0001\u0007I>l\u0017-\u001b8\n\u0005a*$\u0001\u0005*fY\u0016\f7/Z#yi\u0016t7/[8o\u0011\u0015a2\u00011\u0001\u001e\u0011\u0015\u00193\u00011\u0001%\u0003E1\u0017N\u001c3Cs&#wJ\u001d#fM\u0006,H\u000e\u001e\u000b\u0004Wu\u0012\u0005\"\u0002 \u0005\u0001\u0004y\u0014a\u0002:fY\u0016\f7/\u001a\t\u0003i\u0001K!!Q\u001b\u0003\u000fI+G.Z1tK\")1\t\u0002a\u0001\t\u0006\u0011\"/\u001a7fCN,W\t\u001f;f]NLwN\\%e!\t)EJ\u0004\u0002G\u0015B\u0011q\tG\u0007\u0002\u0011*\u0011\u0011jE\u0001\u0007yI|w\u000e\u001e \n\u0005-C\u0012A\u0002)sK\u0012,g-\u0003\u0002N\u001d\n11\u000b\u001e:j]\u001eT!a\u0013\r)\u0005\u0011\u0001\u0006CA)[\u001b\u0005\u0011&BA*U\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003+Z\u000bAaY8sK*\u0011q\u000bW\u0001\u000b[&\u001c'o\\7fi\u0016\u0014(\"A-\u0002\u0005%|\u0017BA.S\u0005\u0015!\u0016.\\3e)\tYS\fC\u0003D\u000b\u0001\u0007A\t\u000b\u0002\u0006!\u0006Aa-\u001b8e\u0005fLE\r\u0006\u0002,C\")1I\u0002a\u0001\t\"\u0012a\u0001U\u0001\u0014O\u0016$(+\u001a7fCN,W\t\u001f;f]NLwN\u001c\u000b\u0003K\"\u00042a\u00064,\u0013\t9\u0007D\u0001\u0004PaRLwN\u001c\u0005\u0006\u0007\u001e\u0001\r\u0001\u0012\u0015\u0003\u000fA\u000bqdZ3u\u000bb$XM\\:j_:4%o\\7Be\u000eD\u0017N^3e%\u0016dW-Y:f)\t)G\u000eC\u0003D\u0011\u0001\u0007A)A\u000fde\u0016\fG/\u001a#fM\u0006,H\u000e\u001e*fY\u0016\f7/Z#yi\u0016t7/[8o)\tYs\u000eC\u0003D\u0013\u0001\u0007A\t")
public abstract class ReleaseExtensionsHelperRepository<T extends ReleaseExtension> {
    private final ReleaseService releaseService;
    private final ReleaseExtensionsRepository releaseExtensionsRepository;

    @Timed
    public T findByIdOrDefault(Release release, String releaseExtensionId) {
        return (T)((ReleaseExtension)CollectionConverters$.MODULE$.ListHasAsScala(release.getExtensions()).asScala().find((Function1 & Serializable)extension -> BoxesRunTime.boxToBoolean((boolean)ReleaseExtensionsHelperRepository.$anonfun$findByIdOrDefault$1(releaseExtensionId, extension))).map((Function1 & Serializable)x$1 -> x$1).getOrElse((Function0 & Serializable)() -> this.createDefaultReleaseExtension(releaseExtensionId)));
    }

    @Timed
    public T findByIdOrDefault(String releaseExtensionId) {
        Option<T> extensionOption = this.getReleaseExtension(releaseExtensionId);
        ReleaseExtension result = (ReleaseExtension)extensionOption.getOrElse((Function0 & Serializable)() -> this.createDefaultReleaseExtension(releaseExtensionId));
        return (T)result;
    }

    @Timed
    public T findById(String releaseExtensionId) {
        Option<T> extensionOption = this.getReleaseExtension(releaseExtensionId);
        ReleaseExtension result = (ReleaseExtension)extensionOption.getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("ReleaseExtension [%s] does not exist in the repository or archive", new Object[]{releaseExtensionId});
        });
        return (T)result;
    }

    @Timed
    public Option<T> getReleaseExtension(String releaseExtensionId) {
        String releaseId = Ids.releaseIdFrom((String)releaseExtensionId);
        Option<T> extensionOption = this.releaseService.exists(releaseId) ? this.releaseExtensionsRepository.read(releaseExtensionId) : (this.releaseService.isArchived(releaseId) ? this.getExtensionFromArchivedRelease(releaseExtensionId) : None$.MODULE$);
        return extensionOption;
    }

    private Option<T> getExtensionFromArchivedRelease(String releaseExtensionId) {
        Release release = this.releaseService.findByIdInArchive(Ids.releaseIdFrom((String)releaseExtensionId));
        return CollectionConverters$.MODULE$.ListHasAsScala((List)release.getProperty("extensions")).asScala().find((Function1 & Serializable)extension -> BoxesRunTime.boxToBoolean((boolean)ReleaseExtensionsHelperRepository.$anonfun$getExtensionFromArchivedRelease$1(releaseExtensionId, extension)));
    }

    public abstract T createDefaultReleaseExtension(String var1);

    public static final /* synthetic */ boolean $anonfun$findByIdOrDefault$1(String releaseExtensionId$1, ReleaseExtension extension) {
        String string = Ids.getName((String)extension.getId());
        String string2 = Ids.getName((String)releaseExtensionId$1);
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getExtensionFromArchivedRelease$1(String releaseExtensionId$4, ReleaseExtension extension) {
        String string = Ids.getName((String)extension.getId());
        String string2 = Ids.getName((String)releaseExtensionId$4);
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public ReleaseExtensionsHelperRepository(ReleaseService releaseService, ReleaseExtensionsRepository releaseExtensionsRepository) {
        this.releaseService = releaseService;
        this.releaseExtensionsRepository = releaseExtensionsRepository;
    }
}

