/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.service;

import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.events.ReleaseCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseOverdueEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseResumedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.TaskAbortedEvent;
import com.xebialabs.xlrelease.domain.events.TaskCompletedEvent;
import com.xebialabs.xlrelease.domain.events.TaskDeletedEvent;
import com.xebialabs.xlrelease.domain.events.TaskFailedEvent;
import com.xebialabs.xlrelease.domain.events.TaskOverdueEvent;
import com.xebialabs.xlrelease.domain.events.TaskRetriedEvent;
import com.xebialabs.xlrelease.domain.events.TaskSkippedEvent;
import com.xebialabs.xlrelease.domain.events.TaskUpdatedEvent;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.events.SynchronizedSubscribe;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.risk.domain.events.RiskProfileUpdated;
import com.xebialabs.xlrelease.risk.service.RiskService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.concurrent.Executor;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.reflect.ScalaSignature;

@Service
@EventListener
@ScalaSignature(bytes="\u0006\u0005\u0005Mh\u0001B\u000b\u0017\u0001\u0005B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\to\u0001\u0011\t\u0011)A\u0005q!Aa\b\u0001B\u0001B\u0003%q\b\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003E\u0011\u0015q\u0005\u0001\"\u0001P\u0011\u0015!\u0007\u0001\"\u0001f\u0011\u0015I\b\u0001\"\u0001{\u0011\u001d\t\u0019\u0001\u0001C\u0001\u0003\u000bAq!a\u0005\u0001\t\u0003\t)\u0002C\u0004\u0002$\u0001!\t!!\n\t\u000f\u0005M\u0002\u0001\"\u0001\u00026!9\u0011\u0011\t\u0001\u0005\u0002\u0005\r\u0003bBA)\u0001\u0011\u0005\u00111\u000b\u0005\b\u0003C\u0002A\u0011AA2\u0011\u001d\t\t\b\u0001C\u0001\u0003gBq!!!\u0001\t\u0003\t\u0019\tC\u0004\u0002\u0012\u0002!\t!a%\t\u000f\u0005\u0005\u0006\u0001\"\u0003\u0002$\"9\u0011\u0011\u0017\u0001\u0005\u0002\u0005M\u0006bBAg\u0001\u0011%\u0011q\u001a\u0002\u0011%&\u001c8.\u0012<f]RD\u0015M\u001c3mKJT!a\u0006\r\u0002\u000fM,'O^5dK*\u0011\u0011DG\u0001\u0005e&\u001c8N\u0003\u0002\u001c9\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003;y\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003}\t1aY8n\u0007\u0001\u00192\u0001\u0001\u0012)!\t\u0019c%D\u0001%\u0015\u0005)\u0013!B:dC2\f\u0017BA\u0014%\u0005\u0019\te.\u001f*fMB\u0011\u0011FL\u0007\u0002U)\u00111\u0006L\u0001\u0006g24GG\u001b\u0006\u0002[\u0005AqM]5{u2,G-\u0003\u00020U\t9Aj\\4hS:<\u0017!\u0003=me\u000e{gNZ5h!\t\u0011T'D\u00014\u0015\t!$$\u0001\u0004d_:4\u0017nZ\u0005\u0003mM\u0012\u0011\u0002\u00177s\u0007>tg-[4\u0002/\r|gNZ5hkJ\fG/[8o%\u0016\u0004xn]5u_JL\bCA\u001d=\u001b\u0005Q$BA\u001e\u001b\u0003)\u0011X\r]8tSR|'/_\u0005\u0003{i\u0012qcQ8oM&<WO]1uS>t'+\u001a9pg&$xN]=\u0002\u0017IL7o[*feZL7-\u001a\t\u0003\u0001\u0006k\u0011AF\u0005\u0003\u0005Z\u00111BU5tWN+'O^5dK\u0006a\"/[:l\u0007\u0006d7-\u001e7bi&|gNQ1uG\",\u00050Z2vi>\u0014\bCA#M\u001b\u00051%BA$I\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003\u0013*\u000bA!\u001e;jY*\t1*\u0001\u0003kCZ\f\u0017BA'G\u0005!)\u00050Z2vi>\u0014\u0018A\u0002\u001fj]&$h\bF\u0003Q#J\u001bF\u000b\u0005\u0002A\u0001!)\u0001'\u0002a\u0001c!)q'\u0002a\u0001q!)a(\u0002a\u0001\u007f!)1)\u0002a\u0001\t\"\u0012QA\u0016\t\u0003/\nl\u0011\u0001\u0017\u0006\u00033j\u000b!\"\u00198o_R\fG/[8o\u0015\tYF,A\u0004gC\u000e$xN]=\u000b\u0005us\u0016!\u00022fC:\u001c(BA0a\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A1\u0002\u0007=\u0014x-\u0003\u0002d1\nI\u0011)\u001e;po&\u0014X\rZ\u0001\u000fe\u0016dW-Y:f\u0007J,\u0017\r^3e)\t1\u0017\u000e\u0005\u0002$O&\u0011\u0001\u000e\n\u0002\u0005+:LG\u000fC\u0003k\r\u0001\u00071.A\nsK2,\u0017m]3De\u0016\fG/\u001a3Fm\u0016tG\u000f\u0005\u0002mc6\tQN\u0003\u0002o_\u00061QM^3oiNT!\u0001\u001d\u000e\u0002\r\u0011|W.Y5o\u0013\t\u0011XNA\nSK2,\u0017m]3De\u0016\fG/\u001a3Fm\u0016tG\u000f\u000b\u0002\u0007iB\u0011Qo^\u0007\u0002m*\u0011aNG\u0005\u0003qZ\u0014\u0011bU;cg\u000e\u0014\u0018NY3\u0002\u001dI,G.Z1tKV\u0003H-\u0019;fIR\u0011am\u001f\u0005\u0006y\u001e\u0001\r!`\u0001\u0014e\u0016dW-Y:f+B$\u0017\r^3e\u000bZ,g\u000e\u001e\t\u0003YzL!a`7\u0003'I+G.Z1tKV\u0003H-\u0019;fI\u00163XM\u001c;)\u0005\u001d!\u0018A\u0004:fY\u0016\f7/Z(wKJ$W/\u001a\u000b\u0004M\u0006\u001d\u0001bBA\u0005\u0011\u0001\u0007\u00111B\u0001\u0014e\u0016dW-Y:f\u001fZ,'\u000fZ;f\u000bZ,g\u000e\u001e\t\u0004Y\u00065\u0011bAA\b[\n\u0019\"+\u001a7fCN,wJ^3sIV,WI^3oi\"\u0012\u0001\u0002^\u0001\u000bi\u0006\u001c8NR1jY\u0016$Gc\u00014\u0002\u0018!9\u0011\u0011D\u0005A\u0002\u0005m\u0011a\u0004;bg.4\u0015-\u001b7fI\u00163XM\u001c;\u0011\u00071\fi\"C\u0002\u0002 5\u0014q\u0002V1tW\u001a\u000b\u0017\u000e\\3e\u000bZ,g\u000e\u001e\u0015\u0003\u0013Q\f1\u0002^1tWJ+GO]5fIR\u0019a-a\n\t\u000f\u0005%\"\u00021\u0001\u0002,\u0005\u0001B/Y:l%\u0016$(/[3e\u000bZ,g\u000e\u001e\t\u0004Y\u00065\u0012bAA\u0018[\n\u0001B+Y:l%\u0016$(/[3e\u000bZ,g\u000e\u001e\u0015\u0003\u0015Q\f1C]3mK\u0006\u001cXMU3tk6,G-\u0012<f]R$2AZA\u001c\u0011\u001d\t\u0019d\u0003a\u0001\u0003s\u00012\u0001\\A\u001e\u0013\r\ti$\u001c\u0002\u0014%\u0016dW-Y:f%\u0016\u001cX/\\3e\u000bZ,g\u000e\u001e\u0015\u0003\u0017Q\fQ\u0002^1tW\u000e{W\u000e\u001d7fi\u0016$Gc\u00014\u0002F!9\u0011q\t\u0007A\u0002\u0005%\u0013A\u0005;bg.\u001cu.\u001c9mKR,G-\u0012<f]R\u00042\u0001\\A&\u0013\r\ti%\u001c\u0002\u0013)\u0006\u001c8nQ8na2,G/\u001a3Fm\u0016tG\u000f\u000b\u0002\ri\u0006YA/Y:l'.L\u0007\u000f]3e)\r1\u0017Q\u000b\u0005\b\u0003/j\u0001\u0019AA-\u0003A!\u0018m]6TW&\u0004\b/\u001a3Fm\u0016tG\u000fE\u0002m\u00037J1!!\u0018n\u0005A!\u0016m]6TW&\u0004\b/\u001a3Fm\u0016tG\u000f\u000b\u0002\u000ei\u0006YA/Y:l\u0003\n|'\u000f^3e)\r1\u0017Q\r\u0005\b\u0003Or\u0001\u0019AA5\u0003A!\u0018m]6BE>\u0014H/\u001a3Fm\u0016tG\u000fE\u0002m\u0003WJ1!!\u001cn\u0005A!\u0016m]6BE>\u0014H/\u001a3Fm\u0016tG\u000f\u000b\u0002\u000fi\u0006YA/Y:l+B$\u0017\r^3e)\r1\u0017Q\u000f\u0005\b\u0003oz\u0001\u0019AA=\u0003A!\u0018m]6Va\u0012\fG/\u001a3Fm\u0016tG\u000fE\u0002m\u0003wJ1!! n\u0005A!\u0016m]6Va\u0012\fG/\u001a3Fm\u0016tG\u000f\u000b\u0002\u0010i\u0006YA/Y:l\u001fZ,'\u000fZ;f)\r1\u0017Q\u0011\u0005\b\u0003\u000f\u0003\u0002\u0019AAE\u0003A!\u0018m]6Pm\u0016\u0014H-^3Fm\u0016tG\u000fE\u0002m\u0003\u0017K1!!$n\u0005A!\u0016m]6Pm\u0016\u0014H-^3Fm\u0016tG\u000f\u000b\u0002\u0011i\u0006YA/Y:l\t\u0016dW\r^3e)\r1\u0017Q\u0013\u0005\b\u0003/\u000b\u0002\u0019AAM\u0003A!\u0018m]6EK2,G/\u001a3Fm\u0016tG\u000fE\u0002m\u00037K1!!(n\u0005A!\u0016m]6EK2,G/\u001a3Fm\u0016tG\u000f\u000b\u0002\u0012i\u0006i1-\u00197dk2\fG/\u001a*jg.$2AZAS\u0011\u001d\t9K\u0005a\u0001\u0003S\u000bqA]3mK\u0006\u001cX\r\u0005\u0003\u0002,\u00065V\"A8\n\u0007\u0005=vNA\u0004SK2,\u0017m]3\u0002/!\fg\u000e\u001a7f%&\u001c8\u000e\u0015:pM&dW-\u00169eCR,Gc\u00014\u00026\"9\u0011qW\nA\u0002\u0005e\u0016!B3wK:$\b\u0003BA^\u0003\u0003l!!!0\u000b\u00079\fyL\u0003\u0002q1%!\u00111YA_\u0005I\u0011\u0016n]6Qe>4\u0017\u000e\\3Va\u0012\fG/\u001a3)\u0007M\t9\rE\u0002v\u0003\u0013L1!a3w\u0005U\u0019\u0016P\\2ie>t\u0017N_3e'V\u00147o\u0019:jE\u0016\fQD];o\u0007\u0006d7-\u001e7bi&|gn\u001d$peJK7o\u001b)s_\u001aLG.\u001a\u000b\u0004M\u0006E\u0007bBAj)\u0001\u0007\u0011Q[\u0001\fe&\u001c8\u000e\u0015:pM&dW\r\u0005\u0003\u0002X\u0006eWBAA`\u0013\u0011\tY.a0\u0003\u0017IK7o\u001b)s_\u001aLG.\u001a\u0015\u0004\u0001\u0005}\u0007\u0003BAq\u0003Ol!!a9\u000b\u0007\u0005\u0015h,\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!!;\u0002d\n91+\u001a:wS\u000e,\u0007f\u0001\u0001\u0002nB\u0019Q/a<\n\u0007\u0005EhOA\u0007Fm\u0016tG\u000fT5ti\u0016tWM\u001d")
public class RiskEventHandler
implements Logging {
    private final XlrConfig xlrConfig;
    private final ConfigurationRepository configurationRepository;
    private final RiskService riskService;
    private final Executor riskCalculationBatchExecutor;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RiskEventHandler riskEventHandler = this;
        synchronized (riskEventHandler) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Subscribe
    public void releaseCreated(ReleaseCreatedEvent releaseCreatedEvent) {
        this.calculateRisk(releaseCreatedEvent.release());
    }

    @Subscribe
    public void releaseUpdated(ReleaseUpdatedEvent releaseUpdatedEvent) {
        this.calculateRisk(releaseUpdatedEvent.updated());
    }

    @Subscribe
    public void releaseOverdue(ReleaseOverdueEvent releaseOverdueEvent) {
        this.calculateRisk(releaseOverdueEvent.release());
    }

    @Subscribe
    public void taskFailed(TaskFailedEvent taskFailedEvent) {
        this.calculateRisk(taskFailedEvent.task().getRelease());
    }

    @Subscribe
    public void taskRetried(TaskRetriedEvent taskRetriedEvent) {
        this.calculateRisk(taskRetriedEvent.task().getRelease());
    }

    @Subscribe
    public void releaseResumedEvent(ReleaseResumedEvent releaseResumedEvent) {
        this.calculateRisk(releaseResumedEvent.release());
    }

    @Subscribe
    public void taskCompleted(TaskCompletedEvent taskCompletedEvent) {
        this.calculateRisk(taskCompletedEvent.task().getRelease());
    }

    @Subscribe
    public void taskSkipped(TaskSkippedEvent taskSkippedEvent) {
        this.calculateRisk(taskSkippedEvent.task().getRelease());
    }

    @Subscribe
    public void taskAborted(TaskAbortedEvent taskAbortedEvent) {
        this.calculateRisk(taskAbortedEvent.task().getRelease());
    }

    @Subscribe
    public void taskUpdated(TaskUpdatedEvent taskUpdatedEvent) {
        this.calculateRisk(taskUpdatedEvent.updated().getRelease());
    }

    @Subscribe
    public void taskOverdue(TaskOverdueEvent taskOverdueEvent) {
        this.calculateRisk(taskOverdueEvent.task().getRelease());
    }

    @Subscribe
    public void taskDeleted(TaskDeletedEvent taskDeletedEvent) {
        this.calculateRisk(taskDeletedEvent.task().getRelease());
    }

    private void calculateRisk(Release release) {
        if (this.xlrConfig.isRiskCalculationEnabled() && this.riskService.isEnabled()) {
            this.riskService.calculateRiskAndUpdateRelease(release);
            return;
        }
    }

    @SynchronizedSubscribe
    public void handleRiskProfileUpdate(RiskProfileUpdated event) {
        if (this.xlrConfig.isRiskCalculationEnabled()) {
            RiskProfile riskProfile = event.riskProfile();
            this.riskCalculationBatchExecutor.execute(() -> this.runCalculationsForRiskProfile(riskProfile));
            return;
        }
    }

    private void runCalculationsForRiskProfile(RiskProfile riskProfile) {
        this.logger().debug((Function0 & Serializable)() -> "Running risk calculations after Risk profile " + riskProfile.getId() + " update");
        this.configurationRepository.getReferenceReleases(riskProfile.getId()).forEach(data -> $this.riskService.calculateRiskAndUpdateRelease(data.id()));
        this.logger().debug((Function0 & Serializable)() -> "Finished running risk calculations after Risk profile " + riskProfile.getId() + " update");
    }

    @Autowired
    public RiskEventHandler(XlrConfig xlrConfig, ConfigurationRepository configurationRepository, RiskService riskService, Executor riskCalculationBatchExecutor) {
        this.xlrConfig = xlrConfig;
        this.configurationRepository = configurationRepository;
        this.riskService = riskService;
        this.riskCalculationBatchExecutor = riskCalculationBatchExecutor;
        Logging.$init$((Logging)this);
    }
}

