package com.xebialabs.xlrelease.risk.spring.config;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;

import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.metrics.MetricsConfiguration;
import com.xebialabs.xlrelease.utils.PrefixedThreadFactory;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;

@Configuration
@EnableAsync
public class RiskConfiguration {

    public static final String RISK_CALCULATION_EXECUTOR = "riskCalculationExecutor";

    @Bean(name = RISK_CALCULATION_EXECUTOR)
    public RestartableExecutorService riskCalculationExecutor(XlrConfig xlrConfig, MeterRegistry meterRegistry) {
        return new RestartableExecutorService("risk-calculation", () -> {
            ExecutorService executor = Executors.newFixedThreadPool(4, new PrefixedThreadFactory("risk-calculation", true));
            if (xlrConfig.metrics().enabled()) {
                return ExecutorServiceMetrics.monitor(meterRegistry, executor, "risk-calculation", MetricsConfiguration.TAG_EXECUTOR());
            }
            return executor;
        });
    }

    @Bean
    public Executor riskCalculationBatchExecutor(XlrConfig xlrConfig, MeterRegistry meterRegistry) {
        ExecutorService executor = Executors.newFixedThreadPool(2, new PrefixedThreadFactory("risk-calculation-batch", true));
        if (xlrConfig.metrics().enabled()) {
            ExecutorServiceMetrics.monitor(meterRegistry, executor, "risk-calculation-batch", MetricsConfiguration.TAG_EXECUTOR());
        }
        return executor;
    }
}
