/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.service;

import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.risk.domain.Risk;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.risk.domain.events.RiskScoreUpdated;
import com.xebialabs.xlrelease.risk.domain.riskassessors.RiskAssessor;
import com.xebialabs.xlrelease.risk.repository.RiskRepository;
import com.xebialabs.xlrelease.risk.service.RiskProfileService;
import com.xebialabs.xlrelease.service.FeatureService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@Service
@Scope(proxyMode=ScopedProxyMode.TARGET_CLASS)
@ScalaSignature(bytes="\u0006\u0005\u0005Eh\u0001B\f\u0019\u0001\rB\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\"AQ\t\u0001B\u0001B\u0003%a\t\u0003\u0005M\u0001\t\u0005\t\u0015!\u0003N\u0011!\u0011\u0006A!A!\u0002\u0013\u0019\u0006\"B-\u0001\t\u0003Q\u0006b\u00029\u0001\u0001\u0004%I!\u001d\u0005\bq\u0002\u0001\r\u0011\"\u0003z\u0011\u0019y\b\u0001)Q\u0005e\"I\u0011\u0011\u0002\u0001C\u0002\u0013%\u00111\u0002\u0005\t\u0003{\u0001\u0001\u0015!\u0003\u0002\u000e!9\u0011q\b\u0001\u0005\u0002\u0005\u0005\u0003bBA/\u0001\u0011\u0005\u0011q\f\u0005\b\u0003;\u0002A\u0011AAF\u0011\u001d\t\t\n\u0001C\u0005\u0003'Cq!a'\u0001\t\u0013\ti\nC\u0004\u0002(\u0002!I!!+\t\u000f\u0005E\u0006\u0001\"\u0003\u00024\"9\u0011\u0011\u0018\u0001\u0005B\u0005m\u0006bBA_\u0001\u0011\u0005\u0013q\u0018\u0005\b\u0003\u0003\u0004A\u0011IA`\u0011\u001d\t\u0019\r\u0001C!\u0003\u000b\u00141BU5tWN+'O^5dK*\u0011\u0011DG\u0001\bg\u0016\u0014h/[2f\u0015\tYB$\u0001\u0003sSN\\'BA\u000f\u001f\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002 A\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002C\u0005\u00191m\\7\u0004\u0001M!\u0001\u0001\n\u00172!\t)#&D\u0001'\u0015\t9\u0003&\u0001\u0003mC:<'\"A\u0015\u0002\t)\fg/Y\u0005\u0003W\u0019\u0012aa\u00142kK\u000e$\bCA\u00170\u001b\u0005q#BA\r\u001d\u0013\t\u0001dF\u0001\bGK\u0006$XO]3TKJ4\u0018nY3\u0011\u0005I:T\"A\u001a\u000b\u0005Q*\u0014!B:mMRR'\"\u0001\u001c\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!\u0001O\u001a\u0003\u000f1{wmZ5oO\u0006q!/[:l%\u0016\u0004xn]5u_JL\bCA\u001e?\u001b\u0005a$BA\u001f\u001b\u0003)\u0011X\r]8tSR|'/_\u0005\u0003\u007fq\u0012aBU5tWJ+\u0007o\\:ji>\u0014\u00180\u0001\nsSN\\\u0007K]8gS2,7+\u001a:wS\u000e,\u0007C\u0001\"D\u001b\u0005A\u0012B\u0001#\u0019\u0005I\u0011\u0016n]6Qe>4\u0017\u000e\\3TKJ4\u0018nY3\u0002'I,G.Z1tK\u0006\u001bGo\u001c:TKJ4\u0018nY3\u0011\u0005\u001dSU\"\u0001%\u000b\u0005%c\u0012AB1di>\u00148/\u0003\u0002L\u0011\n\u0019\"+\u001a7fCN,\u0017i\u0019;peN+'O^5dK\u0006\t\"/\u001a7fCN,'+\u001a9pg&$xN]=\u0011\u00059\u0003V\"A(\u000b\u0005ub\u0012BA)P\u0005E\u0011V\r\\3bg\u0016\u0014V\r]8tSR|'/_\u0001\tKZ,g\u000e\u001e\"vgB\u0011AkV\u0007\u0002+*\u0011a\u000bH\u0001\u0007KZ,g\u000e^:\n\u0005a+&!\u0005-M%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vg\u00061A(\u001b8jiz\"ba\u0017/^=~\u0003\u0007C\u0001\"\u0001\u0011\u0015Id\u00011\u0001;\u0011\u0015\u0001e\u00011\u0001B\u0011\u0015)e\u00011\u0001G\u0011\u0015ae\u00011\u0001N\u0011\u0015\u0011f\u00011\u0001TQ\t1!\r\u0005\u0002d]6\tAM\u0003\u0002fM\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005\u001dD\u0017a\u00024bGR|'/\u001f\u0006\u0003S*\fQAY3b]NT!a\u001b7\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011!\\\u0001\u0004_J<\u0017BA8e\u0005%\tU\u000f^8xSJ,G-A\u0004f]\u0006\u0014G.\u001a3\u0016\u0003I\u0004\"a\u001d<\u000e\u0003QT\u0011!^\u0001\u0006g\u000e\fG.Y\u0005\u0003oR\u0014qAQ8pY\u0016\fg.A\u0006f]\u0006\u0014G.\u001a3`I\u0015\fHC\u0001>~!\t\u001980\u0003\u0002}i\n!QK\\5u\u0011\u001dq\b\"!AA\u0002I\f1\u0001\u001f\u00132\u0003!)g.\u00192mK\u0012\u0004\u0003fA\u0005\u0002\u0004A\u00191/!\u0002\n\u0007\u0005\u001dAO\u0001\u0005w_2\fG/\u001b7f\u0003E\u0011\u0018n]6BgN,7o]8s)f\u0004Xm]\u000b\u0003\u0003\u001b\u0001b!a\u0004\u0002 \u0005\u0015b\u0002BA\t\u00037qA!a\u0005\u0002\u001a5\u0011\u0011Q\u0003\u0006\u0004\u0003/\u0011\u0013A\u0002\u001fs_>$h(C\u0001v\u0013\r\ti\u0002^\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t#a\t\u0003\t1K7\u000f\u001e\u0006\u0004\u0003;!\b\u0003BA\u0014\u0003si!!!\u000b\u000b\t\u0005-\u0012QF\u0001\be\u00164G.Z2u\u0015\u0011\ty#!\r\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u00024\u0005U\u0012A\u00029mk\u001eLgNC\u0002\u00028y\t\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0005\u0003w\tIC\u0001\u0003UsB,\u0017A\u0005:jg.\f5o]3tg>\u0014H+\u001f9fg\u0002\nQbY1mGVd\u0017\r^3SSN\\G\u0003BA\"\u0003\u001f\u0002B!!\u0012\u0002L5\u0011\u0011q\t\u0006\u0004\u0003\u0013R\u0012A\u00023p[\u0006Lg.\u0003\u0003\u0002N\u0005\u001d#\u0001\u0002*jg.Dq!!\u0015\r\u0001\u0004\t\u0019&A\u0004sK2,\u0017m]3\u0011\t\u0005U\u0013\u0011L\u0007\u0003\u0003/R1!!\u0013\u001d\u0013\u0011\tY&a\u0016\u0003\u000fI+G.Z1tK\u0006i2-\u00197dk2\fG/\u001a*jg.\fe\u000eZ+qI\u0006$XMU3mK\u0006\u001cX\rF\u0002{\u0003CBq!a\u0019\u000e\u0001\u0004\t)'A\u0005sK2,\u0017m]3JIB!\u0011qMA8\u001d\u0011\tI'a\u001b\u0011\u0007\u0005MA/C\u0002\u0002nQ\fa\u0001\u0015:fI\u00164\u0017\u0002BA9\u0003g\u0012aa\u0015;sS:<'bAA7i\":Q\"a\u001e\u0002\u0006\u0006\u001d\u0005\u0003BA=\u0003\u0003k!!a\u001f\u000b\u0007\u0015\fiHC\u0002\u0002\u0000)\f!b]2iK\u0012,H.\u001b8h\u0013\u0011\t\u0019)a\u001f\u0003\u000b\u0005\u001b\u0018P\\2\u0002\u000bY\fG.^3\"\u0005\u0005%\u0015a\u0006:jg.\u001c\u0015\r\\2vY\u0006$\u0018n\u001c8Fq\u0016\u001cW\u000f^8s)\rQ\u0018Q\u0012\u0005\b\u0003#r\u0001\u0019AA*Q\u001dq\u0011qOAC\u0003\u000f\u000b!\"\u001e9eCR,'+[:l)\u0015Q\u0018QSAL\u0011\u001d\t\u0019g\u0004a\u0001\u0003KBq!!'\u0010\u0001\u0004\t\u0019%A\u0004va\u0012\fG/\u001a3\u0002\u0019M\u001cwN]3DQ\u0006tw-\u001a3\u0015\u000bI\fy*a)\t\u000f\u0005\u0005\u0006\u00031\u0001\u0002D\u0005\t\u0011\rC\u0004\u0002&B\u0001\r!a\u0011\u0002\u0003\t\fabZ3oKJ\fG/\u001a*jg.LE\r\u0006\u0003\u0002,\u0006=\u0006cA\u0013\u0002.&\u0019\u0011\u0011\u000f\u0014\t\u000f\u0005\r\u0014\u00031\u0001\u0002f\u0005\u0011r-\u001a8fe\u0006$X-Q:tKN\u001cxN]%e)\u0011\t)'!.\t\u000f\u0005]&\u00031\u0001\u0002f\u0005a\u0011m]:fgN|'OT1nK\u0006!a.Y7f)\t\t)'\u0001\u0004f]\u0006\u0014G.\u001a\u000b\u0002u\u00069A-[:bE2,\u0017!C5t\u000b:\f'\r\\3e)\u0005\u0011\bf\u0001\u0001\u0002JB!\u00111ZAi\u001b\t\tiMC\u0002\u0002P*\f!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\t\u0019.!4\u0003\u000fM+'O^5dK\":\u0001!a6\u0002f\u0006\u001d\b\u0003BAm\u0003Cl!!a7\u000b\u0007\u0015\fiNC\u0002\u0002`*\fqaY8oi\u0016DH/\u0003\u0003\u0002d\u0006m'!B*d_B,\u0017!\u00039s_bLXj\u001c3fI\t\tI/\u0003\u0003\u0002l\u00065\u0018\u0001\u0004+B%\u001e+EkX\"M\u0003N\u001b&\u0002BAx\u00037\fqbU2pa\u0016$\u0007K]8ys6{G-\u001a")
public class RiskService
implements FeatureService,
Logging {
    private final RiskRepository riskRepository;
    private final RiskProfileService riskProfileService;
    private final ReleaseActorService releaseActorService;
    private final ReleaseRepository releaseRepository;
    private final XLReleaseEventBus eventBus;
    private volatile boolean enabled;
    private final List<Type> riskAssessorTypes;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @ManagedOperation(description="Stop service")
    public void stop() {
        super.stop();
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RiskService riskService = this;
        synchronized (riskService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private boolean enabled() {
        return this.enabled;
    }

    private void enabled_$eq(boolean x$1) {
        this.enabled = x$1;
    }

    private List<Type> riskAssessorTypes() {
        return this.riskAssessorTypes;
    }

    public Risk calculateRisk(Release release) {
        this.logger().debug((Function0 & Serializable)() -> "Running risk calculations for release " + release.getId());
        Risk risk = this.riskRepository.findByIdOrDefault(this.generateRiskId(release.getId()));
        RiskProfile riskProfileByRelease = (RiskProfile)Option$.MODULE$.apply(release.getProperty("riskProfile")).getOrElse((Function0 & Serializable)() -> $this.riskProfileService.findByIdOrDefault(RiskProfile.DEFAULT_RISK_PROFILE_ID));
        List riskAssessors = this.riskAssessorTypes().filter((Function1 & Serializable)type -> BoxesRunTime.boxToBoolean((boolean)riskProfileByRelease.hasRiskAssessorEnabled(type))).map((Function1 & Serializable)riskAssessorType -> (RiskAssessor)riskAssessorType.getDescriptor().newInstance(this.generateAssessorId(riskAssessorType.getName())));
        List riskAssessments = riskAssessors.map((Function1 & Serializable)riskAssessor -> riskAssessor.execute(release, riskProfileByRelease));
        risk.setRiskAssessments(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)riskAssessments).asJava());
        int score = BoxesRunTime.unboxToInt((Object)riskAssessments.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$2.getScore()))).maxOption((Ordering)Ordering.Int$.MODULE$).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
        int totalScore = BoxesRunTime.unboxToInt((Object)riskAssessments.map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$3.getScore()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        risk.setScore(Predef$.MODULE$.int2Integer(score));
        risk.setTotalScore(Predef$.MODULE$.int2Integer(totalScore));
        this.logger().debug((Function0 & Serializable)() -> "Finished running risk calculations for release " + release.getId() + " with score " + risk.getScore() + " and total score " + risk.getTotalScore());
        return risk;
    }

    @Async(value="riskCalculationExecutor")
    public void calculateRiskAndUpdateRelease(String releaseId) {
        Release release = this.releaseRepository.findById(releaseId);
        this.calculateRiskAndUpdateRelease(release);
    }

    @Async(value="riskCalculationExecutor")
    public void calculateRiskAndUpdateRelease(Release release) {
        if (release.isPlannedOrActive() && !release.isWorkflow()) {
            Risk risk = this.calculateRisk(release);
            if (this.enabled()) {
                this.updateRisk(release.getId(), risk);
                return;
            }
            return;
        }
    }

    private void updateRisk(String releaseId, Risk updated) {
        Some some;
        Risk risk;
        boolean bl;
        Option<Risk> maybeOriginal;
        this.logger().debug((Function0 & Serializable)() -> "UpdateRisk(" + releaseId + ")");
        String riskId = releaseId + "/Risk";
        Option<Risk> option = maybeOriginal = this.riskRepository.read(riskId);
        if (None$.MODULE$.equals(option)) {
            this.riskRepository.create(updated);
            this.logger().info((Function0 & Serializable)() -> "Created risk score for release " + releaseId + ": " + updated.getScore() + " and total risk score " + updated.getTotalScore());
            bl = true;
        } else if (option instanceof Some && (risk = (Risk)(some = (Some)option).value()) != null) {
            Risk risk2;
            Risk original = risk2 = risk;
            this.riskRepository.update(updated);
            if (this.scoreChanged(original, updated)) {
                this.logger().info((Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Updated risk score for release " + releaseId + " from " + original.getScore() + " to " + updated.getScore() + "\n               | and total risk score from " + original.getTotalScore() + " to " + updated.getTotalScore())));
                bl = true;
            } else {
                bl = false;
            }
        } else {
            throw new MatchError(option);
        }
        boolean doUpdate = bl;
        if (doUpdate) {
            this.releaseRepository.setRiskScores(releaseId, Predef$.MODULE$.Integer2int(updated.getScore()), Predef$.MODULE$.Integer2int(updated.getTotalScore()));
            this.releaseActorService.updateReleaseRiskScores(releaseId, updated.getScore(), updated.getTotalScore());
            this.eventBus.publish((XLReleaseEvent)new RiskScoreUpdated(releaseId, maybeOriginal, updated));
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean scoreChanged(Risk a, Risk b) {
        Integer n = a.getScore();
        Integer n2 = b.getScore();
        if (n == null) {
            if (n2 != null) {
                return true;
            }
        } else if (!((Object)n).equals(n2)) return true;
        Integer n3 = a.getTotalScore();
        Integer n4 = b.getTotalScore();
        if (n3 == null) {
            if (n4 == null) return false;
            return true;
        } else if (((Object)n3).equals(n4)) return false;
        return true;
    }

    private String generateRiskId(String releaseId) {
        return releaseId + "/Risk";
    }

    private String generateAssessorId(String assessorName) {
        return Ids.ROOT_FOLDER_ID + "/" + assessorName;
    }

    public String name() {
        return "RiskService";
    }

    public void enable() {
        this.enabled_$eq(true);
    }

    public void disable() {
        this.enabled_$eq(false);
    }

    public boolean isEnabled() {
        return this.enabled();
    }

    public static final /* synthetic */ boolean $anonfun$riskAssessorTypes$1(Type x$1) {
        return !x$1.getDescriptor().isVirtual();
    }

    @Autowired
    public RiskService(RiskRepository riskRepository, RiskProfileService riskProfileService, ReleaseActorService releaseActorService, ReleaseRepository releaseRepository, XLReleaseEventBus eventBus) {
        this.riskRepository = riskRepository;
        this.riskProfileService = riskProfileService;
        this.releaseActorService = releaseActorService;
        this.releaseRepository = releaseRepository;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
        this.enabled = true;
        this.riskAssessorTypes = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(DescriptorRegistry.getSubtypes((Type)Type.valueOf(RiskAssessor.class))).asScala().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RiskService.$anonfun$riskAssessorTypes$1(x$1)))).toList();
    }
}

