/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.service;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.events.ConfigurationCopiedEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationDeletedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.RetryTitleGenerator;
import com.xebialabs.xlrelease.repository.query.ReleaseBasicData;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.risk.domain.events.RiskProfileUpdated;
import com.xebialabs.xlrelease.risk.domain.riskassessors.RiskAssessor;
import com.xebialabs.xlrelease.service.CiIdService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.collection.IterableOnceOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005Me\u0001\u0002\u000b\u0016\u0001\u0001B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tk\u0001\u0011\t\u0011)A\u0005m!AA\b\u0001BC\u0002\u0013\u0005Q\b\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003?\u0011\u0015)\u0005\u0001\"\u0001G\u0011\u0015Y\u0006\u0001\"\u0001]\u0011\u0015\t\b\u0001\"\u0001s\u0011\u001d\tI\u0001\u0001C\u0001\u0003\u0017Aq!!\u0005\u0001\t\u0003\t\u0019\u0002C\u0004\u0002\u001c\u0001!\t!!\b\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&!9\u0011\u0011\b\u0001\u0005\u0002\u0005m\u0002bBA\"\u0001\u0011\u0005\u0011Q\t\u0005\b\u0003\u0017\u0002A\u0011AA'\u0011\u001d\tI\u0006\u0001C\u0001\u00037Bq!!\u0019\u0001\t\u0003\t\u0019\u0007C\u0004\u0002x\u0001!\t!!\u001f\t\u0011\u0005m\u0004\u0001)C\u0005\u0003{B\u0001\"!!\u0001A\u0013%\u00111\u0011\u0002\u0013%&\u001c8\u000e\u0015:pM&dWmU3sm&\u001cWM\u0003\u0002\u0017/\u000591/\u001a:wS\u000e,'B\u0001\r\u001a\u0003\u0011\u0011\u0018n]6\u000b\u0005iY\u0012!\u0003=me\u0016dW-Y:f\u0015\taR$A\u0005yK\nL\u0017\r\\1cg*\ta$A\u0002d_6\u001c\u0001aE\u0002\u0001C\u001d\u0002\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012a!\u00118z%\u00164\u0007C\u0001\u0015.\u001b\u0005I#B\u0001\u0016,\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005a\u0013\u0001C4sSjTH.\u001a3\n\u00059J#a\u0002'pO\u001eLgnZ\u0001\fG&LEmU3sm&\u001cW\r\u0005\u00022g5\t!G\u0003\u0002\u00173%\u0011AG\r\u0002\f\u0007&LEmU3sm&\u001cW-A\fd_:4\u0017nZ;sCRLwN\u001c*fa>\u001c\u0018\u000e^8ssB\u0011qGO\u0007\u0002q)\u0011\u0011(G\u0001\u000be\u0016\u0004xn]5u_JL\u0018BA\u001e9\u0005]\u0019uN\u001c4jOV\u0014\u0018\r^5p]J+\u0007o\\:ji>\u0014\u00180\u0001\u0005fm\u0016tGOQ;t+\u0005q\u0004CA C\u001b\u0005\u0001%BA!\u001a\u0003\u0019)g/\u001a8ug&\u00111\t\u0011\u0002\t\u000bZ,g\u000e\u001e\"vg\u0006IQM^3oi\n+8\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u001dK%j\u0013\t\u0003\u0011\u0002i\u0011!\u0006\u0005\u0006_\u0015\u0001\r\u0001\r\u0005\u0006k\u0015\u0001\rA\u000e\u0005\u0006y\u0015\u0001\rA\u0010\u0015\u0003\u000b5\u0003\"AT-\u000e\u0003=S!\u0001U)\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002S'\u00069a-Y2u_JL(B\u0001+V\u0003\u0015\u0011W-\u00198t\u0015\t1v+A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005A\u0016aA8sO&\u0011!l\u0014\u0002\n\u0003V$xn^5sK\u0012\faa\u0019:fCR,GCA/d!\tq\u0016-D\u0001`\u0015\t\u0001w#\u0001\u0004e_6\f\u0017N\\\u0005\u0003E~\u00131BU5tWB\u0013xNZ5mK\")AM\u0002a\u0001;\u0006Y!/[:l!J|g-\u001b7fQ\t1a\r\u0005\u0002h_6\t\u0001N\u0003\u0002QS*\u0011!n[\u0001\u0005G>\u0014XM\u0003\u0002m[\u0006QQ.[2s_6,G/\u001a:\u000b\u00039\f!![8\n\u0005AD'!\u0002+j[\u0016$\u0017AB3ySN$8\u000f\u0006\u0002tmB\u0011!\u0005^\u0005\u0003k\u000e\u0012qAQ8pY\u0016\fg\u000eC\u0003x\u000f\u0001\u0007\u00010A\u0007sSN\\\u0007K]8gS2,\u0017\n\u001a\t\u0004s\u0006\u0005aB\u0001>\u007f!\tY8%D\u0001}\u0015\tix$\u0001\u0004=e>|GOP\u0005\u0003\u007f\u000e\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0002\u0003\u000b\u0011aa\u0015;sS:<'BA@$Q\t9a-\u0001\u0005gS:$')_%e)\ri\u0016Q\u0002\u0005\u0006o\"\u0001\r\u0001\u001f\u0015\u0003\u0011\u0019\fQ\"\u001a=jgR\u001c()\u001f+ji2,GcA:\u0002\u0016!1\u0011qC\u0005A\u0002a\fQ\u0001^5uY\u0016D#!\u00034\u0002#\u0019Lg\u000e\u001a\"z\u0013\u0012|%\u000fR3gCVdG\u000fF\u0002^\u0003?AQa\u001e\u0006A\u0002aD#A\u00034\u0002\u000f\u0019Lg\u000eZ!mYR\u0011\u0011q\u0005\t\u0006\u0003S\t\u0019$X\u0007\u0003\u0003WQA!!\f\u00020\u0005!Q\u000f^5m\u0015\t\t\t$\u0001\u0003kCZ\f\u0017\u0002BA\u001b\u0003W\u0011A\u0001T5ti\"\u00121BZ\u0001\fM&tGMQ=USRdW\rF\u0002^\u0003{Aa!a\u0010\r\u0001\u0004A\u0018\u0001\u0005:jg.\u0004&o\u001c4jY\u0016$\u0016\u000e\u001e7fQ\taa-\u0001\u0004va\u0012\fG/\u001a\u000b\u0004;\u0006\u001d\u0003\"\u00023\u000e\u0001\u0004i\u0006FA\u0007g\u0003\u0019!W\r\\3uKR!\u0011qJA+!\r\u0011\u0013\u0011K\u0005\u0004\u0003'\u001a#\u0001B+oSRDQa\u001e\bA\u0002aD#A\u00044\u0002\t\r|\u0007/\u001f\u000b\u0004;\u0006u\u0003\"B<\u0010\u0001\u0004A\bFA\bg\u000359W\r\u001e*fM\u0016\u0014XM\\2fgR!\u0011QMA:!\u0019\tI#a\r\u0002hA!\u0011\u0011NA8\u001b\t\tYGC\u0002\u0002na\nQ!];fefLA!!\u001d\u0002l\t\u0001\"+\u001a7fCN,')Y:jG\u0012\u000bG/\u0019\u0005\u0006oB\u0001\r\u0001\u001f\u0015\u0003!\u0019\f!dZ3oKJ\fG/\u001a#fM\u0006,H\u000e\u001e*jg.\u0004&o\u001c4jY\u0016,\u0012!X\u0001\u000fG\",7m\u001b#va2L7-\u0019;f)\u0011\ty%a \t\r\u0005]!\u00031\u0001y\u0003U9WM\\3sCR,'+[:l!J|g-\u001b7f\u0013\u0012,\u0012\u0001\u001f\u0015\u0004\u0001\u0005\u001d\u0005\u0003BAE\u0003\u001fk!!a#\u000b\u0007\u00055U+\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!!%\u0002\f\n91+\u001a:wS\u000e,\u0007")
public class RiskProfileService
implements Logging {
    private final CiIdService ciIdService;
    private final ConfigurationRepository configurationRepository;
    private final EventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RiskProfileService riskProfileService = this;
        synchronized (riskProfileService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public EventBus eventBus() {
        return this.eventBus;
    }

    @Timed
    public RiskProfile create(RiskProfile riskProfile) {
        this.checkDuplicate(riskProfile.getTitle());
        riskProfile.setId(this.generateRiskProfileId());
        this.configurationRepository.create((BaseConfiguration)riskProfile);
        this.eventBus().publish((XLReleaseEvent)new ConfigurationCreatedEvent((BaseConfiguration)riskProfile));
        return riskProfile;
    }

    @Timed
    public boolean exists(String riskProfileId) {
        return this.configurationRepository.exists(riskProfileId);
    }

    @Timed
    public RiskProfile findById(String riskProfileId) {
        return (RiskProfile)this.configurationRepository.read(riskProfileId);
    }

    @Timed
    public boolean existsByTitle(String title) {
        return this.configurationRepository.existsByTypeAndTitle(Type.valueOf(RiskProfile.class), title);
    }

    @Timed
    public RiskProfile findByIdOrDefault(String riskProfileId) {
        RiskProfile riskProfile;
        try {
            riskProfile = (RiskProfile)this.configurationRepository.read(riskProfileId);
        }
        catch (NotFoundException notFoundException) {
            riskProfile = this.generateDefaultRiskProfile();
        }
        return riskProfile;
    }

    @Timed
    public List<RiskProfile> findAll() {
        return this.configurationRepository.findAllByType(Type.valueOf(RiskProfile.class));
    }

    @Timed
    public RiskProfile findByTitle(String riskProfileTitle) {
        List profiles = this.configurationRepository.findAllByTypeAndTitle(Type.valueOf(RiskProfile.class), riskProfileTitle);
        int n = profiles.size();
        switch (n) {
            case 0: {
                throw new NotFoundException("Could not find risk profile for title [" + riskProfileTitle + "]", new Object[0]);
            }
        }
        return (RiskProfile)profiles.get(0);
    }

    @Timed
    public RiskProfile update(RiskProfile riskProfile) {
        RiskProfile currentRiskProfile = this.findById(riskProfile.getId());
        Checks.checkArgument((!currentRiskProfile.isDefaultProfile() ? 1 : 0) != 0, (String)"Default risk profile cannot be updated", (Object[])new Object[0]);
        String string = currentRiskProfile.getTitle();
        String string2 = riskProfile.getTitle();
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.checkDuplicate(riskProfile.getTitle());
        }
        this.configurationRepository.update((BaseConfiguration)riskProfile);
        this.eventBus().publish((XLReleaseEvent)new RiskProfileUpdated(riskProfile));
        return riskProfile;
    }

    @Timed
    public void delete(String riskProfileId) {
        RiskProfile riskProfile = this.findById(riskProfileId);
        Checks.checkArgument((!riskProfile.isDefaultProfile() ? 1 : 0) != 0, (String)"Default risk profile cannot be deleted", (Object[])new Object[0]);
        this.configurationRepository.delete(riskProfileId);
        this.eventBus().publish((XLReleaseEvent)new ConfigurationDeletedEvent((BaseConfiguration)riskProfile));
    }

    @Timed
    public RiskProfile copy(String riskProfileId) {
        RiskProfile riskProfile = this.findById(riskProfileId);
        String copyRiskProfileTitle = riskProfile.getTitle();
        while (this.existsByTitle(copyRiskProfileTitle)) {
            copyRiskProfileTitle = RetryTitleGenerator.getNextTitle((String)copyRiskProfileTitle);
        }
        RiskProfile copyRiskProfile = (RiskProfile)Type.valueOf(RiskProfile.class).getDescriptor().newInstance(this.generateRiskProfileId());
        copyRiskProfile.setTitle(copyRiskProfileTitle);
        copyRiskProfile.setRiskProfileAssessors(riskProfile.getRiskProfileAssessors());
        this.configurationRepository.create((BaseConfiguration)copyRiskProfile);
        this.eventBus().publish((XLReleaseEvent)new ConfigurationCopiedEvent((BaseConfiguration)riskProfile, copyRiskProfile.getId()));
        return copyRiskProfile;
    }

    @Timed
    public List<ReleaseBasicData> getReferences(String riskProfileId) {
        return this.configurationRepository.getReferenceReleases(riskProfileId);
    }

    public RiskProfile generateDefaultRiskProfile() {
        RiskProfile defaultRiskProfile = (RiskProfile)Type.valueOf(RiskProfile.class).getDescriptor().newInstance(null);
        ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(DescriptorRegistry.getSubtypes((Type)Type.valueOf(RiskAssessor.class))).asScala().filter((Function1 & Serializable)type -> BoxesRunTime.boxToBoolean((boolean)RiskProfileService.$anonfun$generateDefaultRiskProfile$1(type)))).foreach((Function1 & Serializable)t -> {
            defaultRiskProfile.setValueFor(t, BoxesRunTime.unboxToInt((Object)t.getDescriptor().getPropertyDescriptor("score").getDefaultValue()));
            return BoxedUnit.UNIT;
        });
        return defaultRiskProfile;
    }

    private void checkDuplicate(String title) {
        if (this.existsByTitle(title)) {
            throw new ItemAlreadyExistsException("Risk profile '%s' already exist.", new Object[]{title});
        }
    }

    private String generateRiskProfileId() {
        return this.ciIdService.getUniqueId(Type.valueOf(RiskProfile.class), Ids.RISK_PROFILE_CONFIGURATION_ROOT);
    }

    public static final /* synthetic */ boolean $anonfun$generateDefaultRiskProfile$1(Type type) {
        return !type.getDescriptor().isVirtual();
    }

    @Autowired
    public RiskProfileService(CiIdService ciIdService, ConfigurationRepository configurationRepository, EventBus eventBus) {
        this.ciIdService = ciIdService;
        this.configurationRepository = configurationRepository;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

