/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.spring.config;

import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.metrics.MetricsConfiguration;
import com.xebialabs.xlrelease.risk.spring.config.RestartableExecutorService;
import com.xebialabs.xlrelease.utils.PrefixedThreadFactory;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;

@Configuration
@EnableAsync
public class RiskConfiguration {
    public static final String RISK_CALCULATION_EXECUTOR = "riskCalculationExecutor";

    @Bean(name={"riskCalculationExecutor"})
    public RestartableExecutorService riskCalculationExecutor(XlrConfig xlrConfig, MeterRegistry meterRegistry) {
        return new RestartableExecutorService("risk-calculation", () -> {
            ExecutorService executor = Executors.newFixedThreadPool(4, (ThreadFactory)new PrefixedThreadFactory("risk-calculation", Boolean.valueOf(true)));
            if (xlrConfig.metrics().enabled()) {
                return ExecutorServiceMetrics.monitor((MeterRegistry)meterRegistry, (ExecutorService)executor, (String)"risk-calculation", (Tag[])new Tag[]{MetricsConfiguration.TAG_EXECUTOR()});
            }
            return executor;
        });
    }

    @Bean
    public Executor riskCalculationBatchExecutor(XlrConfig xlrConfig, MeterRegistry meterRegistry) {
        ExecutorService executor = Executors.newFixedThreadPool(2, (ThreadFactory)new PrefixedThreadFactory("risk-calculation-batch", Boolean.valueOf(true)));
        if (xlrConfig.metrics().enabled()) {
            ExecutorServiceMetrics.monitor((MeterRegistry)meterRegistry, (ExecutorService)executor, (String)"risk-calculation-batch", (Tag[])new Tag[]{MetricsConfiguration.TAG_EXECUTOR()});
        }
        return executor;
    }
}

