package com.xebialabs.xlrelease.risk.builder;

import java.util.Arrays;
import java.util.List;

import com.xebialabs.xlrelease.risk.domain.RiskAssessment;

public class RiskAssessmentBuilder {
    private String riskAssessorId;
    private int score = 0;
    private String headline;
    private List<String> messages;

    public RiskAssessmentBuilder() {
    }

    public static RiskAssessmentBuilder newRiskAssessment() {
        return new RiskAssessmentBuilder();
    }

    public RiskAssessmentBuilder withRiskAssessorId(String riskAssessorId) {
        this.riskAssessorId = riskAssessorId;
        return this;
    }

    public RiskAssessmentBuilder withScore(int score) {
        this.score = score;
        return this;
    }

    public RiskAssessmentBuilder withHeadline(String headline) {
        this.headline = headline;
        return this;
    }

    public RiskAssessmentBuilder withMessages(String... messages) {
        this.messages = Arrays.asList(messages);
        return this;
    }

    public RiskAssessment build() {
        RiskAssessment riskAssessment = new RiskAssessment();
        riskAssessment.setRiskAssessorId(this.riskAssessorId);
        riskAssessment.setScore(this.score);
        riskAssessment.setHeadline(this.headline);
        riskAssessment.setMessages(this.messages);
        return riskAssessment;
    }
}
