/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseExtension;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.PhaseClosedEvent;
import com.xebialabs.xlrelease.domain.events.PhaseDeletedEvent;
import com.xebialabs.xlrelease.domain.events.PhaseDuplicatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseProgressCalculated;
import com.xebialabs.xlrelease.domain.events.TaskCompletedEvent;
import com.xebialabs.xlrelease.domain.events.TaskCopiedEvent;
import com.xebialabs.xlrelease.domain.events.TaskCreatedEvent;
import com.xebialabs.xlrelease.domain.events.TaskDeletedEvent;
import com.xebialabs.xlrelease.domain.events.TaskReopenedEvent;
import com.xebialabs.xlrelease.domain.events.TaskSkippedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.risk.domain.progress.ReleaseProgress;
import com.xebialabs.xlrelease.risk.repository.ProgressRepository;
import com.xebialabs.xlrelease.risk.service.ReleaseProgressWithReleaseId;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@EventListener
@ScalaSignature(bytes="\u0006\u0005\u0005-g\u0001B\n\u0015\u0001}A\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\tk\u0001\u0011\t\u0011)A\u0005m!)A\b\u0001C\u0001{!)\u0011\u000b\u0001C\u0001%\")1\r\u0001C\u0001I\")!\u000e\u0001C\u0001W\")!\u000f\u0001C\u0001g\")!\u0010\u0001C\u0001w\"9\u0011Q\u0001\u0001\u0005\u0002\u0005\u001d\u0001bBA\u000b\u0001\u0011\u0005\u0011q\u0003\u0005\b\u0003K\u0001A\u0011AA\u0014\u0011\u001d\t)\u0004\u0001C\u0001\u0003oAq!!\u0012\u0001\t\u0003\t9\u0005C\u0004\u0002V\u0001!\t!a\u0016\t\u000f\u0005e\u0004\u0001\"\u0003\u0002|!9\u0011Q\u0013\u0001\u0005\n\u0005]\u0005bBAN\u0001\u0011%\u0011Q\u0014\u0005\b\u0003C\u0003A\u0011BAR\u0005=\u0001&o\\4sKN\u001c8+\u001a:wS\u000e,'BA\u000b\u0017\u0003\u001d\u0019XM\u001d<jG\u0016T!a\u0006\r\u0002\tIL7o\u001b\u0006\u00033i\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005ma\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005i\u0012aA2p[\u000e\u00011c\u0001\u0001!MA\u0011\u0011\u0005J\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t1\u0011I\\=SK\u001a\u0004\"a\n\u0017\u000e\u0003!R!!\u000b\u0016\u0002\u000bMdg\r\u000e6\u000b\u0003-\n\u0001b\u001a:jujdW\rZ\u0005\u0003[!\u0012q\u0001T8hO&tw-\u0001\nqe><'/Z:t%\u0016\u0004xn]5u_JL\bC\u0001\u00194\u001b\u0005\t$B\u0001\u001a\u0017\u0003)\u0011X\r]8tSR|'/_\u0005\u0003iE\u0012!\u0003\u0015:pOJ,7o\u001d*fa>\u001c\u0018\u000e^8ss\u0006AQM^3oi\n+8\u000f\u0005\u00028u5\t\u0001H\u0003\u0002:1\u00051QM^3oiNL!a\u000f\u001d\u0003\u0011\u00153XM\u001c;CkN\fa\u0001P5oSRtDc\u0001 A\u0003B\u0011q\bA\u0007\u0002)!)af\u0001a\u0001_!)Qg\u0001a\u0001m!\u00121a\u0011\t\u0003\t>k\u0011!\u0012\u0006\u0003\r\u001e\u000b!\"\u00198o_R\fG/[8o\u0015\tA\u0015*A\u0004gC\u000e$xN]=\u000b\u0005)[\u0015!\u00022fC:\u001c(B\u0001'N\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u0001(\u0002\u0007=\u0014x-\u0003\u0002Q\u000b\nI\u0011)\u001e;po&\u0014X\rZ\u0001\u000fe\u0016dW-Y:f\u0007J,\u0017\r^3e)\t\u0019f\u000b\u0005\u0002\")&\u0011QK\t\u0002\u0005+:LG\u000fC\u0003X\t\u0001\u0007\u0001,A\nsK2,\u0017m]3De\u0016\fG/\u001a3Fm\u0016tG\u000f\u0005\u0002Z;6\t!L\u0003\u0002:7*\u0011A\fG\u0001\u0007I>l\u0017-\u001b8\n\u0005yS&a\u0005*fY\u0016\f7/Z\"sK\u0006$X\rZ#wK:$\bF\u0001\u0003a!\t9\u0014-\u0003\u0002cq\tI1+\u001e2tGJL'-Z\u0001\u0011a\"\f7/Z\"m_N,G-\u0012<f]R$\"aU3\t\u000b\r,\u0001\u0019\u00014\u0011\u0005e;\u0017B\u00015[\u0005A\u0001\u0006.Y:f\u00072|7/\u001a3Fm\u0016tG\u000f\u000b\u0002\u0006A\u0006y\u0001\u000f[1tK\u0012+\b\u000f\\5dCR,G\r\u0006\u0002TY\")QN\u0002a\u0001]\u0006!\u0002\u000f[1tK\u0012+\b\u000f\\5dCR,G-\u0012<f]R\u0004\"!W8\n\u0005AT&\u0001\u0006)iCN,G)\u001e9mS\u000e\fG/\u001a3Fm\u0016tG\u000f\u000b\u0002\u0007A\u0006a\u0001\u000f[1tK\u0012+G.\u001a;fIR\u00111\u000b\u001e\u0005\u0006k\u001e\u0001\rA^\u0001\u0012a\"\f7/\u001a#fY\u0016$X\rZ#wK:$\bCA-x\u0013\tA(LA\tQQ\u0006\u001cX\rR3mKR,G-\u0012<f]RD#a\u00021\u0002\u0017Q\f7o[*lSB\u0004X\r\u001a\u000b\u0003'rDQ! \u0005A\u0002y\f\u0001\u0003^1tWN[\u0017\u000e\u001d9fI\u00163XM\u001c;\u0011\u0005e{\u0018bAA\u00015\n\u0001B+Y:l'.L\u0007\u000f]3e\u000bZ,g\u000e\u001e\u0015\u0003\u0011\u0001\fQ\u0002^1tW\u000e{W\u000e\u001d7fi\u0016$GcA*\u0002\n!9\u00111B\u0005A\u0002\u00055\u0011A\u0005;bg.\u001cu.\u001c9mKR,G-\u0012<f]R\u00042!WA\b\u0013\r\t\tB\u0017\u0002\u0013)\u0006\u001c8nQ8na2,G/\u001a3Fm\u0016tG\u000f\u000b\u0002\nA\u0006YA/Y:l\u0007J,\u0017\r^3e)\r\u0019\u0016\u0011\u0004\u0005\b\u00037Q\u0001\u0019AA\u000f\u0003A!\u0018m]6De\u0016\fG/\u001a3Fm\u0016tG\u000fE\u0002Z\u0003?I1!!\t[\u0005A!\u0016m]6De\u0016\fG/\u001a3Fm\u0016tG\u000f\u000b\u0002\u000bA\u0006qA/Y:l\tV\u0004H.[2bi\u0016$GcA*\u0002*!9\u00111F\u0006A\u0002\u00055\u0012a\u0004;bg.\u001cu\u000e]5fI\u00163XM\u001c;\u0011\u0007e\u000by#C\u0002\u00022i\u0013q\u0002V1tW\u000e{\u0007/[3e\u000bZ,g\u000e\u001e\u0015\u0003\u0017\u0001\f1\u0002^1tW\u0012+G.\u001a;fIR\u00191+!\u000f\t\u000f\u0005mB\u00021\u0001\u0002>\u0005\u0001B/Y:l\t\u0016dW\r^3e\u000bZ,g\u000e\u001e\t\u00043\u0006}\u0012bAA!5\n\u0001B+Y:l\t\u0016dW\r^3e\u000bZ,g\u000e\u001e\u0015\u0003\u0019\u0001\fA\u0002^1tWJ+w\u000e]3oK\u0012$2aUA%\u0011\u001d\tY%\u0004a\u0001\u0003\u001b\n\u0011\u0003^1tWJ+w\u000e]3oK\u0012,e/\u001a8u!\rI\u0016qJ\u0005\u0004\u0003#R&!\u0005+bg.\u0014Vm\u001c9f]\u0016$WI^3oi\"\u0012Q\u0002Y\u0001\u0016kB$\u0017\r^3SK2,\u0017m]3Qe><'/Z:t)\r\u0019\u0016\u0011\f\u0005\b\u00037r\u0001\u0019AA/\u0003\u001d\u0011X\r\\3bg\u0016\u0004B!a\u0018\u0002b5\t1,C\u0002\u0002dm\u0013qAU3mK\u0006\u001cX\rK\u0002\u000f\u0003O\u0002B!!\u001b\u0002v5\u0011\u00111\u000e\u0006\u0004\r\u00065$\u0002BA8\u0003c\nq!\\3ue&\u001c7OC\u0002\u0002tq\t\u0001bY8eC\"\fG.Z\u0005\u0005\u0003o\nYGA\u0003US6,G-A\u0007ti>\u0014X\r\u0015:pOJ,7o\u001d\u000b\u0005\u0003{\nY\t\u0005\u0003\u0002\u0000\u0005\u001dUBAAA\u0015\u0011\t\u0019)!\"\u0002\u0011A\u0014xn\u001a:fgNT!\u0001\u0018\f\n\t\u0005%\u0015\u0011\u0011\u0002\u0010%\u0016dW-Y:f!J|wM]3tg\"9\u0011QR\bA\u0002\u0005=\u0015\u0001\b:fY\u0016\f7/\u001a)s_\u001e\u0014Xm]:XSRD'+\u001a7fCN,\u0017\n\u001a\t\u0004\u007f\u0005E\u0015bAAJ)\ta\"+\u001a7fCN,\u0007K]8he\u0016\u001c8oV5uQJ+G.Z1tK&#\u0017\u0001G2bY\u000e,H.\u0019;f%\u0016dW-Y:f!J|wM]3tgR!\u0011qRAM\u0011\u001d\tY\u0006\u0005a\u0001\u0003;\n\u0011cY1mGVd\u0017\r^3Qe><'/Z:t)\u0011\ti(a(\t\u000f\u0005m\u0013\u00031\u0001\u0002^\u0005y\u0011n\u001d+bg.\u001cu.\u001c9mKR,G\r\u0006\u0003\u0002&\u0006-\u0006cA\u0011\u0002(&\u0019\u0011\u0011\u0016\u0012\u0003\u000f\t{w\u000e\\3b]\"9\u0011Q\u0016\nA\u0002\u0005=\u0016\u0001\u0002;bg.\u0004B!a\u0018\u00022&\u0019\u00111W.\u0003\tQ\u000b7o\u001b\u0015\u0004\u0001\u0005]\u0006\u0003BA]\u0003\u007fk!!a/\u000b\u0007\u0005u6*\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!!1\u0002<\n91+\u001a:wS\u000e,\u0007f\u0001\u0001\u0002FB\u0019q'a2\n\u0007\u0005%\u0007HA\u0007Fm\u0016tG\u000fT5ti\u0016tWM\u001d")
public class ProgressService
implements Logging {
    private final ProgressRepository progressRepository;
    private final EventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ProgressService progressService = this;
        synchronized (progressService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Subscribe
    public void releaseCreated(ReleaseCreatedEvent releaseCreatedEvent) {
        this.updateReleaseProgress(releaseCreatedEvent.release());
    }

    @Subscribe
    public void phaseClosedEvent(PhaseClosedEvent phaseClosedEvent) {
        this.updateReleaseProgress(phaseClosedEvent.phase().getRelease());
    }

    @Subscribe
    public void phaseDuplicated(PhaseDuplicatedEvent phaseDuplicatedEvent) {
        this.updateReleaseProgress(phaseDuplicatedEvent.phaseDuplicate().getRelease());
    }

    @Subscribe
    public void phaseDeleted(PhaseDeletedEvent phaseDeletedEvent) {
        this.updateReleaseProgress(phaseDeletedEvent.phase().getRelease());
    }

    @Subscribe
    public void taskSkipped(TaskSkippedEvent taskSkippedEvent) {
        this.updateReleaseProgress(taskSkippedEvent.task().getRelease());
    }

    @Subscribe
    public void taskCompleted(TaskCompletedEvent taskCompletedEvent) {
        this.updateReleaseProgress(taskCompletedEvent.task().getRelease());
    }

    @Subscribe
    public void taskCreated(TaskCreatedEvent taskCreatedEvent) {
        this.updateReleaseProgress(taskCreatedEvent.task().getRelease());
    }

    @Subscribe
    public void taskDuplicated(TaskCopiedEvent taskCopiedEvent) {
        this.updateReleaseProgress(taskCopiedEvent.task().getRelease());
    }

    @Subscribe
    public void taskDeleted(TaskDeletedEvent taskDeletedEvent) {
        this.updateReleaseProgress(taskDeletedEvent.task().getRelease());
    }

    @Subscribe
    public void taskReopened(TaskReopenedEvent taskReopenedEvent) {
        this.updateReleaseProgress(taskReopenedEvent.task().getRelease());
    }

    @Timed
    public void updateReleaseProgress(Release release) {
        if (!release.isTemplate()) {
            ReleaseProgressWithReleaseId releaseProgressWithId = this.calculateReleaseProgress(release);
            this.storeProgress(releaseProgressWithId);
            return;
        }
    }

    private ReleaseProgress storeProgress(ReleaseProgressWithReleaseId releaseProgressWithReleaseId) {
        ReleaseProgress savedReleaseProgress = this.progressRepository.createOrUpdate(releaseProgressWithReleaseId.releaseProgress());
        this.eventBus.publish((XLReleaseEvent)new ReleaseProgressCalculated(releaseProgressWithReleaseId.releaseId(), (ReleaseExtension)savedReleaseProgress));
        return savedReleaseProgress;
    }

    private ReleaseProgressWithReleaseId calculateReleaseProgress(Release release) {
        return new ReleaseProgressWithReleaseId(release.getId(), this.calculateProgress(release));
    }

    private ReleaseProgress calculateProgress(Release release) {
        this.logger().debug((Function0 & Serializable)() -> "Calculating progress of release " + release.getId());
        List allTasks = release.getAllTasks();
        int totalTasks = allTasks.size();
        int tasksCompleted = CollectionConverters$.MODULE$.ListHasAsScala(allTasks).asScala().count((Function1 & Serializable)task -> BoxesRunTime.boxToBoolean((boolean)this.isTaskCompleted(task)));
        ReleaseProgress releaseProgress = new ReleaseProgress();
        releaseProgress.setId(release.getId() + "/progress");
        releaseProgress.setTotalRemainingTasks(totalTasks - tasksCompleted);
        releaseProgress.setTotalTasks(totalTasks);
        scala.collection.immutable.Map phasesProgress = (scala.collection.immutable.Map)CollectionConverters$.MODULE$.ListHasAsScala(release.getPhases()).asScala().foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                scala.collection.immutable.Map acc = (scala.collection.immutable.Map)tuple2._1();
                Phase phase = (Phase)tuple2._2();
                int totalPhaseTasks = phase.getAllTasks().size();
                int tasksCompletedInPhase = CollectionConverters$.MODULE$.ListHasAsScala(phase.getAllTasks()).asScala().count((Function1 & Serializable)task -> BoxesRunTime.boxToBoolean((boolean)this.isTaskCompleted(task)));
                return (scala.collection.immutable.Map)acc.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)phase.getId()), (Object)(totalPhaseTasks + ";" + tasksCompletedInPhase)));
            }
            throw new MatchError((Object)tuple2);
        });
        releaseProgress.setPhasesProgress(CollectionConverters$.MODULE$.MapHasAsJava((Map)phasesProgress).asJava());
        return releaseProgress;
    }

    private boolean isTaskCompleted(Task task) {
        return task.isDone() || task.isDoneInAdvance();
    }

    @Autowired
    public ProgressService(ProgressRepository progressRepository, EventBus eventBus) {
        this.progressRepository = progressRepository;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

