package com.xebialabs.xlrelease.risk.builder;

import com.xebialabs.xlrelease.risk.domain.progress.ReleaseProgress;

public class ReleaseProgressBuilder {

    private String id;
    private int totalTasks = 0;
    private int totalRemainingTasks = 0;

    public ReleaseProgressBuilder() {
    }

    public static ReleaseProgressBuilder newReleaseProgress() {
        return new ReleaseProgressBuilder();
    }

    public ReleaseProgressBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public ReleaseProgressBuilder withTotalTasks(int totalTasks) {
        this.totalTasks = totalTasks;
        return this;
    }

    public ReleaseProgressBuilder withTotalRemainingTasks(int totalRemainingTasks) {
        this.totalRemainingTasks = totalRemainingTasks;
        return this;
    }


    public ReleaseProgress build() {
        ReleaseProgress progress = new ReleaseProgress().getType().getDescriptor().newInstance(this.id);
        progress.setTotalTasks(this.totalTasks);
        progress.setTotalRemainingTasks(this.totalRemainingTasks);
        return progress;
    }
}
