package com.xebialabs.xlrelease.risk.repository

import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.repository.{PersistenceInterceptor, ReleaseRepository}
import com.xebialabs.xlrelease.risk.domain.RiskProfile.DEFAULT_RISK_PROFILE_ID
import com.xebialabs.xlrelease.risk.service.RiskProfileService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
class RiskProfilePersistenceInterceptor @Autowired()(releaseRepository: ReleaseRepository,
                                                     riskProfileService: RiskProfileService)
  extends PersistenceInterceptor[Release] {

  releaseRepository.registerPersistenceInterceptor(this)

  override def onCreate(ci: Release) = {
    setDefaultRiskProfile(ci)
  }

  override def onUpdate(ci: Release): Unit = {
    setDefaultRiskProfile(ci)
  }

  private def setDefaultRiskProfile(ci: Release): Unit = {
    if (null == ci.getRiskProfile) {
      val defaultRiskProfile = riskProfileService.findById(DEFAULT_RISK_PROFILE_ID)
      ci.setRiskProfile(defaultRiskProfile)
    }
  }
}
