/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.spring.config;

import com.codahale.metrics.InstrumentedExecutorService;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.metrics.XlrMetricRegistry;
import com.xebialabs.xlrelease.utils.PrefixedThreadFactory;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;

@Configuration
@EnableAsync
public class RiskConfiguration {
    public static final String RISK_CALCULATION_EXECUTOR = "riskCalculationExecutor";

    @Bean(name={"riskCalculationExecutor"})
    public Executor riskCalculationExecutor(XlrConfig xlrConfig) {
        ExecutorService executor = Executors.newFixedThreadPool(4, (ThreadFactory)new PrefixedThreadFactory("risk-calculation", Boolean.valueOf(true)));
        if (xlrConfig.metrics().enabled()) {
            return new InstrumentedExecutorService(executor, XlrMetricRegistry.metricRegistry(), "riskCalculation");
        }
        return executor;
    }

    @Bean
    public Executor riskCalculationBatchExecutor(XlrConfig xlrConfig) {
        ExecutorService executor = Executors.newFixedThreadPool(2, (ThreadFactory)new PrefixedThreadFactory("risk-calculation-batch", Boolean.valueOf(true)));
        if (xlrConfig.metrics().enabled()) {
            return new InstrumentedExecutorService(executor, XlrMetricRegistry.metricRegistry(), "riskCalculationBatch");
        }
        return executor;
    }
}

