/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.service;

import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.risk.domain.Risk;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.risk.domain.events.RiskScoreUpdated;
import com.xebialabs.xlrelease.risk.domain.riskassessors.RiskAssessor;
import com.xebialabs.xlrelease.risk.repository.RiskRepository;
import com.xebialabs.xlrelease.risk.service.RiskProfileService;
import com.xebialabs.xlrelease.service.FeatureService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@Service
@Scope(proxyMode=ScopedProxyMode.TARGET_CLASS)
@ScalaSignature(bytes="\u0006\u0005\u0005Mg\u0001\u0002\f\u0018\u0001\tB\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\"AA\t\u0001B\u0001B\u0003%Q\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003L\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u001d9\u0007\u00011A\u0005\n!Dqa\u001c\u0001A\u0002\u0013%\u0001\u000f\u0003\u0004w\u0001\u0001\u0006K!\u001b\u0005\bo\u0002\u0011\r\u0011\"\u0003y\u0011\u001d\t\u0019\u0003\u0001Q\u0001\neDq!!\n\u0001\t\u0003\t9\u0003C\u0004\u0002D\u0001!\t!!\u0012\t\u000f\u0005\r\u0003\u0001\"\u0001\u0002r!9\u0011q\u000f\u0001\u0005\n\u0005e\u0004bBAA\u0001\u0011%\u00111\u0011\u0005\b\u0003\u001b\u0003A\u0011BAH\u0011\u001d\t\u0019\n\u0001C\u0005\u0003+Cq!a'\u0001\t\u0003\ni\nC\u0004\u0002 \u0002!\t%!)\t\u000f\u0005\r\u0006\u0001\"\u0011\u0002\"\"9\u0011Q\u0015\u0001\u0005B\u0005\u001d&a\u0003*jg.\u001cVM\u001d<jG\u0016T!\u0001G\r\u0002\u000fM,'O^5dK*\u0011!dG\u0001\u0005e&\u001c8N\u0003\u0002\u001d;\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003=}\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003\u0001\n1aY8n\u0007\u0001\u0019B\u0001A\u0012,aA\u0011A%K\u0007\u0002K)\u0011aeJ\u0001\u0005Y\u0006twMC\u0001)\u0003\u0011Q\u0017M^1\n\u0005)*#AB(cU\u0016\u001cG\u000f\u0005\u0002-]5\tQF\u0003\u0002\u00197%\u0011q&\f\u0002\u000f\r\u0016\fG/\u001e:f'\u0016\u0014h/[2f!\t\td'D\u00013\u0015\t\u0019D'A\u0003tY\u001a$$NC\u00016\u0003!9'/\u001b>{Y\u0016$\u0017BA\u001c3\u0005\u001daunZ4j]\u001e\faB]5tWJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002;{5\t1H\u0003\u0002=3\u0005Q!/\u001a9pg&$xN]=\n\u0005yZ$A\u0004*jg.\u0014V\r]8tSR|'/_\u0001\u0013e&\u001c8\u000e\u0015:pM&dWmU3sm&\u001cW\r\u0005\u0002B\u00056\tq#\u0003\u0002D/\t\u0011\"+[:l!J|g-\u001b7f'\u0016\u0014h/[2f\u0003E\u0011X\r\\3bg\u0016\u0014V\r]8tSR|'/\u001f\t\u0003\r\"k\u0011a\u0012\u0006\u0003ymI!!S$\u0003#I+G.Z1tKJ+\u0007o\\:ji>\u0014\u00180\u0001\u0005fm\u0016tGOQ;t!\tau*D\u0001N\u0015\tq5$\u0001\u0004fm\u0016tGo]\u0005\u0003!6\u0013\u0011\u0003\u0017'SK2,\u0017m]3Fm\u0016tGOQ;t\u0003\u0019a\u0014N\\5u}Q)1\u000bV+W/B\u0011\u0011\t\u0001\u0005\u0006q\u0015\u0001\r!\u000f\u0005\u0006\u007f\u0015\u0001\r\u0001\u0011\u0005\u0006\t\u0016\u0001\r!\u0012\u0005\u0006\u0015\u0016\u0001\ra\u0013\u0015\u0003\u000be\u0003\"AW3\u000e\u0003mS!\u0001X/\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002_?\u00069a-Y2u_JL(B\u00011b\u0003\u0015\u0011W-\u00198t\u0015\t\u00117-A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005!\u0017aA8sO&\u0011am\u0017\u0002\n\u0003V$xn^5sK\u0012\fq!\u001a8bE2,G-F\u0001j!\tQW.D\u0001l\u0015\u0005a\u0017!B:dC2\f\u0017B\u00018l\u0005\u001d\u0011un\u001c7fC:\f1\"\u001a8bE2,Gm\u0018\u0013fcR\u0011\u0011\u000f\u001e\t\u0003UJL!a]6\u0003\tUs\u0017\u000e\u001e\u0005\bk\u001e\t\t\u00111\u0001j\u0003\rAH%M\u0001\tK:\f'\r\\3eA\u0005\t\"/[:l\u0003N\u001cXm]:peRK\b/Z:\u0016\u0003e\u0004RA_A\u0003\u0003\u0017q1a_A\u0001\u001d\tax0D\u0001~\u0015\tq\u0018%\u0001\u0004=e>|GOP\u0005\u0002Y&\u0019\u00111A6\u0002\u000fA\f7m[1hK&!\u0011qAA\u0005\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005\r1\u000e\u0005\u0003\u0002\u000e\u0005}QBAA\b\u0015\u0011\t\t\"a\u0005\u0002\u000fI,g\r\\3di*!\u0011QCA\f\u0003\r\t\u0007/\u001b\u0006\u0005\u00033\tY\"\u0001\u0004qYV<\u0017N\u001c\u0006\u0004\u0003;i\u0012\u0001\u00033fa2|\u00170\u001b;\n\t\u0005\u0005\u0012q\u0002\u0002\u0005)f\u0004X-\u0001\nsSN\\\u0017i]:fgN|'\u000fV=qKN\u0004\u0013!D2bY\u000e,H.\u0019;f%&\u001c8\u000e\u0006\u0003\u0002*\u0005U\u0002\u0003BA\u0016\u0003ci!!!\f\u000b\u0007\u0005=\u0012$\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0003g\tiC\u0001\u0003SSN\\\u0007bBA\u001c\u0017\u0001\u0007\u0011\u0011H\u0001\be\u0016dW-Y:f!\u0011\tY$a\u0010\u000e\u0005\u0005u\"bAA\u00187%!\u0011\u0011IA\u001f\u0005\u001d\u0011V\r\\3bg\u0016\fQdY1mGVd\u0017\r^3SSN\\\u0017I\u001c3Va\u0012\fG/\u001a*fY\u0016\f7/\u001a\u000b\u0004c\u0006\u001d\u0003bBA%\u0019\u0001\u0007\u00111J\u0001\ne\u0016dW-Y:f\u0013\u0012\u0004B!!\u0014\u0002V9!\u0011qJA)!\ta8.C\u0002\u0002T-\fa\u0001\u0015:fI\u00164\u0017\u0002BA,\u00033\u0012aa\u0015;sS:<'bAA*W\":A\"!\u0018\u0002l\u00055\u0004\u0003BA0\u0003Oj!!!\u0019\u000b\u0007q\u000b\u0019GC\u0002\u0002f\u0005\f!b]2iK\u0012,H.\u001b8h\u0013\u0011\tI'!\u0019\u0003\u000b\u0005\u001b\u0018P\\2\u0002\u000bY\fG.^3\"\u0005\u0005=\u0014a\u0006:jg.\u001c\u0015\r\\2vY\u0006$\u0018n\u001c8Fq\u0016\u001cW\u000f^8s)\r\t\u00181\u000f\u0005\b\u0003oi\u0001\u0019AA\u001dQ\u001di\u0011QLA6\u0003[\n!\"\u001e9eCR,'+[:l)\u0015\t\u00181PA?\u0011\u001d\tIE\u0004a\u0001\u0003\u0017Bq!a \u000f\u0001\u0004\tI#A\u0004va\u0012\fG/\u001a3\u0002\u0019M\u001cwN]3DQ\u0006tw-\u001a3\u0015\u000b%\f))!#\t\u000f\u0005\u001du\u00021\u0001\u0002*\u0005\t\u0011\rC\u0004\u0002\f>\u0001\r!!\u000b\u0002\u0003\t\fabZ3oKJ\fG/\u001a*jg.LE\r\u0006\u0003\u0002L\u0005E\u0005bBA%!\u0001\u0007\u00111J\u0001\u0013O\u0016tWM]1uK\u0006\u001b8/Z:t_JLE\r\u0006\u0003\u0002L\u0005]\u0005bBAM#\u0001\u0007\u00111J\u0001\rCN\u001cXm]:pe:\u000bW.Z\u0001\u0005]\u0006lW\r\u0006\u0002\u0002L\u00051QM\\1cY\u0016$\u0012!]\u0001\bI&\u001c\u0018M\u00197f\u0003%I7/\u00128bE2,G\rF\u0001jQ\u001d\u0001\u00111VA]\u0003w\u0003B!!,\u000266\u0011\u0011q\u0016\u0006\u00049\u0006E&bAAZC\u000691m\u001c8uKb$\u0018\u0002BA\\\u0003_\u0013QaU2pa\u0016\f\u0011\u0002\u001d:pqflu\u000eZ3%\u0005\u0005u\u0016\u0002BA`\u0003\u0003\fA\u0002V!S\u000f\u0016#vl\u0011'B'NSA!a1\u00020\u0006y1kY8qK\u0012\u0004&o\u001c=z\u001b>$W\rK\u0002\u0001\u0003\u000f\u0004B!!3\u0002P6\u0011\u00111\u001a\u0006\u0004\u0003\u001b\f\u0017AC:uKJ,w\u000e^=qK&!\u0011\u0011[Af\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class RiskService
implements FeatureService,
Logging {
    private final RiskRepository riskRepository;
    private final RiskProfileService riskProfileService;
    private final ReleaseRepository releaseRepository;
    private final XLReleaseEventBus eventBus;
    private boolean enabled;
    private final List<Type> riskAssessorTypes;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RiskService riskService = this;
        synchronized (riskService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private boolean enabled() {
        return this.enabled;
    }

    private void enabled_$eq(boolean x$1) {
        this.enabled = x$1;
    }

    private List<Type> riskAssessorTypes() {
        return this.riskAssessorTypes;
    }

    /*
     * WARNING - void declaration
     */
    public Risk calculateRisk(Release release) {
        void var2_2;
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(38).append("Running risk calculations for release ").append(release.getId()).toString());
        Risk risk = this.riskRepository.findByIdOrDefault(this.generateRiskId(release.getId()));
        RiskProfile riskProfileByRelease = (RiskProfile)((Object)Option$.MODULE$.apply(release.getProperty("riskProfile")).getOrElse((Function0 & Serializable)() -> $this.riskProfileService.findByIdOrDefault(RiskProfile.DEFAULT_RISK_PROFILE_ID)));
        List riskAssessors = this.riskAssessorTypes().filter((Function1 & Serializable)type -> BoxesRunTime.boxToBoolean((boolean)riskProfileByRelease.hasRiskAssessorEnabled(type))).map((Function1 & Serializable)riskAssessorType -> (RiskAssessor)riskAssessorType.getDescriptor().newInstance(this.generateAssessorId(riskAssessorType.getName())));
        List riskAssessments = riskAssessors.map((Function1 & Serializable)riskAssessor -> riskAssessor.execute(release, riskProfileByRelease));
        risk.setRiskAssessments(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)riskAssessments).asJava());
        int score = BoxesRunTime.unboxToInt((Object)riskAssessments.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$2.getScore()))).maxOption((Ordering)Ordering.Int$.MODULE$).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
        int totalScore = BoxesRunTime.unboxToInt((Object)riskAssessments.map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$3.getScore()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        risk.setScore(Predef$.MODULE$.int2Integer(score));
        risk.setTotalScore(Predef$.MODULE$.int2Integer(totalScore));
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(76).append("Finished running risk calculations for release ").append(release.getId()).append(" with score ").append(risk.getScore()).append(" and total score ").append(risk.getTotalScore()).toString());
        return var2_2;
    }

    @Async(value="riskCalculationExecutor")
    public void calculateRiskAndUpdateRelease(String releaseId) {
        Release release = this.releaseRepository.findById(releaseId);
        this.calculateRiskAndUpdateRelease(release);
    }

    @Async(value="riskCalculationExecutor")
    public void calculateRiskAndUpdateRelease(Release release) {
        block1: {
            if (!release.isPlannedOrActive()) break block1;
            Risk risk = this.calculateRisk(release);
            if (this.enabled()) {
                this.updateRisk(release.getId(), risk);
            }
        }
    }

    private void updateRisk(String releaseId, Risk updated) {
        block6: {
            Some some;
            Risk risk;
            boolean bl;
            Option<Risk> maybeOriginal;
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(12).append("UpdateRisk(").append(releaseId).append(")").toString());
            String riskId = new StringBuilder(5).append(releaseId).append("/").append("Risk").toString();
            Option<Risk> option = maybeOriginal = this.riskRepository.read(riskId);
            if (None$.MODULE$.equals(option)) {
                this.riskRepository.create(updated);
                this.logger().info((Function0 & Serializable)() -> new StringBuilder(55).append("Created risk score for release ").append(releaseId).append(": ").append(updated.getScore()).append(" and total risk score ").append(updated.getTotalScore()).toString());
                bl = true;
            } else if (option instanceof Some && (risk = (Risk)((Object)(some = (Some)option).value())) != null) {
                boolean bl2;
                Risk risk2;
                Risk original = risk2 = risk;
                this.riskRepository.update(updated);
                if (this.scoreChanged(original, updated)) {
                    this.logger().info((Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(89).append("Updated risk score for release ").append(releaseId).append(" from ").append(original.getScore()).append(" to ").append(updated.getScore()).append("\n               | and total risk score from ").append(original.getTotalScore()).append(" to ").append(updated.getTotalScore()).toString())));
                    bl2 = true;
                } else {
                    bl2 = false;
                }
                bl = bl2;
            } else {
                throw new MatchError(option);
            }
            boolean doUpdate = bl;
            if (!doUpdate) break block6;
            this.releaseRepository.setRiskScores(releaseId, Predef$.MODULE$.Integer2int(updated.getScore()), Predef$.MODULE$.Integer2int(updated.getTotalScore()));
            this.eventBus.publish((XLReleaseEvent)new RiskScoreUpdated(releaseId, maybeOriginal, updated));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean scoreChanged(Risk a, Risk b) {
        Integer n = a.getScore();
        Integer n2 = b.getScore();
        if (n == null) {
            if (n2 != null) {
                return true;
            }
        } else if (!((Object)n).equals(n2)) return true;
        Integer n3 = a.getTotalScore();
        Integer n4 = b.getTotalScore();
        if (n3 == null) {
            if (n4 == null) return false;
            return true;
        } else if (((Object)n3).equals(n4)) return false;
        return true;
    }

    private String generateRiskId(String releaseId) {
        return new StringBuilder(5).append(releaseId).append("/").append("Risk").toString();
    }

    private String generateAssessorId(String assessorName) {
        return new StringBuilder(1).append(Ids.ROOT_FOLDER_ID).append("/").append(assessorName).toString();
    }

    public String name() {
        return "RiskService";
    }

    public void enable() {
        this.enabled_$eq(true);
    }

    public void disable() {
        this.enabled_$eq(false);
    }

    public boolean isEnabled() {
        return this.enabled();
    }

    public static final /* synthetic */ boolean $anonfun$riskAssessorTypes$1(Type x$1) {
        return !x$1.getDescriptor().isVirtual();
    }

    @Autowired
    public RiskService(RiskRepository riskRepository, RiskProfileService riskProfileService, ReleaseRepository releaseRepository, XLReleaseEventBus eventBus) {
        this.riskRepository = riskRepository;
        this.riskProfileService = riskProfileService;
        this.releaseRepository = releaseRepository;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
        this.enabled = true;
        this.riskAssessorTypes = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(DescriptorRegistry.getSubtypes((Type)Type.valueOf(RiskAssessor.class))).asScala().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RiskService.$anonfun$riskAssessorTypes$1(x$1)))).toList();
    }
}

