/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseExtension;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.PhaseDeletedEvent;
import com.xebialabs.xlrelease.domain.events.PhaseDuplicatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseProgressCalculated;
import com.xebialabs.xlrelease.domain.events.TaskCompletedEvent;
import com.xebialabs.xlrelease.domain.events.TaskCopiedEvent;
import com.xebialabs.xlrelease.domain.events.TaskCreatedEvent;
import com.xebialabs.xlrelease.domain.events.TaskDeletedEvent;
import com.xebialabs.xlrelease.domain.events.TaskSkippedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.risk.domain.progress.ReleaseProgress;
import com.xebialabs.xlrelease.risk.repository.ProgressRepository;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.LockSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Sinks;

@Service
@EventListener
public class ProgressService {
    private static final Logger logger = LoggerFactory.getLogger(ProgressService.class);
    private final XLReleaseEventBus eventBus;
    private final ProgressRepository progressRepository;
    private final Sinks.Many<Release> releaseSink = Sinks.many().unicast().onBackpressureBuffer();

    @Autowired
    public ProgressService(XLReleaseEventBus eventBus, ProgressRepository progressRepository) {
        this.eventBus = eventBus;
        this.progressRepository = progressRepository;
        this.releaseSink.asFlux().map(this::calculateReleaseProgress).map(this::storeProgress).onErrorContinue((e, r) -> {
            if (e instanceof NotFoundException) {
                logger.error("Unable to calculate and store progress because. Reason: {}", (Object)e.getMessage());
            } else {
                logger.error("Unable to calculate and store progress", e);
            }
        }).subscribe();
    }

    private static Sinks.EmitFailureHandler retryOnNonSerializedElse(Sinks.EmitFailureHandler fallback) {
        return (signalType, emitResult) -> {
            if (emitResult == Sinks.EmitResult.FAIL_NON_SERIALIZED) {
                LockSupport.parkNanos(10L);
                return true;
            }
            return fallback.onEmitFailure(signalType, emitResult);
        };
    }

    private static boolean isTaskCompleted(Task task) {
        return task.isDone() || task.isDoneInAdvance();
    }

    @Subscribe
    public void releaseCreated(ReleaseCreatedEvent releaseCreatedEvent) {
        this.updateReleaseProgress(releaseCreatedEvent.release());
    }

    @Subscribe
    public void phaseDuplicated(PhaseDuplicatedEvent phaseDuplicatedEvent) {
        this.updateReleaseProgress(phaseDuplicatedEvent.phaseDuplicate().getRelease());
    }

    @Subscribe
    public void phaseDeleted(PhaseDeletedEvent phaseDeletedEvent) {
        this.updateReleaseProgress(phaseDeletedEvent.phase().getRelease());
    }

    @Subscribe
    public void taskSkipped(TaskSkippedEvent taskSkippedEvent) {
        this.updateReleaseProgress(taskSkippedEvent.task());
    }

    @Subscribe
    public void taskCompleted(TaskCompletedEvent taskCompletedEvent) {
        this.updateReleaseProgress(taskCompletedEvent.task());
    }

    @Subscribe
    public void taskCreated(TaskCreatedEvent taskCreatedEvent) {
        this.updateReleaseProgress(taskCreatedEvent.task());
    }

    @Subscribe
    public void taskDuplicated(TaskCopiedEvent taskCopiedEvent) {
        this.updateReleaseProgress(taskCopiedEvent.taskCopied());
    }

    @Subscribe
    public void taskDeleted(TaskDeletedEvent event) {
        this.updateReleaseProgress(event.task());
    }

    private void updateReleaseProgress(Task task) {
        this.updateReleaseProgress(task.getRelease());
    }

    @Timed
    public void updateReleaseProgress(Release release) {
        if (!release.isTemplate()) {
            Sinks.EmitFailureHandler failureHandler = ProgressService.retryOnNonSerializedElse(Sinks.EmitFailureHandler.FAIL_FAST);
            this.releaseSink.emitNext((Object)release, failureHandler);
        }
    }

    private ReleaseProgressWithReleaseId calculateReleaseProgress(Release release) {
        return new ReleaseProgressWithReleaseId(release.getId(), this.calculateProgress(release));
    }

    private ReleaseProgress calculateProgress(Release release) {
        logger.debug("Calculating progress of release {}", (Object)release.getId());
        List allTasks = release.getAllTasks();
        int totalTasks = allTasks.size();
        int tasksCompleted = (int)allTasks.stream().filter(ProgressService::isTaskCompleted).count();
        ReleaseProgress releaseProgress = new ReleaseProgress();
        releaseProgress.setId(release.getId() + "/progress");
        releaseProgress.setTotalRemainingTasks(totalTasks - tasksCompleted);
        releaseProgress.setTotalTasks(totalTasks);
        HashMap<String, String> phasesProgress = new HashMap<String, String>();
        release.getPhases().forEach(phase -> {
            int totalPhaseTasks = phase.getAllTasks().size();
            int tasksCompletedInPhase = (int)phase.getAllTasks().stream().filter(ProgressService::isTaskCompleted).count();
            phasesProgress.put(phase.getId(), String.format("%d;%d", totalPhaseTasks, tasksCompletedInPhase));
        });
        releaseProgress.setPhasesProgress(phasesProgress);
        return releaseProgress;
    }

    private ReleaseProgress storeProgress(ReleaseProgressWithReleaseId releaseProgressWithReleaseId) {
        ReleaseProgress savedReleaseProgress = this.progressRepository.createOrUpdate(releaseProgressWithReleaseId.getReleaseProgress());
        this.eventBus.publish((XLReleaseEvent)new ReleaseProgressCalculated(releaseProgressWithReleaseId.getReleaseId(), (ReleaseExtension)savedReleaseProgress));
        return savedReleaseProgress;
    }

    protected Sinks.Many<Release> getReleaseSink() {
        return this.releaseSink;
    }

    private static class ReleaseProgressWithReleaseId {
        private final String releaseId;
        private final ReleaseProgress releaseProgress;

        public ReleaseProgressWithReleaseId(String releaseId, ReleaseProgress releaseProgress) {
            this.releaseId = releaseId;
            this.releaseProgress = releaseProgress;
        }

        public String getReleaseId() {
            return this.releaseId;
        }

        public ReleaseProgress getReleaseProgress() {
            return this.releaseProgress;
        }
    }
}

