/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.domain.riskassessors;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.risk.domain.RiskAssessment;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.risk.domain.riskassessors.RiskAssessor;
import java.util.ArrayList;

@PublicApiRef
@Metadata(label="ReleaseStatusFailingRiskAssessor", versioned=false)
public class ReleaseStatusFailingRiskAssessor
extends RiskAssessor {
    private static final String RELEASE_FAILING_HEADLINE = "Release is failing";

    @Override
    public RiskAssessment execute(Release release, RiskProfile riskProfile) {
        RiskAssessment assessment = new RiskAssessment();
        assessment.setRiskAssessorId(this.getId());
        ArrayList<String> messages = new ArrayList<String>();
        if (release.isFailing()) {
            assessment.setScore(riskProfile.getValueFor(this.getType()));
            assessment.setHeadline(RELEASE_FAILING_HEADLINE);
            messages.add(String.format("%s is failing", release.getTitle()));
        } else {
            assessment.setScore(0);
            assessment.setHeadline("Release is on track");
        }
        assessment.setMessages(messages);
        return assessment;
    }
}

