/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseExtension;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.EventBus;
import com.xebialabs.xlrelease.domain.events.PhaseDeletedEvent;
import com.xebialabs.xlrelease.domain.events.PhaseDuplicatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseProgressCalculated;
import com.xebialabs.xlrelease.domain.events.TaskCompletedEvent;
import com.xebialabs.xlrelease.domain.events.TaskCopiedEvent;
import com.xebialabs.xlrelease.domain.events.TaskCreatedEvent;
import com.xebialabs.xlrelease.domain.events.TaskDeletedEvent;
import com.xebialabs.xlrelease.domain.events.TaskReopenedEvent;
import com.xebialabs.xlrelease.domain.events.TaskSkippedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.risk.domain.progress.ReleaseProgress;
import com.xebialabs.xlrelease.risk.repository.ProgressRepository;
import com.xebialabs.xlrelease.risk.service.ReleaseProgressWithReleaseId;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@EventListener
@ScalaSignature(bytes="\u0006\u0001\u0005mf\u0001\u0002\n\u0014\u0001yA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\ti\u0001\u0011\t\u0011)A\u0005k!)Q\b\u0001C\u0001}!)!\u000b\u0001C\u0001'\")!\r\u0001C\u0001G\")!\u000e\u0001C\u0001W\")!\u000f\u0001C\u0001g\")!\u0010\u0001C\u0001w\"9\u0011Q\u0001\u0001\u0005\u0002\u0005\u001d\u0001bBA\u000b\u0001\u0011\u0005\u0011q\u0003\u0005\b\u0003K\u0001A\u0011AA\u0014\u0011\u001d\t)\u0004\u0001C\u0001\u0003oAq!!\u0012\u0001\t\u0003\t9\u0005C\u0004\u0002j\u0001!I!a\u001b\t\u000f\u0005\u0015\u0005\u0001\"\u0003\u0002\b\"9\u00111\u0012\u0001\u0005\n\u00055\u0005bBAI\u0001\u0011%\u00111\u0013\u0002\u0010!J|wM]3tgN+'O^5dK*\u0011A#F\u0001\bg\u0016\u0014h/[2f\u0015\t1r#\u0001\u0003sSN\\'B\u0001\r\u001a\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u001b7\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u00029\u0005\u00191m\\7\u0004\u0001M\u0019\u0001aH\u0013\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\r\u0005s\u0017PU3g!\t13&D\u0001(\u0015\tA\u0013&A\u0003tY\u001a$$NC\u0001+\u0003!9'/\u001b>{Y\u0016$\u0017B\u0001\u0017(\u0005\u001daunZ4j]\u001e\f!\u0003\u001d:pOJ,7o\u001d*fa>\u001c\u0018\u000e^8ssB\u0011qFM\u0007\u0002a)\u0011\u0011'F\u0001\u000be\u0016\u0004xn]5u_JL\u0018BA\u001a1\u0005I\u0001&o\\4sKN\u001c(+\u001a9pg&$xN]=\u0002\u0011\u00154XM\u001c;CkN\u0004\"AN\u001e\u000e\u0003]R!\u0001O\u001d\u0002\r\u00154XM\u001c;t\u0015\tQt#\u0001\u0004e_6\f\u0017N\\\u0005\u0003y]\u0012\u0001\"\u0012<f]R\u0014Uo]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007}\n%\t\u0005\u0002A\u00015\t1\u0003C\u0003.\u0007\u0001\u0007a\u0006C\u00035\u0007\u0001\u0007Q\u0007\u000b\u0002\u0004\tB\u0011Q\tU\u0007\u0002\r*\u0011q\tS\u0001\u000bC:tw\u000e^1uS>t'BA%K\u0003\u001d1\u0017m\u0019;pefT!a\u0013'\u0002\u000b\t,\u0017M\\:\u000b\u00055s\u0015aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003=\u000b1a\u001c:h\u0013\t\tfIA\u0005BkR|w/\u001b:fI\u0006q!/\u001a7fCN,7I]3bi\u0016$GC\u0001+X!\t\u0001S+\u0003\u0002WC\t!QK\\5u\u0011\u0015AF\u00011\u0001Z\u0003M\u0011X\r\\3bg\u0016\u001c%/Z1uK\u0012,e/\u001a8u!\t1$,\u0003\u0002\\o\t\u0019\"+\u001a7fCN,7I]3bi\u0016$WI^3oi\"\u0012A!\u0018\t\u0003=\u0002l\u0011a\u0018\u0006\u0003q]I!!Y0\u0003\u0013M+(m]2sS\n,\u0017a\u00049iCN,G)\u001e9mS\u000e\fG/\u001a3\u0015\u0005Q#\u0007\"B3\u0006\u0001\u00041\u0017\u0001\u00069iCN,G)\u001e9mS\u000e\fG/\u001a3Fm\u0016tG\u000f\u0005\u00027O&\u0011\u0001n\u000e\u0002\u0015!\"\f7/\u001a#va2L7-\u0019;fI\u00163XM\u001c;)\u0005\u0015i\u0016\u0001\u00049iCN,G)\u001a7fi\u0016$GC\u0001+m\u0011\u0015ig\u00011\u0001o\u0003E\u0001\b.Y:f\t\u0016dW\r^3e\u000bZ,g\u000e\u001e\t\u0003m=L!\u0001]\u001c\u0003#AC\u0017m]3EK2,G/\u001a3Fm\u0016tG\u000f\u000b\u0002\u0007;\u0006YA/Y:l'.L\u0007\u000f]3e)\t!F\u000fC\u0003v\u000f\u0001\u0007a/\u0001\tuCN\\7k[5qa\u0016$WI^3oiB\u0011ag^\u0005\u0003q^\u0012\u0001\u0003V1tWN[\u0017\u000e\u001d9fI\u00163XM\u001c;)\u0005\u001di\u0016!\u0004;bg.\u001cu.\u001c9mKR,G\r\u0006\u0002Uy\")Q\u0010\u0003a\u0001}\u0006\u0011B/Y:l\u0007>l\u0007\u000f\\3uK\u0012,e/\u001a8u!\t1t0C\u0002\u0002\u0002]\u0012!\u0003V1tW\u000e{W\u000e\u001d7fi\u0016$WI^3oi\"\u0012\u0001\"X\u0001\fi\u0006\u001c8n\u0011:fCR,G\rF\u0002U\u0003\u0013Aq!a\u0003\n\u0001\u0004\ti!\u0001\tuCN\\7I]3bi\u0016$WI^3oiB\u0019a'a\u0004\n\u0007\u0005EqG\u0001\tUCN\\7I]3bi\u0016$WI^3oi\"\u0012\u0011\"X\u0001\u000fi\u0006\u001c8\u000eR;qY&\u001c\u0017\r^3e)\r!\u0016\u0011\u0004\u0005\b\u00037Q\u0001\u0019AA\u000f\u0003=!\u0018m]6D_BLW\rZ#wK:$\bc\u0001\u001c\u0002 %\u0019\u0011\u0011E\u001c\u0003\u001fQ\u000b7o[\"pa&,G-\u0012<f]RD#AC/\u0002\u0017Q\f7o\u001b#fY\u0016$X\r\u001a\u000b\u0004)\u0006%\u0002bBA\u0016\u0017\u0001\u0007\u0011QF\u0001\u0011i\u0006\u001c8\u000eR3mKR,G-\u0012<f]R\u00042ANA\u0018\u0013\r\t\td\u000e\u0002\u0011)\u0006\u001c8\u000eR3mKR,G-\u0012<f]RD#aC/\u0002\u0019Q\f7o\u001b*f_B,g.\u001a3\u0015\u0007Q\u000bI\u0004C\u0004\u0002<1\u0001\r!!\u0010\u0002#Q\f7o\u001b*f_B,g.\u001a3Fm\u0016tG\u000fE\u00027\u0003\u007fI1!!\u00118\u0005E!\u0016m]6SK>\u0004XM\\3e\u000bZ,g\u000e\u001e\u0015\u0003\u0019u\u000bQ#\u001e9eCR,'+\u001a7fCN,\u0007K]8he\u0016\u001c8\u000fF\u0002U\u0003\u0013Bq!a\u0013\u000e\u0001\u0004\ti%A\u0004sK2,\u0017m]3\u0011\t\u0005=\u0013\u0011K\u0007\u0002s%\u0019\u00111K\u001d\u0003\u000fI+G.Z1tK\"\u001aQ\"a\u0016\u0011\t\u0005e\u0013QM\u0007\u0003\u00037R1aRA/\u0015\u0011\ty&!\u0019\u0002\u000f5,GO]5dg*\u0019\u00111M\u000e\u0002\u0011\r|G-\u00195bY\u0016LA!a\u001a\u0002\\\t)A+[7fI\u0006i1\u000f^8sKB\u0013xn\u001a:fgN$B!!\u001c\u0002|A!\u0011qNA<\u001b\t\t\tH\u0003\u0003\u0002t\u0005U\u0014\u0001\u00039s_\u001e\u0014Xm]:\u000b\u0005i*\u0012\u0002BA=\u0003c\u0012qBU3mK\u0006\u001cX\r\u0015:pOJ,7o\u001d\u0005\b\u0003{r\u0001\u0019AA@\u0003q\u0011X\r\\3bg\u0016\u0004&o\\4sKN\u001cx+\u001b;i%\u0016dW-Y:f\u0013\u0012\u00042\u0001QAA\u0013\r\t\u0019i\u0005\u0002\u001d%\u0016dW-Y:f!J|wM]3tg^KG\u000f\u001b*fY\u0016\f7/Z%e\u0003a\u0019\u0017\r\\2vY\u0006$XMU3mK\u0006\u001cX\r\u0015:pOJ,7o\u001d\u000b\u0005\u0003\u007f\nI\tC\u0004\u0002L=\u0001\r!!\u0014\u0002#\r\fGnY;mCR,\u0007K]8he\u0016\u001c8\u000f\u0006\u0003\u0002n\u0005=\u0005bBA&!\u0001\u0007\u0011QJ\u0001\u0010SN$\u0016m]6D_6\u0004H.\u001a;fIR!\u0011QSAN!\r\u0001\u0013qS\u0005\u0004\u00033\u000b#a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003;\u000b\u0002\u0019AAP\u0003\u0011!\u0018m]6\u0011\t\u0005=\u0013\u0011U\u0005\u0004\u0003GK$\u0001\u0002+bg.D3\u0001AAT!\rq\u0016\u0011V\u0005\u0004\u0003W{&!D#wK:$H*[:uK:,'\u000fK\u0002\u0001\u0003_\u0003B!!-\u000286\u0011\u00111\u0017\u0006\u0004\u0003kc\u0015AC:uKJ,w\u000e^=qK&!\u0011\u0011XAZ\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class ProgressService
implements Logging {
    private final ProgressRepository progressRepository;
    private final EventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ProgressService progressService = this;
        synchronized (progressService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Subscribe
    public void releaseCreated(ReleaseCreatedEvent releaseCreatedEvent) {
        this.updateReleaseProgress(releaseCreatedEvent.release());
    }

    @Subscribe
    public void phaseDuplicated(PhaseDuplicatedEvent phaseDuplicatedEvent) {
        this.updateReleaseProgress(phaseDuplicatedEvent.phaseDuplicate().getRelease());
    }

    @Subscribe
    public void phaseDeleted(PhaseDeletedEvent phaseDeletedEvent) {
        this.updateReleaseProgress(phaseDeletedEvent.phase().getRelease());
    }

    @Subscribe
    public void taskSkipped(TaskSkippedEvent taskSkippedEvent) {
        this.updateReleaseProgress(taskSkippedEvent.task().getRelease());
    }

    @Subscribe
    public void taskCompleted(TaskCompletedEvent taskCompletedEvent) {
        this.updateReleaseProgress(taskCompletedEvent.task().getRelease());
    }

    @Subscribe
    public void taskCreated(TaskCreatedEvent taskCreatedEvent) {
        this.updateReleaseProgress(taskCreatedEvent.task().getRelease());
    }

    @Subscribe
    public void taskDuplicated(TaskCopiedEvent taskCopiedEvent) {
        this.updateReleaseProgress(taskCopiedEvent.task().getRelease());
    }

    @Subscribe
    public void taskDeleted(TaskDeletedEvent taskDeletedEvent) {
        this.updateReleaseProgress(taskDeletedEvent.task().getRelease());
    }

    @Subscribe
    public void taskReopened(TaskReopenedEvent taskReopenedEvent) {
        this.updateReleaseProgress(taskReopenedEvent.task().getRelease());
    }

    @Timed
    public void updateReleaseProgress(Release release) {
        block0: {
            if (release.isTemplate()) break block0;
            ReleaseProgressWithReleaseId releaseProgressWithId = this.calculateReleaseProgress(release);
            this.storeProgress(releaseProgressWithId);
        }
    }

    /*
     * WARNING - void declaration
     */
    private ReleaseProgress storeProgress(ReleaseProgressWithReleaseId releaseProgressWithReleaseId) {
        void var2_2;
        ReleaseProgress savedReleaseProgress = this.progressRepository.createOrUpdate(releaseProgressWithReleaseId.releaseProgress());
        this.eventBus.publish((XLReleaseEvent)new ReleaseProgressCalculated(releaseProgressWithReleaseId.releaseId(), (ReleaseExtension)savedReleaseProgress));
        return var2_2;
    }

    private ReleaseProgressWithReleaseId calculateReleaseProgress(Release release) {
        return new ReleaseProgressWithReleaseId(release.getId(), this.calculateProgress(release));
    }

    private ReleaseProgress calculateProgress(Release release) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Calculating progress of release ").append(release.getId()).toString());
        List allTasks = release.getAllTasks();
        int totalTasks = allTasks.size();
        int tasksCompleted = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(allTasks).asScala()).count((Function1 & Serializable & scala.Serializable)task -> BoxesRunTime.boxToBoolean((boolean)this.isTaskCompleted(task)));
        ReleaseProgress releaseProgress = new ReleaseProgress();
        releaseProgress.setId(new StringBuilder(9).append(release.getId()).append("/progress").toString());
        releaseProgress.setTotalRemainingTasks(totalTasks - tasksCompleted);
        releaseProgress.setTotalTasks(totalTasks);
        scala.collection.immutable.Map phasesProgress = (scala.collection.immutable.Map)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(release.getPhases()).asScala()).foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            scala.collection.immutable.Map acc = (scala.collection.immutable.Map)tuple2._1();
            Phase phase = (Phase)tuple2._2();
            int totalPhaseTasks = phase.getAllTasks().size();
            int tasksCompletedInPhase = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(phase.getAllTasks()).asScala()).count((Function1 & Serializable & scala.Serializable)task -> BoxesRunTime.boxToBoolean((boolean)this.isTaskCompleted(task)));
            scala.collection.immutable.Map map = acc.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)phase.getId()), (Object)new StringBuilder(1).append(totalPhaseTasks).append(";").append(tasksCompletedInPhase).toString()));
            return map;
        });
        releaseProgress.setPhasesProgress((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)phasesProgress).asJava());
        return releaseProgress;
    }

    private boolean isTaskCompleted(Task task) {
        return task.isDone() || task.isDoneInAdvance();
    }

    @Autowired
    public ProgressService(ProgressRepository progressRepository, EventBus eventBus) {
        this.progressRepository = progressRepository;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

