/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.group;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.internal.InternalMetadata;
import com.xebialabs.xlrelease.domain.CiWithInternalMetadata;
import com.xebialabs.xlrelease.domain.group.ReleaseGroupStatus;
import com.xebialabs.xlrelease.repository.Ids;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(root=Metadata.ConfigurationItemRoot.APPLICATIONS, versioned=false, description="A grouping of multiple releases.")
public class ReleaseGroup
extends BaseConfigurationItem
implements CiWithInternalMetadata {
    public static final String GROUP_ROOT = Metadata.ConfigurationItemRoot.APPLICATIONS.getRootNodeName();
    private Map<String, InternalMetadata> $metadata = new LinkedHashMap<String, InternalMetadata>();
    @Property(description="Symbolic name for the release group.")
    private String title;
    @Property(description="The state the release group is in.")
    private ReleaseGroupStatus status = ReleaseGroupStatus.PLANNED;
    @Property(required=false, description="The expected start date.")
    protected Date startDate;
    @Property(required=false, description="The expected end date.")
    protected Date endDate;
    @Property(defaultValue="0", description="The worst risk score of the contained releases.")
    private Integer riskScore = 0;
    @Property(required=false, description="List of releases contained by this release group.")
    private Set<String> releaseIds = new HashSet<String>();
    @Property(required=false, description="Release group progress")
    private Integer progress = 0;
    @Property(required=false, isTransient=true, description="Folder that the release group belongs to")
    private String folderId;

    @PublicApiMember
    public String getTitle() {
        return this.title;
    }

    @PublicApiMember
    public void setTitle(String title) {
        this.title = title;
    }

    @PublicApiMember
    public ReleaseGroupStatus getStatus() {
        return this.status;
    }

    @PublicApiMember
    public void setStatus(ReleaseGroupStatus status) {
        this.status = status;
    }

    @PublicApiMember
    public Date getStartDate() {
        return this.startDate;
    }

    @PublicApiMember
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @PublicApiMember
    public Date getEndDate() {
        return this.endDate;
    }

    @PublicApiMember
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @PublicApiMember
    public Integer getRiskScore() {
        return this.riskScore;
    }

    @PublicApiMember
    public void setRiskScore(Integer riskScore) {
        this.riskScore = riskScore;
    }

    @PublicApiMember
    public Set<String> getReleaseIds() {
        return this.releaseIds;
    }

    public void removeReleaseIds(List<String> idsToRemove) {
        List strippedIds = idsToRemove.stream().map(Ids::getName).collect(Collectors.toList());
        this.releaseIds = this.releaseIds.stream().filter(id -> !strippedIds.contains(Ids.getName((String)id))).collect(Collectors.toSet());
    }

    @PublicApiMember
    public void setReleaseIds(Set<String> releaseIds) {
        this.releaseIds = releaseIds;
    }

    @PublicApiMember
    public Integer getProgress() {
        return this.progress;
    }

    @PublicApiMember
    public void setProgress(Integer progress) {
        this.progress = progress;
    }

    public boolean isUpdatable() {
        return !ReleaseGroupStatus.COMPLETED.equals((Object)this.status) && !ReleaseGroupStatus.ABORTED.equals((Object)this.status);
    }

    @PublicApiMember
    public String getFolderId() {
        return this.folderId;
    }

    @PublicApiMember
    public void setFolderId(String folderId) {
        this.folderId = folderId;
    }

    public Map<String, InternalMetadata> get$metadata() {
        return this.$metadata;
    }
}

