/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseGroupFilters;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseGroupOrderMode;
import com.xebialabs.xlrelease.api.v1.views.ReleaseGroupTimeline;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.group.ReleaseGroup;
import com.xebialabs.xlrelease.domain.group.ReleaseGroupStatus;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.events.ReleaseGroupCreatedEvent;
import com.xebialabs.xlrelease.events.ReleaseGroupDeletedEvent;
import com.xebialabs.xlrelease.events.ReleaseGroupUpdatedEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.ReleaseGroupRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.CiIdWithTitle;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseGroupTimelineCalculator;
import com.xebialabs.xlrelease.service.ReleaseService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.SetLike;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@Service
@ScalaSignature(bytes="\u0006\u0001\rUa\u0001B\u0001\u0003\u0001-\u00111CU3mK\u0006\u001cXm\u0012:pkB\u001cVM\u001d<jG\u0016T!a\u0001\u0003\u0002\u000fM,'O^5dK*\u0011QAB\u0001\nq2\u0014X\r\\3bg\u0016T!a\u0002\u0005\u0002\u0013a,'-[1mC\n\u001c(\"A\u0005\u0002\u0007\r|Wn\u0001\u0001\u0014\t\u0001a!C\u0007\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005MAR\"\u0001\u000b\u000b\u0005U1\u0012!B:mMRR'\"A\f\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!!\u0007\u000b\u0003\u000f1{wmZ5oOB\u00111\u0004H\u0007\u0002\u0005%\u0011QD\u0001\u0002\u001f%\u0016dW-Y:f\u000fJ|W\u000f\u001d+j[\u0016d\u0017N\\3DC2\u001cW\u000f\\1u_JD\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001I\u0001\u0017e\u0016dW-Y:f\u000fJ|W\u000f\u001d*fa>\u001c\u0018\u000e^8ssB\u0011\u0011\u0005J\u0007\u0002E)\u00111\u0005B\u0001\u000be\u0016\u0004xn]5u_JL\u0018BA\u0013#\u0005Y\u0011V\r\\3bg\u0016<%o\\;q%\u0016\u0004xn]5u_JL\b\u0002C\u0014\u0001\u0005\u000b\u0007I\u0011\u0001\u0015\u0002#I,G.Z1tKJ+\u0007o\\:ji>\u0014\u00180F\u0001*!\t\t#&\u0003\u0002,E\t\t\"+\u001a7fCN,'+\u001a9pg&$xN]=\t\u00115\u0002!\u0011!Q\u0001\n%\n!C]3mK\u0006\u001cXMU3q_NLGo\u001c:zA!Aq\u0006\u0001BC\u0002\u0013\u0005\u0001'\u0001\bsK2,\u0017m]3TKJ4\u0018nY3\u0016\u0003E\u0002\"a\u0007\u001a\n\u0005M\u0012!A\u0004*fY\u0016\f7/Z*feZL7-\u001a\u0005\tk\u0001\u0011\t\u0011)A\u0005c\u0005y!/\u001a7fCN,7+\u001a:wS\u000e,\u0007\u0005\u0003\u00058\u0001\t\u0005\t\u0015!\u00039\u0003-\u0019\u0017.\u00133TKJ4\u0018nY3\u0011\u0005mI\u0014B\u0001\u001e\u0003\u0005-\u0019\u0015.\u00133TKJ4\u0018nY3\t\u0011q\u0002!\u0011!Q\u0001\nu\n\u0001#\u0019:dQ&4X\r\u001a*fY\u0016\f7/Z:\u0011\u0005y\nU\"A \u000b\u0005\u0001#\u0011A\u00013c\u0013\t\u0011uH\u0001\tBe\u000eD\u0017N^3e%\u0016dW-Y:fg\"AA\t\u0001B\u0001B\u0003%Q)A\u0007g_2$WM]*feZL7-\u001a\t\u00037\u0019K!a\u0012\u0002\u0003\u001b\u0019{G\u000eZ3s'\u0016\u0014h/[2f\u0011!I\u0005A!A!\u0002\u0013Q\u0015a\u0003:pY\u0016\u001cVM\u001d<jG\u0016\u0004\"a\u0013)\u000e\u00031S!!\u0014(\u0002\u0011M,7-\u001e:jifT!a\u0014\u0004\u0002\u0011\u0011,\u0007\u000f\\8zSRL!!\u0015'\u0003\u0017I{G.Z*feZL7-\u001a\u0005\t'\u0002\u0011)\u0019!C\u0001)\u0006AQM^3oi\n+8/F\u0001V!\t1\u0016,D\u0001X\u0015\tAF!\u0001\u0004fm\u0016tGo]\u0005\u00035^\u0013\u0011\u0003\u0017'SK2,\u0017m]3Fm\u0016tGOQ;t\u0011!a\u0006A!A!\u0002\u0013)\u0016!C3wK:$()^:!\u0011\u0015q\u0006\u0001\"\u0001`\u0003\u0019a\u0014N\\5u}QI\u0001-\u00192dI\u00164w\r\u001b\t\u00037\u0001AQaH/A\u0002\u0001BQaJ/A\u0002%BQaL/A\u0002EBQaN/A\u0002aBQ\u0001P/A\u0002uBQ\u0001R/A\u0002\u0015CQ!S/A\u0002)CQaU/A\u0002UC#!\u00186\u0011\u0005-4X\"\u00017\u000b\u00055t\u0017AC1o]>$\u0018\r^5p]*\u0011q\u000e]\u0001\bM\u0006\u001cGo\u001c:z\u0015\t\t(/A\u0003cK\u0006t7O\u0003\u0002ti\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001v\u0003\ry'oZ\u0005\u0003o2\u0014\u0011\"Q;u_^L'/\u001a3\t\u000be\u0004A\u0011\u0001>\u0002\u0011\u001d,Go\u0012:pkB$2a_A\u0004!\ra\u00181A\u0007\u0002{*\u0011ap`\u0001\u0006OJ|W\u000f\u001d\u0006\u0004\u0003\u0003!\u0011A\u00023p[\u0006Lg.C\u0002\u0002\u0006u\u0014ABU3mK\u0006\u001cXm\u0012:pkBDq!!\u0003y\u0001\u0004\tY!A\u0004he>,\b/\u00133\u0011\t\u00055\u00111\u0004\b\u0005\u0003\u001f\t9\u0002E\u0002\u0002\u00129i!!a\u0005\u000b\u0007\u0005U!\"\u0001\u0004=e>|GOP\u0005\u0004\u00033q\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002\u001e\u0005}!AB*ue&twMC\u0002\u0002\u001a9A3\u0001_A\u0012!\u0011\t)#!\r\u000e\u0005\u0005\u001d\"bA7\u0002*)!\u00111FA\u0017\u0003\u001diW\r\u001e:jGNT1!a\f\t\u0003!\u0019w\u000eZ1iC2,\u0017\u0002BA\u001a\u0003O\u0011Q\u0001V5nK\u0012Dq!a\u000e\u0001\t\u0003\tI$A\u0006fq&\u001cHo]$s_V\u0004H\u0003BA\u001e\u0003\u0003\u00022!DA\u001f\u0013\r\tyD\u0004\u0002\b\u0005>|G.Z1o\u0011!\tI!!\u000eA\u0002\u0005-\u0001\u0006BA\u001b\u0003GAq!a\u0012\u0001\t\u0003\tI%A\u0006de\u0016\fG/Z$s_V\u0004HcA>\u0002L!9\u0011QJA#\u0001\u0004Y\u0018\u0001\u0004:fY\u0016\f7/Z$s_V\u0004\b\u0006BA#\u0003GAq!a\u0015\u0001\t\u0003\t)&A\u0006va\u0012\fG/Z$s_V\u0004HcA>\u0002X!9\u0011QJA)\u0001\u0004Y\b\u0006BA)\u0003GAq!!\u0018\u0001\t\u0003\ty&A\u0006eK2,G/Z$s_V\u0004H\u0003BA1\u0003O\u00022!DA2\u0013\r\t)G\u0004\u0002\u0005+:LG\u000f\u0003\u0005\u0002\n\u0005m\u0003\u0019AA\u0006Q\u0011\tY&a\t\t\u000f\u00055\u0004\u0001\"\u0001\u0002p\u0005\t\u0012\r\u001a3NK6\u0014WM]:U_\u001e\u0013x.\u001e9\u0015\r\u0005\u0005\u0014\u0011OA:\u0011!\tI!a\u001bA\u0002\u0005-\u0001\u0002CA;\u0003W\u0002\r!a\u001e\u0002\u00135,WNY3s\u0013\u0012\u001c\bCBA=\u0003\u0007\u000bYA\u0004\u0003\u0002|\u0005}d\u0002BA\t\u0003{J\u0011aD\u0005\u0004\u0003\u0003s\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003\u000b\u000b9IA\u0002TKFT1!!!\u000fQ\u0011\tY'a\t\t\u000f\u00055\u0005\u0001\"\u0001\u0002\u0010\u00061\"/Z7pm\u0016lU-\u001c2feN4%o\\7He>,\b\u000f\u0006\u0004\u0002b\u0005E\u00151\u0013\u0005\t\u0003\u0013\tY\t1\u0001\u0002\f!A\u0011QOAF\u0001\u0004\t9\b\u000b\u0003\u0002\f\u0006\r\u0002bBAM\u0001\u0011\u0005\u00111T\u0001\u0007g\u0016\f'o\u00195\u0015\u0011\u0005u\u0015QVAc\u0003\u001f\u0004R!a(\u0002*nl!!!)\u000b\t\u0005\r\u0016QU\u0001\u0005kRLGN\u0003\u0002\u0002(\u0006!!.\u0019<b\u0013\u0011\tY+!)\u0003\t1K7\u000f\u001e\u0005\t\u0003_\u000b9\n1\u0001\u00022\u00069a-\u001b7uKJ\u001c\b\u0003BAZ\u0003\u0003l!!!.\u000b\t\u0005]\u0016\u0011X\u0001\u0006M>\u0014Xn\u001d\u0006\u0005\u0003w\u000bi,\u0001\u0002wc)\u0019\u0011q\u0018\u0003\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002D\u0006U&a\u0005*fY\u0016\f7/Z$s_V\u0004h)\u001b7uKJ\u001c\b\u0002CAd\u0003/\u0003\r!!3\u0002\tA\fw-\u001a\t\u0004C\u0005-\u0017bAAgE\t!\u0001+Y4f\u0011!\t\t.a&A\u0002\u0005M\u0017aB8sI\u0016\u0014()\u001f\t\u0005\u0003g\u000b).\u0003\u0003\u0002X\u0006U&!\u0006*fY\u0016\f7/Z$s_V\u0004xJ\u001d3fe6{G-\u001a\u0015\u0005\u0003/\u000b\u0019\u0003C\u0004\u0002^\u0002!\t!a8\u0002\u0017\u001d,G\u000fV5nK2Lg.\u001a\u000b\u0007\u0003C\fi/a<\u0011\t\u0005\r\u0018\u0011^\u0007\u0003\u0003KTA!a:\u0002:\u0006)a/[3xg&!\u00111^As\u0005Q\u0011V\r\\3bg\u0016<%o\\;q)&lW\r\\5oK\"A\u0011\u0011BAn\u0001\u0004\tY\u0001\u0003\u0005\u0002r\u0006m\u0007\u0019AAz\u0003\rqwn\u001e\t\u0005\u0003k\fy0\u0004\u0002\u0002x*!\u0011\u0011`A~\u0003\u0011!\u0018.\\3\u000b\u0007\u0005uH/\u0001\u0003k_\u0012\f\u0017\u0002\u0002B\u0001\u0003o\u0014\u0001\u0002R1uKRKW.\u001a\u0015\u0005\u00037\f\u0019\u0003C\u0004\u0003\b\u0001!\tA!\u0003\u0002#U\u0004H-\u0019;f\u000fJ|W\u000f]*uCR,8\u000f\u0006\u0003\u0002b\t-\u0001\u0002CA\u0005\u0005\u000b\u0001\r!a\u0003)\t\t\u0015\u00111\u0005\u0005\b\u0005#\u0001A\u0011\u0001B\n\u0003=)\b\u000fZ1uK\u001e\u0013x.\u001e9SSN\\G\u0003BA1\u0005+A\u0001\"!\u0003\u0003\u0010\u0001\u0007\u00111\u0002\u0015\u0005\u0005\u001f\t\u0019\u0003C\u0004\u0003\u001c\u0001!IA!\b\u0002)I,7-\u00197dk2\fG/\u001a*jg.\u001c6m\u001c:f)\u0011\t\tGa\b\t\u000f\u00055#\u0011\u0004a\u0001w\"9!1\u0005\u0001\u0005\u0002\t\u0015\u0012\u0001F4fiJ+G.Z1tKJK7o[*d_J,7\u000f\u0006\u0003\u0003(\t=\u0002CBA=\u0003\u0007\u0013I\u0003E\u0002\u000e\u0005WI1A!\f\u000f\u0005\rIe\u000e\u001e\u0005\t\u0005c\u0011\t\u00031\u0001\u0002x\u0005Q!/\u001a7fCN,\u0017\nZ:\t\u000f\tU\u0002\u0001\"\u0001\u00038\u0005Yq-\u001a;G_2$WM]%e)\u0011\tYA!\u000f\t\u0011\u0005%!1\u0007a\u0001\u0003\u0017AqA!\u0010\u0001\t\u0003\u0011y$\u0001\u000fgS:$wI]8vaN\u0014VMZ3sK:\u001c\u0017N\\4SK2,\u0017m]3\u0015\t\u0005]$\u0011\t\u0005\t\u0005\u0007\u0012Y\u00041\u0001\u0002\f\u0005I!/\u001a7fCN,\u0017\n\u001a\u0015\u0005\u0005w\t\u0019\u0003C\u0004\u0003J\u0001!\tAa\u0013\u0002C\u0019Lg\u000eZ!di&4Xm\u0012:pkB\u001c(+\u001a4fe\u0016t7-\u001b8h\r>dG-\u001a:\u0015\t\t5#q\f\t\u0007\u0003s\n\u0019Ia\u0014\u0011\t\tE#1L\u0007\u0003\u0005'RAA!\u0016\u0003X\u0005Y\u0001/\u001a:tSN$XM\\2f\u0015\r\u0011IFI\u0001\u0004gFd\u0017\u0002\u0002B/\u0005'\u0012QbQ5JI^KG\u000f\u001b+ji2,\u0007\u0002\u0003B1\u0005\u000f\u0002\r!a\u0003\u0002\u0011\u0019|G\u000eZ3s\u0013\u0012DCAa\u0012\u0002$!9!q\r\u0001\u0005\n\t%\u0014\u0001\b:fG\u0006d7-\u001e7bi\u0016\u001cF/\u0019;vg\u0006sG\r\u0015:pOJ,7o\u001d\u000b\u0005\u0003C\u0012Y\u0007C\u0004\u0002N\t\u0015\u0004\u0019A>\t\u000f\t=\u0004\u0001\"\u0003\u0003r\u0005\u0011r-\u001a;SK2,\u0017m]3Ti\u0006$Xo]3t)\u0011\u0011\u0019H!!\u0011\r\u0005e\u00141\u0011B;!\u0011\u00119H! \u000e\u0005\te$b\u0001B>\u007f\u000611\u000f^1ukNLAAa \u0003z\ti!+\u001a7fCN,7\u000b^1ukND\u0001B!\r\u0003n\u0001\u0007\u0011q\u000f\u0005\b\u0005\u000b\u0003A\u0011\u0002BD\u0003Y\u0019\u0017\r\\2vY\u0006$Xm\u0012:pkB\u0004&o\\4sKN\u001cH\u0003\u0002BE\u0005+\u0003BAa#\u0003\u00126\u0011!Q\u0012\u0006\u0005\u0005\u001f\u000b)+\u0001\u0003mC:<\u0017\u0002\u0002BJ\u0005\u001b\u0013q!\u00138uK\u001e,'\u000f\u0003\u0005\u0003\u0018\n\r\u0005\u0019\u0001B:\u0003!\u0019H/\u0019;vg\u0016\u001c\bb\u0002BN\u0001\u0011%!QT\u0001\u0015G\u0006d7-\u001e7bi\u0016<%o\\;q'R\fG/^:\u0015\r\t}%Q\u0015BT!\ra(\u0011U\u0005\u0004\u0005Gk(A\u0005*fY\u0016\f7/Z$s_V\u00048\u000b^1ukNDq!!\u0014\u0003\u001a\u0002\u00071\u0010\u0003\u0005\u0003\u0018\ne\u0005\u0019\u0001B:\u0011\u001d\u0011Y\u000b\u0001C\u0005\u0005[\u000b\u0001c\u00195fG.L5/\u00169eCR\f'\r\\3\u0015\r\u0005\u0005$q\u0016BZ\u0011\u001d\u0011\tL!+A\u0002m\fQ\"\u001a=jgRLgnZ$s_V\u0004\bB\u0003B[\u0005S\u0003\n\u00111\u0001\u0002\f\u00051\u0011m\u0019;j_:DqA!/\u0001\t\u0013\u0011Y,\u0001\u0005wC2LG-\u0019;f)\u0011\t\tG!0\t\u000f\u00055#q\u0017a\u0001w\"9!\u0011\u0019\u0001\u0005\n\t\r\u0017A\u0004<bY&$\u0017\r^3NK6\u0014WM\u001d\u000b\u0005\u0003C\u0012)\r\u0003\u0005\u0003D\t}\u0006\u0019AA\u0006\u0011\u001d\u0011I\r\u0001C\u0005\u0005\u0017\f\u0011cY;se\u0016tG\u000f\u0015:j]\u000eL\u0007/\u00197t+\t\u0011i\r\u0005\u0004\u0003P\nU'\u0011\\\u0007\u0003\u0005#T1Aa5\u000f\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005/\u0014\tN\u0001\u0005Ji\u0016\u0014\u0018M\u00197f!\u0011\u0011YIa7\n\t\u0005u!Q\u0012\u0005\b\u0005?\u0004A\u0011\u0002Bq\u00039\u0019WO\u001d:f]R\u0014v\u000e\\3JIN,\"Aa9\u0011\r\t\u0015(1\u001eBm\u001b\t\u00119O\u0003\u0003\u0003j\nE\u0017aB7vi\u0006\u0014G.Z\u0005\u0005\u0005[\u00149O\u0001\u0004Ck\u001a4WM\u001d\u0005\n\u0005c\u0004\u0011\u0013!C\u0005\u0005g\f!d\u00195fG.L5/\u00169eCR\f'\r\\3%I\u00164\u0017-\u001e7uII*\"A!>+\t\u0005-!q_\u0016\u0003\u0005s\u0004BAa?\u0004\u00045\u0011!Q \u0006\u0005\u0005\u007f\u001c\t!A\u0005v]\u000eDWmY6fI*\u0011QND\u0005\u0005\u0007\u000b\u0011iPA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D3\u0001AB\u0005!\u0011\u0019Ya!\u0005\u000e\u0005\r5!bAB\be\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\rM1Q\u0002\u0002\b'\u0016\u0014h/[2f\u0001")
public class ReleaseGroupService
implements ReleaseGroupTimelineCalculator {
    private final ReleaseGroupRepository releaseGroupRepository;
    private final ReleaseRepository releaseRepository;
    private final ReleaseService releaseService;
    private final CiIdService ciIdService;
    private final ArchivedReleases archivedReleases;
    private final FolderService folderService;
    private final RoleService roleService;
    private final XLReleaseEventBus eventBus;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    @Override
    public ReleaseGroupTimeline calculateTimeline(ReleaseGroup releaseGroup, DateTime now) {
        return ReleaseGroupTimelineCalculator.calculateTimeline$(this, releaseGroup, now);
    }

    @Override
    public <A extends DateTime> Ordering<A> dateOrdering() {
        return ReleaseGroupTimelineCalculator.dateOrdering$(this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReleaseGroupService releaseGroupService = this;
        synchronized (releaseGroupService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    @Override
    public ReleaseService releaseService() {
        return this.releaseService;
    }

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    @Timed
    public ReleaseGroup getGroup(String groupId) {
        return this.releaseGroupRepository.read(groupId);
    }

    @Timed
    public boolean existsGroup(String groupId) {
        return this.releaseGroupRepository.exists(groupId);
    }

    @Timed
    public ReleaseGroup createGroup(ReleaseGroup releaseGroup) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating new release group [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseGroup})));
        this.validate(releaseGroup);
        releaseGroup.setId(this.ciIdService.getUniqueId(Type.valueOf(ReleaseGroup.class), ReleaseGroup.GROUP_ROOT));
        this.recalculateStatusAndProgress(releaseGroup);
        this.recalculateRiskScore(releaseGroup);
        this.releaseGroupRepository.create(releaseGroup);
        this.eventBus().publish((XLReleaseEvent)new ReleaseGroupCreatedEvent(releaseGroup));
        return releaseGroup;
    }

    @Timed
    public ReleaseGroup updateGroup(ReleaseGroup releaseGroup) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updating release group [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseGroup})));
        this.validate(releaseGroup);
        this.checkIsUpdatable(this.releaseGroupRepository.read(releaseGroup.getId()), this.checkIsUpdatable$default$2());
        this.recalculateStatusAndProgress(releaseGroup);
        this.recalculateRiskScore(releaseGroup);
        this.releaseGroupRepository.update(releaseGroup);
        this.eventBus().publish((XLReleaseEvent)new ReleaseGroupUpdatedEvent(releaseGroup));
        return releaseGroup;
    }

    @Timed
    public void deleteGroup(String groupId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting release group [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{groupId})));
        if (this.releaseGroupRepository.exists(groupId)) {
            ReleaseGroup releaseGroup = this.releaseGroupRepository.read(groupId);
            this.checkIsUpdatable(releaseGroup, "delete");
            this.releaseGroupRepository.delete(groupId);
            this.eventBus().publish((XLReleaseEvent)new ReleaseGroupDeletedEvent(releaseGroup));
        } else {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Release group [", "] already deleted"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{groupId})));
        }
    }

    @Timed
    public void addMembersToGroup(String groupId, Seq<String> memberIds) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Adding members ", " to release group [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{memberIds, groupId})));
        memberIds.foreach((Function1 & Serializable & scala.Serializable)releaseId -> {
            this.validateMember(releaseId);
            return BoxedUnit.UNIT;
        });
        ReleaseGroup releaseGroup = this.releaseGroupRepository.read(groupId);
        this.checkIsUpdatable(releaseGroup, this.checkIsUpdatable$default$2());
        releaseGroup.getReleaseIds().addAll((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(memberIds).asJava());
        this.recalculateStatusAndProgress(releaseGroup);
        this.recalculateRiskScore(releaseGroup);
        this.releaseGroupRepository.update(releaseGroup);
        this.eventBus().publish((XLReleaseEvent)new ReleaseGroupUpdatedEvent(releaseGroup));
    }

    @Timed
    public void removeMembersFromGroup(String groupId, Seq<String> memberIds) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removing members ", " from release group [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{memberIds, groupId})));
        ReleaseGroup releaseGroup = this.releaseGroupRepository.read(groupId);
        this.checkIsUpdatable(releaseGroup, this.checkIsUpdatable$default$2());
        releaseGroup.removeReleaseIds((List)JavaConverters$.MODULE$.seqAsJavaListConverter(memberIds).asJava());
        this.recalculateStatusAndProgress(releaseGroup);
        this.recalculateRiskScore(releaseGroup);
        this.releaseGroupRepository.update(releaseGroup);
        this.eventBus().publish((XLReleaseEvent)new ReleaseGroupUpdatedEvent(releaseGroup));
    }

    @Timed
    public List<ReleaseGroup> search(ReleaseGroupFilters filters, Page page, ReleaseGroupOrderMode orderBy) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.releaseGroupRepository.search(filters, page, orderBy, this.currentPrincipals(), (Iterable<String>)this.currentRoleIds())).asJava();
    }

    @Timed
    public ReleaseGroupTimeline getTimeline(String groupId, DateTime now) {
        ReleaseGroup releaseGroup = this.getGroup(groupId);
        return this.calculateTimeline(releaseGroup, now);
    }

    @Timed
    public void updateGroupStatus(String groupId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Recalculating status for release group [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{groupId})));
        ReleaseGroup releaseGroup = this.releaseGroupRepository.read(groupId);
        this.recalculateStatusAndProgress(releaseGroup);
        this.releaseGroupRepository.update(releaseGroup);
    }

    @Timed
    public void updateGroupRisk(String groupId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Recalculating risk for release group [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{groupId})));
        ReleaseGroup releaseGroup = this.releaseGroupRepository.read(groupId);
        this.recalculateRiskScore(releaseGroup);
        this.releaseGroupRepository.update(releaseGroup);
    }

    private void recalculateRiskScore(ReleaseGroup releaseGroup) {
        Seq releaseIds = ((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(releaseGroup.getReleaseIds()).asScala()).toSeq();
        Seq<Object> riskScores = this.getReleaseRiskScores((Seq<String>)releaseIds);
        releaseGroup.setRiskScore(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)riskScores.sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / riskScores.length()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0))));
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Release group [", "] risk score is now: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseGroup.getId(), releaseGroup.getRiskScore()})));
    }

    public Seq<Object> getReleaseRiskScores(Seq<String> releaseIds) {
        return releaseIds.nonEmpty() ? (Seq)this.releaseRepository().getRiskScores(releaseIds).padTo(releaseIds.size(), (Object)BoxesRunTime.boxToInteger((int)0), Seq$.MODULE$.canBuildFrom()) : (Seq)Seq$.MODULE$.empty();
    }

    public String getFolderId(String groupId) {
        return this.releaseGroupRepository.findFolderId(groupId);
    }

    @Timed
    public Seq<String> findGroupsReferencingRelease(String releaseId) {
        return this.releaseGroupRepository.findGroupsReferencingReleaseId(releaseId);
    }

    @Timed
    public Seq<CiIdWithTitle> findActiveGroupsReferencingFolder(String folderId) {
        return this.releaseGroupRepository.findActiveGroupsReferencingFolderId(folderId);
    }

    private void recalculateStatusAndProgress(ReleaseGroup releaseGroup) {
        Seq releaseIds = ((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(releaseGroup.getReleaseIds()).asScala()).toSeq();
        Seq<ReleaseStatus> statuses = this.getReleaseStatuses((Seq<String>)releaseIds);
        releaseGroup.setStatus(this.calculateGroupStatus(releaseGroup, statuses));
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Release group [", "] status is now: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseGroup.getId(), releaseGroup.getStatus()})));
        releaseGroup.setProgress(this.calculateGroupProgress(statuses));
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Release group [", "] progress is now: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseGroup.getId(), releaseGroup.getProgress()})));
    }

    private Seq<ReleaseStatus> getReleaseStatuses(Seq<String> releaseIds) {
        return releaseIds.nonEmpty() ? (Seq)this.releaseRepository().getStatuses(releaseIds).padTo(releaseIds.size(), (Object)ReleaseStatus.COMPLETED, Seq$.MODULE$.canBuildFrom()) : (Seq)Seq$.MODULE$.empty();
    }

    private Integer calculateGroupProgress(Seq<ReleaseStatus> statuses) {
        return statuses.isEmpty() ? Predef$.MODULE$.int2Integer(0) : Predef$.MODULE$.int2Integer((int)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper((double)statuses.count((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isInactive())) / (double)statuses.size() * (double)100)));
    }

    private ReleaseGroupStatus calculateGroupStatus(ReleaseGroup releaseGroup, Seq<ReleaseStatus> statuses) {
        return statuses.isEmpty() ? ReleaseGroupStatus.PLANNED : (statuses.forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ReleaseGroupService.$anonfun$calculateGroupStatus$1(statuses, x$2))) ? ReleaseGroupStatus.fromRelease((ReleaseStatus)statuses.head()) : (statuses.contains((Object)ReleaseStatus.FAILING) || statuses.contains((Object)ReleaseStatus.FAILED) ? ReleaseGroupStatus.FAILING : (statuses.contains((Object)ReleaseStatus.IN_PROGRESS) || statuses.contains((Object)ReleaseStatus.PLANNED) || statuses.contains((Object)ReleaseStatus.PAUSED) ? ReleaseGroupStatus.IN_PROGRESS : (!statuses.exists((Function1 & Serializable & scala.Serializable)status -> BoxesRunTime.boxToBoolean((boolean)ReleaseGroupService.$anonfun$calculateGroupStatus$2(status))) ? ReleaseGroupStatus.COMPLETED : releaseGroup.getStatus()))));
    }

    private void checkIsUpdatable(ReleaseGroup existingGroup, String action) {
        Checks.checkArgument((boolean)existingGroup.isUpdatable(), (String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot ", " release group '", "' because it is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{action, existingGroup.getTitle(), existingGroup.getStatus()})), (Object[])new Object[0]);
    }

    private String checkIsUpdatable$default$2() {
        return "update";
    }

    private void validate(ReleaseGroup releaseGroup) {
        Checks.checkNotNull((Object)((Object)releaseGroup), (String)"Release group");
        Checks.checkArgument((releaseGroup.getStartDate() != null ? 1 : 0) != 0, (String)"Start date must be set", (Object[])new Object[0]);
        Checks.checkArgument((releaseGroup.getEndDate() != null ? 1 : 0) != 0, (String)"End date must be set", (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)releaseGroup.getTitle()), (String)"Title must be set", (Object[])new Object[0]);
        Checks.checkArgument((releaseGroup.getTitle().length() < 256 ? 1 : 0) != 0, (String)"Title must be 255 characters or less", (Object[])new Object[0]);
        Checks.checkArgument((boolean)releaseGroup.getEndDate().after(releaseGroup.getStartDate()), (String)"End date must be after start date", (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)releaseGroup.getFolderId()), (String)"Folder ID must be set", (Object[])new Object[0]);
        Checks.checkArgument((!Ids.isRoot((String)releaseGroup.getFolderId()) ? 1 : 0) != 0, (String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Provided folder ID '", "' must not be a root folder"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseGroup.getFolderId()})), (Object[])new Object[0]);
        if (releaseGroup.getReleaseIds() == null) {
            releaseGroup.setReleaseIds(new HashSet<String>());
        }
        releaseGroup.getReleaseIds().forEach(releaseId -> this.validateMember((String)releaseId));
        Checks.checkArgument((boolean)this.folderService.exists(releaseGroup.getFolderId()), (String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Provided folder ID '", "' must exist in the database"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseGroup.getFolderId()})), (Object[])new Object[0]);
    }

    private void validateMember(String releaseId) {
        Checks.checkArgument((Ids.isDomainId((String)releaseId) && Ids.isReleaseId((String)releaseId) ? 1 : 0) != 0, (String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Provided ID '", "' must be a valid release ID"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseId})), (Object[])new Object[0]);
        Checks.checkArgument((this.releaseRepository().exists(releaseId) || this.archivedReleases.exists(releaseId) ? 1 : 0) != 0, (String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Provided ID '", "' must exist in the database"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseId})), (Object[])new Object[0]);
    }

    private Iterable<String> currentPrincipals() {
        return (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala();
    }

    private Buffer<String> currentRoleIds() {
        return (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService.getRolesFor(Permissions.getAuthentication())).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getId(), Buffer$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$calculateGroupStatus$1(Seq statuses$1, ReleaseStatus x$2) {
        ReleaseStatus releaseStatus = x$2;
        Object object = statuses$1.head();
        return !(releaseStatus != null ? !releaseStatus.equals(object) : object != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$calculateGroupStatus$2(ReleaseStatus status) {
        ReleaseStatus releaseStatus = status;
        ReleaseStatus releaseStatus2 = ReleaseStatus.COMPLETED;
        if (releaseStatus == null) {
            if (releaseStatus2 == null) return false;
        } else if (releaseStatus.equals(releaseStatus2)) return false;
        ReleaseStatus releaseStatus3 = status;
        ReleaseStatus releaseStatus4 = ReleaseStatus.ABORTED;
        if (releaseStatus3 == null) {
            if (releaseStatus4 == null) return false;
            return true;
        } else if (releaseStatus3.equals(releaseStatus4)) return false;
        return true;
    }

    @Autowired
    public ReleaseGroupService(ReleaseGroupRepository releaseGroupRepository, ReleaseRepository releaseRepository, ReleaseService releaseService, CiIdService ciIdService, ArchivedReleases archivedReleases, FolderService folderService, RoleService roleService, XLReleaseEventBus eventBus) {
        this.releaseGroupRepository = releaseGroupRepository;
        this.releaseRepository = releaseRepository;
        this.releaseService = releaseService;
        this.ciIdService = ciIdService;
        this.archivedReleases = archivedReleases;
        this.folderService = folderService;
        this.roleService = roleService;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
        ReleaseGroupTimelineCalculator.$init$(this);
    }
}

