/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.events.handler;

import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.xlrelease.actors.ReleaseGroupActorService;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.events.FolderDeletingAction;
import com.xebialabs.xlrelease.domain.events.ReleaseExecutionEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseUpdatedEvent;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.SynchronizedSubscribe;
import com.xebialabs.xlrelease.repository.sql.persistence.CiIdWithTitle;
import com.xebialabs.xlrelease.service.ReleaseGroupService;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@Component
@EventListener
@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001B\u0001\u0003\u00015\u0011\u0001DU3mK\u0006\u001cXm\u0012:pkB,e/\u001a8u\u0011\u0006tG\r\\3s\u0015\t\u0019A!A\u0004iC:$G.\u001a:\u000b\u0005\u00151\u0011AB3wK:$8O\u0003\u0002\b\u0011\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003\u0013)\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003-\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g\u0011!)\u0002A!A!\u0002\u00131\u0012\u0001\u0007:fY\u0016\f7/Z$s_V\u0004\u0018i\u0019;peN+'O^5dKB\u0011qCG\u0007\u00021)\u0011\u0011DB\u0001\u0007C\u000e$xN]:\n\u0005mA\"\u0001\u0007*fY\u0016\f7/Z$s_V\u0004\u0018i\u0019;peN+'O^5dK\"AQ\u0004\u0001B\u0001B\u0003%a$A\nsK2,\u0017m]3He>,\boU3sm&\u001cW\r\u0005\u0002 E5\t\u0001E\u0003\u0002\"\r\u000591/\u001a:wS\u000e,\u0017BA\u0012!\u0005M\u0011V\r\\3bg\u0016<%o\\;q'\u0016\u0014h/[2f\u0011\u0015)\u0003\u0001\"\u0001'\u0003\u0019a\u0014N\\5u}Q\u0019q%\u000b\u0016\u0011\u0005!\u0002Q\"\u0001\u0002\t\u000bU!\u0003\u0019\u0001\f\t\u000bu!\u0003\u0019\u0001\u0010)\u0005\u0011b\u0003CA\u00179\u001b\u0005q#BA\u00181\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003cI\nqAZ1di>\u0014\u0018P\u0003\u00024i\u0005)!-Z1og*\u0011QGN\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\tq'A\u0002pe\u001eL!!\u000f\u0018\u0003\u0013\u0005+Ho\\<je\u0016$\u0007bB\u001e\u0001\u0005\u0004%I\u0001P\u0001\u0019%&\u001b6jX*D\u001fJ+u\f\u0015*P!\u0016\u0013F+W0O\u00036+U#A\u001f\u0011\u0005y\u001aU\"A \u000b\u0005\u0001\u000b\u0015\u0001\u00027b]\u001eT\u0011AQ\u0001\u0005U\u00064\u0018-\u0003\u0002E\u007f\t11\u000b\u001e:j]\u001eDaA\u0012\u0001!\u0002\u0013i\u0014!\u0007*J'.{6kQ(S\u000b~\u0003&k\u0014)F%RKvLT!N\u000b\u0002BQ\u0001\u0013\u0001\u0005\u0002%\u000b!c\u001c8SK2,\u0017m]3Fq\u0016\u001cW\u000f^5p]R\u0011!*\u0014\t\u0003\u001f-K!\u0001\u0014\t\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u001d\u001e\u0003\raT\u0001\u0006KZ,g\u000e\u001e\t\u0003!Rk\u0011!\u0015\u0006\u0003\u000bIS!a\u0015\u0004\u0002\r\u0011|W.Y5o\u0013\t)\u0016KA\u000bSK2,\u0017m]3Fq\u0016\u001cW\u000f^5p]\u00163XM\u001c;)\u0005\u001d;\u0006C\u0001-Z\u001b\u0005!\u0011B\u0001.\u0005\u0005U\u0019\u0016P\\2ie>t\u0017N_3e'V\u00147o\u0019:jE\u0016DQ\u0001\u0018\u0001\u0005\u0002u\u000b\u0001c\u001c8SK2,\u0017m]3Va\u0012\fG/\u001a3\u0015\u0005)s\u0006\"\u0002(\\\u0001\u0004y\u0006C\u0001)a\u0013\t\t\u0017KA\nSK2,\u0017m]3Va\u0012\fG/\u001a3Fm\u0016tG\u000f\u000b\u0002\\/\")A\r\u0001C\u0001K\u0006\u0001rN\u001c$pY\u0012,'\u000fR3mKRLgn\u001a\u000b\u0003\u0015\u001aDQaZ2A\u0002!\fa!Y2uS>t\u0007C\u0001)j\u0013\tQ\u0017K\u0001\u000bG_2$WM\u001d#fY\u0016$\u0018N\\4BGRLwN\u001c\u0015\u0003G^CQ!\u001c\u0001\u0005\n9\f\u0001\u0004\u001e:jO\u001e,'o\u0015;biV\u001c8)\u00197dk2\fG/[8o)\tQu\u000eC\u0003qY\u0002\u0007\u0011/A\u0004sK2,\u0017m]3\u0011\u0005I\u001cX\"\u0001*\n\u0005Q\u0014&a\u0002*fY\u0016\f7/\u001a\u0005\u0006m\u0002!Ia^\u0001\u0017iJLwmZ3s%&\u001c8nQ1mGVd\u0017\r^5p]R\u0011!\n\u001f\u0005\u0006aV\u0004\r!\u001d\u0005\u0006u\u0002!Ia_\u0001\rO\u0016$(+[:l'\u000e|'/\u001a\u000b\u0003y~\u0004\"aD?\n\u0005y\u0004\"aA%oi\")\u0001/\u001fa\u0001c\"\u001a\u0001!a\u0001\u0011\u0007a\u000b)!C\u0002\u0002\b\u0011\u0011Q\"\u0012<f]Rd\u0015n\u001d;f]\u0016\u0014\bf\u0001\u0001\u0002\fA!\u0011QBA\n\u001b\t\tyAC\u0002\u0002\u0012Q\n!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\t)\"a\u0004\u0003\u0013\r{W\u000e]8oK:$\b")
public class ReleaseGroupEventHandler {
    private final ReleaseGroupActorService releaseGroupActorService;
    private final ReleaseGroupService releaseGroupService;
    private final String RISK_SCORE_PROPERTY_NAME;

    private String RISK_SCORE_PROPERTY_NAME() {
        return this.RISK_SCORE_PROPERTY_NAME;
    }

    @SynchronizedSubscribe
    public void onReleaseExecution(ReleaseExecutionEvent event) {
        this.triggerStatusCalculation(event.release());
    }

    @SynchronizedSubscribe
    public void onReleaseUpdated(ReleaseUpdatedEvent event) {
        block0: {
            if (this.getRiskScore(event.original()) == this.getRiskScore(event.updated())) break block0;
            this.triggerRiskCalculation(event.updated());
        }
    }

    @SynchronizedSubscribe
    public void onFolderDeleting(FolderDeletingAction action) {
        Seq<CiIdWithTitle> groups = this.releaseGroupService.findActiveGroupsReferencingFolder(action.folderId());
        if (groups.nonEmpty()) {
            throw new ItemInUseException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"You cannot delete this folder. The folder or its subfolders contain releases referenced by active groups: "})).s((Seq)Nil$.MODULE$) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)((SeqLike)((TraversableLike)groups.take(20)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.title(), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).mkString("\"", "\", \"", "\"")})), new Object[0]);
        }
    }

    private void triggerStatusCalculation(Release release) {
        this.releaseGroupService.findGroupsReferencingRelease(release.getId()).foreach((Function1 & Serializable & scala.Serializable)groupId -> {
            this.releaseGroupActorService.updateGroupStatus(groupId);
            return BoxedUnit.UNIT;
        });
    }

    private void triggerRiskCalculation(Release release) {
        this.releaseGroupService.findGroupsReferencingRelease(release.getId()).foreach((Function1 & Serializable & scala.Serializable)groupId -> {
            this.releaseGroupActorService.updateGroupRisk(groupId);
            return BoxedUnit.UNIT;
        });
    }

    private int getRiskScore(Release release) {
        return BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString((String)release.getProperty(this.RISK_SCORE_PROPERTY_NAME()))).toInt()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
    }

    @Autowired
    public ReleaseGroupEventHandler(ReleaseGroupActorService releaseGroupActorService, ReleaseGroupService releaseGroupService) {
        this.releaseGroupActorService = releaseGroupActorService;
        this.releaseGroupService = releaseGroupService;
        this.RISK_SCORE_PROPERTY_NAME = "riskScore";
    }
}

