package com.xebialabs.xlrelease.actors

import com.xebialabs.xlrelease.actors.ReleaseGroupActorInitializer.ReleaseGroupActorHolder
import com.xebialabs.xlrelease.config.XlrConfig
import grizzled.slf4j.Logging
import org.springframework.context.annotation.{Bean, Configuration}

object ReleaseGroupActorInitializer {
  type ReleaseGroupActorHolder = ManagedActor[ReleaseGroupProcessingActor]

}

@Configuration
class ReleaseGroupActorInitializer(xlrConfig: XlrConfig, actorSystemHolder: ActorSystemHolder) extends Logging {
  @Bean
  def releaseGroupActorHolder: ReleaseGroupActorHolder = {
    if (xlrConfig.isClusterEnabled) {
      actorSystemHolder.clusterSingletonActorProxyOf(classOf[ReleaseGroupProcessingActor], ReleaseGroupProcessingActor.name)
    } else {
      actorSystemHolder.actorOf(classOf[ReleaseGroupProcessingActor], ReleaseGroupProcessingActor.name)
    }
  }
}


