package com.xebialabs.xlrelease.repository.sql.persistence

import com.xebialabs.xlrelease.repository.sql.persistence.CiId.CiId
import com.xebialabs.xlrelease.utils.FolderId

object ReleaseGroupSchema {

  val COLUMN_LENGTH_TITLE: Int = 255

  object RELEASE_GROUPS extends Table("XLR_RELEASE_GROUPS") {
    val ID = "ID"
    val CI_UID = "CI_UID"
    val FOLDER_UID = "FOLDER_UID"
    val TITLE = "TITLE"
    val STATUS = "STATUS"
    val START_DATE = "START_DATE"
    val END_DATE = "END_DATE"
    val RISK_SCORE = "RISK_SCORE"
    val CONTENT = "CONTENT"
  }

  object RELEASE_GROUP_MEMBERS extends Table("XLR_RELEASE_GROUP_MEMBERS") {
    val GROUP_UID = "GROUP_UID"
    val RELEASE_ID = "RELEASE_ID"
  }

}

case class ReleaseGroupRow(content: String, ciUid: String, folderId: FolderId)

case class ReleaseGroupMemberRow(groupUid: String, releaseId: CiId)

case class CiIdWithTitle(groupId: String, title: String)

