/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.api.internal.DecoratorsCache;
import com.xebialabs.xlrelease.api.internal.DecoratorsCache$;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator$;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseGroupFilters;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseGroupOrderMode;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.group.ReleaseGroup;
import com.xebialabs.xlrelease.domain.group.ReleaseGroupStatus;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.ReleaseGroupRepository;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiIdWithTitle;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleaseGroupMemberPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleaseGroupPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleaseGroupRow;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleaseGroupSqlBuilder;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.utils.Diff;
import com.xebialabs.xlrelease.utils.Diff$;
import com.xebialabs.xlrelease.utils.ScopedTokenPermissionValidator$;
import java.io.Serializable;
import java.util.HashSet;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@IsTransactional
@Repository
@ScalaSignature(bytes="\u0006\u0005\t\u001db\u0001B\f\u0019\u0001\rB\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\tk\u0001\u0011\t\u0011)A\u0005m!A\u0011\b\u0001B\u0001B\u0003%!\b\u0003\u0005?\u0001\t\u0015\r\u0011b\u0001@\u0011!A\u0005A!A!\u0002\u0013\u0001\u0005\u0002C%\u0001\u0005\u000b\u0007I1\u0001&\t\u0011\t\u0004!\u0011!Q\u0001\n-C\u0001b\u0019\u0001\u0003\u0006\u0004%\t\u0001\u001a\u0005\t[\u0002\u0011\t\u0011)A\u0005K\")a\u000e\u0001C\u0001_\"9\u00111\u0003\u0001\u0005B\u0005U\u0001bBA%\u0001\u0011\u0005\u00131\n\u0005\b\u0003/\u0002A\u0011IA-\u0011\u001d\ti\u0006\u0001C!\u0003?Bq!a\u001b\u0001\t\u0003\ni\u0007C\u0004\u0002r\u0001!\t%a\u001d\t\u000f\u0005}\u0006\u0001\"\u0011\u0002B\"9\u0011\u0011\u001a\u0001\u0005B\u0005-\u0007bBAn\u0001\u0011%\u0011Q\u001c\u0005\b\u0003W\u0004A\u0011BAw\u0011\u001d\t9\u0010\u0001C!\u0003sDq!a@\u0001\t\u0013\u0011\tAA\rTc2\u0014V\r\\3bg\u0016<%o\\;q%\u0016\u0004xn]5u_JL(BA\r\u001b\u0003\r\u0019\u0018\u000f\u001c\u0006\u00037q\t!B]3q_NLGo\u001c:z\u0015\tib$A\u0005yYJ,G.Z1tK*\u0011q\u0004I\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011!I\u0001\u0004G>l7\u0001A\n\u0004\u0001\u0011R\u0003CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#AB!osJ+g\r\u0005\u0002,Y5\t!$\u0003\u0002.5\t1\"+\u001a7fCN,wI]8vaJ+\u0007o\\:ji>\u0014\u00180A\fsK2,\u0017m]3He>,\b\u000fU3sg&\u001cH/\u001a8dKB\u0011\u0001gM\u0007\u0002c)\u0011!\u0007G\u0001\fa\u0016\u00148/[:uK:\u001cW-\u0003\u00025c\t9\"+\u001a7fCN,wI]8vaB+'o]5ti\u0016t7-Z\u0001\u001ee\u0016dW-Y:f\u000fJ|W\u000f]'f[\n,'\u000fU3sg&\u001cH/\u001a8dKB\u0011\u0001gN\u0005\u0003qE\u0012QDU3mK\u0006\u001cXm\u0012:pkBlU-\u001c2feB+'o]5ti\u0016t7-Z\u0001\u0015gFd'+\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:\u0011\u0005mbT\"\u0001\r\n\u0005uB\"\u0001F*rYJ+\u0007o\\:ji>\u0014\u00180\u00113baR,'/\u0001\nqKJl\u0017n]:j_:,eNZ8sG\u0016\u0014X#\u0001!\u0011\u0005\u00053U\"\u0001\"\u000b\u0005\r#\u0015\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005\u0015s\u0012\u0001\u00033fa2|\u00170\u001b;\n\u0005\u001d\u0013%A\u0005)fe6L7o]5p]\u0016sgm\u001c:dKJ\f1\u0003]3s[&\u001c8/[8o\u000b:4wN]2fe\u0002\nq\u0001Z5bY\u0016\u001cG/F\u0001L!\tauL\u0004\u0002N9:\u0011aJ\u0017\b\u0003\u001fbs!\u0001U,\u000f\u0005E3fB\u0001*V\u001b\u0005\u0019&B\u0001+#\u0003\u0019a$o\\8u}%\t\u0011%\u0003\u0002 A%\u0011QDH\u0005\u00033r\t!\u0001\u001a2\n\u0005eY&BA-\u001d\u0013\tif,\u0001\u0006Tc2\u0014U/\u001b7eKJT!!G.\n\u0005\u0001\f'a\u0002#jC2,7\r\u001e\u0006\u0003;z\u000b\u0001\u0002Z5bY\u0016\u001cG\u000fI\u0001\u0011I\u0016\u001cwN]1u_J\u001cVM\u001d<jG\u0016,\u0012!\u001a\t\u0003M.l\u0011a\u001a\u0006\u0003Q&\f\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003Ur\t1!\u00199j\u0013\tawM\u0001\u0011J]R,'O\\1m\u001b\u0016$\u0018\rZ1uC\u0012+7m\u001c:bi>\u00148+\u001a:wS\u000e,\u0017!\u00053fG>\u0014\u0018\r^8s'\u0016\u0014h/[2fA\u00051A(\u001b8jiz\"\u0002\u0002]9sgR,\u0018\u0011\u0003\t\u0003w\u0001AQA\f\u0006A\u0002=BQ!\u000e\u0006A\u0002YBQ!\u000f\u0006A\u0002iBQA\u0010\u0006A\u0004\u0001CQ!\u0013\u0006A\u0004-Cc!^<\u0002\f\u00055\u0001c\u0001=\u0002\b5\t\u0011P\u0003\u0002{w\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005ql\u0018a\u00024bGR|'/\u001f\u0006\u0003}~\fQAY3b]NTA!!\u0001\u0002\u0004\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148N\u0003\u0002\u0002\u0006\u0005\u0019qN]4\n\u0007\u0005%\u0011PA\u0005Rk\u0006d\u0017NZ5fe\u0006)a/\u00197vK\u0006\u0012\u0011qB\u0001\u0018q2\u0014(+\u001a9pg&$xN]=Tc2$\u0015.\u00197fGRDQa\u0019\u0006A\u0002\u0015\fAA]3bIR!\u0011qCA\u0014!\u0011\tI\"a\t\u000e\u0005\u0005m!\u0002BA\u000f\u0003?\tQa\u001a:pkBT1!!\t\u001d\u0003\u0019!w.\\1j]&!\u0011QEA\u000e\u00051\u0011V\r\\3bg\u0016<%o\\;q\u0011\u001d\tIc\u0003a\u0001\u0003W\tqa\u001a:pkBLE\r\u0005\u0003\u0002.\u0005Ub\u0002BA\u0018\u0003c\u0001\"A\u0015\u0014\n\u0007\u0005Mb%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003o\tID\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003g1\u0003fA\u0006\u0002>A!\u0011qHA#\u001b\t\t\tEC\u0002\u0002Dy\u000b1\u0002\u001e:b]N\f7\r^5p]&!\u0011qIA!\u0005)I5OU3bI>sG._\u0001\u0007GJ,\u0017\r^3\u0015\t\u00055\u00131\u000b\t\u0004K\u0005=\u0013bAA)M\t!QK\\5u\u0011\u001d\t)\u0006\u0004a\u0001\u0003/\tAB]3mK\u0006\u001cXm\u0012:pkB\fa!\u001e9eCR,G\u0003BA'\u00037Bq!!\u0016\u000e\u0001\u0004\t9\"\u0001\u0004fq&\u001cHo\u001d\u000b\u0005\u0003C\n9\u0007E\u0002&\u0003GJ1!!\u001a'\u0005\u001d\u0011un\u001c7fC:Dq!!\u000b\u000f\u0001\u0004\tY\u0003K\u0002\u000f\u0003{\ta\u0001Z3mKR,G\u0003BA'\u0003_Bq!!\u000b\u0010\u0001\u0004\tY#\u0001\u0004tK\u0006\u00148\r\u001b\u000b\r\u0003k\n9)a'\u0002&\u0006=\u0016\u0011\u0018\t\u0007\u0003o\n\t)a\u0006\u000f\t\u0005e\u0014Q\u0010\b\u0004%\u0006m\u0014\"A\u0014\n\u0007\u0005}d%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\r\u0015Q\u0011\u0002\u0004'\u0016\f(bAA@M!9\u0011\u0011\u0012\tA\u0002\u0005-\u0015a\u00024jYR,'o\u001d\t\u0005\u0003\u001b\u000b9*\u0004\u0002\u0002\u0010*!\u0011\u0011SAJ\u0003\u00151wN]7t\u0015\r\t)*[\u0001\u0003mFJA!!'\u0002\u0010\n\u0019\"+\u001a7fCN,wI]8va\u001aKG\u000e^3sg\"9\u0011Q\u0014\tA\u0002\u0005}\u0015\u0001\u00029bO\u0016\u00042aKAQ\u0013\r\t\u0019K\u0007\u0002\u0005!\u0006<W\rC\u0004\u0002(B\u0001\r!!+\u0002\u000f=\u0014H-\u001a:CsB!\u0011QRAV\u0013\u0011\ti+a$\u0003+I+G.Z1tK\u001e\u0013x.\u001e9Pe\u0012,'/T8eK\"9\u0011\u0011\u0017\tA\u0002\u0005M\u0016A\u00039sS:\u001c\u0017\u000e]1mgB1\u0011qOA[\u0003WIA!a.\u0002\u0006\nA\u0011\n^3sC\ndW\rC\u0004\u0002<B\u0001\r!a-\u0002\u000fI|G.Z%eg\"\u001a\u0001#!\u0010\u0002=\u0019Lg\u000eZ$s_V\u00048OU3gKJ,gnY5oOJ+G.Z1tK&#G\u0003BAb\u0003\u000b\u0004b!a\u001e\u0002\u0002\u0006-\u0002bBAd#\u0001\u0007\u00111F\u0001\ne\u0016dW-Y:f\u0013\u0012\f1EZ5oI\u0006\u001bG/\u001b<f\u000fJ|W\u000f]:SK\u001a,'/\u001a8dS:<gi\u001c7eKJLE\r\u0006\u0003\u0002N\u0006U\u0007CBA<\u0003\u0003\u000by\rE\u00021\u0003#L1!a52\u00055\u0019\u0015.\u00133XSRDG+\u001b;mK\"9\u0011q\u001b\nA\u0002\u0005-\u0012\u0001\u00034pY\u0012,'/\u00133)\u0007I\ti$A\bu_J+G.Z1tK\u001e\u0013x.\u001e9t)\u0011\t)(a8\t\u000f\u0005\u00058\u00031\u0001\u0002d\u0006!!o\\<t!\u0019\t9(!!\u0002fB\u0019\u0001'a:\n\u0007\u0005%\u0018GA\bSK2,\u0017m]3He>,\bOU8x\u00039!xNU3mK\u0006\u001cXm\u0012:pkB$b!a\u0006\u0002p\u0006M\bbBAy)\u0001\u0007\u0011Q]\u0001\u0004e><\bbBA{)\u0001\u0007\u00111Y\u0001\u000e]\u0016<(+\u001a7fCN,\u0017\nZ:\u0002\u0019\u0019Lg\u000e\u001a$pY\u0012,'/\u00133\u0015\t\u0005-\u00121 \u0005\b\u0003S)\u0002\u0019AA\u0016Q\r)\u0012QH\u0001\u001eI\u0016\u001cwN]1uK^KG\u000f[#gM\u0016\u001cG/\u001b<f'\u0016\u001cWO]5usR1\u0011Q\u000fB\u0002\u0005\u000fAqA!\u0002\u0017\u0001\u0004\t)(A\u0007sK2,\u0017m]3He>,\bo\u001d\u0005\b\u0005\u00131\u0002\u0019\u0001B\u0006\u0003\u0015\u0019\u0017m\u00195f!\r1'QB\u0005\u0004\u0005\u001f9'a\u0004#fG>\u0014\u0018\r^8sg\u000e\u000b7\r[3)\u0007\u0001\u0011\u0019\u0002\u0005\u0003\u0002@\tU\u0011\u0002\u0002B\f\u0003\u0003\u0012q\"S:Ue\u0006t7/Y2uS>t\u0017\r\u001c\u0015\u0004\u0001\tm\u0001\u0003\u0002B\u000f\u0005Gi!Aa\b\u000b\u0007\t\u0005r0\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LAA!\n\u0003 \tQ!+\u001a9pg&$xN]=")
public class SqlReleaseGroupRepository
implements ReleaseGroupRepository {
    private final ReleaseGroupPersistence releaseGroupPersistence;
    private final ReleaseGroupMemberPersistence releaseGroupMemberPersistence;
    private final SqlRepositoryAdapter sqlRepositoryAdapter;
    private final PermissionEnforcer permissionEnforcer;
    private final SqlBuilder.Dialect dialect;
    private final InternalMetadataDecoratorService decoratorService;

    @Override
    public void createOrUpdate(ReleaseGroup releaseGroup) {
        ReleaseGroupRepository.createOrUpdate$(this, releaseGroup);
    }

    public PermissionEnforcer permissionEnforcer() {
        return this.permissionEnforcer;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    public InternalMetadataDecoratorService decoratorService() {
        return this.decoratorService;
    }

    @Override
    @IsReadOnly
    public ReleaseGroup read(String groupId) {
        return (ReleaseGroup)this.releaseGroupPersistence.findById(groupId).map((Function1 & Serializable)row -> this.toReleaseGroup((ReleaseGroupRow)row, $this.releaseGroupMemberPersistence.findMembersByGroupUid(Predef$.MODULE$.long2Long(row.ciUid())))).map((Function1 & Serializable)releaseGroup -> (ReleaseGroup)this.decorateWithEffectiveSecurity((scala.collection.immutable.Seq<ReleaseGroup>)new .colon.colon(releaseGroup, (List)Nil$.MODULE$), new DecoratorsCache(DecoratorsCache$.MODULE$.$lessinit$greater$default$1())).head()).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyNotFoundException("Release group " + groupId + " not found", new Object[0]);
        });
    }

    @Override
    public void create(ReleaseGroup releaseGroup) {
        Long groupUid = this.releaseGroupPersistence.insert(releaseGroup);
        this.releaseGroupMemberPersistence.insertMembers(groupUid, (scala.collection.immutable.Set<String>)CollectionConverters$.MODULE$.SetHasAsScala(releaseGroup.getReleaseIds()).asScala().toSet());
    }

    @Override
    public void update(ReleaseGroup releaseGroup) {
        this.releaseGroupPersistence.update(releaseGroup);
        Long groupUid = (Long)this.releaseGroupPersistence.getUid(releaseGroup.getId()).get();
        scala.collection.immutable.Seq existingMembers = (scala.collection.immutable.Seq)this.releaseGroupMemberPersistence.findMembersByGroupUid(groupUid).map((Function1 & Serializable)id -> Ids.getName((String)id));
        scala.collection.immutable.Set currentMembers = (scala.collection.immutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(releaseGroup.getReleaseIds()).asScala().toSet().map((Function1 & Serializable)id -> Ids.getName((String)id));
        Diff membersDiff = Diff$.MODULE$.apply((Iterable)existingMembers, (Iterable)currentMembers);
        this.releaseGroupMemberPersistence.deleteMembers(groupUid, (scala.collection.immutable.Set<String>)membersDiff.deletedKeys());
        this.releaseGroupMemberPersistence.insertMembers(groupUid, (scala.collection.immutable.Set<String>)membersDiff.newKeys());
    }

    @Override
    @IsReadOnly
    public boolean exists(String groupId) {
        return this.releaseGroupPersistence.exists(groupId);
    }

    @Override
    public void delete(String groupId) {
        this.releaseGroupPersistence.delete(groupId);
    }

    @Override
    @IsReadOnly
    public scala.collection.immutable.Seq<ReleaseGroup> search(ReleaseGroupFilters filters, Page page, ReleaseGroupOrderMode orderBy, Iterable<String> principals, Iterable<String> roleIds) {
        scala.collection.immutable.Seq<ReleaseGroupRow> seq;
        boolean isAdmin = this.permissionEnforcer().isCurrentUserAdmin();
        if (!isAdmin) {
            ScopedTokenPermissionValidator$.MODULE$.checkPermissionSupportedinScopedToken((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Permission[]{XLReleasePermissions.VIEW_RELEASE_GROUP}));
        }
        if (filters.hasStatuses()) {
            Tuple2 sqlWithParams = new ReleaseGroupSqlBuilder(this.dialect()).select().withTitleLike(filters.getTitle()).withOneOfStatuses((scala.collection.immutable.Seq<ReleaseGroupStatus>)((scala.collection.immutable.Seq)Option$.MODULE$.apply((Object)filters.getStatuses()).map((Function1 & Serializable)x$1 -> CollectionConverters$.MODULE$.ListHasAsScala(x$1).asScala().toSeq()).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()))).withFolder(filters.getFolderId()).withPermission((Option<Permission>)(isAdmin ? None$.MODULE$ : new Some((Object)XLReleasePermissions.VIEW_RELEASE_GROUP)), principals, roleIds).orderBy(orderBy).limitAndOffset(page.resultsPerPage(), page.resultsPerPage() * page.page()).build();
            seq = this.releaseGroupPersistence.findByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams);
        } else {
            seq = (scala.collection.immutable.Seq<ReleaseGroupRow>)package$.MODULE$.Seq().empty();
        }
        scala.collection.immutable.Seq<ReleaseGroupRow> groupRows = seq;
        scala.collection.immutable.Seq<ReleaseGroup> releaseGroups = this.toReleaseGroups(groupRows);
        if (isAdmin) {
            return releaseGroups;
        }
        return this.decorateWithEffectiveSecurity(releaseGroups, new DecoratorsCache(DecoratorsCache$.MODULE$.$lessinit$greater$default$1()));
    }

    @Override
    public scala.collection.immutable.Seq<String> findGroupsReferencingReleaseId(String releaseId) {
        return this.releaseGroupMemberPersistence.findGroupsReferencingReleaseId(releaseId);
    }

    @Override
    @IsReadOnly
    public scala.collection.immutable.Seq<CiIdWithTitle> findActiveGroupsReferencingFolderId(String folderId) {
        return this.releaseGroupMemberPersistence.findActiveGroupsReferencingFolderId(folderId);
    }

    private scala.collection.immutable.Seq<ReleaseGroup> toReleaseGroups(scala.collection.immutable.Seq<ReleaseGroupRow> rows) {
        Map<Long, scala.collection.immutable.Seq<String>> releaseIdsByGroup = this.releaseGroupMemberPersistence.findMembersByGroupUids((scala.collection.immutable.Seq<Long>)((scala.collection.immutable.Seq)rows.map((Function1 & Serializable)x$2 -> Predef$.MODULE$.long2Long(x$2.ciUid()))));
        return (scala.collection.immutable.Seq)rows.map((Function1 & Serializable)row -> this.toReleaseGroup((ReleaseGroupRow)row, (scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)releaseIdsByGroup.getOrElse((Object)Predef$.MODULE$.long2Long(row.ciUid()), (Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()))));
    }

    private ReleaseGroup toReleaseGroup(ReleaseGroupRow row, scala.collection.immutable.Seq<String> newReleaseIds) {
        Option releaseGroupOption = this.sqlRepositoryAdapter.deserialize(row.content());
        Option option = releaseGroupOption;
        if (option instanceof Some) {
            Some some = (Some)option;
            ReleaseGroup releaseGroup = (ReleaseGroup)some.value();
            releaseGroup.setFolderId(row.folderId().absolute());
            Set mergedReleaseIds = (Set)CollectionConverters$.MODULE$.SetHasAsScala(releaseGroup.getReleaseIds()).asScala().map((Function1 & Serializable)oldId -> (String)newReleaseIds.find((Function1 & Serializable)newId -> BoxesRunTime.boxToBoolean((boolean)SqlReleaseGroupRepository.$anonfun$toReleaseGroup$2(oldId, newId))).getOrElse((Function0 & Serializable)() -> oldId));
            releaseGroup.setReleaseIds(new HashSet(CollectionConverters$.MODULE$.MutableSetHasAsJava(mergedReleaseIds).asJava()));
            return releaseGroup;
        }
        if (None$.MODULE$.equals(option)) {
            throw new LogFriendlyNotFoundException("Error reading release group " + row.ciUid() + ", see logs for more details", new Object[0]);
        }
        throw new MatchError((Object)option);
    }

    @Override
    @IsReadOnly
    public String findFolderId(String groupId) {
        return this.releaseGroupPersistence.findFolderId(groupId).absolute();
    }

    private scala.collection.immutable.Seq<ReleaseGroup> decorateWithEffectiveSecurity(scala.collection.immutable.Seq<ReleaseGroup> releaseGroups, DecoratorsCache cache) {
        return (scala.collection.immutable.Seq)releaseGroups.map((Function1 & Serializable)group -> {
            this.decoratorService().decorate((ConfigurationItem)group, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY(), (List)Nil$.MODULE$)).asJava(), cache);
            return group;
        });
    }

    public static final /* synthetic */ boolean $anonfun$toReleaseGroup$2(String oldId$1, String newId) {
        String string = Ids.getName((String)newId);
        String string2 = Ids.getName((String)oldId$1);
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public SqlReleaseGroupRepository(ReleaseGroupPersistence releaseGroupPersistence, ReleaseGroupMemberPersistence releaseGroupMemberPersistence, SqlRepositoryAdapter sqlRepositoryAdapter, PermissionEnforcer permissionEnforcer, @Qualifier(value="xlrRepositorySqlDialect") SqlBuilder.Dialect dialect, InternalMetadataDecoratorService decoratorService) {
        this.releaseGroupPersistence = releaseGroupPersistence;
        this.releaseGroupMemberPersistence = releaseGroupMemberPersistence;
        this.sqlRepositoryAdapter = sqlRepositoryAdapter;
        this.permissionEnforcer = permissionEnforcer;
        this.dialect = dialect;
        this.decoratorService = decoratorService;
        ReleaseGroupRepository.$init$(this);
    }
}

