/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseGroupFilters;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseGroupOrderMode;
import com.xebialabs.xlrelease.api.v1.views.ReleaseGroupTimeline;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.group.ReleaseGroup;
import com.xebialabs.xlrelease.domain.group.ReleaseGroupStatus;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.events.ReleaseGroupCreatedEvent;
import com.xebialabs.xlrelease.events.ReleaseGroupDeletedEvent;
import com.xebialabs.xlrelease.events.ReleaseGroupUpdatedEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.ReleaseGroupRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.CiIdWithTitle;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseGroupTimelineCalculator;
import com.xebialabs.xlrelease.service.ReleaseService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@Service
@ScalaSignature(bytes="\u0006\u0005\rea\u0001B\u0014)\u0001EB\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\t\u0017\u0002\u0011)\u0019!C\u0001\u0019\"A\u0001\u000b\u0001B\u0001B\u0003%Q\n\u0003\u0005R\u0001\t\u0015\r\u0011\"\u0001S\u0011!1\u0006A!A!\u0002\u0013\u0019\u0006\u0002C,\u0001\u0005\u0003\u0005\u000b\u0011\u0002-\t\u0011m\u0003!\u0011!Q\u0001\nqC\u0001B\u0019\u0001\u0003\u0002\u0003\u0006Ia\u0019\u0005\tM\u0002\u0011\t\u0011)A\u0005O\"Aq\u000e\u0001BC\u0002\u0013\u0005\u0001\u000f\u0003\u0005x\u0001\t\u0005\t\u0015!\u0003r\u0011\u0015A\b\u0001\"\u0001z\u0011\u001d\t)\u0003\u0001C\u0001\u0003OAq!a\u001b\u0001\t\u0003\ti\u0007C\u0004\u0002z\u0001!\t!a\u001f\t\u000f\u0005\r\u0005\u0001\"\u0001\u0002\u0006\"9\u00111\u0012\u0001\u0005\u0002\u00055\u0005bBAM\u0001\u0011\u0005\u00111\u0014\u0005\b\u0003o\u0003A\u0011AA]\u0011\u001d\t\t\r\u0001C\u0001\u0003\u0007DqAa\u0001\u0001\t\u0003\u0011)\u0001C\u0004\u0003,\u0001!\tA!\f\t\u000f\tM\u0002\u0001\"\u0001\u00036!9!1\b\u0001\u0005\n\tu\u0002b\u0002B!\u0001\u0011\u0005!1\t\u0005\b\u0005#\u0002A\u0011\u0001B*\u0011\u001d\u00119\u0006\u0001C\u0001\u00053BqA!\u0019\u0001\t\u0003\u0011\u0019\u0007C\u0004\u0003~\u0001!IAa \t\u000f\t\r\u0005\u0001\"\u0003\u0003\u0006\"9!q\u0013\u0001\u0005\n\te\u0005b\u0002BV\u0001\u0011%!Q\u0016\u0005\b\u0005s\u0003A\u0011\u0002B^\u0011%\u0011)\rAI\u0001\n\u0013\u00119\rC\u0004\u0003\\\u0002!IA!8\t\u000f\t\u0005\b\u0001\"\u0003\u0003d\"9!q\u001d\u0001\u0005\n\t%\bb\u0002B~\u0001\u0011%!Q \u0002\u0014%\u0016dW-Y:f\u000fJ|W\u000f]*feZL7-\u001a\u0006\u0003S)\nqa]3sm&\u001cWM\u0003\u0002,Y\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003[9\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003=\n1aY8n\u0007\u0001\u0019B\u0001\u0001\u001a9\u0001B\u00111GN\u0007\u0002i)\tQ'A\u0003tG\u0006d\u0017-\u0003\u00028i\t1\u0011I\\=SK\u001a\u0004\"!\u000f \u000e\u0003iR!a\u000f\u001f\u0002\u000bMdg\r\u000e6\u000b\u0003u\n\u0001b\u001a:jujdW\rZ\u0005\u0003\u007fi\u0012q\u0001T8hO&tw\r\u0005\u0002B\u00056\t\u0001&\u0003\u0002DQ\tq\"+\u001a7fCN,wI]8vaRKW.\u001a7j]\u0016\u001c\u0015\r\\2vY\u0006$xN]\u0001\u0017e\u0016dW-Y:f\u000fJ|W\u000f\u001d*fa>\u001c\u0018\u000e^8ssB\u0011a)S\u0007\u0002\u000f*\u0011\u0001JK\u0001\u000be\u0016\u0004xn]5u_JL\u0018B\u0001&H\u0005Y\u0011V\r\\3bg\u0016<%o\\;q%\u0016\u0004xn]5u_JL\u0018!\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ssV\tQ\n\u0005\u0002G\u001d&\u0011qj\u0012\u0002\u0012%\u0016dW-Y:f%\u0016\u0004xn]5u_JL\u0018A\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ss\u0002\naB]3mK\u0006\u001cXmU3sm&\u001cW-F\u0001T!\t\tE+\u0003\u0002VQ\tq!+\u001a7fCN,7+\u001a:wS\u000e,\u0017a\u0004:fY\u0016\f7/Z*feZL7-\u001a\u0011\u0002\u0017\rL\u0017\nZ*feZL7-\u001a\t\u0003\u0003fK!A\u0017\u0015\u0003\u0017\rK\u0017\nZ*feZL7-Z\u0001\u0011CJ\u001c\u0007.\u001b<fIJ+G.Z1tKN\u0004\"!\u00181\u000e\u0003yS!a\u0018\u0016\u0002\u0005\u0011\u0014\u0017BA1_\u0005A\t%o\u00195jm\u0016$'+\u001a7fCN,7/A\u0007g_2$WM]*feZL7-\u001a\t\u0003\u0003\u0012L!!\u001a\u0015\u0003\u001b\u0019{G\u000eZ3s'\u0016\u0014h/[2f\u0003-\u0011x\u000e\\3TKJ4\u0018nY3\u0011\u0005!lW\"A5\u000b\u0005)\\\u0017\u0001C:fGV\u0014\u0018\u000e^=\u000b\u00051d\u0013\u0001\u00033fa2|\u00170\u001b;\n\u00059L'a\u0003*pY\u0016\u001cVM\u001d<jG\u0016\f\u0001\"\u001a<f]R\u0014Uo]\u000b\u0002cB\u0011!/^\u0007\u0002g*\u0011AOK\u0001\u0007KZ,g\u000e^:\n\u0005Y\u001c(!\u0005-M%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vg\u0006IQM^3oi\n+8\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0019i\\H0 @\u0000\u0003\u0003\t\u0019!!\u0002\u0011\u0005\u0005\u0003\u0001\"\u0002#\r\u0001\u0004)\u0005\"B&\r\u0001\u0004i\u0005\"B)\r\u0001\u0004\u0019\u0006\"B,\r\u0001\u0004A\u0006\"B.\r\u0001\u0004a\u0006\"\u00022\r\u0001\u0004\u0019\u0007\"\u00024\r\u0001\u00049\u0007\"B8\r\u0001\u0004\t\bf\u0001\u0007\u0002\nA!\u00111BA\u0011\u001b\t\tiA\u0003\u0003\u0002\u0010\u0005E\u0011AC1o]>$\u0018\r^5p]*!\u00111CA\u000b\u0003\u001d1\u0017m\u0019;pefTA!a\u0006\u0002\u001a\u0005)!-Z1og*!\u00111DA\u000f\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'BAA\u0010\u0003\ry'oZ\u0005\u0005\u0003G\tiAA\u0005BkR|w/\u001b:fI\u0006Aq-\u001a;He>,\b\u000f\u0006\u0003\u0002*\u0005e\u0002\u0003BA\u0016\u0003ki!!!\f\u000b\t\u0005=\u0012\u0011G\u0001\u0006OJ|W\u000f\u001d\u0006\u0004\u0003gQ\u0013A\u00023p[\u0006Lg.\u0003\u0003\u00028\u00055\"\u0001\u0004*fY\u0016\f7/Z$s_V\u0004\bbBA\u001e\u001b\u0001\u0007\u0011QH\u0001\bOJ|W\u000f]%e!\u0011\ty$!\u0014\u000f\t\u0005\u0005\u0013\u0011\n\t\u0004\u0003\u0007\"TBAA#\u0015\r\t9\u0005M\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005-C'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001f\n\tF\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0017\"\u0004fA\u0007\u0002VA!\u0011qKA4\u001b\t\tIF\u0003\u0003\u0002\u0010\u0005m#\u0002BA/\u0003?\nAaY8sK*!\u0011\u0011MA2\u0003)i\u0017n\u0019:p[\u0016$XM\u001d\u0006\u0003\u0003K\n!![8\n\t\u0005%\u0014\u0011\f\u0002\u0006)&lW\rZ\u0001\fKbL7\u000f^:He>,\b\u000f\u0006\u0003\u0002p\u0005U\u0004cA\u001a\u0002r%\u0019\u00111\u000f\u001b\u0003\u000f\t{w\u000e\\3b]\"9\u00111\b\bA\u0002\u0005u\u0002f\u0001\b\u0002V\u0005Y1M]3bi\u0016<%o\\;q)\u0011\tI#! \t\u000f\u0005}t\u00021\u0001\u0002*\u0005a!/\u001a7fCN,wI]8va\"\u001aq\"!\u0016\u0002\u0017U\u0004H-\u0019;f\u000fJ|W\u000f\u001d\u000b\u0005\u0003S\t9\tC\u0004\u0002\u0000A\u0001\r!!\u000b)\u0007A\t)&A\u0006eK2,G/Z$s_V\u0004H\u0003BAH\u0003+\u00032aMAI\u0013\r\t\u0019\n\u000e\u0002\u0005+:LG\u000fC\u0004\u0002<E\u0001\r!!\u0010)\u0007E\t)&A\tbI\u0012lU-\u001c2feN$vn\u0012:pkB$b!a$\u0002\u001e\u0006}\u0005bBA\u001e%\u0001\u0007\u0011Q\b\u0005\b\u0003C\u0013\u0002\u0019AAR\u0003%iW-\u001c2fe&#7\u000f\u0005\u0004\u0002&\u0006=\u0016Q\b\b\u0005\u0003O\u000bYK\u0004\u0003\u0002D\u0005%\u0016\"A\u001b\n\u0007\u00055F'A\u0004qC\u000e\\\u0017mZ3\n\t\u0005E\u00161\u0017\u0002\u0004'\u0016\f(bAAWi!\u001a!#!\u0016\u0002-I,Wn\u001c<f\u001b\u0016l'-\u001a:t\rJ|Wn\u0012:pkB$b!a$\u0002<\u0006u\u0006bBA\u001e'\u0001\u0007\u0011Q\b\u0005\b\u0003C\u001b\u0002\u0019AARQ\r\u0019\u0012QK\u0001\u0007g\u0016\f'o\u00195\u0015\u0011\u0005\u0015\u0017Q[Aw\u0003o\u0004b!a2\u0002R\u0006%RBAAe\u0015\u0011\tY-!4\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003\u001f\fAA[1wC&!\u00111[Ae\u0005\u0011a\u0015n\u001d;\t\u000f\u0005]G\u00031\u0001\u0002Z\u00069a-\u001b7uKJ\u001c\b\u0003BAn\u0003Sl!!!8\u000b\t\u0005}\u0017\u0011]\u0001\u0006M>\u0014Xn\u001d\u0006\u0005\u0003G\f)/\u0001\u0002wc)\u0019\u0011q\u001d\u0016\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002l\u0006u'a\u0005*fY\u0016\f7/Z$s_V\u0004h)\u001b7uKJ\u001c\bbBAx)\u0001\u0007\u0011\u0011_\u0001\u0005a\u0006<W\rE\u0002G\u0003gL1!!>H\u0005\u0011\u0001\u0016mZ3\t\u000f\u0005eH\u00031\u0001\u0002|\u00069qN\u001d3fe\nK\b\u0003BAn\u0003{LA!a@\u0002^\n)\"+\u001a7fCN,wI]8va>\u0013H-\u001a:N_\u0012,\u0007f\u0001\u000b\u0002V\u0005Yq-\u001a;US6,G.\u001b8f)\u0019\u00119Aa\u0005\u0003\u0016A!!\u0011\u0002B\b\u001b\t\u0011YA\u0003\u0003\u0003\u000e\u0005\u0005\u0018!\u0002<jK^\u001c\u0018\u0002\u0002B\t\u0005\u0017\u0011ACU3mK\u0006\u001cXm\u0012:pkB$\u0016.\\3mS:,\u0007bBA\u001e+\u0001\u0007\u0011Q\b\u0005\b\u0005/)\u0002\u0019\u0001B\r\u0003\rqwn\u001e\t\u0005\u00057\u0011)#\u0004\u0002\u0003\u001e)!!q\u0004B\u0011\u0003\u0011!\u0018.\\3\u000b\t\t\r\u0012QD\u0001\u0005U>$\u0017-\u0003\u0003\u0003(\tu!\u0001\u0003#bi\u0016$\u0016.\\3)\u0007U\t)&A\tva\u0012\fG/Z$s_V\u00048\u000b^1ukN$B!a$\u00030!9\u00111\b\fA\u0002\u0005u\u0002f\u0001\f\u0002V\u0005yQ\u000f\u001d3bi\u0016<%o\\;q%&\u001c8\u000e\u0006\u0003\u0002\u0010\n]\u0002bBA\u001e/\u0001\u0007\u0011Q\b\u0015\u0004/\u0005U\u0013\u0001\u0006:fG\u0006d7-\u001e7bi\u0016\u0014\u0016n]6TG>\u0014X\r\u0006\u0003\u0002\u0010\n}\u0002bBA@1\u0001\u0007\u0011\u0011F\u0001\u0015O\u0016$(+\u001a7fCN,'+[:l'\u000e|'/Z:\u0015\t\t\u0015#Q\n\t\u0007\u0003K\u000byKa\u0012\u0011\u0007M\u0012I%C\u0002\u0003LQ\u00121!\u00138u\u0011\u001d\u0011y%\u0007a\u0001\u0003G\u000b!B]3mK\u0006\u001cX-\u00133t\u0003-9W\r\u001e$pY\u0012,'/\u00133\u0015\t\u0005u\"Q\u000b\u0005\b\u0003wQ\u0002\u0019AA\u001f\u0003q1\u0017N\u001c3He>,\bo\u001d*fM\u0016\u0014XM\\2j]\u001e\u0014V\r\\3bg\u0016$B!a)\u0003\\!9!QL\u000eA\u0002\u0005u\u0012!\u0003:fY\u0016\f7/Z%eQ\rY\u0012QK\u0001\"M&tG-Q2uSZ,wI]8vaN\u0014VMZ3sK:\u001c\u0017N\\4G_2$WM\u001d\u000b\u0005\u0005K\u00129\b\u0005\u0004\u0002&\u0006=&q\r\t\u0005\u0005S\u0012\u0019(\u0004\u0002\u0003l)!!Q\u000eB8\u0003-\u0001XM]:jgR,gnY3\u000b\u0007\tEt)A\u0002tc2LAA!\u001e\u0003l\ti1)[%e/&$\b\u000eV5uY\u0016DqA!\u001f\u001d\u0001\u0004\ti$\u0001\u0005g_2$WM]%eQ\ra\u0012QK\u0001\u001de\u0016\u001c\u0017\r\\2vY\u0006$Xm\u0015;biV\u001c\u0018I\u001c3Qe><'/Z:t)\u0011\tyI!!\t\u000f\u0005}T\u00041\u0001\u0002*\u0005\u0011r-\u001a;SK2,\u0017m]3Ti\u0006$Xo]3t)\u0011\u00119I!&\u0011\r\u0005\u0015\u0016q\u0016BE!\u0011\u0011YI!%\u000e\u0005\t5%\u0002\u0002BH\u0003c\taa\u001d;biV\u001c\u0018\u0002\u0002BJ\u0005\u001b\u0013QBU3mK\u0006\u001cXm\u0015;biV\u001c\bb\u0002B(=\u0001\u0007\u00111U\u0001\u0017G\u0006d7-\u001e7bi\u0016<%o\\;q!J|wM]3tgR!!1\u0014BT!\u0011\u0011iJa)\u000e\u0005\t}%\u0002\u0002BQ\u0003\u001b\fA\u0001\\1oO&!!Q\u0015BP\u0005\u001dIe\u000e^3hKJDqA!+ \u0001\u0004\u00119)\u0001\u0005ti\u0006$Xo]3t\u0003Q\u0019\u0017\r\\2vY\u0006$Xm\u0012:pkB\u001cF/\u0019;vgR1!q\u0016B[\u0005o\u0003B!a\u000b\u00032&!!1WA\u0017\u0005I\u0011V\r\\3bg\u0016<%o\\;q'R\fG/^:\t\u000f\u0005}\u0004\u00051\u0001\u0002*!9!\u0011\u0016\u0011A\u0002\t\u001d\u0015\u0001E2iK\u000e\\\u0017j]+qI\u0006$\u0018M\u00197f)\u0019\tyI!0\u0003B\"9!qX\u0011A\u0002\u0005%\u0012!D3ySN$\u0018N\\4He>,\b\u000fC\u0005\u0003D\u0006\u0002\n\u00111\u0001\u0002>\u00051\u0011m\u0019;j_:\f!d\u00195fG.L5/\u00169eCR\f'\r\\3%I\u00164\u0017-\u001e7uII*\"A!3+\t\u0005u\"1Z\u0016\u0003\u0005\u001b\u0004BAa4\u0003X6\u0011!\u0011\u001b\u0006\u0005\u0005'\u0014).A\u0005v]\u000eDWmY6fI*\u0019\u0011q\u0002\u001b\n\t\te'\u0011\u001b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001\u0003<bY&$\u0017\r^3\u0015\t\u0005=%q\u001c\u0005\b\u0003\u007f\u001a\u0003\u0019AA\u0015\u000391\u0018\r\\5eCR,W*Z7cKJ$B!a$\u0003f\"9!Q\f\u0013A\u0002\u0005u\u0012!E2veJ,g\u000e\u001e)sS:\u001c\u0017\u000e]1mgV\u0011!1\u001e\t\u0007\u0005[\u0014\u0019Pa>\u000e\u0005\t=(b\u0001Byi\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\tU(q\u001e\u0002\t\u0013R,'/\u00192mKB!!Q\u0014B}\u0013\u0011\tyEa(\u0002\u001d\r,(O]3oiJ{G.Z%egV\u0011!q \t\u0007\u0007\u0003\u00199Aa>\u000e\u0005\r\r!\u0002BB\u0003\u0005_\fq!\\;uC\ndW-\u0003\u0003\u0004\n\r\r!A\u0002\"vM\u001a,'\u000fK\u0002\u0001\u0007\u001b\u0001Baa\u0004\u0004\u00165\u00111\u0011\u0003\u0006\u0005\u0007'\tI\"\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LAaa\u0006\u0004\u0012\t91+\u001a:wS\u000e,\u0007")
public class ReleaseGroupService
implements ReleaseGroupTimelineCalculator {
    private final ReleaseGroupRepository releaseGroupRepository;
    private final ReleaseRepository releaseRepository;
    private final ReleaseService releaseService;
    private final CiIdService ciIdService;
    private final ArchivedReleases archivedReleases;
    private final FolderService folderService;
    private final RoleService roleService;
    private final XLReleaseEventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public ReleaseGroupTimeline calculateTimeline(ReleaseGroup releaseGroup, DateTime now) {
        return ReleaseGroupTimelineCalculator.calculateTimeline$(this, releaseGroup, now);
    }

    @Override
    public <A extends DateTime> Ordering<A> dateOrdering() {
        return ReleaseGroupTimelineCalculator.dateOrdering$(this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReleaseGroupService releaseGroupService = this;
        synchronized (releaseGroupService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    @Override
    public ReleaseService releaseService() {
        return this.releaseService;
    }

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    @Timed
    public ReleaseGroup getGroup(String groupId) {
        return this.releaseGroupRepository.read(groupId);
    }

    @Timed
    public boolean existsGroup(String groupId) {
        return this.releaseGroupRepository.exists(groupId);
    }

    @Timed
    public ReleaseGroup createGroup(ReleaseGroup releaseGroup) {
        this.logger().debug((Function0 & Serializable)() -> "Creating new release group [" + releaseGroup + "]");
        this.validate(releaseGroup);
        releaseGroup.setId(this.ciIdService.getUniqueId(Type.valueOf(ReleaseGroup.class), ReleaseGroup.GROUP_ROOT));
        this.recalculateStatusAndProgress(releaseGroup);
        this.recalculateRiskScore(releaseGroup);
        this.releaseGroupRepository.create(releaseGroup);
        this.eventBus().publish((XLReleaseEvent)new ReleaseGroupCreatedEvent(releaseGroup));
        return releaseGroup;
    }

    @Timed
    public ReleaseGroup updateGroup(ReleaseGroup releaseGroup) {
        this.logger().debug((Function0 & Serializable)() -> "Updating release group [" + releaseGroup + "]");
        this.validate(releaseGroup);
        this.checkIsUpdatable(this.releaseGroupRepository.read(releaseGroup.getId()), this.checkIsUpdatable$default$2());
        this.recalculateStatusAndProgress(releaseGroup);
        this.recalculateRiskScore(releaseGroup);
        this.releaseGroupRepository.update(releaseGroup);
        this.eventBus().publish((XLReleaseEvent)new ReleaseGroupUpdatedEvent(releaseGroup));
        return releaseGroup;
    }

    @Timed
    public void deleteGroup(String groupId) {
        this.logger().debug((Function0 & Serializable)() -> "Deleting release group [" + groupId + "]");
        if (this.releaseGroupRepository.exists(groupId)) {
            ReleaseGroup releaseGroup = this.releaseGroupRepository.read(groupId);
            this.checkIsUpdatable(releaseGroup, "delete");
            this.releaseGroupRepository.delete(groupId);
            this.eventBus().publish((XLReleaseEvent)new ReleaseGroupDeletedEvent(releaseGroup));
            return;
        }
        this.logger().debug((Function0 & Serializable)() -> "Release group [" + groupId + "] already deleted");
    }

    @Timed
    public void addMembersToGroup(String groupId, Seq<String> memberIds) {
        this.logger().debug((Function0 & Serializable)() -> "Adding members " + memberIds + " to release group [" + groupId + "]");
        memberIds.foreach((Function1 & Serializable)releaseId -> {
            this.validateMember(releaseId);
            return BoxedUnit.UNIT;
        });
        ReleaseGroup releaseGroup = this.releaseGroupRepository.read(groupId);
        this.checkIsUpdatable(releaseGroup, this.checkIsUpdatable$default$2());
        releaseGroup.getReleaseIds().addAll(CollectionConverters$.MODULE$.SeqHasAsJava(memberIds).asJava());
        this.recalculateStatusAndProgress(releaseGroup);
        this.recalculateRiskScore(releaseGroup);
        this.releaseGroupRepository.update(releaseGroup);
        this.eventBus().publish((XLReleaseEvent)new ReleaseGroupUpdatedEvent(releaseGroup));
    }

    @Timed
    public void removeMembersFromGroup(String groupId, Seq<String> memberIds) {
        this.logger().debug((Function0 & Serializable)() -> "Removing members " + memberIds + " from release group [" + groupId + "]");
        ReleaseGroup releaseGroup = this.releaseGroupRepository.read(groupId);
        this.checkIsUpdatable(releaseGroup, this.checkIsUpdatable$default$2());
        releaseGroup.removeReleaseIds(CollectionConverters$.MODULE$.SeqHasAsJava(memberIds).asJava());
        this.recalculateStatusAndProgress(releaseGroup);
        this.recalculateRiskScore(releaseGroup);
        this.releaseGroupRepository.update(releaseGroup);
        this.eventBus().publish((XLReleaseEvent)new ReleaseGroupUpdatedEvent(releaseGroup));
    }

    @Timed
    public List<ReleaseGroup> search(ReleaseGroupFilters filters, Page page, ReleaseGroupOrderMode orderBy) {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.releaseGroupRepository.search(filters, page, orderBy, this.currentPrincipals(), (Iterable<String>)this.currentRoleIds())).asJava();
    }

    @Timed
    public ReleaseGroupTimeline getTimeline(String groupId, DateTime now) {
        ReleaseGroup releaseGroup = this.getGroup(groupId);
        return this.calculateTimeline(releaseGroup, now);
    }

    @Timed
    public void updateGroupStatus(String groupId) {
        this.logger().debug((Function0 & Serializable)() -> "Recalculating status for release group [" + groupId + "]");
        ReleaseGroup releaseGroup = this.releaseGroupRepository.read(groupId);
        this.recalculateStatusAndProgress(releaseGroup);
        this.releaseGroupRepository.update(releaseGroup);
    }

    @Timed
    public void updateGroupRisk(String groupId) {
        this.logger().debug((Function0 & Serializable)() -> "Recalculating risk for release group [" + groupId + "]");
        ReleaseGroup releaseGroup = this.releaseGroupRepository.read(groupId);
        this.recalculateRiskScore(releaseGroup);
        this.releaseGroupRepository.update(releaseGroup);
    }

    private void recalculateRiskScore(ReleaseGroup releaseGroup) {
        Seq releaseIds = CollectionConverters$.MODULE$.SetHasAsScala(releaseGroup.getReleaseIds()).asScala().toSeq();
        Seq<Object> riskScores = this.getReleaseRiskScores((Seq<String>)releaseIds);
        releaseGroup.setRiskScore(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)riskScores.sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / riskScores.length()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0))));
        this.logger().debug((Function0 & Serializable)() -> "Release group [" + releaseGroup.getId() + "] risk score is now: " + releaseGroup.getRiskScore());
    }

    public Seq<Object> getReleaseRiskScores(Seq<String> releaseIds) {
        if (releaseIds.nonEmpty()) {
            return (Seq)this.releaseRepository().getRiskScores(releaseIds).padTo(releaseIds.size(), (Object)BoxesRunTime.boxToInteger((int)0));
        }
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public String getFolderId(String groupId) {
        return this.releaseGroupRepository.findFolderId(groupId);
    }

    @Timed
    public Seq<String> findGroupsReferencingRelease(String releaseId) {
        return this.releaseGroupRepository.findGroupsReferencingReleaseId(releaseId);
    }

    @Timed
    public Seq<CiIdWithTitle> findActiveGroupsReferencingFolder(String folderId) {
        return this.releaseGroupRepository.findActiveGroupsReferencingFolderId(folderId);
    }

    private void recalculateStatusAndProgress(ReleaseGroup releaseGroup) {
        Seq releaseIds = CollectionConverters$.MODULE$.SetHasAsScala(releaseGroup.getReleaseIds()).asScala().toSeq();
        Seq<ReleaseStatus> statuses = this.getReleaseStatuses((Seq<String>)releaseIds);
        releaseGroup.setStatus(this.calculateGroupStatus(releaseGroup, statuses));
        this.logger().debug((Function0 & Serializable)() -> "Release group [" + releaseGroup.getId() + "] status is now: " + releaseGroup.getStatus());
        releaseGroup.setProgress(this.calculateGroupProgress(statuses));
        this.logger().debug((Function0 & Serializable)() -> "Release group [" + releaseGroup.getId() + "] progress is now: " + releaseGroup.getProgress());
    }

    private Seq<ReleaseStatus> getReleaseStatuses(Seq<String> releaseIds) {
        if (releaseIds.nonEmpty()) {
            return (Seq)this.releaseRepository().getStatuses(releaseIds).padTo(releaseIds.size(), (Object)ReleaseStatus.COMPLETED);
        }
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private Integer calculateGroupProgress(Seq<ReleaseStatus> statuses) {
        if (statuses.isEmpty()) {
            return Predef$.MODULE$.int2Integer(0);
        }
        return Predef$.MODULE$.int2Integer((int)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper((double)statuses.count((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isInactive())) / (double)statuses.size() * (double)100)));
    }

    private ReleaseGroupStatus calculateGroupStatus(ReleaseGroup releaseGroup, Seq<ReleaseStatus> statuses) {
        if (statuses.isEmpty()) {
            return ReleaseGroupStatus.PLANNED;
        }
        if (statuses.forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ReleaseGroupService.$anonfun$calculateGroupStatus$1(statuses, x$2)))) {
            return ReleaseGroupStatus.fromRelease((ReleaseStatus)((ReleaseStatus)statuses.head()));
        }
        if (statuses.contains((Object)ReleaseStatus.FAILING) || statuses.contains((Object)ReleaseStatus.FAILED)) {
            return ReleaseGroupStatus.FAILING;
        }
        if (statuses.contains((Object)ReleaseStatus.IN_PROGRESS) || statuses.contains((Object)ReleaseStatus.PLANNED) || statuses.contains((Object)ReleaseStatus.PAUSED)) {
            return ReleaseGroupStatus.IN_PROGRESS;
        }
        if (!statuses.exists((Function1 & Serializable)status -> BoxesRunTime.boxToBoolean((boolean)ReleaseGroupService.$anonfun$calculateGroupStatus$2(status)))) {
            return ReleaseGroupStatus.COMPLETED;
        }
        return releaseGroup.getStatus();
    }

    private void checkIsUpdatable(ReleaseGroup existingGroup, String action) {
        Checks.checkArgument((boolean)existingGroup.isUpdatable(), (String)("Cannot " + action + " release group '" + existingGroup.getTitle() + "' because it is " + existingGroup.getStatus()), (Object[])new Object[0]);
    }

    private String checkIsUpdatable$default$2() {
        return "update";
    }

    private void validate(ReleaseGroup releaseGroup) {
        Checks.checkNotNull((Object)releaseGroup, (String)"Release group");
        Checks.checkArgument((releaseGroup.getStartDate() != null ? 1 : 0) != 0, (String)"Start date must be set", (Object[])new Object[0]);
        Checks.checkArgument((releaseGroup.getEndDate() != null ? 1 : 0) != 0, (String)"End date must be set", (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)releaseGroup.getTitle()), (String)"Title must be set", (Object[])new Object[0]);
        Checks.checkArgument((releaseGroup.getTitle().length() < 256 ? 1 : 0) != 0, (String)"Title must be 255 characters or less", (Object[])new Object[0]);
        Checks.checkArgument((boolean)releaseGroup.getEndDate().after(releaseGroup.getStartDate()), (String)"End date must be after start date", (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)releaseGroup.getFolderId()), (String)"Folder ID must be set", (Object[])new Object[0]);
        Checks.checkArgument((!Ids.isRoot((String)releaseGroup.getFolderId()) ? 1 : 0) != 0, (String)("Provided folder ID '" + releaseGroup.getFolderId() + "' must not be a root folder"), (Object[])new Object[0]);
        if (releaseGroup.getReleaseIds() == null) {
            releaseGroup.setReleaseIds(new HashSet());
        }
        releaseGroup.getReleaseIds().forEach(releaseId -> this.validateMember((String)releaseId));
        Checks.checkArgument((boolean)this.folderService.exists(releaseGroup.getFolderId()), (String)("Provided folder ID '" + releaseGroup.getFolderId() + "' must exist in the database"), (Object[])new Object[0]);
    }

    private void validateMember(String releaseId) {
        Checks.checkArgument((Ids.isDomainId((String)releaseId) && Ids.isReleaseId((String)releaseId) ? 1 : 0) != 0, (String)("Provided ID '" + releaseId + "' must be a valid release ID"), (Object[])new Object[0]);
        Checks.checkArgument((this.releaseRepository().exists(releaseId) || this.archivedReleases.exists(releaseId) ? 1 : 0) != 0, (String)("Provided ID '" + releaseId + "' must exist in the database"), (Object[])new Object[0]);
    }

    private Iterable<String> currentPrincipals() {
        return CollectionConverters$.MODULE$.CollectionHasAsScala(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala();
    }

    private Buffer<String> currentRoleIds() {
        return (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(this.roleService.getRolesFor(Permissions.getAuthentication())).asScala().map((Function1 & Serializable)x$3 -> x$3.getId());
    }

    public static final /* synthetic */ boolean $anonfun$calculateGroupStatus$1(Seq statuses$1, ReleaseStatus x$2) {
        ReleaseStatus releaseStatus = x$2;
        Object object = statuses$1.head();
        return !(releaseStatus != null ? !releaseStatus.equals(object) : object != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$calculateGroupStatus$2(ReleaseStatus status) {
        ReleaseStatus releaseStatus = status;
        ReleaseStatus releaseStatus2 = ReleaseStatus.COMPLETED;
        if (releaseStatus == null) {
            if (releaseStatus2 == null) return false;
        } else if (releaseStatus.equals(releaseStatus2)) return false;
        ReleaseStatus releaseStatus3 = status;
        ReleaseStatus releaseStatus4 = ReleaseStatus.ABORTED;
        if (releaseStatus3 == null) {
            if (releaseStatus4 == null) return false;
            return true;
        } else if (releaseStatus3.equals(releaseStatus4)) return false;
        return true;
    }

    @Autowired
    public ReleaseGroupService(ReleaseGroupRepository releaseGroupRepository, ReleaseRepository releaseRepository, ReleaseService releaseService, CiIdService ciIdService, ArchivedReleases archivedReleases, FolderService folderService, RoleService roleService, XLReleaseEventBus eventBus) {
        this.releaseGroupRepository = releaseGroupRepository;
        this.releaseRepository = releaseRepository;
        this.releaseService = releaseService;
        this.ciIdService = ciIdService;
        this.archivedReleases = archivedReleases;
        this.folderService = folderService;
        this.roleService = roleService;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
        ReleaseGroupTimelineCalculator.$init$(this);
    }
}

